/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.kirikiri.tjs2.Dispatch;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeJavaClass;
import jp.kirikiri.tjs2.NativeJavaInstance;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class NativeJavaClassMethod
extends Dispatch {
    private Method mProcess;
    private int mClassID;
    private Class<?>[] mParamTypes;
    private Class<?> mReturnType;
    private boolean mIsStatic;

    public NativeJavaClassMethod(Method m, int classID) throws TJSException {
        this.mProcess = m;
        this.mClassID = classID;
        if (m == null) {
            throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        this.mParamTypes = m.getParameterTypes();
        this.mReturnType = m.getReturnType();
        if (Modifier.isStatic(m.getModifiers())) {
            this.mIsStatic = true;
        }
    }

    @Override
    public int isInstanceOf(int flag, String membername, String classname, Dispatch2 objthis) throws VariantException, TJSException {
        if (membername == null && "Function".equals(classname)) {
            return 1;
        }
        int ret = super.isInstanceOf(flag, membername, classname, objthis);
        return ret;
    }

    @Override
    public int funcCall(int flag, String membername, Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
        Object self;
        if (membername != null) {
            return super.funcCall(flag, membername, result, param, objthis);
        }
        if (param.length < this.mParamTypes.length) {
            return -1003;
        }
        if (result != null) {
            result.clear();
        }
        if (this.mIsStatic) {
            self = null;
        } else {
            if (objthis == null) {
                return -1008;
            }
            NativeJavaInstance ni = (NativeJavaInstance)objthis.getNativeInstance(this.mClassID);
            if (ni == null) {
                return -1;
            }
            self = ni.getNativeObject();
            if (self == null) {
                return -1008;
            }
        }
        int er = 0;
        Object[] args = NativeJavaClass.variantArrayToJavaObjectArray(param, this.mParamTypes);
        try {
            Object ret = this.mProcess.invoke(self, args);
            if (result != null) {
                NativeJavaClass.javaObjectToVariant(result, this.mReturnType, ret);
            }
        }
        catch (IllegalArgumentException e) {
            er = -1003;
        }
        catch (IllegalAccessException e) {
            er = -1007;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof VariantException) {
                throw (VariantException)t;
            }
            if (t instanceof TJSException) {
                throw (TJSException)t;
            }
            throw new TJSException(t.toString());
        }
        return er;
    }
}

