/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.kirikiri.tjs2.Dispatch;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeJavaClass;
import jp.kirikiri.tjs2.NativeJavaInstance;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class NativeJavaClassProperty
extends Dispatch {
    private Method mGet;
    private Method mSet;
    private Class<?> mParamType;
    private Class<?> mReturnType;
    private boolean mIsStaticGet;
    private boolean mIsStaticSet;
    private int mClassID;

    public NativeJavaClassProperty(Method get, Method set, int classID) throws TJSException {
        this.mClassID = classID;
        this.mGet = get;
        if (get != null) {
            this.mReturnType = get.getReturnType();
            if (this.mReturnType.equals(Void.TYPE)) {
                throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            if (Modifier.isStatic(get.getModifiers())) {
                this.mIsStaticGet = true;
            }
        }
        this.mSet = set;
        if (set != null) {
            Class<?>[] params = set.getParameterTypes();
            if (params.length != 1) {
                throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            this.mParamType = params[0];
            if (Modifier.isStatic(set.getModifiers())) {
                this.mIsStaticSet = true;
            }
        }
    }

    @Override
    public int isInstanceOf(int flag, String membername, String classname, Dispatch2 objthis) throws VariantException, TJSException {
        if (membername == null && "Property".equals(classname)) {
            return 1;
        }
        return super.isInstanceOf(flag, membername, classname, objthis);
    }

    @Override
    public int propGet(int flag, String membername, Variant result, Dispatch2 objthis) throws VariantException, TJSException {
        Object self;
        if (membername != null) {
            return super.propGet(flag, membername, result, objthis);
        }
        if (result == null) {
            return -1;
        }
        if (this.mGet == null) {
            return -1007;
        }
        if (this.mIsStaticGet) {
            self = null;
        } else {
            if (objthis == null) {
                return -1008;
            }
            NativeJavaInstance ni = (NativeJavaInstance)objthis.getNativeInstance(this.mClassID);
            if (ni == null) {
                return -1;
            }
            self = ni.getNativeObject();
            if (self == null) {
                return -1008;
            }
        }
        int er = 0;
        try {
            Object ret = this.mGet.invoke(self, new Object[0]);
            NativeJavaClass.javaObjectToVariant(result, this.mReturnType, ret);
        }
        catch (IllegalArgumentException e) {
            er = -1003;
        }
        catch (IllegalAccessException e) {
            er = -1007;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof VariantException) {
                throw (VariantException)t;
            }
            if (t instanceof TJSException) {
                throw (TJSException)t;
            }
            throw new TJSException(t.toString());
        }
        return er;
    }

    @Override
    public int propSet(int flag, String membername, Variant param, Dispatch2 objthis) throws VariantException, TJSException {
        Object self;
        if (membername != null) {
            return super.propSet(flag, membername, param, objthis);
        }
        if (objthis == null) {
            return -1008;
        }
        if (param == null) {
            return -1;
        }
        if (this.mSet == null) {
            return -1007;
        }
        if (this.mIsStaticSet) {
            self = null;
        } else {
            NativeJavaInstance ni = (NativeJavaInstance)objthis.getNativeInstance(this.mClassID);
            if (ni == null) {
                return -1;
            }
            self = ni.getNativeObject();
            if (self == null) {
                return -1008;
            }
        }
        int er = 0;
        Object arg = NativeJavaClass.variantToJavaObject(param, this.mParamType);
        if (arg == null) {
            return -1003;
        }
        Object[] args = new Object[]{arg};
        try {
            this.mSet.invoke(self, args);
        }
        catch (IllegalArgumentException e) {
            er = -1003;
        }
        catch (IllegalAccessException e) {
            er = -1007;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof VariantException) {
                throw (VariantException)t;
            }
            if (t instanceof TJSException) {
                throw (TJSException)t;
            }
            throw new TJSException(t.toString());
        }
        return er;
    }
}

