/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

public class NumberParser {
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int TAB = 9;
    private static final int SPACE = 32;
    private static final int TJS_IEEE_D_SIGNIFICAND_BITS = 52;
    private static final int TJS_IEEE_D_EXP_MIN = -1022;
    private static final int TJS_IEEE_D_EXP_MAX = 1023;
    private static final long TJS_IEEE_D_EXP_BIAS = 1023L;
    private char[] mText;
    private int mCurrent;
    private boolean mIsDouble;
    private double mResultDouble;
    private int mResultInt;

    public int getIntResult() {
        if (!this.mIsDouble) {
            return this.mResultInt;
        }
        return (int)this.mResultDouble;
    }

    public double getDoubleResult() {
        if (!this.mIsDouble) {
            return this.mResultInt;
        }
        return this.mResultDouble;
    }

    public NumberParser(String text) {
        int scriptLen = text.length();
        this.mText = new char[scriptLen + 1];
        text.getChars(0, scriptLen, this.mText, 0);
        this.mText[scriptLen] = '\u0000';
    }

    public void resetString(String text) {
        int scriptLen = text.length();
        if (this.mText.length < scriptLen + 1) {
            this.mText = new char[scriptLen + 1];
        }
        text.getChars(0, scriptLen, this.mText, 0);
        this.mText[scriptLen] = '\u0000';
    }

    private boolean parseExtractNumber(int basebits) {
        boolean point_found = false;
        boolean exp_found = false;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '.' && !point_found && !exp_found) {
                point_found = true;
                if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
                continue;
            }
            if (!(c != 'p' && c != 'P' || exp_found)) {
                exp_found = true;
                c = ptr[++cur];
                while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                    c = ptr[++cur];
                }
                if (c != '+' && c != '-') continue;
                c = ptr[++cur];
                while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                    c = ptr[++cur];
                }
                continue;
            }
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F') || (basebits != 3 ? basebits == 1 && c != '0' && c != '1' : c < '0' || c > '7')) break;
            if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        return point_found || exp_found;
    }

    private Double parseNonDecimalReal(boolean sign, int basebits) {
        long main = 0L;
        int exp = 0;
        int numsignif = 0;
        boolean pointpassed = false;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '.') {
                pointpassed = true;
            } else {
                if (c == 'p' || c == 'P') {
                    c = ptr[++cur];
                    while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                        c = ptr[++cur];
                    }
                    boolean biassign = false;
                    if (c == '+') {
                        biassign = false;
                        c = ptr[++cur];
                        while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                            c = ptr[++cur];
                        }
                    }
                    if (c == '-') {
                        biassign = true;
                        c = ptr[++cur];
                        while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                            c = ptr[++cur];
                        }
                    }
                    int bias = 0;
                    while (c >= '0' && c <= '9') {
                        bias *= 10;
                        bias += c - 48;
                        if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                        c = ptr[++cur];
                    }
                    if (biassign) {
                        bias = -bias;
                    }
                    exp += bias;
                    break;
                }
                int n = -1;
                if (basebits == 4) {
                    if (c >= '0' && c <= '9') {
                        n = c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        n = c - 97 + 10;
                    } else {
                        if (c < 'A' || c > 'F') break;
                        n = c - 65 + 10;
                    }
                } else if (basebits == 3) {
                    if (c < '0' || c > '7') break;
                    n = c - 48;
                } else if (basebits == 1) {
                    if (c != '0' && c != '1') break;
                    n = c - 48;
                }
                if (numsignif == 0) {
                    int b = basebits - 1;
                    while (b >= 0) {
                        if ((1 << b & n) != 0) break;
                        --b;
                    }
                    if (++b != 0) {
                        numsignif = b;
                        main |= (long)n << 64 - numsignif;
                        exp = pointpassed ? (exp -= basebits - b + 1) : b - 1;
                    } else if (pointpassed) {
                        exp -= basebits;
                    }
                } else {
                    if (numsignif + basebits < 64) {
                        main |= (long)n << 64 - (numsignif += basebits);
                    }
                    if (!pointpassed) {
                        exp += basebits;
                    }
                }
            }
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if ((main >>>= 11) == 0L) {
            return 0.0;
        }
        main &= 0xFFFFFFFFFFFFFL;
        if (exp < -1022) {
            return 0.0;
        }
        if (exp > 1023) {
            if (sign) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        double d = Double.longBitsToDouble((long)exp + 1023L << 52 | main);
        if (sign) {
            d = -d;
        }
        return d;
    }

    private Integer parseNonDecimalInteger16(boolean sign) {
        long v = 0L;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            int n = -1;
            if (c >= '0' && c <= '9') {
                n = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                n = c - 97 + 10;
            } else {
                if (c < 'A' || c > 'F') break;
                n = c - 65 + 10;
            }
            v <<= 4;
            v += (long)n;
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Integer parseNonDecimalInteger8(boolean sign) {
        long v = 0L;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            int n = -1;
            if (c < '0' || c > '7') break;
            n = c - 48;
            v <<= 3;
            v += (long)n;
            if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Integer parseNonDecimalInteger2(boolean sign) {
        long v = 0L;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        while (c != '\u0000') {
            if (c == '1') {
                v <<= 1;
                ++v;
            } else {
                if (c != '0') break;
                v <<= 1;
            }
            c = ptr[++cur];
            if (c != '\r' || ptr[cur + 1] != '\n') continue;
            c = ptr[++cur];
        }
        this.mCurrent = cur;
        if (sign) {
            return (int)(-v);
        }
        return (int)v;
    }

    private Number parseNonDecimalNumber(boolean sign, int base) {
        boolean is_real = this.parseExtractNumber(base);
        if (is_real) {
            return this.parseNonDecimalReal(sign, base);
        }
        switch (base) {
            case 4: {
                return this.parseNonDecimalInteger16(sign);
            }
            case 3: {
                return this.parseNonDecimalInteger8(sign);
            }
            case 1: {
                return this.parseNonDecimalInteger2(sign);
            }
        }
        return null;
    }

    private Number parseNumber() {
        int num = 0;
        boolean sign = false;
        boolean skipNum = false;
        char[] ptr = this.mText;
        int cur = this.mCurrent;
        char c = ptr[cur];
        if (c == '+') {
            sign = false;
            c = ptr[++cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                return null;
            }
        } else if (c == '-') {
            sign = true;
            c = ptr[++cur];
            while (c != '\u0000' && c <= ' ' && (c == '\r' || c == '\n' || c == '\t' || c == ' ')) {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                return null;
            }
        }
        if (c > '9') {
            if (c == 't' && ptr[cur + 1] == 'r' && ptr[cur + 2] == 'u' && ptr[cur + 3] == 'e') {
                this.mCurrent = cur += 4;
                return 1;
            }
            if (c == 'f' && ptr[cur + 1] == 'a' && ptr[cur + 2] == 'l' && ptr[cur + 3] == 's' && ptr[cur + 4] == 'e') {
                this.mCurrent = cur += 5;
                return 0;
            }
            if (c == 'N' && ptr[cur + 1] == 'a' && ptr[cur + 2] == 'N') {
                this.mCurrent = cur += 3;
                return Double.NaN;
            }
            if (c == 'I' && ptr[cur + 1] == 'n' && ptr[cur + 2] == 'f' && ptr[cur + 3] == 'i' && ptr[cur + 4] == 'n' && ptr[cur + 5] == 'i' && ptr[cur + 6] == 't' && ptr[cur + 7] == 'y') {
                this.mCurrent = cur += 8;
                if (sign) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
        }
        if (c == '0') {
            if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                c = ptr[++cur];
            }
            if (c == '\u0000') {
                this.mCurrent = cur;
                return 0;
            }
            if (c == 'x' || c == 'X') {
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                this.mCurrent = cur;
                if (c == '\u0000') {
                    return null;
                }
                return this.parseNonDecimalNumber(sign, 4);
            }
            if (c == 'b' || c == 'B') {
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                this.mCurrent = cur;
                if (c == '\u0000') {
                    return null;
                }
                return this.parseNonDecimalNumber(sign, 1);
            }
            if (c == '.') {
                skipNum = true;
            } else if (c == 'e' || c == 'E') {
                skipNum = true;
            } else {
                if (c == 'p' || c == 'P') {
                    this.mCurrent = cur;
                    return null;
                }
                if (c >= '0' && c <= '7') {
                    this.mCurrent = cur;
                    return this.parseNonDecimalNumber(sign, 3);
                }
            }
        }
        if (!skipNum) {
            while (c != '\u0000') {
                if (c < '0' || c > '9') break;
                num = num * 10 + (c - 48);
                if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                c = ptr[++cur];
            }
        }
        if (c == '.' || c == 'e' || c == 'E') {
            double figure = 1.0;
            int decimal = 0;
            if (c == '.') {
                do {
                    if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                    if (c < '0' || c > '9') break;
                    decimal = decimal * 10 + (c - 48);
                    figure *= 10.0;
                } while (c != '\u0000');
            }
            boolean expSign = false;
            int expValue = 0;
            if (c == 'e' || c == 'E') {
                if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                    c = ptr[++cur];
                }
                if (c == '-') {
                    expSign = true;
                    if ((c = ptr[++cur]) == '\r' && ptr[cur + 1] == '\n') {
                        c = ptr[++cur];
                    }
                }
                while (c != '\u0000') {
                    if (c < '0' || c > '9') break;
                    expValue = expValue * 10 + (c - 48);
                    if ((c = ptr[++cur]) != '\r' || ptr[cur + 1] != '\n') continue;
                    c = ptr[++cur];
                }
            }
            double number = (double)num + (double)decimal / figure;
            if (expValue != 0) {
                number = !expSign ? (number *= Math.pow(10.0, expValue)) : (number /= Math.pow(10.0, expValue));
            }
            if (sign) {
                number = -number;
            }
            this.mCurrent = cur;
            return number;
        }
        if (sign) {
            num = -num;
        }
        this.mCurrent = cur;
        return num;
    }
}

