/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import java.util.Stack;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.ExprNode;
import jp.kirikiri.tjs2.Lexer;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.ScriptLineData;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.StabInterCodeGenerator;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class Parser
implements SourceCodeAccessor {
    private static final boolean LOGD = false;
    private static final String TAG = "Compiler";
    private static final String ERROR_TAG = "Syntax error";
    private TJS mOwner;
    private boolean mUsingPreProcessor;
    private int mCompileErrorCount;
    private Lexer mLexicalAnalyzer;
    private StabInterCodeGenerator mStabInterCodeGenerator;
    private StabInterCodeGenerator mTopLevelGenerator;
    private Stack<StabInterCodeGenerator> mGeneratorStack;
    private ArrayList<StabInterCodeGenerator> mStabInterCodeGeneratorList;
    private boolean mIsUnlex;
    private int mUnlexToken;
    private int mUnlexValue;
    private int mToken;
    private int mValue;
    private ExprNode mNode;
    private String mFirstError;
    private int mFirstErrorPos;
    private String mName;
    private int mLineOffset;
    private String mScript;
    private ScriptLineData mLineData;

    public void notifyUsingPreProcessror() {
        this.mUsingPreProcessor = true;
    }

    public boolean isUsingPreProcessor() {
        return this.mUsingPreProcessor;
    }

    private final void pushContextStack(String name, int type) throws TJSException, VariantException {
        StabInterCodeGenerator ctx = new StabInterCodeGenerator(this.mStabInterCodeGenerator, name, this, type);
        if (this.mStabInterCodeGenerator == null) {
            if (this.mTopLevelGenerator != null) {
                throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            this.mTopLevelGenerator = ctx;
        }
        this.mGeneratorStack.push(ctx);
        this.mStabInterCodeGenerator = ctx;
    }

    private final void popContextStack() throws VariantException, TJSException {
        this.mStabInterCodeGenerator.commit();
        this.mGeneratorStack.pop();
        this.mStabInterCodeGenerator = this.mGeneratorStack.size() >= 1 ? this.mGeneratorStack.peek() : null;
    }

    public Parser(TJS owner) {
        this.mOwner = owner;
        this.mGeneratorStack = new Stack();
        this.mStabInterCodeGeneratorList = new ArrayList();
    }

    public Lexer getLexicalAnalyzer() {
        return this.mLexicalAnalyzer;
    }

    @Override
    public int srcPosToLine(int pos) {
        return this.mLineData.getSrcPosToLine(pos);
    }

    private void unlex(int token, int value) {
        this.mIsUnlex = true;
        this.mUnlexToken = token;
        this.mUnlexValue = value;
    }

    private void unlex() {
        this.mIsUnlex = true;
        this.mUnlexToken = this.mToken;
        this.mUnlexValue = this.mValue;
    }

    private int lex() throws CompileException {
        if (this.mIsUnlex) {
            this.mIsUnlex = false;
            this.mToken = this.mUnlexToken;
            this.mValue = this.mUnlexValue;
            return this.mUnlexToken;
        }
        this.mToken = this.mLexicalAnalyzer.getNext();
        this.mValue = this.mLexicalAnalyzer.getValue();
        return this.mToken;
    }

    public void parse(String script, boolean isexpr, boolean resultneeded) throws VariantException, CompileException, TJSException {
        this.mCompileErrorCount = 0;
        this.mLexicalAnalyzer = new Lexer(null, script, isexpr, resultneeded);
        this.mLineData = new ScriptLineData(script, this.mLineOffset);
        this.program();
        this.mLexicalAnalyzer = null;
        if (this.mCompileErrorCount > 0) {
            throw new TJSScriptError(this.mFirstError, this, this.mFirstErrorPos);
        }
    }

    public void error(String msg) throws CompileException {
        if (this.mCompileErrorCount == 0) {
            this.mFirstError = msg;
            this.mFirstErrorPos = this.mLexicalAnalyzer.getCurrentPosition();
        }
        ++this.mCompileErrorCount;
        String str = "\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059(%1)".replace("%1", msg);
        int line = 1 + this.srcPosToLine(this.mLexicalAnalyzer.getCurrentPosition());
        String message = "Line (" + line + ") : " + str;
        Logger.log(ERROR_TAG, message);
        if (this.mCompileErrorCount > 20) {
            throw new CompileException("Too many errors", this, this.mFirstErrorPos);
        }
    }

    private ExprNode exprConstDicElm() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 385) {
            String name = this.mLexicalAnalyzer.getString(this.mValue);
            token = this.lex();
            if (token != 258) {
                this.error("\u5b9a\u6570\u8f9e\u66f8(const Dictionary)\u3067\u8981\u7d20\u540d\u3068\u5024\u306e\u533a\u5207\u308a\u304c\u4e0d\u6b63\u3067\u3059");
                this.unlex();
                return null;
            }
            token = this.lex();
            switch (token) {
                case 304: {
                    token = this.lex();
                    if (token != 385) {
                        this.error("\u5b9a\u6570\u8f9e\u66f8(const Dictionary)\u306e\u8981\u7d20\u5024\u304c\u4e0d\u6b63\u3067\u3059");
                        this.unlex();
                        return null;
                    }
                    Variant var = this.mLexicalAnalyzer.getValue(this.mValue);
                    var.changeSign();
                    this.mStabInterCodeGenerator.getCurrentNode().addDictionaryElement(name, var);
                    return null;
                }
                case 303: {
                    token = this.lex();
                    if (token != 385) {
                        this.error("\u5b9a\u6570\u8f9e\u66f8(const Dictionary)\u306e\u8981\u7d20\u5024\u304c\u4e0d\u6b63\u3067\u3059");
                        this.unlex();
                        return null;
                    }
                    Variant var = this.mLexicalAnalyzer.getValue(this.mValue);
                    var.toNumber();
                    this.mStabInterCodeGenerator.getCurrentNode().addDictionaryElement(name, var);
                    return null;
                }
                case 385: {
                    this.mStabInterCodeGenerator.getCurrentNode().addDictionaryElement(name, this.mLexicalAnalyzer.getValue(this.mValue));
                    return null;
                }
                case 366: {
                    this.mStabInterCodeGenerator.getCurrentNode().addDictionaryElement(name, new Variant());
                    return null;
                }
                case 310: {
                    this.unlex();
                    ExprNode node = this.exprConstInlineArrayOrDic();
                    this.mStabInterCodeGenerator.getCurrentNode().addDictionaryElement(name, node.getValue());
                    return null;
                }
            }
            this.error("\u5b9a\u6570\u8f9e\u66f8(const Dictionary)\u306e\u8981\u7d20\u5024\u304c\u4e0d\u6b63\u3067\u3059");
            this.unlex();
        }
        this.unlex();
        return null;
    }

    private ExprNode exprConstDicElmList() throws VariantException, CompileException, TJSException {
        int token;
        do {
            this.exprConstDicElm();
        } while ((token = this.lex()) == 258);
        this.unlex();
        return null;
    }

    private ExprNode exprConstInlineDic() throws VariantException, CompileException, TJSException {
        ExprNode node = this.mStabInterCodeGenerator.makeNP0(385);
        Dispatch2 dsp = TJS.createDictionaryObject();
        node.setValue(new Variant(dsp, dsp));
        this.mStabInterCodeGenerator.pushCurrentNode(node);
        this.exprConstDicElmList();
        node = this.mStabInterCodeGenerator.getCurrentNode();
        this.mStabInterCodeGenerator.popCurrentNode();
        int token = this.lex();
        if (token == 316) {
            return node;
        }
        this.error("\u8f9e\u66f8(Dictionary)\u306e\u7d42\u7aef\u306b\"]\"\u304c\u3042\u308a\u307e\u305b\u3093");
        this.unlex();
        return null;
    }

    private ExprNode exprConstArrayElm() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        switch (token) {
            case 304: {
                token = this.lex();
                if (token != 385) {
                    this.error("\u5b9a\u6570\u914d\u5217(const Array)\u306e\u8981\u7d20\u5024\u304c\u4e0d\u6b63\u3067\u3059");
                    this.unlex();
                    return null;
                }
                Variant var = this.mLexicalAnalyzer.getValue(this.mValue);
                var.changeSign();
                this.mStabInterCodeGenerator.getCurrentNode().addArrayElement(var);
                return null;
            }
            case 303: {
                token = this.lex();
                if (token != 385) {
                    this.error("\u5b9a\u6570\u914d\u5217(const Array)\u306e\u8981\u7d20\u5024\u304c\u4e0d\u6b63\u3067\u3059");
                    this.unlex();
                    return null;
                }
                Variant var = this.mLexicalAnalyzer.getValue(this.mValue);
                var.toNumber();
                this.mStabInterCodeGenerator.getCurrentNode().addArrayElement(var);
                return null;
            }
            case 385: {
                this.mStabInterCodeGenerator.getCurrentNode().addArrayElement(this.mLexicalAnalyzer.getValue(this.mValue));
                return null;
            }
            case 366: {
                this.mStabInterCodeGenerator.getCurrentNode().addArrayElement(new Variant());
                return null;
            }
            case 310: {
                this.unlex();
                ExprNode node = this.exprConstInlineArrayOrDic();
                this.mStabInterCodeGenerator.getCurrentNode().addArrayElement(node.getValue());
                return null;
            }
        }
        this.unlex();
        return null;
    }

    private ExprNode exprConstArrayElmList() throws VariantException, CompileException, TJSException {
        int token;
        do {
            this.exprConstArrayElm();
        } while ((token = this.lex()) == 258);
        this.unlex();
        return null;
    }

    private ExprNode exprConstInlineArray() throws VariantException, CompileException, TJSException {
        ExprNode node = this.mStabInterCodeGenerator.makeNP0(385);
        Dispatch2 dsp = TJS.createArrayObject();
        node.setValue(new Variant(dsp, dsp));
        this.mStabInterCodeGenerator.pushCurrentNode(node);
        this.exprConstArrayElmList();
        node = this.mStabInterCodeGenerator.getCurrentNode();
        this.mStabInterCodeGenerator.popCurrentNode();
        int token = this.lex();
        if (token == 316) {
            return node;
        }
        this.error("\u914d\u5217(Array)\u306e\u7d42\u7aef\u306b\"]\"\u304c\u3042\u308a\u307e\u305b\u3093");
        this.unlex();
        return null;
    }

    private ExprNode exprConstInlineArrayOrDic() throws CompileException, VariantException, TJSException {
        int token = this.lex();
        if (token == 310) {
            token = this.lex();
            if (token != 347) {
                this.error("\u5b9a\u6570\u8f9e\u66f8\u3082\u3057\u304f\u306f\u914d\u5217\u3067(const)\u6587\u5b57\u304c\u4e0d\u6b63\u3067\u3059");
                this.unlex();
            }
            if ((token = this.lex()) != 318) {
                this.error("\u5b9a\u6570\u8f9e\u66f8\u3082\u3057\u304f\u306f\u914d\u5217\u3067(const)\u6587\u5b57\u304c\u4e0d\u6b63\u3067\u3059");
                this.unlex();
            }
            if ((token = this.lex()) == 292) {
                token = this.lex();
                if (token == 312) {
                    return this.exprConstInlineDic();
                }
                this.error("\u5b9a\u6570\u8f9e\u66f8(const Dictionary)\u3067(const)%\u306e\u5f8c\u306b\"[\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            } else {
                if (token == 312) {
                    return this.exprConstInlineArray();
                }
                this.error("\u5b9a\u6570\u914d\u5217(const Array)\u3067(const)\u306e\u5f8c\u306b\"[\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        } else if (token == 515) {
            token = this.lex();
            if (token == 292) {
                token = this.lex();
                if (token == 312) {
                    return this.exprConstInlineDic();
                }
                this.error("\u5b9a\u6570\u8f9e\u66f8(const Dictionary)\u3067(const)%\u306e\u5f8c\u306b\"[\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            } else {
                if (token == 312) {
                    return this.exprConstInlineArray();
                }
                this.error("\u5b9a\u6570\u914d\u5217(const Array)\u3067(const)\u306e\u5f8c\u306b\"[\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        }
        return null;
    }

    private ExprNode exprDicElm() throws VariantException, CompileException, TJSException {
        ExprNode node = null;
        int nodeCount = this.mStabInterCodeGenerator.getNodeToDeleteVectorCount();
        ExprNode node0 = this.exprExprNoComma();
        int token = this.lex();
        if (token == 258) {
            node = this.exprExprNoComma();
            return this.mStabInterCodeGenerator.makeNP2(381, node0, node);
        }
        if (token == 319) {
            int curNodeCount = this.mStabInterCodeGenerator.getNodeToDeleteVectorCount();
            node0.setOpecode(385);
            node = this.exprExprNoComma();
            return this.mStabInterCodeGenerator.makeNP2(381, node0, node);
        }
        this.error("\u8f9e\u66f8(Dictionary)\u3067\u8981\u7d20\u540d\u3068\u5024\u306e\u533a\u5207\u308a\u304c\u4e0d\u6b63\u3067\u3059");
        this.unlex();
        return null;
    }

    private ExprNode exprDicElmList() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 316) {
            this.unlex();
        } else {
            this.unlex();
            ExprNode node = this.exprDicElm();
            this.mStabInterCodeGenerator.getCurrentNode().add(node);
            token = this.lex();
            while (token == 258) {
                token = this.lex();
                if (token == 316) break;
                this.unlex();
                node = this.exprDicElm();
                this.mStabInterCodeGenerator.getCurrentNode().add(node);
                token = this.lex();
            }
            this.unlex();
        }
        return null;
    }

    private ExprNode exprInlineDic() throws CompileException, VariantException, TJSException {
        int token = this.lex();
        if (token == 292) {
            token = this.lex();
            if (token == 312) {
                ExprNode node = this.mStabInterCodeGenerator.makeNP0(380);
                this.mStabInterCodeGenerator.pushCurrentNode(node);
                this.exprDicElmList();
                token = this.lex();
                if (token == 316) {
                    node = this.mStabInterCodeGenerator.getCurrentNode();
                    this.mStabInterCodeGenerator.popCurrentNode();
                    return node;
                }
                this.error("\u8f9e\u66f8(Dictionary)\u306e\u7d42\u7aef\u306b\"]\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            } else {
                this.error("\u8f9e\u66f8(Dictionary)\u3067%\u306e\u5f8c\u306b\"[\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprArrayElm() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 258 || token == 316) {
            this.unlex();
            return this.mStabInterCodeGenerator.makeNP1(379, null);
        }
        this.unlex();
        ExprNode node = this.exprExprNoComma();
        return this.mStabInterCodeGenerator.makeNP1(379, node);
    }

    private ExprNode exprArrayElmList() throws VariantException, CompileException, TJSException {
        int token;
        do {
            ExprNode node = this.exprArrayElm();
            this.mStabInterCodeGenerator.getCurrentNode().add(node);
        } while ((token = this.lex()) == 258);
        this.unlex();
        return null;
    }

    private ExprNode exprInlineArray() throws CompileException, VariantException, TJSException {
        int token = this.lex();
        if (token == 312) {
            ExprNode node = this.mStabInterCodeGenerator.makeNP0(378);
            this.mStabInterCodeGenerator.pushCurrentNode(node);
            this.exprArrayElmList();
            token = this.lex();
            if (token == 316) {
                node = this.mStabInterCodeGenerator.getCurrentNode();
                this.mStabInterCodeGenerator.popCurrentNode();
                return node;
            }
            this.error("\u914d\u5217(Array)\u306e\u7d42\u7aef\u306b\"]\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprCallArg() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 318) {
            this.unlex();
            return null;
        }
        this.unlex();
        ExprNode node = this.exprExprNoComma();
        if (node != null) {
            token = this.lex();
            if (token == 295) {
                return this.mStabInterCodeGenerator.makeNP1(377, node);
            }
            if (token == 517) {
                this.unlex(318, 0);
                return this.mStabInterCodeGenerator.makeNP1(377, node);
            }
            if (token == 518) {
                this.unlex(258, 0);
                return this.mStabInterCodeGenerator.makeNP1(377, node);
            }
            this.unlex();
        } else {
            token = this.lex();
            if (token == 295) {
                return this.mStabInterCodeGenerator.makeNP1(377, null);
            }
            if (token == 517) {
                this.unlex(318, 0);
                return this.mStabInterCodeGenerator.makeNP1(377, null);
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprCallArgList2(ExprNode node) throws VariantException, CompileException, TJSException {
        int token;
        node = this.mStabInterCodeGenerator.makeNP1(376, node);
        do {
            ExprNode n2 = this.exprCallArg();
            node = this.mStabInterCodeGenerator.makeNP2(376, n2, node);
        } while ((token = this.lex()) == 258);
        this.unlex();
        return node;
    }

    private ExprNode exprCallArgList() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 356) {
            return this.mStabInterCodeGenerator.makeNP0(356);
        }
        this.unlex();
        ExprNode node = this.exprCallArg();
        token = this.lex();
        if (token == 258) {
            return this.exprCallArgList2(node);
        }
        this.unlex();
        return this.mStabInterCodeGenerator.makeNP1(376, node);
    }

    private ExprNode exprFuncCallExpr(ExprNode node) throws VariantException, CompileException, TJSException {
        boolean newExpression = false;
        if (node == null) {
            node = this.exprPriorityExpr();
            newExpression = true;
        }
        if (node != null && !newExpression) {
            int token = this.lex();
            if (token != 310) {
                this.error("\u95a2\u6570\u547c\u3073\u51fa\u3057\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            ExprNode n2 = this.exprCallArgList();
            token = this.lex();
            if (token != 318) {
                this.error("\u95a2\u6570\u547c\u3073\u51fa\u3057\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            node = this.mStabInterCodeGenerator.makeNP2(310, node, n2);
        }
        return node;
    }

    private ExprNode exprFactorExpr() throws CompileException, VariantException, TJSException {
        int token = this.lex();
        ExprNode node = null;
        switch (token) {
            case 385: {
                node = this.mStabInterCodeGenerator.makeNP0(385);
                node.setValue(this.mLexicalAnalyzer.getValue(this.mValue));
                return node;
            }
            case 386: {
                node = this.mStabInterCodeGenerator.makeNP0(386);
                node.setValue(new Variant(this.mLexicalAnalyzer.getString(this.mValue)));
                return node;
            }
            case 313: {
                return this.mStabInterCodeGenerator.makeNP0(313);
            }
            case 314: {
                return this.mStabInterCodeGenerator.makeNP0(314);
            }
            case 324: {
                this.unlex();
                return this.exprFuncExprDef();
            }
            case 315: {
                return this.mStabInterCodeGenerator.makeNP0(315);
            }
            case 366: {
                return this.mStabInterCodeGenerator.makeNP0(366);
            }
            case 312: {
                this.unlex();
                return this.exprInlineArray();
            }
            case 292: {
                this.unlex();
                return this.exprInlineDic();
            }
            case 515: {
                this.unlex();
                return this.exprConstInlineArrayOrDic();
            }
            case 310: {
                token = this.lex();
                if (token == 347) {
                    token = this.lex();
                    if (token != 318) {
                        this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                        this.unlex();
                    }
                    this.unlex(515, 0);
                    return this.exprConstInlineArrayOrDic();
                }
                this.unlex();
                this.mNode = this.expr();
                token = this.lex();
                if (token != 318) {
                    this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                    this.unlex();
                }
                this.unlex(516, 0);
                return null;
            }
            case 266: {
                this.mLexicalAnalyzer.setStartOfRegExp();
                token = this.lex();
                if (token == 387) {
                    node = this.mStabInterCodeGenerator.makeNP0(387);
                    node.setValue(this.mLexicalAnalyzer.getValue(this.mValue));
                    return node;
                }
                this.error("\u6b63\u898f\u8868\u73fe\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\u6b63\u898f\u8868\u73fe\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
                break;
            }
            case 293: {
                this.mLexicalAnalyzer.setStartOfRegExp();
                token = this.lex();
                if (token == 387) {
                    node = this.mStabInterCodeGenerator.makeNP0(387);
                    node.setValue(this.mLexicalAnalyzer.getValue(this.mValue));
                    return node;
                }
                this.error("\u6b63\u898f\u8868\u73fe\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\u6b63\u898f\u8868\u73fe\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        }
        this.unlex();
        return null;
    }

    private ExprNode exprPriorityExpr1() throws CompileException, VariantException, TJSException {
        ExprNode node = this.exprFactorExpr();
        if (node == null) {
            int token = this.lex();
            if (token == 516) {
                node = this.mNode;
                this.mNode = null;
                return node;
            }
            if (token == 311) {
                this.mLexicalAnalyzer.setNextIsBareWord();
                token = this.lex();
                if (token == 386) {
                    ExprNode n2 = this.mStabInterCodeGenerator.makeNP0(385);
                    n2.setValue(this.mLexicalAnalyzer.getValue(this.mValue));
                    return this.mStabInterCodeGenerator.makeNP1(382, n2);
                }
                this.error("\".\"\u306e\u5f8c\u306b\u30b7\u30f3\u30dc\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            } else {
                this.unlex();
            }
        }
        return node;
    }

    private ExprNode exprPriorityExpr() throws CompileException, VariantException, TJSException {
        ExprNode node = this.exprPriorityExpr1();
        if (node != null) {
            int token = this.lex();
            while (token == 312 || token == 311 || token == 299 || token == 298 || token == 296 || token == 310) {
                switch (token) {
                    case 312: {
                        ExprNode n2 = this.expr();
                        token = this.lex();
                        if (token == 316) {
                            node = this.mStabInterCodeGenerator.makeNP2(312, node, n2);
                            break;
                        }
                        this.error("\u914d\u5217\u3082\u3057\u304f\u306f\u8f9e\u66f8\u8981\u7d20\u3092\u6307\u3059\u5909\u6570\u306e\u7d42\u7aef\u306b\"]\"\u304c\u3042\u308a\u307e\u305b\u3093");
                        this.unlex();
                        break;
                    }
                    case 311: {
                        ExprNode n2;
                        this.mLexicalAnalyzer.setNextIsBareWord();
                        token = this.lex();
                        if (token == 386) {
                            n2 = this.mStabInterCodeGenerator.makeNP0(385);
                            n2.setValue(this.mLexicalAnalyzer.getValue(this.mValue));
                            node = this.mStabInterCodeGenerator.makeNP2(311, node, n2);
                            break;
                        }
                        this.error("\".\"\u306e\u5f8c\u306b\u30b7\u30f3\u30dc\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
                        this.unlex();
                        break;
                    }
                    case 299: {
                        node = this.mStabInterCodeGenerator.makeNP1(373, node);
                        break;
                    }
                    case 298: {
                        node = this.mStabInterCodeGenerator.makeNP1(372, node);
                        break;
                    }
                    case 296: {
                        node = this.mStabInterCodeGenerator.makeNP1(371, node);
                        break;
                    }
                    case 310: {
                        this.unlex();
                        node = this.exprFuncCallExpr(node);
                    }
                }
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprIncontextOfExpr() throws CompileException, VariantException, TJSException {
        ExprNode node = this.exprPriorityExpr();
        int token = this.lex();
        if (token == 341) {
            ExprNode n2 = this.exprIncontextOfExpr();
            return this.mStabInterCodeGenerator.makeNP2(341, node, n2);
        }
        this.unlex();
        return node;
    }

    private ExprNode exprUnaryExpr() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 310) {
            token = this.lex();
            switch (token) {
                case 359: {
                    token = this.lex();
                    if (token != 318) {
                        this.unlex();
                        ExprNode n1 = this.exprUnaryExpr();
                        ExprNode retnode = this.mStabInterCodeGenerator.makeNP1(359, n1);
                        token = this.lex();
                        if (token != 318) {
                            this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                            this.unlex();
                        }
                        return retnode;
                    }
                    this.unlex(512, 0);
                    break;
                }
                case 360: {
                    token = this.lex();
                    if (token != 318) {
                        this.unlex();
                        ExprNode n1 = this.exprUnaryExpr();
                        ExprNode retnode = this.mStabInterCodeGenerator.makeNP1(360, n1);
                        token = this.lex();
                        if (token != 318) {
                            this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                            this.unlex();
                        }
                        return retnode;
                    }
                    this.unlex(513, 0);
                    break;
                }
                case 361: {
                    token = this.lex();
                    if (token != 318) {
                        this.unlex();
                        ExprNode n1 = this.exprUnaryExpr();
                        ExprNode retnode = this.mStabInterCodeGenerator.makeNP1(361, n1);
                        token = this.lex();
                        if (token != 318) {
                            this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                            this.unlex();
                        }
                        return retnode;
                    }
                    this.unlex(514, 0);
                    break;
                }
                case 347: {
                    token = this.lex();
                    if (token != 318) {
                        this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                        this.unlex();
                    }
                    this.unlex(515, 0);
                    break;
                }
                default: {
                    this.unlex();
                    this.mNode = this.expr();
                    token = this.lex();
                    if (token != 318) {
                        this.error("\")\"\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                        this.unlex();
                    }
                    this.unlex(516, 0);
                    break;
                }
            }
        } else {
            this.unlex();
        }
        ExprNode node = this.exprIncontextOfExpr();
        if (node == null) {
            token = this.lex();
            switch (token) {
                case 296: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(296, node);
                }
                case 297: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(297, node);
                }
                case 298: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(298, node);
                }
                case 299: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(299, node);
                }
                case 300: {
                    node = this.exprFuncCallExpr(null);
                    if (node != null) {
                        node.setOpecode(300);
                    }
                    return node;
                }
                case 308: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(308, node);
                }
                case 307: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(307, node);
                }
                case 301: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(301, node);
                }
                case 302: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(302, node);
                }
                case 305: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(305, node);
                }
                case 306: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(306, node);
                }
                case 303: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(369, node);
                }
                case 304: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(370, node);
                }
                case 279: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(374, node);
                }
                case 295: {
                    node = this.exprUnaryExpr();
                    if (node == null) {
                        this.unlex(517, 0);
                        return null;
                    }
                    return this.mStabInterCodeGenerator.makeNP1(375, node);
                }
                case 512: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(359, node);
                }
                case 513: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(360, node);
                }
                case 514: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(361, node);
                }
                case 359: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(359, node);
                }
                case 360: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(360, node);
                }
                case 361: {
                    node = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP1(361, node);
                }
            }
            this.unlex();
        } else {
            token = this.lex();
            switch (token) {
                case 307: {
                    return this.mStabInterCodeGenerator.makeNP1(307, node);
                }
                case 309: {
                    ExprNode n2 = this.exprUnaryExpr();
                    return this.mStabInterCodeGenerator.makeNP2(309, node, n2);
                }
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprMulDivExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprUnaryExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 292 || token == 293 || token == 294 || token == 295) {
                ExprNode n2 = this.exprUnaryExpr();
                if (n2 == null) {
                    token = this.lex();
                    if (token == 318) {
                        this.unlex(517, 0);
                        return node;
                    }
                    if (token == 258) {
                        this.unlex(518, 0);
                        return node;
                    }
                    this.error("\u95a2\u6570\u547c\u3073\u51fa\u3057\u3001\u95a2\u6570\u5b9a\u7fa9\u306e\u914d\u5217\u5c55\u958b(*)\u304c\u4e0d\u6b63\u304b\u3001\u4e57\u7b97\u304c\u4e0d\u6b63\u3067\u3059");
                    break;
                }
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprAddSubExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprMulDivExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 303 || token == 304) {
                ExprNode n2 = this.exprMulDivExpr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprShiftExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprAddSubExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 289 || token == 290 || token == 291) {
                ExprNode n2 = this.exprAddSubExpr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprCompareExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprShiftExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 285 || token == 286 || token == 287 || token == 288) {
                ExprNode n2 = this.exprShiftExpr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprIdenticalExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprCompareExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 280 || token == 281 || token == 282 | token == 283) {
                ExprNode n2 = this.exprCompareExpr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprAndExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprIdenticalExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 279) {
                ExprNode n2 = this.exprIdenticalExpr();
                node = this.mStabInterCodeGenerator.makeNP2(279, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprExclusiveOrExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprAndExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 278) {
                ExprNode n2 = this.exprAndExpr();
                node = this.mStabInterCodeGenerator.makeNP2(278, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprInclusiveOrExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprExclusiveOrExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 277) {
                ExprNode n2 = this.exprExclusiveOrExpr();
                node = this.mStabInterCodeGenerator.makeNP2(277, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprLogicalAndExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprInclusiveOrExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 276) {
                ExprNode n2 = this.exprInclusiveOrExpr();
                node = this.mStabInterCodeGenerator.makeNP2(276, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprLogicalOrExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprLogicalAndExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 275) {
                ExprNode n2 = this.exprLogicalAndExpr();
                node = this.mStabInterCodeGenerator.makeNP2(275, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprCondExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprLogicalOrExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 274) {
                ExprNode n2 = this.exprCondExpr();
                token = this.lex();
                if (token != 319) {
                    this.error("\u6761\u4ef6\u6f14\u7b97\u5b50\u306e\":\"\u304c\u3042\u308a\u307e\u305b\u3093");
                    this.unlex();
                }
                ExprNode n3 = this.exprCondExpr();
                node = this.mStabInterCodeGenerator.makeNP3(274, node, n2, n3);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprAssignExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprCondExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 284 || token == 259 || token == 260 || token == 261 || token == 262 || token == 263 || token == 264 || token == 265 || token == 266 || token == 267 || token == 268 || token == 269 || token == 270 || token == 271 || token == 272 || token == 273) {
                ExprNode n2 = this.exprAssignExpr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprCommaExpr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprAssignExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 258) {
                ExprNode n2 = this.exprAssignExpr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode expr() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprCommaExpr();
        if (node != null) {
            int token = this.lex();
            while (token == 345) {
                ExprNode n2 = this.expr();
                node = this.mStabInterCodeGenerator.makeNP2(token, node, n2);
                token = this.lex();
            }
            this.unlex();
        }
        return node;
    }

    private ExprNode exprExprNoComma() throws VariantException, CompileException, TJSException {
        return this.exprAssignExpr();
    }

    private ExprNode exprThrow() throws VariantException, CompileException, TJSException {
        ExprNode node = this.expr();
        int token = this.lex();
        if (token == 320) {
            this.mStabInterCodeGenerator.processThrowCode(node);
        } else {
            this.error("throw\u306e\u5f8c\u306e\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprCatch() throws CompileException, VariantException {
        int token = this.lex();
        if (token == 355) {
            token = this.lex();
            if (token == 310) {
                token = this.lex();
                if (token == 318) {
                    this.mStabInterCodeGenerator.enterCatchCode(null);
                } else if (token == 386) {
                    int value = this.mValue;
                    token = this.lex();
                    if (token != 318) {
                        this.error("catch\u306e\u5f8c\u306e\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                        this.unlex();
                    }
                    this.mStabInterCodeGenerator.enterCatchCode(this.mLexicalAnalyzer.getString(value));
                } else {
                    this.error("catch\u306e\u5f8c\u306e\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                    this.unlex();
                }
            } else {
                this.unlex();
                this.mStabInterCodeGenerator.enterCatchCode(null);
            }
        } else {
            this.error("try\u306e\u5f8c\u306bcatch\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprTry() throws CompileException, VariantException, TJSException {
        this.mStabInterCodeGenerator.enterTryCode();
        this.exprBlockOrStatment();
        this.exprCatch();
        this.exprBlockOrStatment();
        this.mStabInterCodeGenerator.exitTryCode();
        return null;
    }

    private ExprNode exprCase() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 327) {
            ExprNode node = this.expr();
            token = this.lex();
            if (token != 319) {
                this.error("case\u306e\u5f8c\u306b\":\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.mStabInterCodeGenerator.processCaseCode(node);
        } else if (token == 326) {
            token = this.lex();
            if (token != 319) {
                this.error("default\u306e\u5f8c\u306b\":\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.mStabInterCodeGenerator.processCaseCode(null);
        } else {
            this.error("case\u304bdefault\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067case\u304bdefault\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprWith() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token != 310) {
            this.error("with\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        ExprNode node = this.expr();
        token = this.lex();
        if (token != 318) {
            this.error("with\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.enterWithCode(node);
        this.exprBlockOrStatment();
        this.mStabInterCodeGenerator.exitWidthCode();
        return null;
    }

    private ExprNode exprSwitch() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token != 310) {
            this.error("switch\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        ExprNode node = this.expr();
        token = this.lex();
        if (token != 318) {
            this.error("switch\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.enterSwitchCode(node);
        this.exprBlock();
        this.mStabInterCodeGenerator.exitSwitchCode();
        return null;
    }

    private ExprNode exprReturn() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 320) {
            this.mStabInterCodeGenerator.returnFromFunc(null);
        } else {
            this.unlex();
            ExprNode node = this.expr();
            token = this.lex();
            if (token != 320) {
                this.error("return\u306e\u5f8c\u306e\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.mStabInterCodeGenerator.returnFromFunc(node);
        }
        return null;
    }

    private ExprNode exprExtendsList() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprExprNoComma();
        this.mStabInterCodeGenerator.createExtendsExprCode(node, false);
        int token = this.lex();
        if (token == 258) {
            this.exprExtendsList();
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprClassExtender() throws VariantException, CompileException, TJSException {
        ExprNode node = this.exprExprNoComma();
        int token = this.lex();
        if (token == 258) {
            this.mStabInterCodeGenerator.createExtendsExprCode(node, false);
            this.exprExtendsList();
        } else {
            this.mStabInterCodeGenerator.createExtendsExprCode(node, true);
            this.unlex();
        }
        return null;
    }

    private ExprNode exprClassDef() throws TJSException, CompileException, VariantException {
        int token = this.lex();
        if (token == 317) {
            token = this.lex();
            if (token != 386) {
                this.error("class\u306e\u5f8c\u306b\u30b7\u30f3\u30dc\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.pushContextStack(this.mLexicalAnalyzer.getString(this.mValue), 6);
            token = this.lex();
            if (token == 328) {
                this.exprClassExtender();
            } else {
                this.unlex();
            }
            this.exprBlock();
            this.popContextStack();
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprPropertyGetter() throws CompileException, TJSException, VariantException {
        int token = this.lex();
        if (token == 310) {
            token = this.lex();
            if (token != 318) {
                this.error("property getter\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        } else {
            this.unlex();
        }
        this.pushContextStack("getter", 5);
        this.mStabInterCodeGenerator.enterBlock();
        this.exprBlock();
        this.mStabInterCodeGenerator.exitBlock();
        this.popContextStack();
        return null;
    }

    private ExprNode exprPropertySetter() throws CompileException, TJSException, VariantException {
        int token = this.lex();
        if (token != 310) {
            this.error("property setter\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        if ((token = this.lex()) != 386) {
            this.error("property setter\u306e\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        int value = this.mValue;
        token = this.lex();
        if (token != 318) {
            this.error("property setter\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.pushContextStack("setter", 4);
        this.mStabInterCodeGenerator.enterBlock();
        this.mStabInterCodeGenerator.setPropertyDeclArg(this.mLexicalAnalyzer.getString(value));
        this.exprBlock();
        this.mStabInterCodeGenerator.exitBlock();
        this.popContextStack();
        return null;
    }

    private ExprNode exprPropertyHandlerDefList() throws CompileException, TJSException, VariantException {
        int token = this.lex();
        if (token == 352) {
            this.exprPropertySetter();
            token = this.lex();
            if (token == 353) {
                this.exprPropertyGetter();
            } else {
                this.unlex();
            }
        } else if (token == 353) {
            this.exprPropertyGetter();
            token = this.lex();
            if (token == 352) {
                this.exprPropertySetter();
            } else {
                this.unlex();
            }
        } else {
            this.error("property\u306e\u5f8c\u306b\"getter\"\u3082\u3057\u304f\u306f\"setter\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprPropertyDef() throws CompileException, TJSException, VariantException {
        int token = this.lex();
        if (token == 330) {
            token = this.lex();
            if (token != 386) {
                this.error("property\u306e\u5f8c\u306b\u30b7\u30f3\u30dc\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            int value = this.mValue;
            token = this.lex();
            if (token != 321) {
                this.error("property\u306e\u5f8c\u306b\"{\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.pushContextStack(this.mLexicalAnalyzer.getString(value), 3);
            this.exprPropertyHandlerDefList();
            token = this.lex();
            if (token != 322) {
                this.error("property\u306e\u5f8c\u306b\"}\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.popContextStack();
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprFuncDeclArgs() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 386) {
            int value = this.mValue;
            token = this.lex();
            if (token == 259) {
                ExprNode node = this.exprExprNoComma();
                this.mStabInterCodeGenerator.addFunctionDeclArg(this.mLexicalAnalyzer.getString(value), node);
                token = this.lex();
                if (token == 258) {
                    this.exprFuncDeclArgs();
                } else {
                    this.unlex();
                }
            } else if (token == 295) {
                this.mStabInterCodeGenerator.addFunctionDeclArgCollapse(this.mLexicalAnalyzer.getString(value));
            } else {
                this.mStabInterCodeGenerator.addFunctionDeclArg(this.mLexicalAnalyzer.getString(value), null);
                if (token == 258) {
                    this.exprFuncDeclArgs();
                } else {
                    this.unlex();
                }
            }
        } else if (token == 295) {
            this.mStabInterCodeGenerator.addFunctionDeclArgCollapse(null);
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprFuncDeclArgOpt() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 310) {
            this.exprFuncDeclArgs();
            token = this.lex();
            if (token != 318) {
                this.error("\u95a2\u6570\u5b9a\u7fa9\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprFunctionDef() throws CompileException, TJSException, VariantException {
        int token = this.lex();
        if (token == 324) {
            token = this.lex();
            if (token != 386) {
                this.error("\u95a2\u6570\u5b9a\u7fa9\u306b\u30b7\u30f3\u30dc\u30eb\u540d\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
        } else {
            this.unlex();
            throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        this.pushContextStack(this.mLexicalAnalyzer.getString(this.mValue), 1);
        this.mStabInterCodeGenerator.enterBlock();
        this.exprFuncDeclArgOpt();
        this.exprBlock();
        this.mStabInterCodeGenerator.exitBlock();
        this.popContextStack();
        return null;
    }

    private ExprNode exprFuncExprDef() throws TJSException, VariantException, CompileException {
        ExprNode node = null;
        int token = this.lex();
        if (token != 324) {
            this.unlex();
            throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        this.pushContextStack("anonymous", 2);
        this.mStabInterCodeGenerator.enterBlock();
        this.exprFuncDeclArgOpt();
        this.exprBlock();
        this.mStabInterCodeGenerator.exitBlock();
        Variant v = new Variant(this.mStabInterCodeGenerator);
        this.popContextStack();
        node = this.mStabInterCodeGenerator.makeNP0(385);
        node.setValue(v);
        return node;
    }

    private ExprNode exprVariableId() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 386) {
            int value = this.mValue;
            token = this.lex();
            if (token == 259) {
                ExprNode node = this.exprExprNoComma();
                this.mStabInterCodeGenerator.initLocalVariable(this.mLexicalAnalyzer.getString(value), node);
            } else {
                this.unlex();
                this.mStabInterCodeGenerator.addLocalVariable(this.mLexicalAnalyzer.getString(value));
            }
        } else {
            this.error("\u5909\u6570\u5ba3\u8a00\u306b\u30b7\u30f3\u30dc\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprVariableIdList() throws VariantException, CompileException, TJSException {
        this.exprVariableId();
        int token = this.lex();
        if (token == 258) {
            this.exprVariableIdList();
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprVariableDefInner() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 346) {
            this.exprVariableIdList();
        } else if (token == 347) {
            this.exprVariableIdList();
        } else {
            this.unlex();
            throw new TJSException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        return null;
    }

    private ExprNode exprVariableDef() throws VariantException, CompileException, TJSException {
        this.exprVariableDefInner();
        int token = this.lex();
        if (token != 320) {
            this.error("\u5909\u6570\u5ba3\u8a00\u306e\u5f8c\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprForThridClause() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 318) {
            this.unlex();
            this.mStabInterCodeGenerator.setForThirdExprCode(null);
        } else {
            this.unlex();
            ExprNode node = this.expr();
            this.mStabInterCodeGenerator.setForThirdExprCode(node);
        }
        return null;
    }

    private ExprNode exprForSecondClause() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 320) {
            this.unlex();
            this.mStabInterCodeGenerator.createForExprCode(null);
        } else {
            this.unlex();
            ExprNode node = this.expr();
            this.mStabInterCodeGenerator.createForExprCode(node);
        }
        return null;
    }

    private ExprNode exprForFirstClause() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 346 || token == 347) {
            this.unlex();
            this.mStabInterCodeGenerator.enterForCode(true);
            this.exprVariableDefInner();
        } else if (token == 320) {
            this.unlex();
            this.mStabInterCodeGenerator.enterForCode(false);
        } else {
            this.unlex();
            ExprNode node = this.expr();
            this.mStabInterCodeGenerator.enterForCode(false);
            this.mStabInterCodeGenerator.createExprCode(node);
        }
        return null;
    }

    private ExprNode exprFor() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token != 310) {
            this.error("for\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.exprForFirstClause();
        token = this.lex();
        if (token != 320) {
            this.error("for\u306e\u5404\u7bc0\u306e\u533a\u5207\u308a\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.exprForSecondClause();
        token = this.lex();
        if (token != 320) {
            this.error("for\u306e\u5404\u7bc0\u306e\u533a\u5207\u308a\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.exprForThridClause();
        token = this.lex();
        if (token != 318) {
            this.error("for\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.exprBlockOrStatment();
        this.mStabInterCodeGenerator.exitForCode();
        return null;
    }

    private ExprNode exprIf() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token != 310) {
            this.error("if\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.enterIfCode();
        ExprNode node = this.expr();
        this.mStabInterCodeGenerator.crateIfExprCode(node);
        token = this.lex();
        if (token != 318) {
            this.error("if\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.exprBlockOrStatment();
        this.mStabInterCodeGenerator.exitIfCode();
        token = this.lex();
        if (token == 354) {
            this.mStabInterCodeGenerator.enterElseCode();
            this.exprBlockOrStatment();
            this.mStabInterCodeGenerator.exitElseCode();
        } else {
            this.unlex();
        }
        return null;
    }

    private ExprNode exprDo() throws CompileException, VariantException, TJSException {
        this.mStabInterCodeGenerator.enterWhileCode(true);
        this.exprBlockOrStatment();
        int token = this.lex();
        if (token != 343) {
            this.error("do-while\u6587\u3067while\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        if ((token = this.lex()) != 310) {
            this.error("do-while\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        ExprNode node = this.expr();
        token = this.lex();
        if (token != 318) {
            this.error("do-while\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.createWhileExprCode(node, true);
        token = this.lex();
        if (token != 320) {
            this.error("do-while\u6587\u3067while\u306e\u5f8c\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.exitWhileCode(true);
        return null;
    }

    private ExprNode exprWhile() throws CompileException, VariantException, TJSException {
        this.mStabInterCodeGenerator.enterWhileCode(false);
        int token = this.lex();
        if (token != 310) {
            this.error("while\u306e\u5f8c\u306b\"(\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        ExprNode node = this.expr();
        token = this.lex();
        if (token != 318) {
            this.error("while\u306e\u5f8c\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.createWhileExprCode(node, false);
        this.exprBlockOrStatment();
        this.mStabInterCodeGenerator.exitWhileCode(false);
        return null;
    }

    private ExprNode exprBlock() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token != 321) {
            this.error("\u30d6\u30ed\u30c3\u30af\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\"{\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        this.mStabInterCodeGenerator.enterBlock();
        this.exprDefList();
        this.mStabInterCodeGenerator.exitBlock();
        token = this.lex();
        if (token != 322) {
            this.error("\u30d6\u30ed\u30c3\u30af\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067\"}\"\u304c\u3042\u308a\u307e\u305b\u3093");
            this.unlex();
        }
        return null;
    }

    private ExprNode exprStatement() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        ExprNode node = null;
        switch (token) {
            case 345: {
                node = this.exprIf();
                break;
            }
            case 343: {
                node = this.exprWhile();
                break;
            }
            case 344: {
                node = this.exprDo();
                break;
            }
            case 342: {
                node = this.exprFor();
                break;
            }
            case 336: {
                token = this.lex();
                if (token != 320) {
                    this.error("break\u306e\u5f8c\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
                    this.unlex();
                }
                this.mStabInterCodeGenerator.doBreak();
                break;
            }
            case 323: {
                token = this.lex();
                if (token != 320) {
                    this.error("continue\u306e\u5f8c\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
                    this.unlex();
                }
                this.mStabInterCodeGenerator.doContinue();
                break;
            }
            case 325: {
                token = this.lex();
                if (token != 320) {
                    this.error("debugger\u306e\u5f8c\u306b\";\"\u304c\u3042\u308a\u307e\u305b\u3093");
                    this.unlex();
                }
                this.mStabInterCodeGenerator.doDebugger();
                break;
            }
            case 346: 
            case 347: {
                this.unlex();
                node = this.exprVariableDef();
                break;
            }
            case 324: {
                this.unlex();
                node = this.exprFunctionDef();
                break;
            }
            case 330: {
                this.unlex();
                node = this.exprPropertyDef();
                break;
            }
            case 317: {
                this.unlex();
                node = this.exprClassDef();
                break;
            }
            case 335: {
                node = this.exprReturn();
                break;
            }
            case 339: {
                node = this.exprSwitch();
                break;
            }
            case 358: {
                node = this.exprWith();
                break;
            }
            case 326: 
            case 327: {
                this.unlex();
                node = this.exprCase();
                break;
            }
            case 351: {
                node = this.exprTry();
                break;
            }
            case 350: {
                node = this.exprThrow();
                break;
            }
            case 320: {
                break;
            }
            default: {
                this.unlex();
                node = this.expr();
                token = this.lex();
                if (token != 320) {
                    this.error("\u6587\u306e\u7d42\u308f\u308a\u306b\";\"\u304c\u306a\u3044\u304b\u3001\u4e88\u7d04\u8a9e\u306e\u30bf\u30a4\u30d7\u30df\u30b9\u3067\u3059");
                    this.unlex();
                }
                this.mStabInterCodeGenerator.createExprCode(node);
            }
        }
        return node;
    }

    private ExprNode exprBlockOrStatment() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        if (token == 321) {
            this.mStabInterCodeGenerator.enterBlock();
            this.exprDefList();
            token = this.lex();
            if (token != 322) {
                this.error("\u30d6\u30ed\u30c3\u30af\u306e\u7d42\u308f\u308a\u306b\"}\"\u304c\u3042\u308a\u307e\u305b\u3093");
                this.unlex();
            }
            this.mStabInterCodeGenerator.exitBlock();
        } else {
            this.unlex();
            this.exprStatement();
        }
        return null;
    }

    private ExprNode exprDefList() throws VariantException, CompileException, TJSException {
        int token = this.lex();
        while (token > 0 && token != 322) {
            this.unlex();
            this.exprBlockOrStatment();
            token = this.lex();
        }
        this.unlex();
        return null;
    }

    private void program() throws VariantException, CompileException, TJSException {
        int token;
        this.pushContextStack("global", 0);
        do {
            this.exprDefList();
            token = this.lex();
            if (token <= 0) continue;
            this.error("\u30d6\u30ed\u30c3\u30af\u306e\u5bfe\u5fdc\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093\u3002\"}\"\u304c\u591a\u3044\u3067\u3059");
            this.unlex();
        } while (token > 0);
        this.popContextStack();
    }

    public TJS getTJS() {
        return this.mOwner;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name, int lineofs) {
        this.mName = null;
        if (name != null) {
            this.mLineOffset = lineofs;
            this.mName = new String(name);
        }
    }

    @Override
    public int getLineOffset() {
        return this.mLineOffset;
    }

    public ScriptBlock doCompile(String text, boolean isexpression, boolean isresultneeded) throws CompileException, VariantException, TJSException {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return null;
        }
        this.mScript = text;
        this.parse(text, isexpression, isresultneeded);
        return null;
    }

    @Override
    public String getScript() {
        return this.mScript;
    }

    public final int getMaxLine() {
        return this.mLineData.getMaxLine();
    }

    @Override
    public int codePosToSrcPos(int codepos) {
        return 0;
    }

    @Override
    public String getLine(int line) {
        return null;
    }
}

