/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.ArrayList;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.TJS;

public class PreprocessorExpressionParser
extends LexBase {
    private static final int BUFFER_CAPACITY = 1024;
    private ArrayList<String> mIDs = new ArrayList();
    private int mValue;
    private int mUnlex;
    private int mUnValue;
    private boolean mIsUnlex;
    private TJS mTJS;

    public PreprocessorExpressionParser(TJS tjs, String script) {
        super(script);
        this.mTJS = tjs;
    }

    private int getNext() {
        if (this.mIsUnlex) {
            this.mIsUnlex = false;
            this.mValue = this.mUnValue;
            return this.mUnlex;
        }
        this.mStream.skipSpace();
        int c = this.mStream.getC();
        switch (c) {
            case 40: {
                return 258;
            }
            case 41: {
                return 259;
            }
            case 44: {
                return 261;
            }
            case 61: {
                c = this.mStream.getC();
                if (c == 61) {
                    return 264;
                }
                this.mStream.ungetC();
                return 262;
            }
            case 33: {
                c = this.mStream.getC();
                if (c == 61) {
                    return 263;
                }
                this.mStream.ungetC();
                return 279;
            }
            case 124: {
                c = this.mStream.getC();
                if (c == 124) {
                    return 265;
                }
                this.mStream.ungetC();
                return 267;
            }
            case 38: {
                c = this.mStream.getC();
                if (c == 38) {
                    return 266;
                }
                this.mStream.ungetC();
                return 269;
            }
            case 94: {
                return 268;
            }
            case 43: {
                return 274;
            }
            case 45: {
                return 275;
            }
            case 42: {
                return 276;
            }
            case 47: {
                return 277;
            }
            case 37: {
                return 278;
            }
            case 60: {
                c = this.mStream.getC();
                if (c == 61) {
                    return 272;
                }
                this.mStream.ungetC();
                return 270;
            }
            case 62: {
                c = this.mStream.getC();
                if (c == 61) {
                    return 273;
                }
                this.mStream.ungetC();
                return 271;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.mStream.ungetC();
                Number num = this.parseNumber();
                if (num == null) {
                    return 260;
                }
                this.mValue = num.intValue();
                return 282;
            }
            case -1: {
                return 0;
            }
        }
        if (!this.isWAlpha(c) && c != 95) {
            return 260;
        }
        StringBuilder str = new StringBuilder(1024);
        while ((this.isWAlpha(c) || this.isWDigit(c) || c == 95) && c != -1) {
            str.append((char)c);
            c = this.mStream.getC();
        }
        this.mStream.ungetC();
        this.mIDs.add(str.toString());
        this.mValue = this.mIDs.size() - 1;
        return 281;
    }

    private String getString(int index) {
        return this.mIDs.get(index);
    }

    private void unLex(int lex, int value) {
        this.mUnlex = lex;
        this.mUnValue = value;
        this.mIsUnlex = true;
    }

    private int expr1() throws CompileException {
        int let = this.getNext();
        int result = 0;
        int flag = 1;
        boolean neg = false;
        switch (let) {
            case 279: {
                neg = true;
                let = this.getNext();
                break;
            }
            case 274: {
                let = this.getNext();
                break;
            }
            case 275: {
                flag = -1;
                let = this.getNext();
            }
        }
        if (let == 282) {
            result = this.mValue * flag;
            if (neg) {
                result = result != 0 ? 0 : 1;
            }
        } else if (let == 281) {
            int tmp = this.mValue;
            let = this.getNext();
            this.unLex(let, this.mValue);
            if (let == 262) {
                result = tmp;
            } else {
                result = this.mTJS.getPPValue(this.getString(tmp)) * flag;
                if (neg) {
                    result = result != 0 ? 0 : 1;
                }
            }
        } else if (let == 258) {
            result = this.expression() * flag;
            if (neg) {
                int n = result = result != 0 ? 0 : 1;
            }
            if ((let = this.getNext()) != 259) {
                throw new CompileException("\u30d7\u30ea\u30d7\u30ed\u30bb\u30c3\u30b5\u306b\")\"\u304c\u3042\u308a\u307e\u305b\u3093");
            }
        } else {
            this.unLex(let, this.mValue);
        }
        return result;
    }

    private int expr2() throws CompileException {
        int result = this.expr1();
        int let = this.getNext();
        while (let == 276 || let == 277 || let == 278) {
            switch (let) {
                case 276: {
                    result *= this.expr1();
                    break;
                }
                case 277: {
                    int tmp = this.expr1();
                    if (tmp == 0) {
                        throw new CompileException("\u30d7\u30ea\u30d7\u30ed\u30bb\u30c3\u30b5\u306e\u30bc\u30ed\u9664\u7b97\u30a8\u30e9\u30fc");
                    }
                    result /= tmp;
                    break;
                }
                case 278: {
                    result /= this.expr1();
                }
            }
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr3() throws CompileException {
        int result = this.expr2();
        int let = this.getNext();
        while (let == 274 || let == 275) {
            switch (let) {
                case 274: {
                    result += this.expr2();
                    break;
                }
                case 275: {
                    result -= this.expr2();
                }
            }
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr4() throws CompileException {
        int result = this.expr3();
        int let = this.getNext();
        while (let == 270 || let == 271 || let == 272 || let == 273) {
            int tmp = this.expr3();
            switch (let) {
                case 270: {
                    result = result < tmp ? 1 : 0;
                    break;
                }
                case 271: {
                    result = result > tmp ? 1 : 0;
                    break;
                }
                case 272: {
                    result = result <= tmp ? 1 : 0;
                    break;
                }
                case 273: {
                    result = result >= tmp ? 1 : 0;
                }
            }
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr5() throws CompileException {
        int result = this.expr4();
        int let = this.getNext();
        while (let == 263 || let == 264) {
            int tmp = this.expr4();
            switch (let) {
                case 263: {
                    result = result != tmp ? 1 : 0;
                    break;
                }
                case 264: {
                    result = result == tmp ? 1 : 0;
                }
            }
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr6() throws CompileException {
        int result = this.expr5();
        int let = this.getNext();
        while (let == 269) {
            result &= this.expr5();
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr7() throws CompileException {
        int result = this.expr6();
        int let = this.getNext();
        while (let == 268) {
            result ^= this.expr6();
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr8() throws CompileException {
        int result = this.expr7();
        int let = this.getNext();
        while (let == 267) {
            result |= this.expr7();
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr9() throws CompileException {
        int result = this.expr8();
        int let = this.getNext();
        while (let == 266) {
            result = result != 0 && this.expr8() != 0 ? 1 : 0;
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr10() throws CompileException {
        int result = this.expr9();
        int let = this.getNext();
        while (let == 265) {
            result = result != 0 || this.expr9() != 0 ? 1 : 0;
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr11() throws CompileException {
        int result = this.expr10();
        int let = this.getNext();
        while (let == 262) {
            int tmp = this.expr10();
            this.mTJS.setPPValue(this.getString(result), tmp);
            result = tmp;
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expr12() throws CompileException {
        int result = this.expr11();
        int let = this.getNext();
        while (let == 261) {
            result = this.expr11();
            let = this.getNext();
        }
        this.unLex(let, this.mValue);
        return result;
    }

    private int expression() throws CompileException {
        return this.expr12();
    }

    public int parse() throws CompileException {
        int result = this.expression();
        return result;
    }
}

