/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.MersenneTwister;
import jp.kirikiri.tjs2.MersenneTwisterData;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.RandomBits128;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class RandomGeneratorNI
extends NativeInstanceObject {
    private static RandomBits128 mRandomBits128 = null;
    private static final int MT_N = 624;
    private MersenneTwister mGenerator;

    public static void setRandomBits128(RandomBits128 rbit128) {
        mRandomBits128 = rbit128;
    }

    public Dispatch2 serialize() throws VariantException, TJSException {
        if (this.mGenerator == null) {
            return null;
        }
        Dispatch2 dic = null;
        Variant val = new Variant();
        MersenneTwisterData data = this.mGenerator.getData();
        StringBuilder p = new StringBuilder(4992);
        int i = 0;
        while (i < 624) {
            String hex = "0123456789abcdef";
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 28 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 24 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 20 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 16 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 12 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 8 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 4 & 0xFL)));
            p.append("0123456789abcdef".charAt((int)(data.state.get(i) >> 0 & 0xFL)));
            ++i;
        }
        String state = p.toString();
        dic = TJS.createDictionaryObject();
        val.set(state);
        dic.propSet(512, "state", val, dic);
        val.set(data.left);
        dic.propSet(512, "left", val, dic);
        val.set(data.next);
        dic.propSet(512, "next", val, dic);
        return dic;
    }

    public void randomize(Variant[] param) throws TJSException, VariantException {
        if (param.length == 0) {
            if (mRandomBits128 != null) {
                ByteBuffer buf = ByteBuffer.allocateDirect(32);
                mRandomBits128.getRandomBits128(buf, 0);
                mRandomBits128.getRandomBits128(buf, 16);
                int[] tmp = new int[32];
                int i = 0;
                while (i < 32) {
                    long num = (long)buf.get(i) + ((long)buf.get(i) << 8) + ((long)buf.get(1) << 16) + ((long)buf.get(i) << 24);
                    tmp[i] = (int)(num > Integer.MAX_VALUE ? num - 0x100000000L : num);
                    ++i;
                }
                if (this.mGenerator != null) {
                    this.mGenerator = null;
                }
                this.mGenerator = new MersenneTwister(tmp);
            } else {
                if (this.mGenerator != null) {
                    this.mGenerator = null;
                }
                this.mGenerator = new MersenneTwister(System.currentTimeMillis());
            }
        } else if (param.length >= 1) {
            if (param[0].isObject()) {
                MersenneTwisterData data = null;
                try {
                    String state;
                    VariantClosure clo = param[0].asObjectClosure();
                    if (clo.mObject == null) {
                        throw new TJSException("null \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
                    }
                    Variant val = new Variant();
                    data = new MersenneTwisterData();
                    int hr = clo.propGet(1024, "state", val, null);
                    if (hr < 0) {
                        Error.throwFrom_tjs_error(hr, null);
                    }
                    if ((state = val.asString()).length() != 4992) {
                        throw new TJSException("\u4e71\u6570\u7cfb\u5217\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093(\u304a\u305d\u3089\u304f\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u304c\u6e21\u3055\u308c\u307e\u3057\u305f)");
                    }
                    int p = 0;
                    int i = 0;
                    while (i < 624) {
                        long n = 0L;
                        int j = 0;
                        while (j < 8) {
                            char c = state.charAt(p + j);
                            int tmp = -1;
                            if (c >= '0' && c <= '9') {
                                n = c - 48;
                            } else if (c >= 'a' && c <= 'f') {
                                n = c - 97 + 10;
                            } else if (c >= 'A' && c <= 'F') {
                                n = c - 65 + 10;
                            }
                            if (tmp == -1) {
                                throw new TJSException("\u4e71\u6570\u7cfb\u5217\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093(\u304a\u305d\u3089\u304f\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u304c\u6e21\u3055\u308c\u307e\u3057\u305f)");
                            }
                            n <<= 4;
                            n += (long)tmp;
                            ++j;
                        }
                        p += 8;
                        data.state.put(i, n & 0xFFFFFFFFL);
                        ++i;
                    }
                    hr = clo.propGet(1024, "left", val, null);
                    if (hr < 0) {
                        Error.throwFrom_tjs_error(hr, null);
                    }
                    data.left = val.asInteger();
                    hr = clo.propGet(1024, "next", val, null);
                    data.next = val.asInteger();
                    if (this.mGenerator != null) {
                        this.mGenerator = null;
                    }
                    this.mGenerator = new MersenneTwister(data);
                }
                catch (VariantException e) {
                    data = null;
                    throw new TJSException("\u4e71\u6570\u7cfb\u5217\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093(\u304a\u305d\u3089\u304f\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u304c\u6e21\u3055\u308c\u307e\u3057\u305f)");
                }
                catch (TJSException e) {
                    data = null;
                    throw new TJSException("\u4e71\u6570\u7cfb\u5217\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093(\u304a\u305d\u3089\u304f\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u304c\u6e21\u3055\u308c\u307e\u3057\u305f)");
                }
                data = null;
            } else {
                int n = param[0].asInteger();
                int[] tmp = new int[]{n};
                if (this.mGenerator != null) {
                    this.mGenerator = null;
                }
                this.mGenerator = new MersenneTwister(tmp);
            }
        }
    }

    public double random() {
        if (this.mGenerator == null) {
            return 0.0;
        }
        return this.mGenerator.rand_double();
    }

    public int random32() {
        if (this.mGenerator == null) {
            return 0;
        }
        return this.mGenerator.int32();
    }

    public long random63() {
        if (this.mGenerator == null) {
            return 0L;
        }
        long v = (long)this.mGenerator.int32() << 32;
        return (v |= (long)this.mGenerator.int32()) & Long.MAX_VALUE;
    }

    public long random64() {
        if (this.mGenerator == null) {
            return 0L;
        }
        long v = (long)this.mGenerator.int32() << 32;
        return v |= (long)this.mGenerator.int32();
    }
}

