/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.RegExpNI;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class RegExpClass
extends NativeClass {
    public static int mClassID = -1;
    public static Variant mLastRegExp;
    private static final int globalsearch = Integer.MIN_VALUE;
    private static final int tjsflagsmask = -16777216;
    private static final String CLASS_NAME = "RegExp";

    @Override
    protected NativeInstance createNativeInstance() {
        return new RegExpNI();
    }

    private static void compile(Variant[] param, RegExpNI _this) throws VariantException, TJSException {
        int flags;
        String expr = param[0].asString();
        if (param.length >= 2) {
            String fs = param[1].asString();
            flags = RegExpNI.getRegExpFlagsFromString(fs);
        } else {
            flags = RegExpNI.regExpFlagToValue('\u0000', 0);
        }
        if (expr.length() == 0) {
            expr = "(?:)";
        }
        try {
            int pflag = flags & 0xFFFFFF;
            _this.RegEx = pflag != 0 ? Pattern.compile(expr, pflag) : Pattern.compile(expr);
        }
        catch (PatternSyntaxException e) {
            _this.RegEx = null;
            throw new TJSException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            _this.RegEx = null;
            throw new TJSException(e.getMessage());
        }
        _this.mFlags = flags;
    }

    private static boolean match(String target, RegExpNI _this) {
        if (_this.RegEx == null) {
            return false;
        }
        int targlen = target.length();
        if (_this.mStart == targlen) {
            return _this.RegEx == null;
        }
        if (_this.mStart > targlen) {
            return false;
        }
        int searchstart = _this.mStart;
        _this.mMatch = _this.RegEx.matcher(target.substring(searchstart));
        return _this.mMatch.matches();
    }

    private static boolean exec(String target, RegExpNI _this) throws VariantException, TJSException {
        boolean matched = RegExpClass.match(target, _this);
        Dispatch2 array = RegExpClass.getResultArray(matched, _this, _this.mMatch);
        _this.mArray = new Variant(array, array);
        _this.mInput = target;
        if (!matched || _this.RegEx == null) {
            _this.mIndex = _this.mStart;
            _this.mLastIndex = _this.mStart;
            _this.mLastMatch = new String();
            _this.mLastParen = new String();
            _this.mLeftContext = target.substring(0, _this.mStart);
        } else {
            _this.mIndex = _this.mStart + _this.mMatch.start();
            _this.mLastIndex = _this.mStart + _this.mMatch.end();
            _this.mLastMatch = _this.mMatch.group();
            _this.mLastParen = _this.mMatch.group(_this.mMatch.groupCount() - 1);
            _this.mLeftContext = target.substring(_this.mIndex);
            _this.mRightContext = target.substring(_this.mLastIndex);
            if ((_this.mFlags & Integer.MIN_VALUE) != 0) {
                int match_end;
                _this.mStart = match_end = _this.mLastIndex;
            }
        }
        return matched;
    }

    private static Dispatch2 getResultArray(boolean matched, RegExpNI _this, Matcher m) throws VariantException, TJSException {
        Dispatch2 array = TJS.createArrayObject();
        if (matched) {
            if (_this.RegEx == null) {
                Variant val = new Variant("");
                array.propSetByNum(2560, 0, val, array);
            } else if (m != null) {
                Variant val;
                boolean isMatch = m.matches();
                if (isMatch) {
                    val = new Variant(m.group());
                    array.propSetByNum(2560, 0, val, array);
                }
                int size = m.groupCount();
                int i = 0;
                while (i < size) {
                    val = new Variant(m.group(i + 1));
                    array.propSetByNum(2560, i + 1, val, array);
                    ++i;
                }
            }
        }
        return array;
    }

    public RegExpClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        mClassID = NCM_CLASSID;
        this.registerNCM(CLASS_NAME, new NativeClassConstructor(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                int hr = _this.construct(param, objthis);
                if (hr < 0) {
                    return hr;
                }
                if (param.length >= 1) {
                    RegExpClass.compile(param, _this);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("finalize", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("compile", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                RegExpClass.compile(param, _this);
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("_compile", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length != 1) {
                    return -1004;
                }
                String expr = param[0].getString();
                if (expr == null || expr.charAt(0) == '\u0000') {
                    return -1;
                }
                if (expr.charAt(0) != '/' || expr.charAt(1) != '/') {
                    return -1;
                }
                int exprstart = expr.indexOf(47, 2);
                if (exprstart < 0) {
                    return -1;
                }
                int flags = RegExpNI.getRegExpFlagsFromString(expr.substring(2));
                int pflag = flags & 0xFFFFFF;
                try {
                    _this.RegEx = pflag != 0 ? Pattern.compile(expr.substring(exprstart + 1), pflag) : Pattern.compile(expr.substring(exprstart + 1));
                }
                catch (PatternSyntaxException e) {
                    throw new TJSException(e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    throw new TJSException(e.getMessage());
                }
                _this.mFlags = flags;
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("test", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String target = param[0].asString();
                boolean matched = RegExpClass.exec(target, _this);
                mLastRegExp = new Variant(objthis, objthis);
                if (result != null) {
                    result.set(matched ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("match", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    String target = param[0].asString();
                    boolean matched = RegExpClass.match(target, _this);
                    Dispatch2 array = RegExpClass.getResultArray(matched, _this, _this.mMatch);
                    result.set(array, array);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("exec", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String target = param[0].asString();
                RegExpClass.exec(target, _this);
                mLastRegExp = new Variant(objthis, objthis);
                if (result != null) {
                    result.set(_this.mArray);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("replace", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                boolean func;
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 2) {
                    return -1004;
                }
                String target = param[0].asString();
                String to = null;
                VariantClosure funcval = null;
                if (!param[1].isObject()) {
                    to = param[1].asString();
                    func = false;
                } else {
                    funcval = param[1].asObjectClosure();
                    if (funcval.mObjThis == null) {
                        funcval.mObjThis = objthis;
                    }
                    func = true;
                }
                String ret = null;
                Matcher m = _this.RegEx.matcher(target);
                if (!func) {
                    ret = m.replaceAll(to);
                } else {
                    VariantClosure clo = new VariantClosure(null, null);
                    Variant funcret = new Variant();
                    Variant arrayval = new Variant(clo);
                    Variant[] args = new Variant[]{arrayval};
                    int size = target.length();
                    ret = "";
                    int i = 0;
                    while (i < size) {
                        if (!m.find(i)) break;
                        ret = String.valueOf(ret) + target.substring(i, m.start());
                        Dispatch2 array = RegExpClass.getResultArray(true, _this, m);
                        clo.set(array, array);
                        int hr = funcval.funcCall(0, null, funcret, args, null);
                        if (hr >= 0) {
                            ret = String.valueOf(ret) + funcret.asString();
                        }
                        i = m.end();
                    }
                }
                if (result != null) {
                    result.set(ret);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("split", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                if (param.length < 1) {
                    return -1004;
                }
                String target = param[0].asString();
                boolean purgeempty = false;
                if (param.length >= 3) {
                    purgeempty = param[2].asBoolean();
                }
                Holder<Object> array = new Holder<Object>(null);
                _this.split(array, target, purgeempty);
                if (result != null) {
                    result.set((Dispatch2)array.mValue, (Dispatch2)array.mValue);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 0);
        this.registerNCM("matches", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mArray);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("start", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mStart);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) throws VariantException {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                _this.mStart = param.asInteger();
                return 0;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("index", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mIndex);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("lastIndex", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mLastIndex);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("input", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mInput);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("lastMatch", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mLastMatch);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("lastParen", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mLastParen);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("leftContext", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mLeftContext);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("rightContext", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                RegExpNI _this = (RegExpNI)objthis.getNativeInstance(mClassID);
                if (_this == null) {
                    return -1008;
                }
                result.set(_this.mRightContext);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 0);
        this.registerNCM("last", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(mLastRegExp);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
    }
}

