/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.ScriptLineData;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class ScriptBlock
implements SourceCodeAccessor {
    private static final boolean D_IS_DISASSEMBLE = false;
    private static final String NO_SCRIPT = "no script";
    private TJS mOwner;
    private InterCodeObject mTopLevelObject;
    private ArrayList<WeakReference<InterCodeObject>> mInterCodeObjectList;
    private String mName;
    private int mLineOffset;
    private String mScript;
    private ScriptLineData mLineData;

    public ScriptBlock(TJS owner, String name, int lineoffset, String script, ScriptLineData linedata) {
        this.mOwner = owner;
        this.mName = name;
        this.mLineOffset = lineoffset;
        this.mScript = script;
        this.mLineData = linedata;
        this.mOwner.addScriptBlock(this);
    }

    public void setObjects(InterCodeObject toplevel, ArrayList<InterCodeObject> objs) {
        this.mTopLevelObject = toplevel;
        this.mInterCodeObjectList = new ArrayList(objs.size());
        int count = objs.size();
        int i = 0;
        while (i < count) {
            this.mInterCodeObjectList.add(new WeakReference<InterCodeObject>(objs.get(i)));
            ++i;
        }
    }

    public void setObjects(InterCodeObject toplevel, InterCodeObject[] objs, int count) {
        this.mTopLevelObject = toplevel;
        this.mInterCodeObjectList = new ArrayList(objs.length);
        int i = 0;
        while (i < count) {
            this.mInterCodeObjectList.add(new WeakReference<InterCodeObject>(objs[i]));
            objs[i] = null;
            ++i;
        }
    }

    public ScriptBlock(TJS owner) {
        this.mOwner = owner;
        this.mOwner.addScriptBlock(this);
    }

    protected void finalize() {
        if (this.mTopLevelObject != null) {
            this.mTopLevelObject = null;
        }
        this.mOwner.removeScriptBlock(this);
        if (this.mScript != null) {
            this.mScript = null;
        }
        if (this.mName != null) {
            this.mName = null;
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void compact() {
        if (TJS.IsLowMemory) {
            this.mScript = null;
            this.mLineData = null;
            int count = this.mInterCodeObjectList.size();
            int i = 0;
            while (i < count) {
                InterCodeObject v = (InterCodeObject)this.mInterCodeObjectList.get(i).get();
                if (v != null) {
                    v.compact();
                }
                ++i;
            }
        }
    }

    @Override
    public int srcPosToLine(int pos) {
        if (this.mLineData == null) {
            return 0;
        }
        return this.mLineData.getSrcPosToLine(pos);
    }

    public TJS getTJS() {
        return this.mOwner;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public int getLineOffset() {
        return this.mLineOffset;
    }

    private void compactInterCodeObjectList() {
        int count = this.mInterCodeObjectList.size();
        int i = count - 1;
        while (i >= 0) {
            if (this.mInterCodeObjectList.get(i).get() == null) {
                this.mInterCodeObjectList.remove(i);
            }
            --i;
        }
    }

    public void executeTopLevel(Variant result, Dispatch2 context) throws VariantException, TJSException, CompileException {
        this.executeTopLevelScript(result, context);
        int context_count = this.mInterCodeObjectList.size();
        if (context_count != 1) {
            InterCodeObject toplevel = this.mTopLevelObject;
            if (this.mTopLevelObject != null) {
                this.mTopLevelObject = null;
            }
            this.remove(toplevel);
        }
    }

    public void executeTopLevelScript(Variant result, Dispatch2 context) throws VariantException, TJSException {
        if (this.mTopLevelObject != null) {
            this.mTopLevelObject.funcCall(0, null, result, null, context);
        }
    }

    public String getLineDescriptionString(int pos) {
        StringBuilder builer = new StringBuilder(512);
        int line = this.srcPosToLine(pos) + 1;
        if (this.mName != null) {
            builer.append(this.mName);
        } else {
            builer.append("anonymous@");
            builer.append(this.toString());
        }
        builer.append('(');
        builer.append(String.valueOf(line));
        builer.append(')');
        return builer.toString();
    }

    public int lineToSrcPos(int line) {
        if (this.mLineData == null) {
            return 0;
        }
        return this.mLineData.getLineToSrcPos(line -= this.mLineOffset);
    }

    @Override
    public String getLine(int line) {
        if (this.mLineData == null) {
            return NO_SCRIPT;
        }
        return this.mLineData.getLine(line -= this.mLineOffset);
    }

    public boolean isReusable() {
        return this.getContextCount() == 1 && this.mTopLevelObject != null;
    }

    public int getContextCount() {
        return this.mInterCodeObjectList.size();
    }

    public void add(InterCodeObject obj) {
        this.mInterCodeObjectList.add(new WeakReference<InterCodeObject>(obj));
    }

    public void remove(InterCodeObject obj) {
        int count = this.mInterCodeObjectList.size();
        int i = 0;
        while (i < count) {
            if (this.mInterCodeObjectList.get(i).get() == obj) {
                this.mInterCodeObjectList.remove(i);
                break;
            }
            ++i;
        }
        this.compactInterCodeObjectList();
    }

    public int getObjectIndex(InterCodeObject obj) {
        return this.mInterCodeObjectList.indexOf(obj);
    }

    public InterCodeObject getCodeObject(int index) {
        if (index >= 0 && index < this.mInterCodeObjectList.size()) {
            return (InterCodeObject)this.mInterCodeObjectList.get(index).get();
        }
        return null;
    }

    public String getNameInfo() {
        if (this.mLineOffset == 0) {
            return new String(this.mName);
        }
        return String.valueOf(this.mName) + "(line +" + String.valueOf(this.mLineOffset) + ")";
    }

    public int getTotalVMCodeSize() {
        this.compactInterCodeObjectList();
        int size = 0;
        int count = this.mInterCodeObjectList.size();
        int i = 0;
        while (i < count) {
            InterCodeObject obj = (InterCodeObject)this.mInterCodeObjectList.get(i).get();
            if (obj != null) {
                size += obj.getCodeSize();
            }
            ++i;
        }
        return size;
    }

    public int getTotalVMDataSize() {
        this.compactInterCodeObjectList();
        int size = 0;
        int count = this.mInterCodeObjectList.size();
        int i = 0;
        while (i < count) {
            InterCodeObject obj = (InterCodeObject)this.mInterCodeObjectList.get(i).get();
            if (obj != null) {
                size += obj.getDataSize();
            }
            ++i;
        }
        return size;
    }

    public static void consoleOutput(String msg, ScriptBlock blk) {
        TJS.outputToConsole(msg);
    }

    public void dump() throws VariantException {
        this.compactInterCodeObjectList();
        int count = this.mInterCodeObjectList.size();
        int i = 0;
        while (i < count) {
            InterCodeObject v = (InterCodeObject)this.mInterCodeObjectList.get(i).get();
            if (v != null) {
                ScriptBlock.consoleOutput("", this);
                String ptr = String.format(" 0x%08X", v.hashCode());
                ScriptBlock.consoleOutput("(" + v.getContextTypeName() + ") " + v.getName() + ptr, this);
                v.disassemble(this, 0, 0);
            }
            ++i;
        }
    }

    @Override
    public String getScript() {
        if (this.mScript != null) {
            return this.mScript;
        }
        return NO_SCRIPT;
    }

    @Override
    public int codePosToSrcPos(int codepos) {
        return 0;
    }
}

