/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.util.HashMap;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class ScriptCache {
    private static final int SCRIPT_CACHE_MAX = 64;
    private TJS mOwner;
    private HashMap<ScriptCacheData, ScriptBlock> mCache;

    public ScriptCache(TJS owner) {
        this.mOwner = owner;
        this.mCache = new HashMap(64);
    }

    public void execScript(String script, Variant result, Dispatch2 context, String name, int lineofs) throws VariantException, TJSException, CompileException {
        ScriptBlock blk;
        Compiler compiler = new Compiler(this.mOwner);
        if (name != null) {
            compiler.setName(name, lineofs);
        }
        if ((blk = compiler.doCompile(script, false, result != null)) == null) {
            return;
        }
        compiler = null;
        blk.executeTopLevel(result, context);
        if (blk.getContextCount() == 0) {
            this.mOwner.removeScriptBlock(blk);
        }
        blk.compact();
        blk = null;
    }

    public void evalExpression(String expression, Variant result, Dispatch2 context, String name, int lineofs) throws VariantException, TJSException, CompileException {
        if (name != null && name.length() > 0) {
            Compiler compiler = new Compiler(this.mOwner);
            compiler.setName(name, lineofs);
            ScriptBlock blk = compiler.doCompile(expression, true, result != null);
            compiler = null;
            if (blk != null) {
                blk.executeTopLevel(result, context);
                if (blk.getContextCount() == 0) {
                    this.mOwner.removeScriptBlock(blk);
                }
                blk.compact();
                blk = null;
            }
            return;
        }
        ScriptCacheData data = new ScriptCacheData();
        data.mScript = expression;
        data.mExpressionMode = true;
        data.mMustReturnResult = result != null;
        ScriptBlock block = this.mCache.get(data);
        if (block != null) {
            block.executeTopLevelScript(result, context);
            return;
        }
        Compiler compiler = new Compiler(this.mOwner);
        compiler.setName(name, lineofs);
        ScriptBlock blk = compiler.doCompile(expression, true, result != null);
        blk.executeTopLevel(result, context);
        boolean preprocess = compiler.isUsingPreProcessor();
        compiler = null;
        if (blk.isReusable() && !preprocess) {
            this.mCache.put(data, blk);
        } else if (blk.getContextCount() == 0) {
            this.mOwner.removeScriptBlock(blk);
        }
        blk.compact();
        blk = null;
    }

    static class ScriptCacheData {
        public String mScript;
        public boolean mExpressionMode;
        public boolean mMustReturnResult;

        ScriptCacheData() {
        }

        public boolean equals(Object o) {
            if (o instanceof ScriptCacheData && o != null) {
                ScriptCacheData rhs = (ScriptCacheData)o;
                return this.mScript.equals(rhs.mScript) && this.mExpressionMode == rhs.mExpressionMode && this.mMustReturnResult == rhs.mMustReturnResult;
            }
            return false;
        }

        public int hashCode() {
            int v = this.mScript.hashCode();
            v ^= this.mExpressionMode ? 1 : 0;
            return v ^= this.mMustReturnResult ? 1 : 0;
        }
    }
}

