/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.IntVector;

public class ScriptLineData {
    private final String mString;
    private IntVector mLineVector;
    private IntVector mLineLengthVector;
    private int mLineOffset;
    private static final int CARRIAGE_RETURN = 13;
    private static final int LINE_FEED = 10;

    public ScriptLineData(String string, int offset) {
        this.mString = string;
        this.mLineOffset = offset;
    }

    private final void generateLineVector() {
        this.mLineVector = new IntVector();
        this.mLineLengthVector = new IntVector();
        int count = this.mString.length();
        int lastCR = 0;
        int i = 0;
        while (i < count) {
            char c = this.mString.charAt(i);
            if (c == '\r' || c == '\n') {
                this.mLineVector.add(lastCR);
                this.mLineLengthVector.add(i - lastCR);
                lastCR = i + 1;
                if (i + 1 < count && ((c = this.mString.charAt(i + 1)) == '\r' || c == '\n')) {
                    lastCR = ++i + 1;
                }
            }
            ++i;
        }
        if (i != lastCR) {
            this.mLineVector.add(lastCR);
            this.mLineLengthVector.add(i - lastCR);
        }
    }

    public final int getSrcPosToLine(int pos) {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        int s = 0;
        int e = this.mLineVector.size();
        while (e - s > 1) {
            int m = s + (e - s) / 2;
            if (this.mLineVector.get(m) > pos) {
                e = m;
                continue;
            }
            s = m;
        }
        return s + this.mLineOffset;
    }

    public final int getLineToSrcPos(int pos) {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        return this.mLineVector.get(pos);
    }

    public final String getLine(int line) {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        int start = this.mLineVector.get(line);
        int length = this.mLineLengthVector.get(line);
        return this.mString.substring(start, start + length);
    }

    public final int getMaxLine() {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        return this.mLineVector.size();
    }
}

