/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.IntVector;

public class StringStream {
    private static final int BUFFER_CAPACITY = 1024;
    private final String mString;
    private final char[] mText;
    private int mOffset;
    private boolean mEOF;
    private int mStringStatus;
    private IntVector mLineVector;
    private IntVector mLineLengthVector;
    private int mLineOffset;
    private static final int CARRIAGE_RETURN = 13;
    private static final int LINE_FEED = 10;
    private static final int TAB = 9;
    private static final int SPACE = 32;
    public static final int NOT_COMMENT = 0;
    public static final int UNCLOSED_COMMENT = -1;
    public static final int CONTINUE = 1;
    public static final int ENDED = 2;
    public static final int NONE = 0;
    public static final int DELIMITER = 1;
    public static final int AMPERSAND = 2;
    public static final int DOLLAR = 3;

    public StringStream(String str) {
        this.mString = str;
        this.mText = new char[this.mString.length()];
        str.getChars(0, this.mString.length(), this.mText, 0);
    }

    public final void ungetC() {
        if (this.mOffset > 0) {
            --this.mOffset;
        }
    }

    public final int getC() {
        int retval = -1;
        if (this.mOffset < this.mText.length) {
            retval = this.mText[this.mOffset];
            ++this.mOffset;
        } else {
            this.mEOF = true;
        }
        return retval;
    }

    public final void incOffset() {
        if (this.mOffset < this.mText.length) {
            ++this.mOffset;
        } else {
            this.mEOF = true;
        }
    }

    public final int peekC() {
        int retval = -1;
        if (this.mOffset < this.mText.length) {
            retval = this.mText[this.mOffset];
        }
        return retval;
    }

    public final int peekC(int offset) {
        int retval = -1;
        if (this.mOffset + offset < this.mText.length) {
            retval = this.mText[this.mOffset + offset];
        }
        return retval;
    }

    public final int next() {
        int retval = -1;
        if (this.mOffset < this.mText.length) {
            retval = this.mText[this.mOffset];
            ++this.mOffset;
            while (retval == 13 || retval == 10) {
                if (this.mOffset < this.mText.length) {
                    retval = this.mText[this.mOffset];
                    ++this.mOffset;
                    continue;
                }
                retval = -1;
                this.mEOF = true;
                break;
            }
            return retval;
        }
        this.mEOF = true;
        return retval;
    }

    public final boolean isEOF() {
        return this.mEOF;
    }

    public final void skipSpace() {
        if (this.mOffset < this.mText.length) {
            char c = this.mText[this.mOffset];
            ++this.mOffset;
            boolean skipToLast = false;
            while (c == '\r' || c == '\n' || c == '\t' || c == ' ') {
                if (this.mOffset < this.mText.length) {
                    c = this.mText[this.mOffset];
                    ++this.mOffset;
                    continue;
                }
                skipToLast = true;
                break;
            }
            if (this.mOffset > 0 && !skipToLast) {
                --this.mOffset;
            }
        }
        if (this.mOffset >= this.mText.length) {
            this.mEOF = true;
        }
    }

    public final void skipReturn() {
        if (this.mOffset < this.mText.length) {
            char c = this.mText[this.mOffset];
            ++this.mOffset;
            boolean skipToLast = false;
            while (c == '\r' || c == '\n') {
                if (this.mOffset < this.mText.length) {
                    c = this.mText[this.mOffset];
                    ++this.mOffset;
                    continue;
                }
                skipToLast = true;
                break;
            }
            if (this.mOffset > 0 && !skipToLast) {
                --this.mOffset;
            }
        }
        if (this.mOffset >= this.mText.length) {
            this.mEOF = true;
        }
    }

    public final int skipComment() throws CompileException {
        int offset = this.mOffset;
        if (offset + 1 < this.mText.length) {
            if (this.mText[offset] != '/') {
                return 0;
            }
            if (this.mText[offset + 1] == '/') {
                this.mOffset += 2;
                char c = this.mText[this.mOffset];
                ++this.mOffset;
                while (c != '\r' && c != '\n') {
                    if (this.mOffset >= this.mText.length) break;
                    c = this.mText[this.mOffset];
                    ++this.mOffset;
                }
                if (this.mOffset < this.mText.length) {
                    if (c == '\r' && this.mText[this.mOffset] == '\n') {
                        ++this.mOffset;
                    }
                } else {
                    this.mEOF = true;
                    return 2;
                }
                this.skipSpace();
                if (this.mOffset >= this.mText.length) {
                    this.mEOF = true;
                    return 2;
                }
                return 1;
            }
            if (this.mText[offset + 1] == '*') {
                block16: {
                    this.mOffset += 2;
                    int level = 0;
                    while (this.mOffset + 1 < this.mText.length) {
                        if (this.mText[this.mOffset] == '/' && this.mText[this.mOffset + 1] == '*') {
                            ++level;
                        } else if (this.mText[this.mOffset] == '*' && this.mText[this.mOffset + 1] == '/') {
                            if (level == 0) {
                                this.mOffset += 2;
                                break block16;
                            }
                            --level;
                        }
                        ++this.mOffset;
                    }
                    throw new CompileException("\u30b3\u30e1\u30f3\u30c8\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
                }
                if (this.mOffset >= this.mText.length) {
                    this.mEOF = true;
                    return 2;
                }
                this.skipSpace();
                if (this.mOffset >= this.mText.length) {
                    this.mEOF = true;
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    public final int getOffset() {
        return this.mOffset;
    }

    public final void setOffset(int offset) {
        if (offset < this.mText.length) {
            this.mOffset = offset;
        } else {
            this.mOffset = this.mText.length;
            this.mEOF = true;
        }
    }

    public final boolean equalString(String value) {
        int count = value.length();
        if (this.mText.length - this.mOffset >= count) {
            int offset = this.mOffset;
            int i = 0;
            while (i < count) {
                if (this.mText[offset + i] != value.charAt(i)) {
                    return false;
                }
                ++i;
            }
            this.mOffset += count;
            return true;
        }
        return false;
    }

    public static final int unescapeBackSlash(int ch) {
        switch (ch) {
            case 97: {
                return 7;
            }
            case 98: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 11;
            }
        }
        return ch;
    }

    public final int countOctetTail() {
        if (this.mOffset < this.mText.length) {
            int offset = this.mOffset;
            while (offset + 1 < this.mText.length) {
                if (this.mText[offset] == '%' && this.mText[offset + 1] == '>') break;
                ++offset;
            }
            return offset - this.mOffset;
        }
        return 0;
    }

    public final String readString(int delimiter, boolean embexpmode) throws CompileException {
        if (this.mOffset < this.mText.length) {
            StringBuilder str;
            block32: {
                str = new StringBuilder(1024);
                this.mStringStatus = 0;
                try {
                    while (this.mOffset < this.mText.length) {
                        int offset;
                        char c = this.mText[this.mOffset];
                        ++this.mOffset;
                        while (c == '\r' || c == '\n') {
                            c = this.mText[this.mOffset];
                            ++this.mOffset;
                        }
                        if (c == '\\') {
                            int code;
                            c = this.mText[this.mOffset];
                            ++this.mOffset;
                            while (c == '\r' || c == '\n') {
                                c = this.mText[this.mOffset];
                                ++this.mOffset;
                            }
                            if (c == 'x' || c == 'X') {
                                code = 0;
                                int count = 0;
                                while (count < 4) {
                                    c = this.mText[this.mOffset];
                                    ++this.mOffset;
                                    while (c == '\r' || c == '\n') {
                                        c = this.mText[this.mOffset];
                                        ++this.mOffset;
                                    }
                                    int n = -1;
                                    if (c >= '0' && c <= '9') {
                                        n = c - 48;
                                    } else if (c >= 'a' && c <= 'f') {
                                        n = c - 97 + 10;
                                    } else if (c >= 'A' && c <= 'F') {
                                        n = c - 65 + 10;
                                    }
                                    if (n == -1) {
                                        --this.mOffset;
                                        break;
                                    }
                                    code <<= 4;
                                    code += n;
                                    ++count;
                                }
                                str.append((char)code);
                                continue;
                            }
                            if (c == '0') {
                                code = 0;
                                while (true) {
                                    c = this.mText[this.mOffset];
                                    ++this.mOffset;
                                    while (c == '\r' || c == '\n') {
                                        c = this.mText[this.mOffset];
                                        ++this.mOffset;
                                    }
                                    int n = -1;
                                    if (c >= '0' && c <= '7') {
                                        n = c - 48;
                                    }
                                    if (n == -1) {
                                        --this.mOffset;
                                        break;
                                    }
                                    code <<= 3;
                                    code += n;
                                }
                                str.append((char)code);
                                continue;
                            }
                            str.append((char)StringStream.unescapeBackSlash(c));
                            continue;
                        }
                        if (c == delimiter) {
                            if (this.mOffset >= this.mText.length) {
                                this.mStringStatus = 1;
                            } else {
                                offset = this.mOffset;
                                this.skipSpace();
                                c = this.mText[this.mOffset];
                                ++this.mOffset;
                                while (c == '\r' || c == '\n') {
                                    c = this.mText[this.mOffset];
                                    ++this.mOffset;
                                }
                                if (c == delimiter) continue;
                                this.mStringStatus = 1;
                                this.mOffset = offset;
                            }
                            break;
                        }
                        if (embexpmode && c == '&') {
                            if (this.mOffset < this.mText.length) {
                                this.mStringStatus = 2;
                            }
                            break;
                        }
                        if (embexpmode && c == '$') {
                            offset = this.mOffset;
                            c = this.mText[this.mOffset];
                            ++this.mOffset;
                            while (c == '\r' || c == '\n') {
                                c = this.mText[this.mOffset];
                                ++this.mOffset;
                            }
                            if (this.mOffset >= this.mText.length) break;
                            if (c == '{') {
                                if (this.mOffset < this.mText.length) {
                                    this.mStringStatus = 3;
                                }
                                break;
                            }
                            this.mOffset = offset;
                            str.append(c);
                            continue;
                        }
                        str.append(c);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.mEOF = true;
                    if (this.mStringStatus != 0) break block32;
                    throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
                }
            }
            if (this.mStringStatus == 0) {
                throw new CompileException("\u6587\u5b57\u5217\u5b9a\u6570/\u6b63\u898f\u8868\u73fe/\u30aa\u30af\u30c6\u30c3\u30c8\u5373\u5024\u304c\u7d42\u308f\u3089\u306a\u3044\u307e\u307e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u7aef\u306b\u9054\u3057\u307e\u3057\u305f");
            }
            return str.toString();
        }
        return null;
    }

    public final int getStringStatus() {
        return this.mStringStatus;
    }

    public final String substring(int beginIndex, int endIndex) {
        return this.mString.substring(beginIndex, endIndex);
    }

    private final void generateLineVector() {
        this.mLineVector = new IntVector();
        this.mLineLengthVector = new IntVector();
        int count = this.mText.length;
        int lastCR = 0;
        int i = 0;
        while (i < count) {
            char c = this.mText[i];
            if (c == '\r' || c == '\n') {
                this.mLineVector.add(lastCR);
                this.mLineLengthVector.add(i - lastCR);
                lastCR = i + 1;
                if (i + 1 < count && ((c = this.mText[i + 1]) == '\r' || c == '\n')) {
                    lastCR = ++i + 1;
                }
            }
            ++i;
        }
        if (i != lastCR) {
            this.mLineVector.add(lastCR);
            this.mLineLengthVector.add(i - lastCR);
        }
    }

    public final int getSrcPosToLine(int pos) {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        int s = 0;
        int e = this.mLineVector.size();
        while (e - s > 1) {
            int m = s + (e - s) / 2;
            if (this.mLineVector.get(m) > pos) {
                e = m;
                continue;
            }
            s = m;
        }
        return s + this.mLineOffset;
    }

    public final int getLineToSrcPos(int pos) {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        return this.mLineVector.get(pos);
    }

    public final String getLine(int line) {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        int start = this.mLineVector.get(line);
        int length = this.mLineLengthVector.get(line);
        return this.mString.substring(start, start + length);
    }

    public final int getMaxLine() {
        if (this.mLineVector == null) {
            this.generateLineVector();
        }
        return this.mLineVector.size();
    }
}

