/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.ArrayClass;
import jp.kirikiri.tjs2.ArrayObject;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.ByteCodeLoader;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.CompileState;
import jp.kirikiri.tjs2.Compiler;
import jp.kirikiri.tjs2.ConsoleOutput;
import jp.kirikiri.tjs2.CustomObject;
import jp.kirikiri.tjs2.DateClass;
import jp.kirikiri.tjs2.DictionaryClass;
import jp.kirikiri.tjs2.DictionaryObject;
import jp.kirikiri.tjs2.Dispatch;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.ExceptionClass;
import jp.kirikiri.tjs2.GlobalStringMap;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.Lexer;
import jp.kirikiri.tjs2.LexicalAnalyzer;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.MathClass;
import jp.kirikiri.tjs2.MessageMapper;
import jp.kirikiri.tjs2.RandomGeneratorClass;
import jp.kirikiri.tjs2.RandomGeneratorNI;
import jp.kirikiri.tjs2.RegExpClass;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.ScriptCache;
import jp.kirikiri.tjs2.ScriptLineData;
import jp.kirikiri.tjs2.StorageInterface;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class TJS {
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 4;
    public static final int VERSION_RELEASE = 28;
    public static final int VERSION_HEX = 33816604;
    private static final int ENV_WINDOWS = 0;
    private static final int ENV_ANDROID = 1;
    private static final int ENV_JAVA_APPLICATION = 2;
    private static final int ENV_JAVA_APPLET = 3;
    private static final int GLOBAL_HASH_BITS = 7;
    private static final int MEMBERENSURE = 512;
    private static GlobalStringMap mGlobalStringMap;
    private static ArrayList<String> mNativeClassNames;
    private static ConsoleOutput mConsoleOutput;
    private static MessageMapper mMessageMapper;
    public static boolean mWarnOnNonGlobalEvalOperator;
    public static boolean mUnaryAsteriskIgnoresPropAccess;
    public static boolean mEvalOperatorIsOnGlobal;
    public static boolean EnableDebugMode;
    public static boolean IsTarminating;
    public static boolean IsLowMemory;
    public static StorageInterface mStorage;
    private static Dispatch2 mArrayClass;
    private static Dispatch2 mDictionayClass;
    public static Variant[] NULL_ARG;
    private HashMap<String, Integer> mPPValues;
    private ArrayList<WeakReference<ScriptBlock>> mScriptBlocks;
    private CustomObject mGlobal;
    private ScriptCache mCache = new ScriptCache(this);
    private static ArrayList<Dispatch> mFinalizeList;

    public static void initialize() {
        mFinalizeList = new ArrayList();
        NULL_ARG = new Variant[0];
        IsTarminating = false;
        mWarnOnNonGlobalEvalOperator = false;
        mUnaryAsteriskIgnoresPropAccess = false;
        mNativeClassNames = new ArrayList();
        mGlobalStringMap = new GlobalStringMap();
        mEvalOperatorIsOnGlobal = false;
        EnableDebugMode = true;
        mConsoleOutput = null;
        mMessageMapper = new MessageMapper();
        RandomGeneratorNI.setRandomBits128(null);
        CompileState.mEnableDicFuncQuickHack = true;
        Variant.initialize();
        DictionaryObject.initialize();
        ArrayObject.initialize();
        ByteCodeLoader.initialize();
        CustomObject.initialize();
        MathClass.initialize();
        LexicalAnalyzer.initialize();
        try {
            mArrayClass = new ArrayClass();
            mDictionayClass = new DictionaryClass();
        }
        catch (VariantException variantException) {
        }
        catch (TJSException tJSException) {
            // empty catch block
        }
    }

    public static void finalizeApplication() {
        if (mFinalizeList != null) {
            int count = mFinalizeList.size();
            int i = 0;
            while (i < count) {
                Dispatch dsp = mFinalizeList.get(i);
                dsp.doFinalize();
                ++i;
            }
            mFinalizeList.clear();
            mFinalizeList = null;
        }
        mGlobalStringMap = null;
        if (mNativeClassNames != null) {
            mNativeClassNames.clear();
        }
        mNativeClassNames = null;
        mConsoleOutput = null;
        mMessageMapper = null;
        mStorage = null;
        mArrayClass = null;
        mDictionayClass = null;
        NULL_ARG = null;
        ArrayObject.finalizeApplication();
        ByteCodeLoader.finalizeApplication();
        CustomObject.finalizeApplication();
        DictionaryObject.finalizeApplication();
        MathClass.finalizeApplication();
        Variant.finalizeApplication();
        LexicalAnalyzer.finalizeApplication();
    }

    public static void doObjectFinalize() {
        if (mFinalizeList != null) {
            System.runFinalization();
            int count = mFinalizeList.size();
            if (count > 0) {
                int i = 0;
                while (i < count) {
                    Dispatch dsp = mFinalizeList.get(i);
                    dsp.doFinalize();
                    ++i;
                }
                mFinalizeList.clear();
            }
        }
    }

    public static void pushObject(Dispatch obj) {
        if (mFinalizeList != null) {
            mFinalizeList.add(obj);
        }
    }

    public TJS() throws VariantException, TJSException {
        this.mPPValues = new HashMap();
        this.setPPValue("version", 33816604);
        this.setPPValue("environment", 2);
        this.setPPValue("compatibleSystem", 1);
        this.mGlobal = new CustomObject(7);
        this.mScriptBlocks = new ArrayList();
        Dispatch2 dsp = mArrayClass;
        Variant val = new Variant(dsp, null);
        this.mGlobal.propSet(512, "Array", val, this.mGlobal);
        dsp = mDictionayClass;
        val = new Variant(dsp, null);
        this.mGlobal.propSet(512, "Dictionary", val, this.mGlobal);
        dsp = new DateClass();
        val = new Variant(dsp, null);
        this.mGlobal.propSet(512, "Date", val, this.mGlobal);
        MathClass math = new MathClass();
        dsp = math;
        val = new Variant(dsp, null);
        this.mGlobal.propSet(512, "Math", val, this.mGlobal);
        dsp = new RandomGeneratorClass();
        val = new Variant(dsp, null);
        math.propSet(512, "RandomGenerator", val, math);
        dsp = new ExceptionClass();
        val = new Variant(dsp, null);
        this.mGlobal.propSet(512, "Exception", val, this.mGlobal);
        dsp = new RegExpClass();
        val = new Variant(dsp, null);
        this.mGlobal.propSet(512, "RegExp", val, this.mGlobal);
    }

    public void setPPValue(String name, int value) {
        if (name != null) {
            this.mPPValues.put(name, value);
        }
    }

    public int getPPValue(String name) {
        Integer ret = this.mPPValues.get(name);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public static void outputExceptionToConsole(String msg) {
        TJS.outputToConsole(msg);
    }

    public static void outputToConsole(String mes) {
        if (mConsoleOutput == null) {
            Logger.log(mes);
        } else {
            mConsoleOutput.print(mes);
        }
    }

    public static void outputToConsoleWithCentering(String msg, int width) {
        if (msg == null) {
            return;
        }
        int len = msg.length();
        int ns = (width - len) / 2;
        if (ns <= 0) {
            TJS.outputToConsole(msg);
        } else {
            StringBuilder builder = new StringBuilder(ns + len + 1);
            while (ns-- > 0) {
                builder.append(' ');
            }
            builder.append(msg);
            TJS.outputToConsole(builder.toString());
            builder = null;
        }
    }

    public static void outputToConsoleSeparator(String text, int count) {
        int len = text.length();
        StringBuilder builder = new StringBuilder(len * count);
        while (count > 0) {
            builder.append(text);
            --count;
        }
        TJS.outputToConsole(builder.toString());
    }

    public static String mapGlobalStringMap(String str) {
        return mGlobalStringMap.map(str);
    }

    public static int registerNativeClass(String name) {
        int count = mNativeClassNames.size();
        int i = 0;
        while (i < count) {
            if (mNativeClassNames.get(i).equals(name)) {
                return i;
            }
            ++i;
        }
        mNativeClassNames.add(TJS.mapGlobalStringMap(name));
        return mNativeClassNames.size() - 1;
    }

    public static int findNaitveClassID(String name) {
        int count = mNativeClassNames.size();
        int i = 0;
        while (i < count) {
            if (mNativeClassNames.get(i).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final String findNativeClassName(int id) {
        if (id < 0 || id >= mNativeClassNames.size()) {
            return null;
        }
        return mNativeClassNames.get(id);
    }

    public static void setConsoleOutput(ConsoleOutput console) {
        mConsoleOutput = console;
    }

    public static ConsoleOutput getConsoleOutput() {
        return mConsoleOutput;
    }

    public void execScript(String script, Variant result, Dispatch2 context, String name, int lineofs) throws VariantException, TJSException, CompileException {
        if (this.mCache != null) {
            this.mCache.execScript(script, result, context, name, lineofs);
        }
    }

    public void evalExpression(String expression, Variant result, Dispatch2 context, String name, int lineofs) throws VariantException, TJSException, CompileException {
        if (this.mCache != null) {
            this.mCache.evalExpression(expression, result, context, name, lineofs);
        }
    }

    public void compileScript(String script, String name, int lineofs, boolean isresultneeded, BinaryStream output) throws CompileException, VariantException, TJSException {
        Compiler compiler = new Compiler(this);
        if (name != null) {
            compiler.setName(name, lineofs);
        }
        compiler.compile(script, false, isresultneeded, output);
        compiler = null;
    }

    public void toJavaCode(String script, String name, int lineofs, boolean isresultneeded) throws CompileException, VariantException, TJSException {
        Compiler compiler = new Compiler(this);
        if (name != null) {
            compiler.setName(name, lineofs);
        }
        compiler.toJavaCode(script, false, isresultneeded);
        compiler = null;
    }

    public void loadByteCode(Variant result, Dispatch2 context, String name, BinaryStream input) throws TJSException {
        ByteCodeLoader loader = new ByteCodeLoader();
        ScriptBlock block = loader.readByteCode(this, name, input);
        if (block != null) {
            block.executeTopLevel(result, context);
            if (block.getContextCount() == 0) {
                this.removeScriptBlock(block);
            }
            block = null;
        }
    }

    public Dispatch2 getGlobal() {
        return this.mGlobal;
    }

    public static Dispatch2 createArrayObject() throws VariantException, TJSException {
        return TJS.createArrayObject(null);
    }

    public static Dispatch2 createArrayObject(Holder<Dispatch2> classout) throws VariantException, TJSException {
        if (classout != null) {
            classout.mValue = mArrayClass;
        }
        Holder<Object> holder = new Holder<Object>(null);
        mArrayClass.createNew(0, null, holder, null, mArrayClass);
        return (Dispatch2)holder.mValue;
    }

    public static Dispatch2 createDictionaryObject() throws VariantException, TJSException {
        return TJS.createDictionaryObject(null);
    }

    public static Dispatch2 createDictionaryObject(Holder<Dispatch2> classout) throws VariantException, TJSException {
        if (classout != null) {
            classout.mValue = mDictionayClass;
        }
        Holder<Object> holder = new Holder<Object>(null);
        mDictionayClass.createNew(0, null, holder, null, mDictionayClass);
        return (Dispatch2)holder.mValue;
    }

    public void addScriptBlock(ScriptBlock block) {
        this.mScriptBlocks.add(new WeakReference<ScriptBlock>(block));
    }

    public void removeScriptBlock(ScriptBlock block) {
        int count = this.mScriptBlocks.size();
        int i = 0;
        while (i < count) {
            if (this.mScriptBlocks.get(i).get() == block) {
                this.mScriptBlocks.remove(i);
                break;
            }
            ++i;
        }
        this.compactScriptBlock();
    }

    private void compactScriptBlock() {
        int count = this.mScriptBlocks.size();
        int i = count - 1;
        while (i >= 0) {
            if (this.mScriptBlocks.get(i).get() == null) {
                this.mScriptBlocks.remove(i);
            }
            --i;
        }
    }

    public void dump() throws VariantException {
        this.dump(80);
    }

    public void dump(int width) throws VariantException {
        String version = String.format("TJS version %d.%d.%d", 2, 4, 28);
        TJS.outputToConsoleSeparator("#", width);
        TJS.outputToConsoleWithCentering("TJS Context Dump", width);
        TJS.outputToConsoleSeparator("#", width);
        TJS.outputToConsole(version);
        TJS.outputToConsole("");
        this.compactScriptBlock();
        if (this.mScriptBlocks.size() > 0) {
            ScriptBlock b;
            String buf = String.format("Total %d script block(s)", this.mScriptBlocks.size());
            TJS.outputToConsole(buf);
            TJS.outputToConsole("");
            int totalcontexts = 0;
            int totalcodesize = 0;
            int totaldatasize = 0;
            int i = 0;
            while (i < this.mScriptBlocks.size()) {
                b = (ScriptBlock)this.mScriptBlocks.get(i).get();
                if (b != null) {
                    String name = b.getName();
                    String title = name != null ? b.getNameInfo() : "(no-named script block)";
                    String ptr = String.format(" 0x%08X", b.hashCode());
                    title = String.valueOf(title) + ptr;
                    TJS.outputToConsole(title);
                    int n = b.getContextCount();
                    totalcontexts += n;
                    buf = String.format("\tCount of contexts      : %d", n);
                    TJS.outputToConsole(buf);
                    n = b.getTotalVMCodeSize();
                    totalcodesize += n;
                    buf = String.format("\tVM code area size      : %d words", n);
                    TJS.outputToConsole(buf);
                    n = b.getTotalVMDataSize();
                    totaldatasize += n;
                    buf = String.format("\tVM constant data count : %d", n);
                    TJS.outputToConsole(buf);
                    TJS.outputToConsole("");
                }
                ++i;
            }
            buf = String.format("Total count of contexts      : %d", totalcontexts);
            TJS.outputToConsole(buf);
            buf = String.format("Total VM code area size      : %d words", totalcodesize);
            TJS.outputToConsole(buf);
            buf = String.format("Total VM constant data count : %d", totaldatasize);
            TJS.outputToConsole(buf);
            TJS.outputToConsole("");
            i = 0;
            while (i < this.mScriptBlocks.size()) {
                b = (ScriptBlock)this.mScriptBlocks.get(i).get();
                if (b != null) {
                    TJS.outputToConsoleSeparator("-", width);
                    String name = b.getName();
                    String title = name != null ? b.getNameInfo() : "(no-named script block)";
                    String ptr = String.format(" 0x%08X", b.hashCode());
                    title = String.valueOf(title) + ptr;
                    TJS.outputToConsoleWithCentering(title, width);
                    TJS.outputToConsoleSeparator("-", width);
                    b.dump();
                    TJS.outputToConsole("");
                    TJS.outputToConsole("");
                }
                ++i;
            }
        } else {
            TJS.outputToConsole("");
            TJS.outputToConsole("There are no script blocks in the system.");
        }
    }

    public static void registerMessageMap(String name, MessageMapper.MessageHolder holder) {
        if (mMessageMapper != null) {
            mMessageMapper.register(name, holder);
        }
    }

    public static void unregisterMessageMap(String name) {
        if (mMessageMapper != null) {
            mMessageMapper.unregister(name);
        }
    }

    public static boolean assignMessage(String name, String newmsg) {
        if (mMessageMapper != null) {
            return mMessageMapper.assignMessage(name, newmsg);
        }
        return false;
    }

    public static String createMessageMapString() {
        if (mMessageMapper != null) {
            return mMessageMapper.createMessageMapString();
        }
        return "";
    }

    public static String getMessageMapMessage(String name) {
        if (mMessageMapper != null) {
            String ret = mMessageMapper.get(name);
            if (ret != null) {
                return ret;
            }
            return "";
        }
        return "";
    }

    public void shutdown() {
        if (this.mGlobal != null) {
            try {
                this.mGlobal.invalidate(0, null, this.mGlobal);
            }
            catch (VariantException variantException) {
            }
            catch (TJSException tJSException) {
                // empty catch block
            }
            this.mGlobal.clear();
            this.mGlobal = null;
        }
        if (this.mCache != null) {
            this.mCache = null;
        }
    }

    public void lexTest(String script) {
        Compiler compiler = new Compiler(this);
        int token = 0;
        ScriptLineData lineData = new ScriptLineData(script, 0);
        Lexer lexer = new Lexer(compiler, script, false, false);
        LexicalAnalyzer lex = new LexicalAnalyzer(compiler, script, false, false);
        try {
            do {
                Object o2;
                Object o1;
                int v2;
                int v1;
                token = lexer.getNext();
                int token1 = lex.getNext();
                if (token1 != token) {
                    int oleline = lineData.getSrcPosToLine(lexer.getCurrentPosition());
                    int newline = lineData.getSrcPosToLine(lex.getCurrentPosition());
                    System.out.print("error line:" + oleline + ", " + newline + "\n");
                }
                if ((v1 = lexer.getValue()) != (v2 = lex.getValue())) {
                    int oleline = lineData.getSrcPosToLine(lexer.getCurrentPosition());
                    int newline = lineData.getSrcPosToLine(lex.getCurrentPosition());
                    System.out.print("error line:" + oleline + ", " + newline + "\n");
                }
                if (v1 == 0 || (o1 = lexer.getValue(v1).toJavaObject()).equals(o2 = lex.getValue(v2).toJavaObject())) continue;
                int oleline = lineData.getSrcPosToLine(lexer.getCurrentPosition());
                int newline = lineData.getSrcPosToLine(lex.getCurrentPosition());
                System.out.print("o1:" + o1.toString() + ", o2" + o2.toString() + "\n");
                System.out.print("error line:" + oleline + ", " + newline + "\n");
            } while (token != 0);
        }
        catch (CompileException v1) {
            // empty catch block
        }
        long start = System.currentTimeMillis();
        lexer = new Lexer(compiler, script, false, false);
        try {
            do {
                token = lexer.getNext();
                lexer.getValue();
            } while (token != 0);
        }
        catch (CompileException o1) {
            // empty catch block
        }
        long time = System.currentTimeMillis() - start;
        System.out.print("old lex : " + time + "ms\n");
        start = System.currentTimeMillis();
        lex = new LexicalAnalyzer(compiler, script, false, false);
        try {
            do {
                token = lex.getNext();
                lex.getValue();
            } while (token != 0);
        }
        catch (CompileException compileException) {
            // empty catch block
        }
        time = System.currentTimeMillis() - start;
        System.out.print("new lex : " + time + "ms\n");
    }
}

