/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.TJSException;

public class TJSScriptError
extends TJSException {
    private static final long serialVersionUID = -1727870605938357683L;
    private static final int MAX_TRACE_TEXT_LEN = 1500;
    private SourceCodeAccessor mAccessor;
    private int mPosition;
    private String mTrace;

    public SourceCodeAccessor getAccessor() {
        return this.mAccessor;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public int GetSourceLine() {
        return this.mAccessor.srcPosToLine(this.mPosition) + 1;
    }

    public final String getBlockName() {
        String name = this.mAccessor.getName();
        return name != null ? name : "";
    }

    public final String getTrace() {
        return this.mTrace;
    }

    public boolean addTrace(ScriptBlock block, int srcpos) {
        int len = this.mTrace.length();
        if (len >= 1500) {
            return false;
        }
        if (len != 0) {
            this.mTrace = String.valueOf(this.mTrace) + " <-- ";
        }
        this.mTrace = String.valueOf(this.mTrace) + block.getLineDescriptionString(srcpos);
        return true;
    }

    public boolean addTrace(String data) {
        int len = this.mTrace.length();
        if (len >= 1500) {
            return false;
        }
        if (len != 0) {
            this.mTrace = String.valueOf(this.mTrace) + " <-- ";
        }
        this.mTrace = String.valueOf(this.mTrace) + data;
        return true;
    }

    public TJSScriptError(String Msg, SourceCodeAccessor accessor, int pos) {
        super(Msg);
        this.mAccessor = accessor;
        this.mPosition = pos;
        this.mTrace = new String();
    }

    public TJSScriptError(TJSScriptError ref) {
        this.mAccessor = ref.mAccessor;
        this.mPosition = ref.mPosition;
        this.mTrace = ref.mTrace;
    }

    public boolean addTrace(InterCodeObject context, int codepos) {
        int len = this.mTrace.length();
        if (len >= 1500) {
            return false;
        }
        if (len != 0) {
            this.mTrace = String.valueOf(this.mTrace) + " <-- ";
        }
        this.mTrace = String.valueOf(this.mTrace) + context.getPositionDescriptionString(codepos);
        return true;
    }
}

