/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import jp.kirikiri.tjs2.CustomObject;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class Utils {
    public static String VariantToReadableString(Variant val) throws VariantException {
        return Utils.VariantToReadableString(val, 512);
    }

    public static String VariantToReadableString(Variant val, int maxlen) throws VariantException {
        String ret = null;
        if (val == null || val.isVoid()) {
            ret = new String("(void)");
        } else if (val.isInteger()) {
            ret = new String("(int)" + val.asString());
        } else if (val.isReal()) {
            ret = new String("(real)" + val.asString());
        } else if (val.isString()) {
            ret = new String("(string)\"" + LexBase.escapeC(val.asString()) + "\"");
        } else if (val.isOctet()) {
            ret = new String("(octet)<% " + Variant.OctetToListString(val.asOctet()) + " %>");
        } else if (val.isObject()) {
            String name;
            VariantClosure c = val.asObjectClosure();
            StringBuilder str = new StringBuilder(128);
            str.append("(object)");
            str.append('(');
            if (c.mObject != null) {
                str.append('[');
                if (c.mObject instanceof NativeClass) {
                    str.append(((NativeClass)c.mObject).getClassName());
                } else if (c.mObject instanceof InterCodeObject) {
                    str.append(((InterCodeObject)c.mObject).getName());
                } else if (c.mObject instanceof CustomObject) {
                    name = ((CustomObject)c.mObject).getClassNames();
                    if (name != null) {
                        str.append(name);
                    } else {
                        str.append(c.mObject.getClass().getName());
                    }
                } else {
                    str.append(c.mObject.getClass().getName());
                }
                str.append(']');
            } else {
                str.append("0x00000000");
            }
            if (c.mObjThis != null) {
                str.append('[');
                if (c.mObjThis instanceof NativeClass) {
                    str.append(((NativeClass)c.mObjThis).getClassName());
                } else if (c.mObjThis instanceof InterCodeObject) {
                    str.append(((InterCodeObject)c.mObjThis).getName());
                } else if (c.mObjThis instanceof CustomObject) {
                    name = ((CustomObject)c.mObjThis).getClassNames();
                    if (name != null) {
                        str.append(name);
                    } else {
                        str.append(c.mObjThis.getClass().getName());
                    }
                } else {
                    str.append(c.mObjThis.getClass().getName());
                }
                str.append(']');
            } else {
                str.append(":0x00000000");
            }
            str.append(')');
            ret = str.toString();
        } else {
            ret = new String("(octet) [" + val.getClass().getName() + "]");
        }
        if (ret != null) {
            if (ret.length() > maxlen) {
                return ret.substring(0, maxlen);
            }
            return ret;
        }
        return new String("");
    }

    public static final String variantToExpressionString(Variant val) throws VariantException {
        if (val.isVoid()) {
            return "void";
        }
        if (val.isInteger()) {
            return val.asString();
        }
        if (val.isReal()) {
            String s = Variant.realToHexString(val.asDouble());
            return String.valueOf(s) + " /* " + val.asString() + " */";
        }
        if (val.isString()) {
            String s = LexBase.escapeC(val.asString());
            return "\"" + s + "\"";
        }
        if (val.isOctet()) {
            String s = Variant.octetToListString(val.asOctet());
            return "<%" + s + "%>";
        }
        return new String();
    }

    public static String formatString(String format, Variant[] params) {
        int count = params.length;
        Object[] args = new Object[count];
        int i = 0;
        while (i < count) {
            int length;
            args[i] = params[i].toJavaObject();
            if (args[i] instanceof String && (length = ((String)args[i]).length()) == 1) {
                args[i] = Character.valueOf(((String)args[i]).charAt(0));
            }
            ++i;
        }
        return String.format(format, args);
    }
}

