/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class Variant
implements Cloneable {
    private static VariantClosure NullVariantClosure;
    private static StringBuilder mBuilder;
    public static final int VOID = 0;
    public static final int OBJECT = 1;
    public static final int STRING = 2;
    public static final int OCTET = 3;
    public static final int INTEGER = 4;
    public static final int REAL = 5;
    public static final String TYPE_VOID = "void";
    public static final String TYPE_INTEGER = "int";
    public static final String TYPE_REAL = "real";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_OCTET = "octet";
    public static final String TYPE_OBJECT = "object";
    private Object mObject;
    private static final long IEEE_D_SIGN_MASK = Long.MIN_VALUE;
    private static final long D_EXP_MASK = 0x7FF0000000000000L;
    private static final int D_SIGNIFICAND_BITS = 52;
    private static final long D_EXP_BIAS = 1023L;

    public static void initialize() {
        NullVariantClosure = new VariantClosure(null, null);
        mBuilder = new StringBuilder(256);
    }

    public static void finalizeApplication() {
        NullVariantClosure = null;
        mBuilder = null;
    }

    public Variant() {
    }

    public Variant(int value) {
        this.mObject = value;
    }

    public Variant(double value) {
        this.mObject = value;
    }

    public Variant(ByteBuffer value) {
        this.mObject = value;
    }

    public Variant(String value) {
        this.mObject = value;
    }

    public Variant(Variant value) {
        if (value.mObject instanceof VariantClosure) {
            VariantClosure clo = (VariantClosure)value.mObject;
            this.mObject = new VariantClosure(clo.mObject, clo.mObjThis);
        } else {
            this.mObject = value.mObject;
        }
    }

    public Variant(Object value) {
        this.mObject = value;
    }

    public Variant(Dispatch2 dsp, Dispatch2 dsp2) {
        this.mObject = new VariantClosure(dsp, dsp2);
    }

    public Variant(Dispatch2 dsp) {
        this.mObject = new VariantClosure(dsp, null);
    }

    public final void set(int value) {
        this.mObject = value;
    }

    public final void set(double value) {
        this.mObject = value;
    }

    public final void set(ByteBuffer value) {
        this.mObject = value;
    }

    public final void set(String value) {
        this.mObject = value;
    }

    public final void setJavaObject(Object value) {
        this.mObject = value;
    }

    public final void set(Variant value) {
        if (value.mObject instanceof VariantClosure) {
            VariantClosure clo = (VariantClosure)value.mObject;
            this.mObject = new VariantClosure(clo.mObject, clo.mObjThis);
        } else if (this.mObject != value.mObject) {
            this.mObject = value.mObject;
        }
    }

    public final void set(Dispatch2 dsp, Dispatch2 dsp2) {
        this.mObject = new VariantClosure(dsp, dsp2);
    }

    public final void set(Dispatch2 dsp) {
        this.mObject = new VariantClosure(dsp);
    }

    public final void copyRef(Variant value) {
        if (value.mObject instanceof VariantClosure) {
            VariantClosure clo = (VariantClosure)value.mObject;
            this.mObject = new VariantClosure(clo.mObject, clo.mObjThis);
        } else if (this.mObject != value.mObject) {
            this.mObject = value.mObject;
        }
    }

    public final Object cloneSeparate() {
        if (this.mObject instanceof VariantClosure) {
            VariantClosure clo = (VariantClosure)this.mObject;
            return new VariantClosure(clo.mObject, clo.mObjThis);
        }
        return this.mObject;
    }

    public static final String OctetToListString(ByteBuffer oct) {
        int size = oct.capacity();
        String hex = new String("0123456789ABCDEF");
        StringBuilder str = mBuilder;
        str.delete(0, str.length());
        int i = 0;
        while (i < size) {
            byte b = oct.get(i);
            str.append(hex.charAt(b >> 4 & 0xF));
            str.append(hex.charAt(b & 0xF));
            if (i != size - 1) {
                str.append(' ');
            }
            ++i;
        }
        return str.toString();
    }

    public final Variant getBitNotValue() throws VariantException {
        int val = this.asInteger();
        return new Variant(~val);
    }

    public final Variant getNotValue() {
        boolean val = !this.asBoolean();
        return new Variant(val ? 1 : 0);
    }

    public final Variant logicOr(Variant val) {
        boolean v = this.asBoolean() || val.asBoolean();
        return new Variant(v ? 1 : 0);
    }

    public final Variant logicAnd(Variant val) {
        boolean v = this.asBoolean() && val.asBoolean();
        return new Variant(v ? 1 : 0);
    }

    public final Variant bitOr(Variant val) throws VariantException {
        int v = this.asInteger() | val.asInteger();
        return new Variant(v);
    }

    public final Variant bitXor(Variant val) throws VariantException {
        int v = this.asInteger() ^ val.asInteger();
        return new Variant(v);
    }

    public final Variant bitAnd(Variant val) throws VariantException {
        int v = this.asInteger() & val.asInteger();
        return new Variant(v);
    }

    public final Variant notEqual(Variant val) throws VariantException {
        boolean v = this.normalCompare(val);
        return new Variant(!v ? 1 : 0);
    }

    public final Variant equalEqual(Variant val) throws VariantException {
        boolean v = this.normalCompare(val);
        return new Variant(v ? 1 : 0);
    }

    public final Variant discNotEqual(Variant val) {
        boolean v = this.discernCompareInternal(val);
        return new Variant(!v ? 1 : 0);
    }

    public final Variant discernCompare(Variant val) {
        boolean v = this.discernCompareInternal(val);
        return new Variant(v ? 1 : 0);
    }

    public final Variant lt(Variant val) throws VariantException {
        boolean v = this.greaterThan(val);
        return new Variant(v ? 1 : 0);
    }

    public final Variant gt(Variant val) throws VariantException {
        boolean v = this.littlerThan(val);
        return new Variant(v ? 1 : 0);
    }

    public final Variant ltOrEqual(Variant val) throws VariantException {
        boolean v = this.littlerThan(val);
        return new Variant(!v ? 1 : 0);
    }

    public final Variant gtOrEqual(Variant val) throws VariantException {
        boolean v = this.greaterThan(val);
        return new Variant(!v ? 1 : 0);
    }

    public final Variant rightShift(Variant val) throws VariantException {
        int v = this.asInteger() >> val.asInteger();
        return new Variant(v);
    }

    public final Variant leftShift(Variant val) throws VariantException {
        int v = this.asInteger() << val.asInteger();
        return new Variant(v);
    }

    public final Variant rightBitShift(Variant val) throws VariantException {
        int v = this.asInteger();
        return new Variant(v >>>= val.asInteger());
    }

    public final Variant add(Variant val) throws VariantException {
        if (this.mObject instanceof String || val.mObject instanceof String) {
            String s1 = this.asString();
            String s2 = val.asString();
            if (s1 != null && s2 != null) {
                StringBuilder builder = mBuilder;
                builder.delete(0, builder.length());
                builder.append(s1);
                builder.append(s2);
                return new Variant(builder.toString());
            }
            if (s1 != null) {
                return new Variant(s1);
            }
            return new Variant(s2);
        }
        if (this.mObject != null && val.mObject != null && this.mObject.getClass().isAssignableFrom(val.mObject.getClass())) {
            if (this.mObject instanceof ByteBuffer) {
                ByteBuffer b1 = (ByteBuffer)this.mObject;
                ByteBuffer b2 = (ByteBuffer)val.mObject;
                ByteBuffer result = ByteBuffer.allocate(b1.capacity() + b2.capacity());
                b1.position(0);
                b2.position(0);
                result.put(b1);
                result.put(b2);
                result.position(0);
                return new Variant(result);
            }
            if (this.mObject instanceof Integer) {
                int result = (Integer)this.mObject + (Integer)val.mObject;
                return new Variant(result);
            }
        }
        if (this.mObject == null && val.mObject != null) {
            if (val.mObject instanceof Integer) {
                return new Variant((Integer)val.mObject);
            }
            if (val.mObject instanceof Double) {
                return new Variant((Double)val.mObject);
            }
        }
        if (val.mObject == null && this.mObject != null) {
            if (this.mObject instanceof Integer) {
                return new Variant((Integer)this.mObject);
            }
            if (this.mObject instanceof Double) {
                return new Variant((Double)this.mObject);
            }
        }
        return new Variant(this.asDouble() + val.asDouble());
    }

    public final Variant subtract(Variant val) throws VariantException {
        if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
            int result = (Integer)this.mObject - (Integer)val.mObject;
            return new Variant(result);
        }
        Number n1 = this.asNumber();
        Number n2 = val.asNumber();
        if (n1 instanceof Integer && n2 instanceof Integer) {
            int result = n1.intValue() - n2.intValue();
            return new Variant(result);
        }
        double result = n1.doubleValue() - n2.doubleValue();
        return new Variant(result);
    }

    public final Variant residue(Variant val) throws VariantException {
        int r = val.asInteger();
        if (r == 0) {
            Variant.throwDividedByZero();
        }
        int l = this.asInteger();
        return new Variant(l % r);
    }

    public final Variant divide(Variant val) throws VariantException {
        double l = this.asDouble();
        double r = val.asDouble();
        return new Variant(l / r);
    }

    public final Variant idiv(Variant val) throws VariantException {
        int r = val.asInteger();
        if (r == 0) {
            Variant.throwDividedByZero();
        }
        int l = this.asInteger();
        return new Variant(l / r);
    }

    public final Variant multiply(Variant val) throws VariantException {
        if (this.mObject == null || val.mObject == null) {
            return new Variant(0);
        }
        if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
            int result = (Integer)this.mObject * (Integer)val.mObject;
            return new Variant(result);
        }
        Number n1 = this.asNumber();
        Number n2 = val.asNumber();
        if (n1 instanceof Integer && n2 instanceof Integer) {
            int result = n1.intValue() * n2.intValue();
            return new Variant(result);
        }
        double result = n1.doubleValue() * n2.doubleValue();
        return new Variant(result);
    }

    public final boolean normalCompare(Variant val2) throws VariantException {
        if (this.mObject != null && val2.mObject != null) {
            if (this.mObject.getClass().isAssignableFrom(val2.mObject.getClass())) {
                if (this.mObject instanceof Integer) {
                    return ((Integer)this.mObject).intValue() == ((Integer)val2.mObject).intValue();
                }
                if (this.mObject instanceof String) {
                    return ((String)this.mObject).equals((String)val2.mObject);
                }
                if (this.mObject instanceof ByteBuffer) {
                    int c2;
                    ByteBuffer v1 = (ByteBuffer)this.mObject;
                    ByteBuffer v2 = (ByteBuffer)val2.mObject;
                    int c1 = v1.limit();
                    if (c1 == (c2 = v2.limit())) {
                        int i = 0;
                        while (i < c1) {
                            byte b2;
                            byte b1 = v1.get(i);
                            if (b1 != (b2 = v2.get(i))) {
                                return false;
                            }
                            ++i;
                        }
                    } else {
                        return false;
                    }
                    return true;
                }
                if (this.mObject instanceof Double) {
                    return ((Double)this.mObject).doubleValue() == ((Double)val2.mObject).doubleValue();
                }
                return this.mObject.equals(val2.mObject);
            }
            if (this.mObject instanceof String || val2.mObject instanceof String) {
                String v1 = this.asString();
                String v2 = val2.asString();
                return v1.equals(v2);
            }
            if (this.mObject instanceof Number && val2.mObject instanceof Number) {
                double r1 = ((Number)this.mObject).doubleValue();
                double r2 = ((Number)val2.mObject).doubleValue();
                if (Double.isNaN(r1) || Double.isNaN(r2)) {
                    return false;
                }
                if (Double.isInfinite(r1) || Double.isInfinite(r2)) {
                    return Double.compare(r1, r2) == 0;
                }
                return r1 == r2;
            }
            return false;
        }
        if (this.mObject == null && val2.mObject == null) {
            return true;
        }
        if (this.mObject == null) {
            if (val2.mObject instanceof Integer) {
                return (Integer)val2.mObject == 0;
            }
            if (val2.mObject instanceof Double) {
                return (Double)val2.mObject == 0.0;
            }
            if (val2.mObject instanceof String) {
                return ((String)val2.mObject).length() == 0;
            }
            return false;
        }
        if (this.mObject instanceof Integer) {
            return (Integer)this.mObject == 0;
        }
        if (this.mObject instanceof Double) {
            return (Double)this.mObject == 0.0;
        }
        if (this.mObject instanceof String) {
            return ((String)this.mObject).length() == 0;
        }
        return false;
    }

    public final boolean discernCompareInternal(Variant val) {
        if (this.mObject != null && val.mObject != null) {
            if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
                return ((Integer)this.mObject).intValue() == ((Integer)val.mObject).intValue();
            }
            if (this.mObject instanceof String && val.mObject instanceof String) {
                return ((String)this.mObject).equals((String)val.mObject);
            }
            if (this.mObject instanceof Double && val.mObject instanceof Double) {
                double r1 = ((Number)this.mObject).doubleValue();
                double r2 = ((Number)val.mObject).doubleValue();
                if (Double.isNaN(r1) || Double.isNaN(r2)) {
                    return false;
                }
                if (Double.isInfinite(r1) || Double.isInfinite(r2)) {
                    return Double.compare(r1, r2) == 0;
                }
                return r1 == r2;
            }
            if (this.mObject instanceof VariantClosure && val.mObject instanceof VariantClosure) {
                VariantClosure v1 = (VariantClosure)this.mObject;
                VariantClosure v2 = (VariantClosure)val.mObject;
                return v1.mObject == v2.mObject && v1.mObjThis == v2.mObjThis;
            }
            if (this.mObject instanceof ByteBuffer && val.mObject instanceof ByteBuffer) {
                int c2;
                ByteBuffer v1 = (ByteBuffer)this.mObject;
                ByteBuffer v2 = (ByteBuffer)val.mObject;
                int c1 = v1.limit();
                if (c1 == (c2 = v2.limit())) {
                    int i = 0;
                    while (i < c1) {
                        byte b2;
                        byte b1 = v1.get(i);
                        if (b1 != (b2 = v2.get(i))) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    return false;
                }
                return true;
            }
            if (this.mObject.getClass().isAssignableFrom(val.mObject.getClass())) {
                return this.mObject.equals(val.mObject);
            }
            return false;
        }
        return this.mObject == null && val.mObject == null;
    }

    public final boolean discernCompareStrictReal(Variant val) throws VariantException {
        if (this.mObject != null && val.mObject != null) {
            if (this.mObject instanceof Double && val.mObject instanceof Double) {
                return ((Double)this.mObject).doubleValue() == ((Double)val.mObject).doubleValue();
            }
            if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
                return ((Integer)this.mObject).intValue() == ((Integer)val.mObject).intValue();
            }
            if (this.mObject instanceof String && val.mObject instanceof String) {
                return ((String)this.mObject).equals((String)val.mObject);
            }
            if (this.mObject instanceof VariantClosure && val.mObject instanceof VariantClosure) {
                VariantClosure v1 = (VariantClosure)this.mObject;
                VariantClosure v2 = (VariantClosure)val.mObject;
                return v1.mObject == v2.mObject && v1.mObjThis == v2.mObjThis;
            }
            if (this.mObject instanceof ByteBuffer && val.mObject instanceof ByteBuffer) {
                int c2;
                ByteBuffer v1 = (ByteBuffer)this.mObject;
                ByteBuffer v2 = (ByteBuffer)val.mObject;
                int c1 = v1.limit();
                if (c1 == (c2 = v2.limit())) {
                    int i = 0;
                    while (i < c1) {
                        byte b2;
                        byte b1 = v1.get(i);
                        if (b1 != (b2 = v2.get(i))) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    return false;
                }
                return true;
            }
            if (this.mObject.getClass().isAssignableFrom(val.mObject.getClass())) {
                return this.mObject.equals(val.mObject);
            }
            return false;
        }
        return this.mObject == null && val.mObject == null;
    }

    public final boolean greaterThan(Variant val) throws VariantException {
        String s2;
        if (!(this.mObject instanceof String) || !(val.mObject instanceof String)) {
            if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
                return (Integer)this.mObject < (Integer)val.mObject;
            }
            return this.asDouble() < val.asDouble();
        }
        String s1 = this.asString();
        return s1.compareTo(s2 = val.asString()) < 0;
    }

    public final int greaterThanForSort(Variant val) throws VariantException {
        if (!(this.mObject instanceof String) || !(val.mObject instanceof String)) {
            if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
                return (Integer)this.mObject - (Integer)val.mObject;
            }
            double ret = this.asDouble() - val.asDouble();
            if (ret == 0.0) {
                return 0;
            }
            if (ret < 0.0) {
                return -1;
            }
            return 1;
        }
        String s1 = this.asString();
        String s2 = val.asString();
        return s1.compareTo(s2);
    }

    public final boolean littlerThan(Variant val) throws VariantException {
        String s2;
        if (!(this.mObject instanceof String) || !(val.mObject instanceof String)) {
            if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
                return (Integer)this.mObject > (Integer)val.mObject;
            }
            return this.asDouble() > val.asDouble();
        }
        String s1 = this.asString();
        return s1.compareTo(s2 = val.asString()) > 0;
    }

    public final int littlerThanForSort(Variant val) throws VariantException {
        if (!(this.mObject instanceof String) || !(val.mObject instanceof String)) {
            if (this.mObject instanceof Integer && val.mObject instanceof Integer) {
                return (Integer)val.mObject - (Integer)this.mObject;
            }
            double ret = val.asDouble() - this.asDouble();
            if (ret == 0.0) {
                return 0;
            }
            if (ret < 0.0) {
                return -1;
            }
            return 1;
        }
        String s1 = this.asString();
        String s2 = val.asString();
        return s2.compareTo(s1);
    }

    public final void asNumber(Variant targ) throws VariantException {
        if (this.mObject == null) {
            targ.set(0);
        } else if (this.mObject instanceof Number) {
            if (this.mObject instanceof Integer) {
                targ.set((Integer)this.mObject);
            } else {
                targ.set(((Number)this.mObject).doubleValue());
            }
        } else if (this.mObject instanceof String) {
            LexBase lex = new LexBase((String)this.mObject);
            Number num = lex.parseNumber();
            if (num != null) {
                if (num instanceof Integer) {
                    targ.set((Integer)num);
                } else {
                    targ.set(num.doubleValue());
                }
            } else {
                targ.set(0);
            }
        } else {
            Variant.throwVariantConvertError(this, TYPE_INTEGER, TYPE_REAL);
        }
    }

    public final Number asNumber() throws VariantException {
        if (this.mObject instanceof Integer) {
            return (int)((Integer)this.mObject);
        }
        if (this.mObject instanceof Double) {
            return (double)((Double)this.mObject);
        }
        if (this.mObject instanceof String) {
            LexBase lex = new LexBase((String)this.mObject);
            Number num = lex.parseNumber();
            if (num != null) {
                return num;
            }
            return 0;
        }
        if (this.mObject == null) {
            return 0;
        }
        Variant.throwVariantConvertError(this, TYPE_INTEGER, TYPE_REAL);
        return null;
    }

    public final void changeSign() throws VariantException {
        if (this.mObject instanceof Integer) {
            this.mObject = -((Integer)this.mObject).intValue();
            return;
        }
        Number val = this.asNumber();
        this.mObject = val instanceof Integer ? (Number)(-val.intValue()) : (Number)(-val.doubleValue());
    }

    public final void toNumber() throws VariantException {
        if (this.mObject == null) {
            this.mObject = 0;
        } else {
            if (this.mObject instanceof Number) {
                return;
            }
            if (this.mObject instanceof String) {
                Number num = Variant.stringToNumber((String)this.mObject);
                this.mObject = num instanceof Integer ? (Number)num.intValue() : (Number)num.doubleValue();
            } else {
                Variant.throwVariantConvertError(this, TYPE_INTEGER, TYPE_REAL);
            }
        }
    }

    public final void toInteger() throws VariantException {
        this.mObject = this.asInteger();
    }

    public final void toReal() throws VariantException {
        this.mObject = this.asDouble();
    }

    public final void selfToString() throws VariantException {
        if (this.mObject == null || this.mObject instanceof String) {
            return;
        }
        if (this.mObject instanceof Integer) {
            this.mObject = ((Integer)this.mObject).toString();
        } else if (this.mObject instanceof Double) {
            this.mObject = ((Double)this.mObject).toString();
        } else if (this.mObject instanceof ByteBuffer) {
            Variant.throwVariantConvertError(this, TYPE_STRING);
        } else {
            this.mObject = Utils.VariantToReadableString(this);
        }
    }

    public final void toOctet() throws VariantException {
        if (this.mObject == null || this.mObject instanceof ByteBuffer) {
            return;
        }
        Variant.throwVariantConvertError(this, TYPE_OCTET);
    }

    public final boolean asBoolean() {
        if (this.mObject instanceof Integer) {
            return (Integer)this.mObject != 0;
        }
        if (this.mObject instanceof Double) {
            return (Double)this.mObject != 0.0;
        }
        if (this.mObject instanceof String) {
            LexBase lex = new LexBase((String)this.mObject);
            Number num = lex.parseNumber();
            if (num != null) {
                return num.intValue() != 0;
            }
            return false;
        }
        if (this.mObject instanceof VariantClosure) {
            VariantClosure v = (VariantClosure)this.mObject;
            return v.mObject != null;
        }
        if (this.mObject instanceof ByteBuffer) {
            return true;
        }
        if (this.mObject == null) {
            return false;
        }
        return false;
    }

    public final int asInteger() throws VariantException {
        if (this.mObject instanceof Integer) {
            return (Integer)this.mObject;
        }
        if (this.mObject instanceof Double) {
            return ((Double)this.mObject).intValue();
        }
        if (this.mObject instanceof String) {
            LexBase lex = new LexBase((String)this.mObject);
            Number num = lex.parseNumber();
            if (num != null) {
                return num.intValue();
            }
            return 0;
        }
        if (this.mObject == null) {
            return 0;
        }
        Variant.throwVariantConvertError(this, TYPE_INTEGER);
        return 0;
    }

    public final double asDouble() throws VariantException {
        if (this.mObject instanceof Double) {
            return (Double)this.mObject;
        }
        if (this.mObject instanceof Integer) {
            return ((Integer)this.mObject).doubleValue();
        }
        if (this.mObject instanceof String) {
            LexBase lex = new LexBase((String)this.mObject);
            Number num = lex.parseNumber();
            if (num != null) {
                return num.doubleValue();
            }
            return 0.0;
        }
        if (this.mObject == null) {
            return 0.0;
        }
        Variant.throwVariantConvertError(this, TYPE_REAL);
        return 0.0;
    }

    public final String asString() throws VariantException {
        if (this.mObject instanceof String) {
            return (String)this.mObject;
        }
        if (this.mObject instanceof Integer) {
            return ((Integer)this.mObject).toString();
        }
        if (this.mObject instanceof Double) {
            return ((Double)this.mObject).toString();
        }
        if (this.mObject == null) {
            return null;
        }
        if (!(this.mObject instanceof ByteBuffer)) {
            return Utils.VariantToReadableString(this);
        }
        Variant.throwVariantConvertError(this, TYPE_STRING);
        return null;
    }

    public final VariantClosure asObjectClosure() throws VariantException {
        if (this.mObject instanceof VariantClosure) {
            return (VariantClosure)this.mObject;
        }
        Variant.throwVariantConvertError(this, TYPE_OBJECT);
        return NullVariantClosure;
    }

    public final ByteBuffer asOctet() throws VariantException {
        if (this.mObject == null) {
            return null;
        }
        if (this.mObject instanceof ByteBuffer) {
            return (ByteBuffer)this.mObject;
        }
        Variant.throwVariantConvertError(this, TYPE_OCTET);
        return null;
    }

    public final Dispatch2 asObject() throws VariantException {
        if (this.mObject instanceof VariantClosure) {
            return ((VariantClosure)this.mObject).mObject;
        }
        Variant.throwVariantConvertError(this, TYPE_OBJECT);
        return null;
    }

    public final Dispatch2 asObjectThis() throws VariantException {
        if (this.mObject instanceof VariantClosure) {
            return ((VariantClosure)this.mObject).mObjThis;
        }
        Variant.throwVariantConvertError(this, TYPE_OBJECT);
        return null;
    }

    public final void changeClosureObjThis(Dispatch2 objthis) throws VariantException {
        if (this.mObject instanceof VariantClosure) {
            VariantClosure vc = (VariantClosure)this.mObject;
            if (vc.mObjThis != null) {
                vc.mObjThis = null;
            }
            vc.mObjThis = objthis;
        } else {
            Variant.throwVariantConvertError(this, TYPE_OBJECT);
        }
    }

    public static final void throwVariantConvertError(Variant from, String to) throws VariantException {
        if (to.equals(TYPE_OBJECT)) {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(from));
            throw new VariantException(mes);
        }
        String mes = "%1 \u304b\u3089 %2 \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093".replace("%1", Utils.VariantToReadableString(from));
        String mes2 = mes.replace("%2", to);
        throw new VariantException(mes2);
    }

    public static final void throwVariantConvertError(Variant from, String to1, String to2) throws VariantException {
        String mes = "%1 \u304b\u3089 %2 \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093".replace("%1", Utils.VariantToReadableString(from));
        String mes2 = mes.replace("%2", String.valueOf(to1) + "/" + to2);
        throw new VariantException(mes2);
    }

    public static final void throwDividedByZero() throws VariantException {
        throw new VariantException("0 \u3067\u9664\u7b97\u3092\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
    }

    public static final Number stringToNumber(String str) {
        LexBase lex = new LexBase(str);
        Number num = lex.parseNumber();
        if (num != null) {
            return num;
        }
        return 0;
    }

    public final boolean isString() {
        return this.mObject instanceof String;
    }

    public final boolean isObject() {
        return this.mObject instanceof VariantClosure;
    }

    public final boolean isInteger() {
        return this.mObject instanceof Integer;
    }

    public final boolean isReal() {
        return this.mObject instanceof Double;
    }

    public final boolean isOctet() {
        return this.mObject instanceof ByteBuffer;
    }

    public final boolean isVoid() {
        return this.mObject == null;
    }

    public final boolean isNumber() {
        return this.mObject instanceof Number;
    }

    public final void clear() {
        this.mObject = null;
    }

    public static final String specialRealToString(double r) {
        if (Double.isNaN(r)) {
            return "NaN";
        }
        if (Double.isInfinite(r)) {
            if (Double.NEGATIVE_INFINITY == r) {
                return "-Infinity";
            }
            return "+Infinity";
        }
        if (r == 0.0) {
            long ui64 = Double.doubleToLongBits(r);
            if ((ui64 & Long.MIN_VALUE) != 0L) {
                return "-0.0";
            }
            return "+0.0";
        }
        return null;
    }

    public static final String realToHexString(double r) {
        String v = Variant.specialRealToString(r);
        if (v != null) {
            return v;
        }
        long ui64 = Double.doubleToLongBits(r);
        StringBuilder builder = mBuilder;
        builder.delete(0, builder.length());
        if ((ui64 & Long.MIN_VALUE) != 0L) {
            builder.append("-0x1.");
        } else {
            builder.append("0x1.");
        }
        String hexdigits = new String("0123456789ABCDEF");
        int exp = (int)(((ui64 & 0x7FF0000000000000L) >> 52) - 1023L);
        int bits = 52;
        while ((bits -= 4) >= 0) {
            builder.append(hexdigits.charAt((int)(ui64 >> bits) & 0xF));
        }
        builder.append('p');
        builder.append(String.valueOf(exp));
        return builder.toString();
    }

    public static final String octetToListString(ByteBuffer oct) {
        if (oct == null) {
            return null;
        }
        if (oct.capacity() == 0) {
            return null;
        }
        StringBuilder str = mBuilder;
        str.delete(0, str.length());
        String hex = new String("0123456789ABCDEF");
        int count = oct.capacity();
        int i = 0;
        while (i < count) {
            byte data = oct.get(i);
            str.append(hex.charAt(data >> 4 & 0xF));
            str.append(hex.charAt(data & 0xF));
            if (i != count - 1) {
                str.append(' ');
            }
            ++i;
        }
        return str.toString();
    }

    public final void andEqual(Variant rhs) throws VariantException {
        int l = this.asInteger();
        this.mObject = null;
        this.mObject = l & rhs.asInteger();
    }

    public final void orEqual(Variant rhs) throws VariantException {
        int l = this.asInteger();
        this.mObject = null;
        this.mObject = l | rhs.asInteger();
    }

    public final void bitXorEqual(Variant rhs) throws VariantException {
        int l = this.asInteger();
        this.mObject = null;
        this.mObject = l ^ rhs.asInteger();
    }

    public final void subtractEqual(Variant rhs) throws VariantException {
        if (this.mObject instanceof Integer && rhs.mObject instanceof Integer) {
            this.mObject = (Integer)this.mObject - (Integer)rhs.mObject;
            return;
        }
        Number l = this.asNumber();
        Number r = rhs.asNumber();
        this.mObject = l instanceof Integer && r instanceof Integer ? (Number)((Integer)l - (Integer)r) : (Number)(l.doubleValue() - r.doubleValue());
    }

    public final void addEqual(Variant rhs) throws VariantException {
        if (this.mObject instanceof String || rhs.mObject instanceof String) {
            if (this.mObject instanceof String && rhs.mObject instanceof String) {
                this.mObject = String.valueOf((String)this.mObject) + (String)rhs.mObject;
                return;
            }
            String s1 = this.asString();
            String s2 = rhs.asString();
            if (s1 != null && s2 != null) {
                StringBuilder builder = mBuilder;
                builder.delete(0, builder.length());
                builder.append(s1);
                builder.append(s2);
                this.mObject = builder.toString();
            } else {
                this.mObject = s1 != null ? s1 : s2;
            }
            return;
        }
        if (this.mObject != null && rhs.mObject != null && this.mObject.getClass().isAssignableFrom(rhs.mObject.getClass())) {
            if (this.mObject instanceof ByteBuffer) {
                ByteBuffer b1 = (ByteBuffer)this.mObject;
                ByteBuffer b2 = (ByteBuffer)rhs.mObject;
                ByteBuffer result = ByteBuffer.allocate(b1.capacity() + b2.capacity());
                b1.position(0);
                b2.position(0);
                result.put(b1);
                result.put(b2);
                result.position(0);
                this.mObject = result;
                return;
            }
            if (this.mObject instanceof Integer) {
                int result = (Integer)this.mObject + (Integer)rhs.mObject;
                this.mObject = result;
                return;
            }
        }
        if (this.mObject == null && rhs.mObject != null) {
            if (rhs.mObject instanceof Integer) {
                this.mObject = (int)((Integer)rhs.mObject);
                return;
            }
            if (rhs.mObject instanceof Double) {
                this.mObject = (double)((Double)rhs.mObject);
                return;
            }
        }
        if (rhs.mObject == null && this.mObject != null) {
            if (this.mObject instanceof Integer) {
                return;
            }
            if (this.mObject instanceof Double) {
                return;
            }
        }
        this.mObject = this.asDouble() + rhs.asDouble();
    }

    public final void residueEqual(Variant rhs) throws VariantException {
        int r = rhs.asInteger();
        if (r == 0) {
            Variant.throwDividedByZero();
        }
        int l = this.asInteger();
        this.mObject = l % r;
    }

    public final void divideEqual(Variant rhs) throws VariantException {
        double l = this.asDouble();
        double r = rhs.asDouble();
        this.mObject = l / r;
    }

    public final void idivequal(Variant rhs) throws VariantException {
        int r = rhs.asInteger();
        if (r == 0) {
            Variant.throwDividedByZero();
        }
        int l = this.asInteger();
        this.mObject = l / r;
    }

    public final void logicalorequal(Variant rhs) {
        boolean l = this.asBoolean();
        boolean r = rhs.asBoolean();
        this.mObject = l || r ? 1 : 0;
    }

    public final void multiplyEqual(Variant rhs) throws VariantException {
        if (this.mObject instanceof Integer && rhs.mObject instanceof Integer) {
            this.mObject = (Integer)this.mObject * (Integer)rhs.mObject;
            return;
        }
        Number l = this.asNumber();
        Number r = rhs.asNumber();
        if (l instanceof Integer && r instanceof Integer) {
            this.mObject = l.intValue() * r.intValue();
            return;
        }
        this.mObject = l.doubleValue() * r.doubleValue();
    }

    public final void logicalandequal(Variant rhs) {
        boolean l = this.asBoolean();
        boolean r = rhs.asBoolean();
        this.mObject = l && r ? 1 : 0;
    }

    public final void rightShiftEqual(Variant rhs) throws VariantException {
        int l = this.asInteger();
        int r = rhs.asInteger();
        this.mObject = l >> r;
    }

    public final void leftShiftEqual(Variant rhs) throws VariantException {
        int l = this.asInteger();
        int r = rhs.asInteger();
        this.mObject = l << r;
    }

    public final void rbitshiftequal(Variant rhs) throws VariantException {
        int l = this.asInteger();
        int r = rhs.asInteger();
        this.mObject = l >>> r;
    }

    public final void increment() throws VariantException {
        if (this.mObject instanceof String) {
            this.toNumber();
        }
        if (this.mObject instanceof Double) {
            this.mObject = (Double)this.mObject + 1.0;
        } else if (this.mObject instanceof Integer) {
            this.mObject = (Integer)this.mObject + 1;
        } else if (this.mObject == null) {
            this.mObject = 1;
        } else {
            Variant.throwVariantConvertError(this, TYPE_INTEGER, TYPE_REAL);
        }
    }

    public final void decrement() throws VariantException {
        if (this.mObject instanceof String) {
            this.toNumber();
        }
        if (this.mObject instanceof Double) {
            this.mObject = (Double)this.mObject - 1.0;
        } else if (this.mObject instanceof Integer) {
            this.mObject = (Integer)this.mObject - 1;
        } else if (this.mObject == null) {
            this.mObject = -1;
        } else {
            Variant.throwVariantConvertError(this, TYPE_INTEGER, TYPE_REAL);
        }
    }

    public final String getString() throws VariantException {
        if (this.mObject != null && this.mObject instanceof String) {
            return (String)this.mObject;
        }
        Variant.throwVariantConvertError(this, TYPE_STRING);
        return null;
    }

    public final String getTypeName() {
        if (this.mObject == null) {
            return TYPE_VOID;
        }
        if (this.mObject instanceof VariantClosure) {
            return "Object";
        }
        if (this.mObject instanceof String) {
            return "String";
        }
        if (this.mObject instanceof Integer) {
            return "Integer";
        }
        if (this.mObject instanceof Double) {
            return "Real";
        }
        if (this.mObject instanceof ByteBuffer) {
            return "Octet";
        }
        return null;
    }

    public final void logicalnot() {
        boolean res = !this.asBoolean();
        this.mObject = res ? 1 : 0;
    }

    public final void bitnot() throws VariantException {
        int res = ~this.asInteger();
        this.mObject = res;
    }

    public final void tonumber() throws VariantException {
        if (this.mObject instanceof Number) {
            return;
        }
        if (this.mObject instanceof String) {
            Number num = Variant.stringToNumber((String)this.mObject);
            this.mObject = num instanceof Integer ? (Number)num.intValue() : (Number)num.doubleValue();
            return;
        }
        if (this.mObject == null) {
            this.mObject = 0;
            return;
        }
        Variant.throwVariantConvertError(this, TYPE_INTEGER, TYPE_REAL);
    }

    public final void changesign() throws VariantException {
        if (this.mObject instanceof Integer) {
            this.mObject = -((Integer)this.mObject).intValue();
            return;
        }
        Number val = this.asNumber();
        this.mObject = val instanceof Integer ? (Number)(-val.intValue()) : (Number)(-val.doubleValue());
    }

    public final Object toJavaObject() {
        return this.mObject;
    }

    public final void setObject(Dispatch2 ref) {
        this.mObject = new VariantClosure(ref, null);
    }

    public final void setObject(Dispatch2 object, Dispatch2 objthis) {
        this.mObject = new VariantClosure(object, objthis);
    }

    public final String toString() {
        block8: {
            try {
                if (!this.isVoid()) break block8;
                return "(void)";
            }
            catch (VariantException e) {
                return "";
            }
        }
        if (this.isInteger()) {
            return new String("(int)" + this.asString());
        }
        if (this.isReal()) {
            return new String("(real)" + this.asString());
        }
        if (this.isString()) {
            return new String("(string)\"" + LexBase.escapeC(this.asString()) + "\"");
        }
        if (this.isOctet()) {
            return new String("(octet)<% " + Variant.OctetToListString(this.asOctet()) + " %>");
        }
        if (this.isObject()) {
            VariantClosure c = this.asObjectClosure();
            return c.toString();
        }
        return new String("(octet) [" + this.getClass().getName() + "]");
    }

    public final String toJavaString() {
        block10: {
            if (!this.isVoid()) break block10;
            return null;
        }
        try {
            if (this.isInteger()) {
                return this.asString();
            }
            if (this.isReal()) {
                return this.asString();
            }
            if (this.isString()) {
                return "\"" + LexBase.escapeC(this.asString()) + "\"";
            }
            if (this.isOctet()) {
                ByteBuffer buf = this.asOctet();
                if (buf != null && buf.capacity() != 0) {
                    StringBuilder builder = mBuilder;
                    builder.delete(0, builder.length());
                    int count = buf.capacity();
                    builder.append('{');
                    int i = 0;
                    while (i < count) {
                        byte b = buf.get(i);
                        builder.append("0x");
                        builder.append(Integer.toHexString(b));
                        builder.append(", ");
                        ++i;
                    }
                    builder.append('}');
                }
                return new String("(octet)<% " + Variant.OctetToListString(this.asOctet()) + " %>");
            }
            if (this.isObject()) {
                return " new " + this.mObject.getClass().getName();
            }
            return " new " + this.mObject.getClass().getName();
        }
        catch (VariantException e) {
            return " error ";
        }
    }
}

