/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Variant;

class VariantPool {
    private static final int DEFAULT_SIZE = 64;
    private static final int LIMIT_SIZE = 48;
    private ArrayList<Variant> mPool = new ArrayList(64);

    public final Variant allocate() {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant();
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        return ret;
    }

    public Variant allocate(int value) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(value);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(value);
        return ret;
    }

    public Variant allocate(double value) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(value);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(value);
        return ret;
    }

    public Variant allocate(ByteBuffer value) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(value);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(value);
        return ret;
    }

    public Variant allocate(String value) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(value);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(value);
        return ret;
    }

    public Variant allocate(Variant value) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(value);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(value);
        return ret;
    }

    public Variant allocate(Dispatch2 dsp, Dispatch2 dsp2) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(dsp, dsp2);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(dsp, dsp2);
        return ret;
    }

    public Variant allocate(Dispatch2 dsp) {
        int len = this.mPool.size();
        if (len == 0) {
            return new Variant(dsp, null);
        }
        Variant ret = this.mPool.get(len - 1);
        this.mPool.remove(len - 1);
        ret.set(dsp, null);
        return ret;
    }

    public final void release(Variant va) {
        if (va == null) {
            return;
        }
        va.clear();
        int poolSize = this.mPool.size();
        if (poolSize < 48) {
            this.mPool.add(va);
        }
    }

    public final void release(Variant[] va) {
        if (va == null) {
            return;
        }
        int poolSize = this.mPool.size();
        if (poolSize < 48) {
            int count = va.length;
            int i = 0;
            while (i < count) {
                va[i].clear();
                this.mPool.add(va[i]);
                ++i;
            }
        }
    }
}

