/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2.translate;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.IntVector;
import jp.kirikiri.tjs2.InterCodeGenerator;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.SourceCodeAccessor;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class JavaCodeGenerator {
    private static final byte TYPE_VOID = 0;
    private static final byte TYPE_OBJECT = 1;
    private static final byte TYPE_INTER_OBJECT = 2;
    private static final byte TYPE_STRING = 3;
    private static final byte TYPE_OCTET = 4;
    private static final byte TYPE_REAL = 5;
    private static final byte TYPE_INTEGER = 8;
    private static final byte TYPE_INTER_GENERATOR = 10;
    private static final byte TYPE_NULL_CLOSURE = 11;
    private static final byte TYPE_UNKNOWN = -1;
    private ArrayList<String> mSourceCodes;
    private ArrayList<ExceptionData> mExceptionDataStack;
    private short[] mCode;
    private Variant[] mData;
    private SourceCodeAccessor mAccessor;
    private int mFuncDeclUnnamedArgArrayBase;
    private static final int VM_NOP = 0;
    private static final int VM_CONST = 1;
    private static final int VM_CP = 2;
    private static final int VM_CL = 3;
    private static final int VM_CCL = 4;
    private static final int VM_TT = 5;
    private static final int VM_TF = 6;
    private static final int VM_CEQ = 7;
    private static final int VM_CDEQ = 8;
    private static final int VM_CLT = 9;
    private static final int VM_CGT = 10;
    private static final int VM_SETF = 11;
    private static final int VM_SETNF = 12;
    private static final int VM_LNOT = 13;
    private static final int VM_NF = 14;
    private static final int VM_JF = 15;
    private static final int VM_JNF = 16;
    private static final int VM_JMP = 17;
    private static final int VM_INC = 18;
    private static final int VM_INCPD = 19;
    private static final int VM_INCPI = 20;
    private static final int VM_INCP = 21;
    private static final int VM_DEC = 22;
    private static final int VM_DECPD = 23;
    private static final int VM_DECPI = 24;
    private static final int VM_DECP = 25;
    private static final int VM_LOR = 26;
    private static final int VM_LORPD = 27;
    private static final int VM_LORPI = 28;
    private static final int VM_LORP = 29;
    private static final int VM_LAND = 30;
    private static final int VM_LANDPD = 31;
    private static final int VM_LANDPI = 32;
    private static final int VM_LANDP = 33;
    private static final int VM_BOR = 34;
    private static final int VM_BORPD = 35;
    private static final int VM_BORPI = 36;
    private static final int VM_BORP = 37;
    private static final int VM_BXOR = 38;
    private static final int VM_BXORPD = 39;
    private static final int VM_BXORPI = 40;
    private static final int VM_BXORP = 41;
    private static final int VM_BAND = 42;
    private static final int VM_BANDPD = 43;
    private static final int VM_BANDPI = 44;
    private static final int VM_BANDP = 45;
    private static final int VM_SAR = 46;
    private static final int VM_SARPD = 47;
    private static final int VM_SARPI = 48;
    private static final int VM_SARP = 49;
    private static final int VM_SAL = 50;
    private static final int VM_SALPD = 51;
    private static final int VM_SALPI = 52;
    private static final int VM_SALP = 53;
    private static final int VM_SR = 54;
    private static final int VM_SRPD = 55;
    private static final int VM_SRPI = 56;
    private static final int VM_SRP = 57;
    private static final int VM_ADD = 58;
    private static final int VM_ADDPD = 59;
    private static final int VM_ADDPI = 60;
    private static final int VM_ADDP = 61;
    private static final int VM_SUB = 62;
    private static final int VM_SUBPD = 63;
    private static final int VM_SUBPI = 64;
    private static final int VM_SUBP = 65;
    private static final int VM_MOD = 66;
    private static final int VM_MODPD = 67;
    private static final int VM_MODPI = 68;
    private static final int VM_MODP = 69;
    private static final int VM_DIV = 70;
    private static final int VM_DIVPD = 71;
    private static final int VM_DIVPI = 72;
    private static final int VM_DIVP = 73;
    private static final int VM_IDIV = 74;
    private static final int VM_IDIVPD = 75;
    private static final int VM_IDIVPI = 76;
    private static final int VM_IDIVP = 77;
    private static final int VM_MUL = 78;
    private static final int VM_MULPD = 79;
    private static final int VM_MULPI = 80;
    private static final int VM_MULP = 81;
    private static final int VM_BNOT = 82;
    private static final int VM_TYPEOF = 83;
    private static final int VM_TYPEOFD = 84;
    private static final int VM_TYPEOFI = 85;
    private static final int VM_EVAL = 86;
    private static final int VM_EEXP = 87;
    private static final int VM_CHKINS = 88;
    private static final int VM_ASC = 89;
    private static final int VM_CHR = 90;
    private static final int VM_NUM = 91;
    private static final int VM_CHS = 92;
    private static final int VM_INV = 93;
    private static final int VM_CHKINV = 94;
    private static final int VM_INT = 95;
    private static final int VM_REAL = 96;
    private static final int VM_STR = 97;
    private static final int VM_OCTET = 98;
    private static final int VM_CALL = 99;
    private static final int VM_CALLD = 100;
    private static final int VM_CALLI = 101;
    private static final int VM_NEW = 102;
    private static final int VM_GPD = 103;
    private static final int VM_SPD = 104;
    private static final int VM_SPDE = 105;
    private static final int VM_SPDEH = 106;
    private static final int VM_GPI = 107;
    private static final int VM_SPI = 108;
    private static final int VM_SPIE = 109;
    private static final int VM_GPDS = 110;
    private static final int VM_SPDS = 111;
    private static final int VM_GPIS = 112;
    private static final int VM_SPIS = 113;
    private static final int VM_SETP = 114;
    private static final int VM_GETP = 115;
    private static final int VM_DELD = 116;
    private static final int VM_DELI = 117;
    private static final int VM_SRV = 118;
    private static final int VM_RET = 119;
    private static final int VM_ENTRY = 120;
    private static final int VM_EXTRY = 121;
    private static final int VM_THROW = 122;
    private static final int VM_CHGTHIS = 123;
    private static final int VM_GLOBAL = 124;
    private static final int VM_ADDCI = 125;
    private static final int VM_REGMEMBER = 126;
    private static final int VM_DEBUGGER = 127;
    private static final int fatNormal = 0;
    private static final int fatExpand = 1;
    private static final int fatUnnamedExpand = 2;
    private static final int FUNC_NORMAL = 0;
    private static final int FUNC_INDIRECT = 1;
    private static final int FUNC_DIRECT = 2;
    private static final String[] STR_FUNC = new String[]{"charAt", "indexOf", "toUpperCase", "toLowerCase", "substring", "substr", "sprintf", "replace", "escape", "split", "trim", "reverse", "repeat"};

    public JavaCodeGenerator(short[] ca, Variant[] da, SourceCodeAccessor a) {
        this.mCode = ca;
        this.mData = da;
        this.mAccessor = a;
        this.mExceptionDataStack = new ArrayList();
        this.mSourceCodes = new ArrayList();
    }

    public void set(short[] ca, Variant[] da, SourceCodeAccessor a) {
        this.mCode = ca;
        this.mData = da;
        this.mAccessor = a;
        this.mExceptionDataStack = new ArrayList();
        this.mSourceCodes = new ArrayList();
    }

    private int findJumpTarget(int[] array, int pos) {
        int count = array.length;
        int i = 0;
        while (i < count) {
            if (array[i] == pos) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private void outputFuncSrc(String msg, String name, int line) {
        String buf = line >= 0 ? String.format("// #%s(%d) %s", name, line + 1, msg) : String.format("// #%s %s", name, msg);
        this.mSourceCodes.add(buf);
    }

    private final byte getType(Variant v) {
        Object o = v.toJavaObject();
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return 3;
        }
        if (o instanceof Integer) {
            return 8;
        }
        if (o instanceof Double) {
            return 5;
        }
        if (o instanceof VariantClosure) {
            VariantClosure clo = (VariantClosure)o;
            Dispatch2 dsp = clo.mObject;
            if (dsp instanceof InterCodeObject) {
                return 2;
            }
            if (dsp == null) {
                return 11;
            }
            return 1;
        }
        if (o instanceof InterCodeGenerator) {
            return 10;
        }
        if (o instanceof ByteBuffer) {
            return 4;
        }
        if (o instanceof Long) {
            return 8;
        }
        return -1;
    }

    private String getRegisterName(int v) {
        if (v < 0) {
            if (v == -1) {
                return "varthis";
            }
            if (v == -2) {
                return "this_proxy";
            }
            v += 3;
            v = -v;
            return "args[" + v + "]";
        }
        return "r" + v;
    }

    private String getDataToStrOrNum(Variant v) throws CompileException {
        Object o = v.toJavaObject();
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + (String)o + "\"";
        }
        if (o instanceof Integer) {
            return ((Integer)o).toString();
        }
        if (o instanceof Double) {
            return ((Double)o).toString();
        }
        if (o instanceof VariantClosure) {
            throw new CompileException("\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u5b9a\u6570\u5f62\u5f0f");
        }
        if (o instanceof InterCodeGenerator) {
            throw new CompileException("\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u5b9a\u6570\u5f62\u5f0f");
        }
        if (o instanceof ByteBuffer) {
            throw new CompileException("\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u5b9a\u6570\u5f62\u5f0f");
        }
        if (o instanceof Long) {
            return ((Long)o).toString();
        }
        throw new CompileException("\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u5b9a\u6570\u5f62\u5f0f");
    }

    public void genFunCall(int variable, int frame, int declArgCount, int declCollapseBase) {
        this.mSourceCodes.add("protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {");
        int num_alloc = variable;
        if (num_alloc == 0) {
            this.mSourceCodes.add("Variant[] args = TJS.NULL_ARG;");
        } else {
            this.mSourceCodes.add("Variant[] args = new Variant[" + num_alloc + "];");
            int i = 0;
            while (i < num_alloc) {
                this.mSourceCodes.add("args[" + i + "] = new Variant();");
                ++i;
            }
        }
        this.mSourceCodes.add("Variant this_proxy;");
        this.mSourceCodes.add("if( objthis != null ) {");
        this.mSourceCodes.add("ObjectProxy proxy = new ObjectProxy();");
        this.mSourceCodes.add("proxy.setObjects( objthis, ScriptsClass.getGlobal() );");
        this.mSourceCodes.add("this_proxy = new Variant( proxy );");
        this.mSourceCodes.add("} else {");
        this.mSourceCodes.add("Dispatch2 global = ScriptsClass.getGlobal();");
        this.mSourceCodes.add("this_proxy = new Variant(global,global);");
        this.mSourceCodes.add("}");
        this.mSourceCodes.add("Variant varthis = new Variant(objthis,objthis);");
        if (num_alloc > 0) {
            int r;
            this.mSourceCodes.add("final int numargs = param != null ? param.length : 0;");
            this.mSourceCodes.add("if( numargs >= " + declArgCount + " ) {");
            if (declArgCount != 0) {
                r = 0;
                int n = declArgCount;
                int argOffset = 0;
                while (true) {
                    this.mSourceCodes.add("args[" + r + "].set( param[" + argOffset + "] );");
                    ++argOffset;
                    if (--n == 0) break;
                    ++r;
                }
            }
            this.mSourceCodes.add("} else {");
            this.mSourceCodes.add("int i;");
            this.mSourceCodes.add("for( i = 0; i < numargs; i++ ) {");
            this.mSourceCodes.add("args[i].set( param[i] );");
            this.mSourceCodes.add("}");
            this.mSourceCodes.add("for( ; i < " + declArgCount + "; i++ ) {");
            this.mSourceCodes.add("args[i].clear();");
            this.mSourceCodes.add("}");
            this.mSourceCodes.add("}");
            if (declCollapseBase >= 0) {
                r = declCollapseBase;
                this.mSourceCodes.add("{");
                this.mSourceCodes.add("Dispatch2 dsp = TJS.createArrayObject();");
                this.mSourceCodes.add("args[" + r + "].set(dsp, dsp);");
                this.mSourceCodes.add("if( numargs > " + declCollapseBase + " ) {");
                this.mSourceCodes.add("for( int c = 0, i = " + declCollapseBase + "; i < numargs; i++, c++) {");
                this.mSourceCodes.add("dsp.propSetByNum(0, c, param[i], dsp);");
                this.mSourceCodes.add("}");
                this.mSourceCodes.add("}");
            }
        }
        this.mSourceCodes.add("executeCode( varthis, this_proxy, args, result, objthis );");
        this.mSourceCodes.add("return Error.S_OK;");
        this.mSourceCodes.add("}");
    }

    private void genReg(int count) {
        this.mSourceCodes.add("private void executeCode( Variant varthis, Variant this_proxy, Variant[] args, Variant result, Dispatch2 objthis) throws VariantException, TJSException {");
        ++count;
        int i = 0;
        while (i < count) {
            this.mSourceCodes.add("Variant " + this.getRegisterName(i) + " = new Variant();");
            ++i;
        }
    }

    public void generate(int start, int end, int funcbase, int framecount) throws VariantException, CompileException {
        this.genReg(framecount);
        this.mFuncDeclUnnamedArgArrayBase = funcbase;
        int prevline = -1;
        int curline = -1;
        short[] ca = this.mCode;
        if (end <= 0) {
            end = ca.length;
        }
        if (end > ca.length) {
            end = ca.length;
        }
        IntVector target = this.checkJumpCode(start, end);
        int[] jumpaddr = null;
        int jumpcount = 0;
        if (target.size() > 0) {
            jumpaddr = target.toArray();
            jumpcount = jumpaddr.length;
            this.mSourceCodes.add("boolean flag = false;");
            this.mSourceCodes.add("boolean loop = true;");
            this.mSourceCodes.add("int goto_target = 0;");
            this.mSourceCodes.add("do {");
            this.mSourceCodes.add("switch(goto_target) {");
            this.mSourceCodes.add("case 0:");
            Arrays.sort(jumpaddr);
        }
        boolean outputmask = false;
        boolean forcejump = false;
        boolean alreadyreturn = false;
        int[] interret = new int[1];
        Variant[] da = this.mData;
        int code = start;
        while (code < end) {
            String msg = null;
            int srcpos = this.mAccessor.codePosToSrcPos(code);
            int line = this.mAccessor.srcPosToLine(srcpos);
            if (curline == -1 || curline <= line) {
                if (curline == -1) {
                    curline = line;
                }
                int nl = line - curline;
                while (curline <= line) {
                    if (nl < 3 || nl >= 3 && line - curline <= 2) {
                        String src = this.mAccessor.getLine(curline);
                        this.outputFuncSrc(src, "", curline);
                        ++curline;
                        continue;
                    }
                    curline = line - 2;
                }
            } else if (prevline != line) {
                String src = this.mAccessor.getLine(line);
                this.outputFuncSrc(src, "", line);
            }
            prevline = line;
            int i = 0;
            while (i < jumpcount) {
                if (jumpaddr[i] == code) {
                    int addr = i + 1;
                    this.mSourceCodes.add("\ncase " + addr + ":");
                    alreadyreturn = false;
                    forcejump = false;
                    break;
                }
                ++i;
            }
            outputmask = alreadyreturn || forcejump;
            short op = ca[code];
            switch (op) {
                case 0: {
                    ++code;
                    break;
                }
                case 1: {
                    byte type = this.getType(da[ca[code + 2]]);
                    int v = ca[code + 1];
                    switch (type) {
                        case 8: {
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( " + da[ca[code + 2]].asInteger() + " );";
                            break;
                        }
                        case 5: {
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( " + da[ca[code + 2]].asDouble() + " );";
                            break;
                        }
                        case 3: {
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( \"" + da[ca[code + 2]].asString() + "\" );";
                            break;
                        }
                        case 0: {
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( null );";
                            break;
                        }
                        case 2: {
                            Object o = da[ca[code + 2]].toJavaObject();
                            VariantClosure clo = (VariantClosure)o;
                            Dispatch2 dsp = clo.mObject;
                            InterCodeObject obj = (InterCodeObject)dsp;
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( (Dispatch2)new " + obj.getName() + "Class() );";
                            break;
                        }
                        case 10: {
                            InterCodeGenerator obj = (InterCodeGenerator)da[ca[code + 2]].toJavaObject();
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( (Dispatch2)new " + obj.getName() + "Class() );";
                        }
                        case 11: {
                            msg = String.valueOf(this.getRegisterName(v)) + ".set( null, null );";
                            break;
                        }
                        default: {
                            throw new CompileException("\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u5b9a\u6570\u5f62\u5f0f");
                        }
                    }
                    code += 3;
                    break;
                }
                case 2: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".set( " + this.getRegisterName(ca[code + 2]) + " );";
                    code += 3;
                    break;
                }
                case 3: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".clear();";
                    code += 2;
                    break;
                }
                case 4: {
                    int v = ca[code + 1];
                    int v1 = v + ca[code + 2];
                    msg = "";
                    while (v < v1) {
                        msg = String.valueOf(msg) + this.getRegisterName(v) + ".clear();\n";
                        ++v;
                    }
                    code += 3;
                    break;
                }
                case 5: {
                    msg = "flag = " + this.getRegisterName(ca[code + 1]) + ".asBoolean();";
                    code += 2;
                    break;
                }
                case 6: {
                    msg = "flag = !" + this.getRegisterName(ca[code + 1]) + ".asBoolean();";
                    code += 2;
                    break;
                }
                case 7: {
                    msg = "flag = " + this.getRegisterName(ca[code + 1]) + ".normalCompare( " + this.getRegisterName(ca[code + 2]) + " );";
                    code += 3;
                    break;
                }
                case 8: {
                    msg = ca[code + 2] == 0 ? "flag = " + this.getRegisterName(ca[code + 1]) + ".isVoid();" : "flag = " + this.getRegisterName(ca[code + 1]) + ".discernCompare( " + this.getRegisterName(ca[code + 2]) + " ).asBoolean();";
                    code += 3;
                    break;
                }
                case 9: {
                    msg = "flag = " + this.getRegisterName(ca[code + 1]) + ".greaterThan( " + this.getRegisterName(ca[code + 2]) + " );";
                    code += 3;
                    break;
                }
                case 10: {
                    msg = "flag = " + this.getRegisterName(ca[code + 1]) + ".littlerThan( " + this.getRegisterName(ca[code + 2]) + " );";
                    code += 3;
                    break;
                }
                case 11: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".set(flag?1:0);";
                    code += 2;
                    break;
                }
                case 12: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".set(flag?0:1);";
                    code += 2;
                    break;
                }
                case 13: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".logicalnot();";
                    code += 2;
                    break;
                }
                case 14: {
                    msg = "flag = !flag;";
                    ++code;
                    break;
                }
                case 15: {
                    int v = this.findJumpTarget(jumpaddr, code + ca[code + 1]);
                    msg = "if( flag ) {\ngoto_target = " + v + ";\nbreak;\n}";
                    code += 2;
                    break;
                }
                case 16: {
                    int v = this.findJumpTarget(jumpaddr, code + ca[code + 1]);
                    msg = "if( !flag ) {\ngoto_target = " + v + ";\nbreak;\n}";
                    code += 2;
                    break;
                }
                case 17: {
                    int v = this.findJumpTarget(jumpaddr, code + ca[code + 1]);
                    msg = "goto_target = " + v + ";\nbreak;";
                    forcejump = true;
                    code += 2;
                    break;
                }
                case 18: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".increment();";
                    code += 2;
                    break;
                }
                case 19: {
                    msg = "{\n";
                    msg = String.valueOf(msg) + "VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = ca[code + 1] != 0 ? String.valueOf(msg) + "int hr = clo.operation( OP_INC, \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", null, objthis );\n" : String.valueOf(msg) + "int hr = clo.operation( OP_INC, \"" + da[ca[code + 3]].getString() + "\", null, null, objthis );\n";
                    msg = String.valueOf(msg) + "if( hr < 0 ) throwFrom_tjs_error( hr, \"" + da[ca[code + 3]].getString() + "\" );\n";
                    msg = String.valueOf(msg) + "}";
                    code += 4;
                    break;
                }
                case 20: {
                    msg = "{\n";
                    msg = String.valueOf(msg) + "VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = String.valueOf(msg) + "Variant name = " + this.getRegisterName(ca[code + 3]) + ";\n";
                    msg = ca[code + 1] != 0 ? String.valueOf(msg) + "operatePropertyIndirect0( clo, name, " + this.getRegisterName(ca[code + 1]) + ", objthis, OP_INC );\n" : String.valueOf(msg) + "operatePropertyIndirect0( clo, name, null, objthis, OP_INC );\n";
                    msg = String.valueOf(msg) + "}";
                    code += 4;
                    break;
                }
                case 21: {
                    msg = "{\n";
                    msg = String.valueOf(msg) + "VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = ca[code + 1] != 0 ? String.valueOf(msg) + "int hr = clo.operation( OP_INC, null, " + this.getRegisterName(ca[code + 1]) + ", null, clo.mObjThis != null ?clo.mObjThis:objthis );\n" : String.valueOf(msg) + "int hr = clo.operation( OP_INC, null, null, null, clo.mObjThis != null ?clo.mObjThis:objthis );\n";
                    msg = String.valueOf(msg) + "if( hr < 0 ) throwFrom_tjs_error( hr, null );\n";
                    msg = String.valueOf(msg) + "}";
                    code += 3;
                    break;
                }
                case 22: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".decrement();";
                    code += 2;
                    break;
                }
                case 23: {
                    msg = "{\n";
                    msg = String.valueOf(msg) + "VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = ca[code + 1] != 0 ? String.valueOf(msg) + "int hr = clo.operation( OP_DEC, \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", null, objthis );\n" : String.valueOf(msg) + "int hr = clo.operation( OP_DEC, \"" + da[ca[code + 3]].getString() + "\", null, null, objthis );\n";
                    msg = String.valueOf(msg) + "if( hr < 0 ) throwFrom_tjs_error( hr, \"" + da[ca[code + 3]].getString() + "\" );\n";
                    msg = String.valueOf(msg) + "}";
                    code += 4;
                    break;
                }
                case 24: {
                    msg = "{\n";
                    msg = String.valueOf(msg) + "VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = String.valueOf(msg) + "Variant name = " + this.getRegisterName(ca[code + 3]) + ";\n";
                    msg = ca[code + 1] != 0 ? String.valueOf(msg) + "operatePropertyIndirect0( clo, name, " + this.getRegisterName(ca[code + 1]) + ", objthis, OP_DEC );\n" : String.valueOf(msg) + "operatePropertyIndirect0( clo, name, null, objthis, OP_DEC );\n";
                    msg = String.valueOf(msg) + "}";
                    code += 4;
                    break;
                }
                case 25: {
                    msg = "{\n";
                    msg = String.valueOf(msg) + "VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = ca[code + 1] != 0 ? String.valueOf(msg) + "int hr = clo.operation( OP_DEC, null, " + this.getRegisterName(ca[code + 1]) + ", null, clo.mObjThis != null ?clo.mObjThis:objthis );\n" : String.valueOf(msg) + "int hr = clo.operation( OP_DEC, null, null, null, clo.mObjThis != null ?clo.mObjThis:objthis );\n";
                    msg = String.valueOf(msg) + "if( hr < 0 ) throwFrom_tjs_error( hr, null );\n";
                    msg = String.valueOf(msg) + "}";
                    code += 3;
                    break;
                }
                case 26: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".logicalorequal(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 27: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LOR );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LOR );";
                    code += 5;
                    break;
                }
                case 28: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LOR );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LOR );";
                    code += 5;
                    break;
                }
                case 29: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_LOR );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_LOR );";
                    code += 4;
                    break;
                }
                case 30: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".logicalandequal(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 31: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LAND );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LAND );";
                    code += 5;
                    break;
                }
                case 32: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LAND );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_LAND );";
                    code += 5;
                    break;
                }
                case 33: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_LAND );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_LAND );";
                    code += 4;
                    break;
                }
                case 34: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".orEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 35: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BOR );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BOR );";
                    code += 5;
                    break;
                }
                case 36: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BOR );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BOR );";
                    code += 5;
                    break;
                }
                case 37: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_BOR );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_BOR );";
                    code += 4;
                    break;
                }
                case 38: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".bitXorEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 39: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BXOR );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BXOR );";
                    code += 5;
                    break;
                }
                case 40: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BXOR );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BXOR );";
                    code += 5;
                    break;
                }
                case 41: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_BXOR );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_BXOR );";
                    code += 4;
                    break;
                }
                case 42: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".andEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 43: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BAND );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BAND );";
                    code += 5;
                    break;
                }
                case 44: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BAND );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_BAND );";
                    code += 5;
                    break;
                }
                case 45: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_BAND );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_BAND );";
                    code += 4;
                    break;
                }
                case 46: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".rightShiftEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 47: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAR );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAR );";
                    code += 5;
                    break;
                }
                case 48: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAR );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAR );";
                    code += 5;
                    break;
                }
                case 49: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SAR );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SAR );";
                    code += 4;
                    break;
                }
                case 50: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".leftShiftEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 51: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAL );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAL );";
                    code += 5;
                    break;
                }
                case 52: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAL );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SAL );";
                    code += 5;
                    break;
                }
                case 53: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SAL );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SAL );";
                    code += 4;
                    break;
                }
                case 54: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".rbitshiftequal(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 55: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SR );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SR );";
                    code += 5;
                    break;
                }
                case 56: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SR );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SR );";
                    code += 5;
                    break;
                }
                case 57: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SR );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SR );";
                    code += 4;
                    break;
                }
                case 58: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".addEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 59: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_ADD );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_ADD );";
                    code += 5;
                    break;
                }
                case 60: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_ADD );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_ADD );";
                    code += 5;
                    break;
                }
                case 61: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_ADD );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_ADD );";
                    code += 4;
                    break;
                }
                case 62: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".subtractEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 63: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SUB );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SUB );";
                    code += 5;
                    break;
                }
                case 64: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SUB );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_SUB );";
                    code += 5;
                    break;
                }
                case 65: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SUB );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_SUB );";
                    code += 4;
                    break;
                }
                case 66: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".residueEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 67: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MOD );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MOD );";
                    code += 5;
                    break;
                }
                case 68: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MOD );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MOD );";
                    code += 5;
                    break;
                }
                case 69: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_MOD );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_MOD );";
                    code += 4;
                    break;
                }
                case 70: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".divideEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 71: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_DIV );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_DIV );";
                    code += 5;
                    break;
                }
                case 72: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_DIV );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_DIV );";
                    code += 5;
                    break;
                }
                case 73: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_DIV );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_DIV );";
                    code += 4;
                    break;
                }
                case 74: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".idivequal(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 75: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_IDIV );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_IDIV );";
                    code += 5;
                    break;
                }
                case 76: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_IDIV );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_IDIV );";
                    code += 5;
                    break;
                }
                case 77: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_IDIV );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_IDIV );";
                    code += 4;
                    break;
                }
                case 78: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".multiplyEqual(" + this.getRegisterName(ca[code + 2]) + ");";
                    code += 3;
                    break;
                }
                case 79: {
                    msg = ca[code + 1] != 0 ? "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MUL );" : "operatePropertyDirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), \"" + da[ca[code + 3]].getString() + "\", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MUL );";
                    code += 5;
                    break;
                }
                case 80: {
                    msg = ca[code + 1] != 0 ? "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MUL );" : "operatePropertyIndirect( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 3]) + ", null, " + this.getRegisterName(ca[code + 4]) + ", objthis, OP_MUL );";
                    code += 5;
                    break;
                }
                case 81: {
                    msg = ca[code + 1] != 0 ? "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_MUL );" : "operateProperty( " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure(), " + "null, " + this.getRegisterName(ca[code + 3]) + ", objthis, OP_MUL );";
                    code += 4;
                    break;
                }
                case 82: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".bitnot();";
                    code += 2;
                    break;
                }
                case 89: {
                    msg = "characterCodeOf( " + this.getRegisterName(ca[code + 1]) + " );";
                    code += 2;
                    break;
                }
                case 90: {
                    msg = "characterCodeFrom( " + this.getRegisterName(ca[code + 1]) + " );";
                    code += 2;
                    break;
                }
                case 91: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".tonumber();";
                    code += 2;
                    break;
                }
                case 92: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".changesign();";
                    code += 2;
                    break;
                }
                case 93: {
                    short offset = ca[code + 1];
                    msg = "boolean tmp = " + this.getRegisterName(offset) + ".isObject() == false ? false : " + this.getRegisterName(offset) + ".asObjectClosure().invalidate(0, null, objthis) == Error.S_TRUE;\n";
                    msg = String.valueOf(msg) + this.getRegisterName(offset) + ".set(tmp?1:0);";
                    code += 2;
                    break;
                }
                case 94: {
                    short offset = ca[code + 1];
                    msg = "{\nboolean tmp;\n";
                    msg = String.valueOf(msg) + "if( " + this.getRegisterName(offset) + ".isObject() == false ) {\n";
                    msg = String.valueOf(msg) + "tmp = true;\n";
                    msg = String.valueOf(msg) + "} else {\n";
                    msg = String.valueOf(msg) + "int ret = " + this.getRegisterName(offset) + ".asObjectClosure().isValid(0, null, objthis );\n";
                    msg = String.valueOf(msg) + "tmp = ret == Error.S_TRUE || ret == Error.E_NOTIMPL;\n";
                    msg = String.valueOf(msg) + "}\n";
                    msg = String.valueOf(msg) + this.getRegisterName(offset) + ".set(tmp?1:0);\n";
                    msg = String.valueOf(msg) + "}";
                    code += 2;
                    break;
                }
                case 95: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".toInteger();";
                    code += 2;
                    break;
                }
                case 96: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".toReal();";
                    code += 2;
                    break;
                }
                case 97: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".selfToString();";
                    code += 2;
                    break;
                }
                case 98: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".toOctet();";
                    code += 2;
                    break;
                }
                case 83: {
                    msg = "typeOf( " + this.getRegisterName(ca[code + 1]) + " );";
                    code += 2;
                    break;
                }
                case 84: {
                    msg = "typeOfMemberDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getDataToStrOrNum(da[ca[code + 3]]) + ", objthis, Interface.MEMBERMUSTEXIST );";
                    code += 4;
                    break;
                }
                case 85: {
                    msg = "typeOfMemberIndirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.MEMBERMUSTEXIST );\n";
                    code += 4;
                    break;
                }
                case 86: {
                    msg = "eval( " + this.getRegisterName(ca[code + 1]) + ", TJS.mEvalOperatorIsOnGlobal ? null : objthis, true);";
                    code += 2;
                    break;
                }
                case 87: {
                    msg = "eval( " + this.getRegisterName(ca[code + 1]) + ", TJS.mEvalOperatorIsOnGlobal ? null : objthis, false);";
                    code += 2;
                    break;
                }
                case 88: {
                    msg = "instanceOf( " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 1]) + " );";
                    code += 3;
                    break;
                }
                case 99: 
                case 102: {
                    msg = this.callFunction(ca, interret, code, 3, 0);
                    code += interret[0];
                    break;
                }
                case 100: {
                    msg = this.callFunction(ca, interret, code, 4, 2);
                    code += interret[0];
                    break;
                }
                case 101: {
                    msg = this.callFunction(ca, interret, code, 4, 1);
                    code += interret[0];
                    break;
                }
                case 103: {
                    msg = "getPropertyDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getDataToStrOrNum(da[ca[code + 3]]) + ", objthis, 0 );";
                    code += 4;
                    break;
                }
                case 110: {
                    msg = "getPropertyDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getDataToStrOrNum(da[ca[code + 3]]) + ", objthis, Interface.IGNOREPROP );";
                    code += 4;
                    break;
                }
                case 104: {
                    msg = "setPropertyDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getDataToStrOrNum(da[ca[code + 2]]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, 0 );";
                    code += 4;
                    break;
                }
                case 105: {
                    msg = "setPropertyDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getDataToStrOrNum(da[ca[code + 2]]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.MEMBERENSURE );";
                    code += 4;
                    break;
                }
                case 106: {
                    msg = "setPropertyDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getDataToStrOrNum(da[ca[code + 2]]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.MEMBERENSURE|Interface.HIDDENMEMBER );";
                    code += 4;
                    break;
                }
                case 111: {
                    msg = "setPropertyDirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getDataToStrOrNum(da[ca[code + 2]]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.MEMBERENSURE|Interface.IGNOREPROP );";
                    code += 4;
                    break;
                }
                case 107: {
                    msg = "getPropertyIndirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, 0 );";
                    code += 4;
                    break;
                }
                case 112: {
                    msg = "getPropertyIndirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.IGNOREPROP );";
                    code += 4;
                    break;
                }
                case 108: {
                    msg = "setPropertyIndirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, 0 );";
                    code += 4;
                    break;
                }
                case 109: {
                    msg = "setPropertyIndirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.MEMBERENSURE );";
                    code += 4;
                    break;
                }
                case 113: {
                    msg = "setPropertyIndirect( " + this.getRegisterName(ca[code + 1]) + ", " + this.getRegisterName(ca[code + 2]) + ", " + this.getRegisterName(ca[code + 3]) + ", objthis, Interface.MEMBERENSURE|Interface.IGNOREPROP );";
                    code += 4;
                    break;
                }
                case 115: {
                    msg = "{\nVariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = String.valueOf(msg) + "int hr = clo.propGet( 0, null, " + this.getRegisterName(ca[code + 1]) + ", clo.mObjThis != null ? clo.mObjThis : objthis );\n";
                    msg = String.valueOf(msg) + "if( hr < 0 ) throwFrom_tjs_error(hr, null);\n}";
                    code += 3;
                    break;
                }
                case 114: {
                    msg = "{\nVariantClosure clo = " + this.getRegisterName(ca[code + 1]) + ".asObjectClosure();\n";
                    msg = String.valueOf(msg) + "int hr = clo.propSet(0, null, " + this.getRegisterName(ca[code + 2]) + ", clo.mObjThis != null ? clo.mObjThis : objthis );\n";
                    msg = String.valueOf(msg) + "if( hr < 0 ) throwFrom_tjs_error( hr, null );\n}";
                    code += 3;
                    break;
                }
                case 116: {
                    msg = "{\nVariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    String name = da[ca[code + 3]].getString();
                    msg = String.valueOf(msg) + "int hr = clo.deleteMember(0, \"" + name + "\", objthis );\n";
                    if (ca[code + 1] != 0) {
                        msg = String.valueOf(msg) + "if( hr < 0 ) " + this.getRegisterName(ca[code + 1]) + ".set(0);\n";
                        msg = String.valueOf(msg) + "else " + this.getRegisterName(ca[code + 1]) + ".set(1);\n";
                    }
                    msg = String.valueOf(msg) + "}";
                    code += 4;
                    break;
                }
                case 117: {
                    msg = "{\nVariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n";
                    msg = String.valueOf(msg) + "final String name = " + this.getRegisterName(ca[code + 3]) + ".asString();\n";
                    msg = String.valueOf(msg) + "int hr = clo.deleteMember( 0, name, clo.mObjThis != null ? clo.mObjThis : objthis );\n";
                    if (ca[code + 1] != 0) {
                        msg = String.valueOf(msg) + "if( hr < 0 ) " + this.getRegisterName(ca[code + 1]) + ".set(0);\n";
                        msg = String.valueOf(msg) + "else " + this.getRegisterName(ca[code + 1]) + ".set(1);\n";
                    }
                    msg = String.valueOf(msg) + "}";
                    code += 4;
                    break;
                }
                case 118: {
                    msg = "if( result != null ) result.copyRef( " + this.getRegisterName(ca[code + 1]) + " );";
                    code += 2;
                    break;
                }
                case 119: {
                    if (!alreadyreturn) {
                        msg = "return;";
                        alreadyreturn = true;
                    }
                    ++code;
                    break;
                }
                case 120: {
                    this.mExceptionDataStack.add(new ExceptionData(ca[code + 1] + code, ca[code + 2]));
                    msg = "try {";
                    code += 3;
                    break;
                }
                case 121: {
                    if (this.mExceptionDataStack.size() > 0) {
                        int last = this.mExceptionDataStack.size() - 1;
                        ExceptionData ex = this.mExceptionDataStack.get(last);
                        this.mExceptionDataStack.remove(last);
                        int exobjreg = ex.mExobjReg;
                        int catchip = this.findJumpTarget(jumpaddr, ex.mCatchIp);
                        msg = "} catch( TJSScriptException e ) {\n";
                        if (exobjreg != 0) {
                            msg = String.valueOf(msg) + this.getRegisterName(exobjreg) + ".set( e.getValue() );\n";
                        }
                        msg = String.valueOf(msg) + "goto_target = " + catchip + ";\n";
                        msg = String.valueOf(msg) + "break;\n";
                        msg = String.valueOf(msg) + "} catch( TJSScriptError e ) {\n";
                        if (exobjreg != 0) {
                            msg = String.valueOf(msg) + "Variant msg = new Variant(e.getMessage());\n";
                            msg = String.valueOf(msg) + "Variant trace = new Variant(e.getTrace());\n";
                            msg = String.valueOf(msg) + "Variant ret = new Variant();\n";
                            msg = String.valueOf(msg) + "Error.getExceptionObject( mBlock.getTJS(), ret, msg, trace );\n";
                            msg = String.valueOf(msg) + this.getRegisterName(exobjreg) + ".set( ret );\n";
                        }
                        msg = String.valueOf(msg) + "goto_target = " + catchip + ";\n";
                        msg = String.valueOf(msg) + "break;\n";
                        msg = String.valueOf(msg) + "} catch( TJSException e ) {\n";
                        if (exobjreg != 0) {
                            msg = String.valueOf(msg) + "Variant msg = new Variant( e.getMessage() );\n";
                            msg = String.valueOf(msg) + "Variant ret = new Variant();\n";
                            msg = String.valueOf(msg) + "Error.getExceptionObject( mBlock.getTJS(), ret, msg, null );\n";
                            msg = String.valueOf(msg) + this.getRegisterName(exobjreg) + ".set( ret );\n";
                        }
                        msg = String.valueOf(msg) + "goto_target = " + catchip + ";\n";
                        msg = String.valueOf(msg) + "break;\n";
                        msg = String.valueOf(msg) + "} catch( Exception e ) {\n";
                        if (exobjreg != 0) {
                            msg = String.valueOf(msg) + "Variant msg = new Variant( e.getMessage() );\n";
                            msg = String.valueOf(msg) + "Variant ret = new Variant();\n";
                            msg = String.valueOf(msg) + "Error.getExceptionObject( mBlock.getTJS(), ret, msg, null );\n";
                            msg = String.valueOf(msg) + this.getRegisterName(exobjreg) + ".set( ret );\n";
                        }
                        msg = String.valueOf(msg) + "goto_target = " + catchip + ";\n";
                        msg = String.valueOf(msg) + "break;\n";
                        msg = String.valueOf(msg) + "}\n";
                    }
                    ++code;
                }
                case 122: {
                    msg = "throwScriptException( " + this.getRegisterName(ca[code + 1]) + ", mBlock, " + this.mAccessor.codePosToSrcPos(code) + " );\n";
                    code += 2;
                    break;
                }
                case 123: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".changeClosureObjThis( " + this.getRegisterName(ca[code + 2]) + ".asObject() );";
                    code += 3;
                    break;
                }
                case 124: {
                    msg = String.valueOf(this.getRegisterName(ca[code + 1])) + ".set( ScriptsClass.getGlobal() );";
                    code += 2;
                    break;
                }
                case 125: {
                    msg = "addClassInstanceInfo( " + this.getRegisterName(ca[code + 1]) + ".asObject(), " + this.getRegisterName(ca[code + 2]) + ".asString() );";
                    code += 3;
                    break;
                }
                case 126: {
                    msg = "copyAllMembers( (CustomObject)objthis );";
                    ++code;
                    break;
                }
                case 127: {
                    ++code;
                    break;
                }
                default: {
                    throw new CompileException("\u672a\u5b9a\u7fa9\u306eVM\u30aa\u30da\u30b3\u30fc\u30c9\u3067\u3059\u3002");
                }
            }
            if (outputmask) continue;
            this.mSourceCodes.add(msg);
        }
        if (target.size() > 0) {
            this.mSourceCodes.add("default: loop = false;");
            this.mSourceCodes.add("}");
            this.mSourceCodes.add("} while(loop);");
            this.mSourceCodes.add("return;");
        }
        this.mSourceCodes.add("}");
    }

    public IntVector checkJumpCode(int start, int end) throws VariantException {
        IntVector ret = new IntVector();
        short[] ca = this.mCode;
        if (end <= 0) {
            end = ca.length;
        }
        if (end > ca.length) {
            end = ca.length;
        }
        int size = 0;
        int i = start;
        while (i < end) {
            switch (ca[i]) {
                case 0: {
                    size = 1;
                    break;
                }
                case 14: {
                    size = 1;
                    break;
                }
                case 1: {
                    size = 3;
                    break;
                }
                case 2: {
                    size = 3;
                    break;
                }
                case 7: {
                    size = 3;
                    break;
                }
                case 8: {
                    size = 3;
                    break;
                }
                case 9: {
                    size = 3;
                    break;
                }
                case 10: {
                    size = 3;
                    break;
                }
                case 88: {
                    size = 3;
                    break;
                }
                case 26: {
                    size = 3;
                    break;
                }
                case 27: {
                    size = 5;
                    break;
                }
                case 28: {
                    size = 5;
                    break;
                }
                case 29: {
                    size = 4;
                    break;
                }
                case 30: {
                    size = 3;
                    break;
                }
                case 31: {
                    size = 5;
                    break;
                }
                case 32: {
                    size = 5;
                    break;
                }
                case 33: {
                    size = 4;
                    break;
                }
                case 34: {
                    size = 3;
                    break;
                }
                case 35: {
                    size = 5;
                    break;
                }
                case 36: {
                    size = 5;
                    break;
                }
                case 37: {
                    size = 4;
                    break;
                }
                case 38: {
                    size = 3;
                    break;
                }
                case 39: {
                    size = 5;
                    break;
                }
                case 40: {
                    size = 5;
                    break;
                }
                case 41: {
                    size = 4;
                    break;
                }
                case 42: {
                    size = 3;
                    break;
                }
                case 43: {
                    size = 5;
                    break;
                }
                case 44: {
                    size = 5;
                    break;
                }
                case 45: {
                    size = 4;
                    break;
                }
                case 46: {
                    size = 3;
                    break;
                }
                case 47: {
                    size = 5;
                    break;
                }
                case 48: {
                    size = 5;
                    break;
                }
                case 49: {
                    size = 4;
                    break;
                }
                case 50: {
                    size = 3;
                    break;
                }
                case 51: {
                    size = 5;
                    break;
                }
                case 52: {
                    size = 5;
                    break;
                }
                case 53: {
                    size = 4;
                    break;
                }
                case 54: {
                    size = 3;
                    break;
                }
                case 55: {
                    size = 5;
                    break;
                }
                case 56: {
                    size = 5;
                    break;
                }
                case 57: {
                    size = 4;
                    break;
                }
                case 58: {
                    size = 3;
                    break;
                }
                case 59: {
                    size = 5;
                    break;
                }
                case 60: {
                    size = 5;
                    break;
                }
                case 61: {
                    size = 4;
                    break;
                }
                case 62: {
                    size = 3;
                    break;
                }
                case 63: {
                    size = 5;
                    break;
                }
                case 64: {
                    size = 5;
                    break;
                }
                case 65: {
                    size = 4;
                    break;
                }
                case 66: {
                    size = 3;
                    break;
                }
                case 67: {
                    size = 5;
                    break;
                }
                case 68: {
                    size = 5;
                    break;
                }
                case 69: {
                    size = 4;
                    break;
                }
                case 70: {
                    size = 3;
                    break;
                }
                case 71: {
                    size = 5;
                    break;
                }
                case 72: {
                    size = 5;
                    break;
                }
                case 73: {
                    size = 4;
                    break;
                }
                case 74: {
                    size = 3;
                    break;
                }
                case 75: {
                    size = 5;
                    break;
                }
                case 76: {
                    size = 5;
                    break;
                }
                case 77: {
                    size = 4;
                    break;
                }
                case 78: {
                    size = 3;
                    break;
                }
                case 79: {
                    size = 5;
                    break;
                }
                case 80: {
                    size = 5;
                    break;
                }
                case 81: {
                    size = 4;
                    break;
                }
                case 5: {
                    size = 2;
                    break;
                }
                case 6: {
                    size = 2;
                    break;
                }
                case 11: {
                    size = 2;
                    break;
                }
                case 12: {
                    size = 2;
                    break;
                }
                case 13: {
                    size = 2;
                    break;
                }
                case 82: {
                    size = 2;
                    break;
                }
                case 89: {
                    size = 2;
                    break;
                }
                case 90: {
                    size = 2;
                    break;
                }
                case 91: {
                    size = 2;
                    break;
                }
                case 92: {
                    size = 2;
                    break;
                }
                case 3: {
                    size = 2;
                    break;
                }
                case 93: {
                    size = 2;
                    break;
                }
                case 94: {
                    size = 2;
                    break;
                }
                case 83: {
                    size = 2;
                    break;
                }
                case 86: {
                    size = 2;
                    break;
                }
                case 87: {
                    size = 2;
                    break;
                }
                case 95: {
                    size = 2;
                    break;
                }
                case 96: {
                    size = 2;
                    break;
                }
                case 97: {
                    size = 2;
                    break;
                }
                case 98: {
                    size = 2;
                    break;
                }
                case 4: {
                    size = 3;
                    break;
                }
                case 18: {
                    size = 2;
                    break;
                }
                case 19: {
                    size = 4;
                    break;
                }
                case 20: {
                    size = 4;
                    break;
                }
                case 21: {
                    size = 3;
                    break;
                }
                case 22: {
                    size = 2;
                    break;
                }
                case 23: {
                    size = 4;
                    break;
                }
                case 24: {
                    size = 4;
                    break;
                }
                case 25: {
                    size = 3;
                    break;
                }
                case 15: {
                    ret.add(ca[i + 1] + i);
                    size = 2;
                    break;
                }
                case 16: {
                    ret.add(ca[i + 1] + i);
                    size = 2;
                    break;
                }
                case 17: {
                    ret.add(ca[i + 1] + i);
                    size = 2;
                    break;
                }
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    int st = ca[i] == 100 || ca[i] == 101 ? 5 : 4;
                    short num = ca[i + st - 1];
                    if (num == -1) {
                        size = st;
                        break;
                    }
                    if (num == -2) {
                        num = ca[i + ++st - 1];
                        size = st + num * 2;
                        break;
                    }
                    size = st + num;
                    break;
                }
                case 103: 
                case 110: {
                    size = 4;
                    break;
                }
                case 104: 
                case 105: 
                case 106: 
                case 111: {
                    size = 4;
                    break;
                }
                case 107: 
                case 112: {
                    size = 4;
                    break;
                }
                case 108: 
                case 109: 
                case 113: {
                    size = 4;
                    break;
                }
                case 114: {
                    size = 3;
                    break;
                }
                case 115: {
                    size = 3;
                    break;
                }
                case 84: 
                case 116: {
                    size = 4;
                    break;
                }
                case 85: 
                case 117: {
                    size = 4;
                    break;
                }
                case 118: {
                    size = 2;
                    break;
                }
                case 119: {
                    size = 1;
                    break;
                }
                case 120: {
                    ret.add(ca[i + 1] + i);
                    size = 3;
                    break;
                }
                case 121: {
                    size = 1;
                    break;
                }
                case 122: {
                    size = 2;
                    break;
                }
                case 123: {
                    size = 3;
                    break;
                }
                case 124: {
                    size = 2;
                    break;
                }
                case 125: {
                    size = 3;
                    break;
                }
                case 126: {
                    size = 1;
                    break;
                }
                case 127: {
                    size = 1;
                    break;
                }
                default: {
                    size = 1;
                }
            }
            i += size;
        }
        return ret;
    }

    private String callFunction(short[] ca, int[] ret, int code, int offset, int style) throws VariantException, CompileException {
        int code_offset = code + offset;
        int pass_args_count = ca[code_offset];
        if (pass_args_count == -1) {
            ret[0] = 1 + offset;
            switch (style) {
                case 0: {
                    return this.callFunctionInternalString(ca, code, "args");
                }
                case 1: {
                    return this.callFunctionIndirectInternalString(ca, code, "args");
                }
                case 2: {
                    return this.callFunctionDirectInternalString(ca, code, "args");
                }
            }
            throw new CompileException("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        if (pass_args_count == -2) {
            int arg_written_count = ca[code_offset + 1];
            ret[0] = arg_written_count * 2 + 2 + offset;
            StringBuilder builder = new StringBuilder();
            builder.append("{\n");
            builder.append("int args_v_count = 0;\n");
            builder.append("int pass_args_count = 0;\n");
            int i = 0;
            while (i < arg_written_count) {
                switch (ca[code_offset + i * 2 + 2]) {
                    case 0: {
                        builder.append("pass_args_count++;\n");
                        break;
                    }
                    case 1: {
                        builder.append("args_v_count += ");
                        builder.append("ArrayClass.getArrayElementCount( " + this.getRegisterName(ca[code_offset + i * 2 + 1 + 2]) + ".asObject();\n");
                        break;
                    }
                    case 2: {
                        builder.append("pass_args_count += ");
                        builder.append("(args.length > " + this.mFuncDeclUnnamedArgArrayBase + ") ? (args.length - " + this.mFuncDeclUnnamedArgArrayBase + ") : 0;\n");
                    }
                }
                ++i;
            }
            builder.append("pass_args_count += args_v_count;\n");
            builder.append("Variant[] pass_args_v = new Variant[args_v_count];\n");
            builder.append("pass_args = new Variant[pass_args_count];\n");
            builder.append("args_v_count = 0;\n");
            builder.append("pass_args_count = 0;\n");
            i = 0;
            while (i < arg_written_count) {
                switch (ca[code_offset + i * 2 + 2]) {
                    case 0: {
                        builder.append("pass_args[pass_args_count++] = " + this.getRegisterName(ca[code_offset + i * 2 + 1 + 2]) + ";");
                        break;
                    }
                    case 1: {
                        builder.append("int count = ArrayClass.copyArrayElementTo( " + this.getRegisterName(ca[code_offset + i * 2 + 1 + 2]) + ".asObject(), pass_args_v, args_v_count, 0, -1);\n");
                        builder.append("for( int j = 0; j < count; j++ ) {\n");
                        builder.append("pass_args[pass_args_count++] = pass_args_v[j + args_v_count];\n");
                        builder.append("}\n");
                        builder.append("args_v_count += count;\n");
                        break;
                    }
                    case 2: {
                        builder.append("int count = (args.length > " + this.mFuncDeclUnnamedArgArrayBase + ") ? (args.length - " + this.mFuncDeclUnnamedArgArrayBase + ") : 0;\n");
                        builder.append("for( int j = 0; j < count; j++ ) {\n");
                        builder.append("pass_args[pass_args_count++] = args[" + this.mFuncDeclUnnamedArgArrayBase + " + j];\n");
                        builder.append("}\n");
                    }
                }
                ++i;
            }
            switch (style) {
                case 0: {
                    builder.append(this.callFunctionInternalString(ca, code, "pass_args"));
                    break;
                }
                case 1: {
                    builder.append(this.callFunctionIndirectInternalString(ca, code, "pass_args"));
                    break;
                }
                case 2: {
                    builder.append(this.callFunctionDirectInternalString(ca, code, "pass_args"));
                }
            }
            builder.append("\npass_args_v = null;\n");
            builder.append("}");
            return builder.toString();
        }
        ret[0] = pass_args_count + 1 + offset;
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        String arg_name = "TJS.NULL_ARG";
        if (pass_args_count > 0) {
            builder.append("Variant[] pass_args = new Variant[" + pass_args_count + "];\n");
            arg_name = "pass_args";
        }
        int i = 0;
        while (i < pass_args_count) {
            builder.append("pass_args[" + i + "] = " + this.getRegisterName(ca[code_offset + 1 + i]) + ";\n");
            ++i;
        }
        switch (style) {
            case 0: {
                builder.append(this.callFunctionInternalString(ca, code, arg_name));
                break;
            }
            case 1: {
                builder.append(this.callFunctionIndirectInternalString(ca, code, arg_name));
                break;
            }
            case 2: {
                builder.append(this.callFunctionDirectInternalString(ca, code, arg_name));
            }
        }
        builder.append("\n}");
        return builder.toString();
    }

    private String callFunctionInternalString(short[] ca, int code, String pass_args) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("VariantClosure clo = " + this.getRegisterName(ca[code + 2]) + ".asObjectClosure();\n");
        short offset = ca[code + 1];
        short op = ca[code];
        if (op == 99) {
            if (offset != 0) {
                builder.append("int hr = clo.funcCall(0, null, " + this.getRegisterName(offset) + ", " + pass_args + "," + "clo.mObjThis != null ?clo.mObjThis:objthis);\n");
            } else {
                builder.append("int hr = clo.funcCall(0, null, null, " + pass_args + "," + "clo.mObjThis != null ?clo.mObjThis:objthis);\n");
            }
        } else {
            builder.append("Holder<Dispatch2> dsp = new Holder<Dispatch2>(null);\n");
            builder.append("int hr = clo.createNew(0, null, dsp, " + pass_args + ", clo.mObjThis != null ?clo.mObjThis:objthis);\n");
            if (offset != 0) {
                builder.append("if( hr >= 0 ) {\n");
                builder.append("if( dsp.mValue != null  ) {\n");
                builder.append(String.valueOf(this.getRegisterName(offset)) + ".set(dsp.mValue, dsp.mValue);\n");
                builder.append("}\n");
                builder.append("}\n");
            }
        }
        builder.append("if( hr < 0 ) throwFrom_tjs_error(hr, \"\" );\n");
        builder.append("}");
        return builder.toString();
    }

    private String callFunctionDirectInternalString(short[] ca, int code, String pass_args) throws VariantException {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("int hr;\n");
        String name = this.mData[ca[code + 3]].getString();
        short offset = ca[code + 1];
        String ra_code2 = this.getRegisterName(ca[code + 2]);
        builder.append("if( " + ra_code2 + ".isObject() ) {\n");
        builder.append("VariantClosure clo = " + ra_code2 + ".asObjectClosure();\n");
        if (offset != 0) {
            builder.append("hr = clo.funcCall(0, \"" + name + "\", " + this.getRegisterName(offset) + ", ");
            builder.append(String.valueOf(pass_args) + ", clo.mObjThis != null ?clo.mObjThis:objthis);\n");
        } else {
            builder.append("hr = clo.funcCall(0, \"" + name + "\", null, ");
            builder.append(String.valueOf(pass_args) + ", clo.mObjThis != null ?clo.mObjThis:objthis);\n");
        }
        if (JavaCodeGenerator.isStringFunctionName(name)) {
            builder.append("} else if( " + ra_code2 + ".isString() ) {\n");
            builder.append("processStringFunction( \"" + name + "\", " + ra_code2 + ".asString()," + pass_args + ", ");
            if (offset != 0) {
                builder.append(this.getRegisterName(offset));
            } else {
                builder.append("null");
            }
            builder.append(");\n");
            builder.append("hr = Error.S_OK;\n");
        }
        builder.append("} else {\n");
        builder.append("String mes = Error.VariantConvertErrorToObject.replace( \"%1\", Utils.VariantToReadableString(" + ra_code2 + ") );\n");
        builder.append("throw new VariantException( mes );\n");
        builder.append("}\n");
        builder.append("if( hr < 0 ) throwFrom_tjs_error(hr, \"" + name + "\" );\n");
        builder.append("}");
        return builder.toString();
    }

    private String callFunctionIndirectInternalString(short[] ca, int code, String pass_args) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("int hr;\n");
        String ra_code2 = this.getRegisterName(ca[code + 2]);
        String name = String.valueOf(this.getRegisterName(ca[code + 3])) + ".asString()";
        short offset = ca[code + 1];
        builder.append("if( " + ra_code2 + ".isObject() ) {\n");
        builder.append("VariantClosure clo = " + ra_code2 + ".asObjectClosure();\n");
        builder.append("hr = clo.funcCall(0, " + name + ", ");
        if (offset != 0) {
            builder.append(this.getRegisterName(offset));
        } else {
            builder.append("null");
        }
        builder.append(pass_args);
        builder.append(", clo.mObjThis != null ? clo.mObjThis:objthis);\n");
        if (JavaCodeGenerator.isStringFunctionName(name)) {
            builder.append("} else if( " + ra_code2 + ".isString() ) {\n");
            builder.append("processStringFunction( " + name + ", " + ra_code2 + ".asString(),");
            builder.append(pass_args);
            builder.append(", ");
            if (offset != 0) {
                builder.append(this.getRegisterName(offset));
            } else {
                builder.append("null");
            }
            builder.append(");\n");
            builder.append("hr = Error.S_OK;\n");
        }
        builder.append("} else {\n");
        builder.append("String mes = Error.VariantConvertErrorToObject.replace( \"%1\", Utils.VariantToReadableString(" + ra_code2 + ") );\n");
        builder.append("throw new VariantException( mes );\n");
        builder.append("}\n");
        builder.append("if( hr < 0 ) throwFrom_tjs_error(hr, \"\" );\n");
        builder.append("}");
        return builder.toString();
    }

    public ArrayList<String> getSourceCode() {
        return this.mSourceCodes;
    }

    private static boolean isStringFunctionName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0) {
            return false;
        }
        int count = STR_FUNC.length;
        int i = 0;
        while (i < count) {
            if (name.equals(STR_FUNC[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class ExceptionData {
        public int mCatchIp;
        public int mExobjReg;

        public ExceptionData(int catchip, int reg) {
            this.mCatchIp = catchip;
            this.mExobjReg = reg;
        }
    }
}

