/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2.translate;

import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;

public class JavaCodeIntermediate {
    private ArrayList<String> mInitializer;
    private ArrayList<ClosureCode> mMembers;
    private HashMap<String, Property> mProps;
    private String mName;

    public JavaCodeIntermediate(String classname) {
        this.mName = classname;
        this.mMembers = new ArrayList();
        this.mProps = new HashMap();
    }

    public void addMember(ClosureCode code) {
        this.mMembers.add(code);
    }

    public void addProperty(String name, Property prop) {
        this.mProps.put(name, prop);
    }

    public Property getProperty(String name) {
        return this.mProps.get(name);
    }

    public void setInitializer(ArrayList<String> code) {
        this.mInitializer = code;
    }

    public String getName() {
        return this.mName;
    }

    public void write() throws TJSException {
        String classname = String.valueOf(this.mName) + "Class";
        String filename = String.valueOf(this.mName) + "Class.java";
        TextWriteStreamInterface stream = TJS.mStorage.createTextWriteStream(filename, "utf-8");
        stream.write("package jp.kirikiri.tjs2java;\n");
        stream.write("import jp.kirikiri.tjs2.*;\n");
        stream.write("import jp.kirikiri.tjs2.Error;\n");
        stream.write("import jp.kirikiri.tvp2.base.ScriptsClass;\n");
        stream.write("import jp.kirikiri.tvp2.msg.Message;\n");
        stream.write("public class " + classname + " extends ExtendableNativeClass {\n");
        stream.write("static public int ClassID = -1;\n");
        stream.write("static public final String CLASS_NAME = \"" + this.mName + "\";\n");
        stream.write("public " + classname + "() throws VariantException, TJSException {\n");
        stream.write("super( CLASS_NAME );\n");
        stream.write("final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);\n");
        stream.write("setClassID( NCM_CLASSID );\n");
        stream.write("ClassID = NCM_CLASSID;\n");
        stream.write("TJS engine = ScriptsClass.getEngine();\n");
        int count = this.mMembers.size();
        int i = 0;
        while (i < count) {
            this.mMembers.get(i).write(this.mName, stream);
            ++i;
        }
        stream.write("}\n}\n");
        stream.destruct();
    }

    public static class ClosureCode {
        public ArrayList<String> mCode;
        public int mType;
        public String mName;

        public ClosureCode(String name, int type, ArrayList<String> code) {
            this.mName = name;
            this.mType = type;
            this.mCode = code;
        }

        public void write(String classname, TextWriteStreamInterface stream) throws TJSException {
            if (this.mType == 1) {
                if (this.mName.equals(classname)) {
                    stream.write("registerNCM( \"" + this.mName + "\", new NativeConvertedClassConstructor(engine) {\n@Override\n");
                } else {
                    stream.write("registerNCM( \"" + this.mName + "\", new NativeConvertedClassMethod(engine) {\n@Override\n");
                }
            }
            ArrayList<String> ca = this.mCode;
            int count = ca.size();
            int i = 0;
            while (i < count) {
                String line = ca.get(i);
                if (line != null) {
                    stream.write(ca.get(i));
                    stream.write("\n");
                }
                ++i;
            }
            if (this.mType == 1) {
                stream.write("}, CLASS_NAME, Interface.nitMethod, 0 );\n\n");
            }
        }
    }

    public static class Property {
        public ArrayList<String> mSetter;
        public ArrayList<String> mGetter;
        public String mName;

        public Property(String name) {
            this.mName = name;
        }

        public void setGetter(ArrayList<String> code) {
            this.mGetter = code;
        }

        public void setSetter(ArrayList<String> code) {
            this.mSetter = code;
        }
    }
}

