/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tjs2.translate;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.CustomObject;
import jp.kirikiri.tjs2.Dispatch;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.InterCodeObject;
import jp.kirikiri.tjs2.ScriptBlock;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tjs2.Utils;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;

public class NativeConvertedClassBase
extends Dispatch {
    protected static final int OP_BAND = 1;
    protected static final int OP_BOR = 2;
    protected static final int OP_BXOR = 3;
    protected static final int OP_SUB = 4;
    protected static final int OP_ADD = 5;
    protected static final int OP_MOD = 6;
    protected static final int OP_DIV = 7;
    protected static final int OP_IDIV = 8;
    protected static final int OP_MUL = 9;
    protected static final int OP_LOR = 10;
    protected static final int OP_LAND = 11;
    protected static final int OP_SAR = 12;
    protected static final int OP_SAL = 13;
    protected static final int OP_SR = 14;
    protected static final int OP_INC = 15;
    protected static final int OP_DEC = 16;
    WeakReference<TJS> mOwner;

    public TJS getOwner() {
        return (TJS)this.mOwner.get();
    }

    public NativeConvertedClassBase(TJS owner) {
        this.mOwner = new WeakReference<TJS>(owner);
    }

    protected static final void operateProperty(VariantClosure clo, Variant result, Variant param, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        Dispatch2 objThis = clo.mObjThis != null ? clo.mObjThis : objthis;
        int hr = clo.operation(ope, null, result, param, objThis);
        if (hr < 0) {
            NativeConvertedClassBase.throwFrom_tjs_error(hr, null);
        }
    }

    protected static final void operatePropertyIndirect(VariantClosure clo, Variant name, Variant result, Variant param, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        Dispatch2 objThis;
        Dispatch2 dispatch2 = objThis = clo.mObjThis != null ? clo.mObjThis : objthis;
        if (!name.isInteger()) {
            String str = name.asString();
            int hr = clo.operation(ope, str, result, param, objThis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, str);
            }
        } else {
            int num = name.asInteger();
            int hr = clo.operationByNum(ope, num, result, param, objThis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error_num(hr, num);
            }
        }
    }

    protected static final void operatePropertyDirect(VariantClosure clo, String name, Variant result, Variant param, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        Dispatch2 objThis = clo.mObjThis != null ? clo.mObjThis : objthis;
        int hr = clo.operation(ope, name, result, param, objThis);
        if (hr < 0) {
            NativeConvertedClassBase.throwFrom_tjs_error(hr, name);
        }
    }

    protected static final void displayExceptionGeneratedCode(int codepos, Variant[] ra, int ra_offset) throws VariantException {
        StringBuilder builder = new StringBuilder(128);
        builder.append("==== An exception occured");
        builder.append(", VM ip = ");
        builder.append(codepos);
        builder.append(" ====");
        TJS.outputToConsole(builder.toString());
    }

    protected static void throwInvalidVMCode() throws TJSException {
        throw new TJSException("\u4e0d\u6b63\u306a VM \u30b3\u30fc\u30c9\u3067\u3059");
    }

    protected static void addClassInstanceInfo(Dispatch2 dsp, String className) throws VariantException {
        if (dsp != null) {
            dsp.addClassInstanveInfo(className);
        }
    }

    protected static void throwScriptException(Variant val, ScriptBlock block, int srcpos) throws TJSException, VariantException {
        String msg = null;
        if (val.isObject()) {
            Variant v2;
            String message_name;
            int hr;
            VariantClosure clo = val.asObjectClosure();
            if (clo.mObject != null && (hr = clo.propGet(0, message_name = "message", v2 = new Variant(), null)) >= 0) {
                msg = "script exception : " + v2.asString();
            }
        }
        if (msg == null || msg.length() == 0) {
            msg = "script exception";
        }
        throw new TJSScriptException(msg, block, srcpos, val);
    }

    public static void throwFrom_tjs_error_num(int hr, int num) throws TJSException {
        Error.throwFrom_tjs_error(hr, String.valueOf(num));
    }

    public static void throwFrom_tjs_error(int hr, String name) throws TJSException {
        Error.throwFrom_tjs_error(hr, name);
    }

    protected static void setPropertyIndirect(Variant target, Variant member, Variant param, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            if (!member.isInteger()) {
                String str = member.asString();
                int hr = clo.propSet(flags, str, param, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    NativeConvertedClassBase.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propSetByNum(flags, member.asInteger(), param, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    NativeConvertedClassBase.throwFrom_tjs_error_num(hr, member.asInteger());
                }
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.setStringProperty(param, target, member);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.setOctetProperty(param, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    private static void getOctetProperty(Variant result, Variant octet, Variant member) throws TJSException, VariantException {
        String name;
        if (!member.isNumber()) {
            name = member.getString();
            if (name == null) {
                NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                ByteBuffer o = octet.asOctet();
                if (o != null) {
                    result.set(o.capacity());
                } else {
                    result.set(0);
                }
                return;
            }
            if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                int len;
                ByteBuffer o = octet.asOctet();
                int n = Integer.valueOf(name);
                int n2 = len = o != null ? o.capacity() : 0;
                if (n < 0 || n >= len) {
                    throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                result.set(o.get(n));
                return;
            }
        } else {
            int len;
            ByteBuffer o = octet.asOctet();
            int n = member.asInteger();
            int n3 = len = o != null ? o.capacity() : 0;
            if (n < 0 || n >= len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(o.get(n));
            return;
        }
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
    }

    private static void getOctetProperty(Variant result, Variant octet, String name) throws TJSException, VariantException {
        if (name == null) {
            NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            ByteBuffer o = octet.asOctet();
            if (o != null) {
                result.set(o.capacity());
            } else {
                result.set(0);
            }
            return;
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            int len;
            ByteBuffer o = octet.asOctet();
            int n = Integer.valueOf(name);
            int n2 = len = o != null ? o.capacity() : 0;
            if (n < 0 || n >= len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(o.get(n));
            return;
        }
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
    }

    private static void getOctetProperty(Variant result, Variant octet, int n) throws TJSException, VariantException {
        int len;
        ByteBuffer o = octet.asOctet();
        int n2 = len = o != null ? o.capacity() : 0;
        if (n < 0 || n >= len) {
            throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
        }
        result.set(o.get(n));
    }

    private static void setOctetProperty(Variant param, Variant octet, Variant member) throws TJSException, VariantException {
        if (!member.isNumber()) {
            String name = member.getString();
            if (name == null) {
                NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
            }
            NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
        } else {
            NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
        }
    }

    private static void setOctetProperty(Variant param, Variant octet, String name) throws TJSException, VariantException {
        if (name == null) {
            NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
        } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
        }
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
    }

    private static void setOctetProperty(Variant param, Variant octet, int member) throws TJSException, VariantException {
        NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
    }

    private static void getStringProperty(Variant result, Variant str, Variant member) throws TJSException, VariantException {
        String name;
        if (!member.isNumber()) {
            name = member.getString();
            if (name == null) {
                NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                String s = str.asString();
                if (s == null) {
                    result.set(0);
                } else {
                    result.set(s.length());
                }
                return;
            }
            if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                int len;
                String s = str.asString();
                int n = Integer.valueOf(name);
                if (n == (len = s.length())) {
                    result.set(new String());
                    return;
                }
                if (n < 0 || n > len) {
                    throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                result.set(s.substring(n, n + 1));
                return;
            }
        } else {
            int len;
            String s = str.asString();
            int n = member.asInteger();
            if (n == (len = s.length())) {
                result.set(new String());
                return;
            }
            if (n < 0 || n > len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(s.substring(n, n + 1));
            return;
        }
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
    }

    private static void getStringProperty(Variant result, Variant str, String name) throws TJSException, VariantException {
        if (name == null) {
            NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            String s = str.asString();
            if (s == null) {
                result.set(0);
            } else {
                result.set(s.length());
            }
            return;
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            int len;
            String s = str.asString();
            int n = Integer.valueOf(name);
            if (n == (len = s.length())) {
                result.set(new String());
                return;
            }
            if (n < 0 || n > len) {
                throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
            }
            result.set(s.substring(n, n + 1));
            return;
        }
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
    }

    private static void getStringProperty(Variant result, Variant str, int n) throws TJSException, VariantException {
        String s = str.asString();
        int len = s.length();
        if (n == len) {
            result.set(new String());
            return;
        }
        if (n < 0 || n > len) {
            throw new TJSException("\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059");
        }
        result.set(s.substring(n, n + 1));
    }

    private static void setStringProperty(Variant param, Variant str, Variant member) throws TJSException, VariantException {
        if (!member.isNumber()) {
            String name = member.getString();
            if (name == null) {
                NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
            }
            if (name.equals("length")) {
                NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
            }
            NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
        } else {
            NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
        }
    }

    private static void setStringProperty(Variant param, Variant str, String name) throws TJSException, VariantException {
        if (name == null) {
            NativeConvertedClassBase.throwFrom_tjs_error(-1001, "");
        }
        if (name.equals("length")) {
            NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
        } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
        }
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, name);
    }

    private static void setStringProperty(Variant param, Variant str, int member) throws TJSException, VariantException {
        NativeConvertedClassBase.throwFrom_tjs_error(-1007, "");
    }

    protected static void getPropertyIndirect(Variant result, Variant target, Variant member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            if (!member.isInteger()) {
                String str = member.asString();
                int hr = clo.propGet(flags, str, result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    NativeConvertedClassBase.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propGetByNum(flags, member.asInteger(), result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr < 0) {
                    NativeConvertedClassBase.throwFrom_tjs_error_num(hr, member.asInteger());
                }
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.getStringProperty(result, target, member);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.getOctetProperty(result, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void setPropertyDirect(Variant target, String member, Variant param, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propSet(flags, member, param, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, member);
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.setStringProperty(param, target, member);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.setOctetProperty(param, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void setPropertyDirect(Variant target, int member, Variant param, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            String name;
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propSet(flags, name = Integer.toString(member), param, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, name);
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.setStringProperty(param, target, member);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.setOctetProperty(param, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void getPropertyDirect(Variant result, Variant target, String member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, member, result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, member);
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.getStringProperty(result, target, member);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.getOctetProperty(result, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void getPropertyDirect(Variant result, Variant target, int member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            String name;
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, name = Integer.toString(member), result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, name);
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.getStringProperty(result, target, member);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.getOctetProperty(result, target, member);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void processOctetFunction(String member, String target, Variant[] args, Variant result) throws TJSException {
        NativeConvertedClassBase.throwFrom_tjs_error(-1001, member);
    }

    protected static void processStringFunction(String member, String target, Variant[] args, Variant result) throws TJSException, VariantException {
        InterCodeObject.processStringFunction(member, target, args, result);
    }

    protected static void instanceOf(Variant name, Variant targ) throws VariantException, TJSException {
        String str = name.asString();
        if (str != null) {
            int hr = CustomObject.defaultIsInstanceOf(0, targ, str, null);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, null);
            }
            targ.set(hr == 1 ? 1 : 0);
            return;
        }
        targ.set(0);
    }

    protected void eval(Variant val, Dispatch2 objthis, boolean resneed) throws VariantException, TJSException, CompileException {
        Variant res = new Variant();
        String str = val.asString();
        if (str.length() > 0) {
            if (resneed) {
                this.getOwner().evalExpression(str, res, objthis, null, 0);
            } else {
                this.getOwner().evalExpression(str, null, objthis, null, 0);
            }
        }
        if (resneed) {
            val.set(res);
        }
    }

    protected static final void typeOfMemberIndirect(Variant result, Variant target, Variant member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            if (!member.isInteger()) {
                String str = member.asString();
                int hr = clo.propGet(flags, str, result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr == 0) {
                    NativeConvertedClassBase.typeOf(result);
                } else if (hr == -1001) {
                    result.set("undefined");
                } else if (hr < 0) {
                    NativeConvertedClassBase.throwFrom_tjs_error(hr, str);
                }
            } else {
                int hr = clo.propGetByNum(flags, member.asInteger(), result, clo.mObjThis != null ? clo.mObjThis : objthis);
                if (hr == 0) {
                    NativeConvertedClassBase.typeOf(result);
                } else if (hr == -1001) {
                    result.set("undefined");
                } else if (hr < 0) {
                    NativeConvertedClassBase.throwFrom_tjs_error_num(hr, member.asInteger());
                }
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.getStringProperty(result, target, member);
            NativeConvertedClassBase.typeOf(result);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.getOctetProperty(result, target, member);
            NativeConvertedClassBase.typeOf(result);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void typeOfMemberDirect(Variant result, Variant target, String member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, member, result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr == 0) {
                NativeConvertedClassBase.typeOf(result);
            } else if (hr == -1001) {
                result.set("undefined");
            } else if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, member);
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.getStringProperty(result, target, member);
            NativeConvertedClassBase.typeOf(result);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.getOctetProperty(result, target, member);
            NativeConvertedClassBase.typeOf(result);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void typeOfMemberDirect(Variant result, Variant target, int member, Dispatch2 objthis, int flags) throws TJSException, VariantException {
        if (target.isObject()) {
            String name;
            VariantClosure clo = target.asObjectClosure();
            int hr = clo.propGet(flags, name = Integer.toString(member), result, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr == 0) {
                NativeConvertedClassBase.typeOf(result);
            } else if (hr == -1001) {
                result.set("undefined");
            } else if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, name);
            }
        } else if (target.isString()) {
            NativeConvertedClassBase.getStringProperty(result, target, member);
            NativeConvertedClassBase.typeOf(result);
        } else if (target.isOctet()) {
            NativeConvertedClassBase.getOctetProperty(result, target, member);
            NativeConvertedClassBase.typeOf(result);
        } else {
            String mes = "%1 \u304b\u3089 Object \u3078\u578b\u3092\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002Object \u578b\u304c\u8981\u6c42\u3055\u308c\u308b\u6587\u8108\u3067 Object \u578b\u4ee5\u5916\u306e\u5024\u304c\u6e21\u3055\u308c\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059".replace("%1", Utils.VariantToReadableString(target));
            throw new VariantException(mes);
        }
    }

    protected static void typeOf(Variant val) {
        String name = val.getTypeName();
        if (name != null) {
            val.set(name);
        }
    }

    protected static void operatePropertyIndirect0(VariantClosure clo, Variant name, Variant result, Dispatch2 objthis, int ope) throws TJSException, VariantException {
        if (!name.isInteger()) {
            String str = name.asString();
            int hr = clo.operation(ope, str, result, null, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error(hr, str);
            }
        } else {
            int hr = clo.operationByNum(ope, name.asInteger(), result, null, clo.mObjThis != null ? clo.mObjThis : objthis);
            if (hr < 0) {
                NativeConvertedClassBase.throwFrom_tjs_error_num(hr, name.asInteger());
            }
        }
    }

    public static void characterCodeFrom(Variant val) throws VariantException {
        char[] ch = new char[]{(char)val.asInteger()};
        val.set(new String(ch));
    }

    public static void characterCodeOf(Variant val) throws VariantException {
        String str = val.asString();
        if (str != null) {
            int v = str.codePointAt(0);
            val.set(v);
        } else {
            val.set(0);
        }
    }
}

