/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.HashMap;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;

public abstract class Archive {
    private HashMap<String, Integer> mHash;
    private boolean mInit;
    private String mArchiveName;

    public Archive(String name) {
        this.mArchiveName = name;
        this.mHash = new HashMap();
    }

    public abstract int getCount();

    public abstract String getName(int var1);

    public abstract BinaryStream createStreamByIndex(int var1) throws TJSException;

    public static String normalizeInArchiveStorageName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        String tmp = name.toLowerCase();
        tmp = tmp.replace('\\', '/');
        char[] ptr = tmp.toCharArray();
        int len = ptr.length;
        int dest = 0;
        int i = 0;
        while (i < len) {
            if (ptr[i] != '/') {
                ptr[dest] = ptr[i];
                ++i;
                ++dest;
                continue;
            }
            if (i != 0) {
                ptr[dest] = ptr[i];
                ++i;
                ++dest;
            }
            while (i < len && ptr[i] == '/') {
                ++i;
            }
        }
        return new String(ptr, 0, dest);
    }

    private void addToHash() {
        int count = this.getCount();
        int i = 0;
        while (i < count) {
            String name = this.getName(i);
            name = Archive.normalizeInArchiveStorageName(name);
            this.mHash.put(name, i);
            ++i;
        }
    }

    public BinaryStream createStream(String name) throws TJSException {
        Integer p;
        if (name == null || name.length() == 0) {
            return null;
        }
        if (!this.mInit) {
            this.mInit = true;
            this.addToHash();
        }
        if ((p = this.mHash.get(name)) == null) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u304c\u30a2\u30fc\u30ab\u30a4\u30d6 %2 \u306e\u4e2d\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093", name, this.mArchiveName);
        }
        return this.createStreamByIndex(p);
    }

    public boolean isExistent(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!this.mInit) {
            this.mInit = true;
            this.addToHash();
        }
        return this.mHash.get(name) != null;
    }

    public int getFirstIndexStartsWith(String prefix) {
        int total_count = this.getCount();
        int s = 0;
        int e = total_count;
        while (e - s > 1) {
            int m = (e + s) / 2;
            if (this.getName(m).compareTo(prefix) >= 0) {
                e = m;
                continue;
            }
            s = m;
        }
        if (s >= total_count) {
            return -1;
        }
        if (this.getName(s).startsWith(prefix)) {
            return s;
        }
        if (++s >= total_count) {
            return -1;
        }
        if (this.getName(s).startsWith(prefix)) {
            return s;
        }
        return -1;
    }
}

