/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.HashMap;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Archive;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;

public class ArchiveCache {
    private static final int DEFAULT_ARCHIVE_CACHE_NUM = 64;
    private HashMap<String, Archive> mArchiveCache = new HashMap(64);

    void clear() {
        this.mArchiveCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Archive get(String name) throws TJSException {
        String nname = TVP.StorageMediaManager.normalizeStorageName(name, null);
        ArchiveCache archiveCache = this;
        synchronized (archiveCache) {
            Archive ptr = this.mArchiveCache.get(nname);
            if (ptr != null) {
                return ptr;
            }
            if (!Storage.isExistentStorageNoSearch(nname)) {
                Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", nname);
            }
            Archive arc = TVP.openArchive(nname);
            this.mArchiveCache.put(nname, arc);
            return arc;
        }
    }
}

