/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.lang.ref.WeakReference;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;

public class AsyncTriggerNI
extends NativeInstanceObject {
    private static final int atmNormal = 0;
    private static final int atmExclusive = 1;
    private static final int atmAtIdle = 2;
    private static final String ON_FIRE = "onFire";
    private WeakReference<Dispatch2> mOwner;
    private VariantClosure mActionOwner = new VariantClosure(null);
    private String mActionName = "action";
    private boolean mCached = true;
    private int mMode = 0;
    private int mIdlePendingCount;

    @Override
    public int construct(Variant[] param, Dispatch2 tjs_obj) throws TJSException {
        if (param.length < 1) {
            return -1004;
        }
        int hr = super.construct(param, tjs_obj);
        if (hr < 0) {
            return hr;
        }
        if (param.length >= 2 && !param[1].isVoid()) {
            this.mActionName = param[1].asString();
        }
        this.mActionOwner.set(param[0].asObjectClosure());
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        return 0;
    }

    @Override
    public void invalidate() throws VariantException, TJSException {
        TVP.EventManager.cancelSourceEvents((Dispatch2)this.mOwner.get());
        this.mOwner.clear();
        this.mActionOwner.mObject = null;
        this.mActionOwner.mObjThis = null;
        super.invalidate();
    }

    public VariantClosure getActionOwner() {
        return this.mActionOwner;
    }

    public String getActionName() {
        return this.mActionName;
    }

    public void trigger() {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            if (this.mCached) {
                TVP.EventManager.cancelSourceEvents(owner);
            }
            int flags = 0;
            if (this.mMode == 1) {
                flags |= 0x20;
            }
            if (this.mMode == 2) {
                flags |= 0x40;
            }
            TVP.EventManager.postEvent(owner, owner, ON_FIRE, 0, flags, TJS.NULL_ARG);
        }
    }

    public void cancel() {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.cancelSourceEvents(owner);
        }
        this.mIdlePendingCount = 0;
    }

    public boolean getCached() {
        return this.mCached;
    }

    public void setCached(boolean b) {
        if (this.mCached != b) {
            this.mCached = b;
            this.cancel();
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int m) {
        if (this.mMode != m) {
            this.mMode = m;
            this.cancel();
        }
    }
}

