/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Archive;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.base.StorageLister;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;

public class AutoPath {
    private boolean mAutoPathTableInit;
    private boolean mClearAutoPathCacheCallbackInit;
    private ArrayList<String> mAutoPathList = new ArrayList();
    private HashMap<String, String> mAutoPathCache = new HashMap();
    private HashMap<String, String> mAutoPathTable = new HashMap();

    public void clearAutoPathCache() {
        this.mAutoPathCache.clear();
        this.mAutoPathTable.clear();
        this.mAutoPathTableInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoPath(String name) throws TJSException {
        Object object = TVP.CreateStreamCS;
        synchronized (object) {
            String normalized;
            int idx;
            char lastchar = name.charAt(name.length() - 1);
            if (lastchar != '>' && lastchar != '/' && lastchar != '\\') {
                Message.throwExceptionMessage("\u30d1\u30b9\u540d\u306e\u6700\u5f8c\u306b\u306f '>' \u307e\u305f\u306f '/' \u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044 (\u5409\u91cc\u5409\u91cc\uff12 2.19 beta 14 \u3088\u308a\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u533a\u5207\u308a\u8a18\u53f7\u304c '#' \u304b\u3089 '>' \u306b\u5909\u308f\u308a\u307e\u3057\u305f)");
            }
            if ((idx = this.mAutoPathList.indexOf(normalized = TVP.StorageMediaManager.normalizeStorageName(name, null))) == -1) {
                this.mAutoPathList.add(normalized);
            }
            this.clearAutoPathCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoPath(String name) throws TJSException {
        Object object = TVP.CreateStreamCS;
        synchronized (object) {
            String normalized;
            int idx;
            char lastchar = name.charAt(name.length() - 1);
            if (lastchar != '>' && lastchar != '/' && lastchar != '\\') {
                Message.throwExceptionMessage("\u30d1\u30b9\u540d\u306e\u6700\u5f8c\u306b\u306f '>' \u307e\u305f\u306f '/' \u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044 (\u5409\u91cc\u5409\u91cc\uff12 2.19 beta 14 \u3088\u308a\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u533a\u5207\u308a\u8a18\u53f7\u304c '#' \u304b\u3089 '>' \u306b\u5909\u308f\u308a\u307e\u3057\u305f)");
            }
            if ((idx = this.mAutoPathList.indexOf(normalized = TVP.StorageMediaManager.normalizeStorageName(name, null))) != -1) {
                this.mAutoPathList.remove(idx);
            }
            this.clearAutoPathCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int rebuildAutoPathTable() throws TJSException {
        if (this.mAutoPathTableInit) {
            return 0;
        }
        var1_1 = TVP.CreateStreamCS;
        synchronized (var1_1) {
            this.mAutoPathTable.clear();
            tick = System.currentTimeMillis();
            DebugClass.addLog("(info) Rebuilding Auto Path Table ...");
            totalcount = 0;
            pathcount = this.mAutoPathList.size();
            i = 0;
            while (i < pathcount) {
                path = this.mAutoPathList.get(i);
                count = 0;
                sharp_pos = path.indexOf(62);
                if (sharp_pos != -1) {
                    arcname = path.substring(0, sharp_pos);
                    in_arc_name = path.substring(sharp_pos + 1);
                    if ((in_arc_name = Archive.normalizeInArchiveStorageName(in_arc_name)) == null) {
                        in_arc_name = "";
                    }
                    in_arc_name_len = in_arc_name.length();
                    arc = TVP.ArchiveCache.get(arcname);
                    try {
                        storagecount = arc.getCount();
                        idx = arc.getFirstIndexStartsWith(in_arc_name);
                        if (idx == -1) ** GOTO lbl53
                        while (idx < storagecount) {
                            name = arc.getName(idx);
                            if (!name.startsWith(in_arc_name)) break;
                            if (name.indexOf(47, in_arc_name_len) == -1) {
                                sname = Storage.extractStorageName(name);
                                this.mAutoPathTable.put(sname, path);
                                ++count;
                            }
                            ++idx;
                        }
                    }
                    finally {
                        arc = null;
                    }
                } else {
                    lister = new Lister();
                    TVP.StorageMediaManager.getListAt(path, lister);
                    list = lister.list;
                    listcount = list.size();
                    j = 0;
                    while (j < listcount) {
                        pname = list.get(j);
                        this.mAutoPathTable.put(pname, path);
                        ++count;
                        ++j;
                    }
                }
lbl53:
                // 4 sources

                totalcount += count;
                ++i;
            }
            endtick = System.currentTimeMillis();
            builder = new StringBuilder(256);
            builder.append("(info) Total ");
            builder.append(totalcount);
            builder.append(" file(s) found, ");
            builder.append(this.mAutoPathTable.size());
            builder.append(" file(s) activated. (");
            builder.append(endtick - tick);
            builder.append("ms)");
            DebugClass.addLog(builder.toString());
            this.mAutoPathTableInit = true;
            return totalcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlacedPath(String name) throws TJSException {
        String incache;
        if (!this.mClearAutoPathCacheCallbackInit) {
            TVP.CompactEvent.addCompactEventHook(new ClearAutoPathCacheCallback());
            this.mClearAutoPathCacheCallbackInit = true;
        }
        if ((incache = this.mAutoPathCache.get(name)) != null) {
            return incache;
        }
        Object object = TVP.CreateStreamCS;
        synchronized (object) {
            String normalized = TVP.StorageMediaManager.normalizeStorageName(name, null);
            boolean found = Storage.isExistentStorageNoSearchNoNormalize(normalized);
            if (found) {
                this.mAutoPathCache.put(name, normalized);
                return normalized;
            }
            String storagename = Storage.extractStorageName(normalized);
            this.rebuildAutoPathTable();
            String result = this.mAutoPathTable.get(storagename);
            if (result != null) {
                String found1 = String.valueOf(result) + storagename;
                this.mAutoPathCache.put(name, found1);
                return found1;
            }
            this.mAutoPathCache.put(name, "");
            return "";
        }
    }

    class ClearAutoPathCacheCallback
    implements CompactEventCallbackInterface {
        ClearAutoPathCacheCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompact(int level) {
            if (level >= 10) {
                Object object = TVP.CreateStreamCS;
                synchronized (object) {
                    AutoPath.this.clearAutoPathCache();
                }
            }
        }
    }

    static class Lister
    implements StorageLister {
        public ArrayList<String> list = new ArrayList();

        @Override
        public void add(String file) {
            this.list.add(file);
        }
    }
}

