/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.IOException;
import java.io.InputStream;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;

public class BinaryInputStream
extends InputStream {
    private BinaryStream mStream;
    private long mMark;
    private byte[] mBuffer;

    public BinaryInputStream(BinaryStream stream) {
        this.mStream = stream;
        this.mBuffer = new byte[1];
    }

    @Override
    public int available() {
        try {
            return (int)this.mStream.getSize();
        }
        catch (TJSException e) {
            return 0;
        }
    }

    @Override
    public void close() {
        this.mStream.close();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.mMark = this.mStream.getPosition();
        }
        catch (TJSException tJSException) {
            // empty catch block
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int ret;
        block3: {
            try {
                ret = this.mStream.read(this.mBuffer);
                if (ret >= 0) break block3;
                return -1;
            }
            catch (TJSException e) {
                throw new IOException();
            }
        }
        ret = this.mBuffer[0] & 0xFF;
        return ret;
    }

    @Override
    public int read(byte[] b) {
        try {
            return this.mStream.read(b);
        }
        catch (TJSException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            return this.mStream.read(b, off, len);
        }
        catch (TJSException e) {
            return -1;
        }
    }

    @Override
    public void reset() {
        try {
            this.mStream.setPosition(this.mMark);
        }
        catch (TJSException tJSException) {
            // empty catch block
        }
    }

    @Override
    public long skip(long n) {
        try {
            long size = this.mStream.getSize();
            long pos = this.mStream.getPosition();
            if (pos + n > size) {
                n = size - pos;
            }
            this.mStream.setPosition(pos + n);
            return n;
        }
        catch (TJSException e) {
            return 0L;
        }
    }
}

