/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer mData;

    public ByteBufferInputStream(ByteBuffer src) {
        this.mData = src;
    }

    @Override
    public int available() {
        return this.mData.limit() - this.mData.position();
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
        this.mData.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        return this.mData.get();
    }

    @Override
    public int read(byte[] b) {
        int len = b.length;
        if (b.length > this.available()) {
            len = this.available();
        }
        this.mData.get(b, 0, len);
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (len + off > this.available()) {
            len = this.available() - off;
        }
        if (len <= 0) {
            return -1;
        }
        this.mData.get(b, off, len);
        return len;
    }

    @Override
    public void reset() {
        this.mData.reset();
    }

    @Override
    public long skip(long n) {
        if (n > (long)(this.mData.limit() - this.mData.position())) {
            n = this.mData.limit() - this.mData.position();
        }
        this.mData.position((int)((long)this.mData.position() + n));
        return n;
    }
}

