/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.BaseInputEvent;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;
import jp.kirikiri.tvp2.base.ContinuousEventCallbackInterface;
import jp.kirikiri.tvp2.base.Event;
import jp.kirikiri.tvp2.base.ScriptsClass;
import jp.kirikiri.tvp2.base.WinUpdateEvent;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.WindowNI;

public class EventManager {
    public static final int EPT_POST = 0;
    public static final int EPT_REMOVE_POST = 1;
    public static final int EPT_IMMEDIATE = 2;
    public static final int EPT_DISCARDABLE = 16;
    public static final int EPT_NORMAL = 0;
    public static final int EPT_EXCLUSIVE = 32;
    public static final int EPT_IDLE = 64;
    public static final int EPT_PRIO_MASK = 224;
    public static final int EPT_METHOD_MASK = 15;
    private ArrayList<BaseInputEvent> mInputEventQueue = new ArrayList();
    private ArrayList<Event> mEventQueue = new ArrayList();
    private ArrayList<WinUpdateEvent> mWinUpdateEventQueue = new ArrayList();
    private boolean mExclusiveEventPosted;
    private long mEventSequenceNumber;
    private long mEventSequenceNumberToProcess;
    private boolean mEventDisabled;
    private boolean mEventInterrupting;
    private boolean mWindowUpdateEventsDelivering;
    private int mInputEventTagMax;
    private boolean mProcessContinuousHandlerEventFlag;
    private ArrayList<ContinuousEventCallbackInterface> mContinuousEventVector = new ArrayList();
    private ArrayList<VariantClosure> mContinuousHandlerVector = new ArrayList();
    private boolean mContinuousEventProcessing;
    private ArrayList<CompactEventCallbackInterface> mCompactEventVector = new ArrayList();
    private boolean mEventInvoked;
    private boolean mBreathing;
    private int mContinousHandlerLimitFrequency;
    private static final String type_name = "type";
    private static final String target_name = "target";
    public static final String ActionName = "action";
    private int ArgumentGeneration = 0;

    public long getSequenceNumber() {
        return this.mEventSequenceNumber;
    }

    public long getSequenceNumberToProcess() {
        return this.mEventSequenceNumberToProcess;
    }

    public void postEvent(Dispatch2 source, Dispatch2 target, String eventname, int tag, int flag, Variant[] args) {
        boolean evdisabled;
        boolean bl = evdisabled = this.mEventDisabled || TVP.getSystemEventDisabledState();
        if ((flag & 0x10) != 0 && (this.mEventInterrupting || evdisabled)) {
            return;
        }
        int method = flag & 0xF;
        if (method == 2) {
            block12: {
                if (evdisabled) {
                    return;
                }
                try {
                    try {
                        Event.immediate(target, source, eventname, tag, args, flag);
                    }
                    catch (TJSException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new TJSException(e.getMessage());
                    }
                }
                catch (TJSException e) {
                    if (ScriptsClass.processUnhandledException(e)) break block12;
                    ScriptsClass.showScriptException(e);
                }
            }
            return;
        }
        if (method == 1) {
            int count = this.mEventQueue.size();
            int i = count - 1;
            while (i >= 0) {
                Event ev = this.mEventQueue.get(i);
                if (source == ev.getSource() && target == ev.getTarget() && eventname.equals(ev.getEventName()) && (tag == 0 || tag == ev.getTag())) {
                    this.mEventQueue.remove(i);
                }
                --i;
            }
        }
        this.mEventQueue.add(new Event(target, source, eventname, tag, args, flag));
        if ((flag & 0xE0) == 32) {
            this.mExclusiveEventPosted = true;
        }
        this.invokeEvents();
    }

    public int cancelEvents(Dispatch2 source, Dispatch2 target, String eventname, int tag) {
        int delCount = 0;
        int count = this.mEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            Event ev = this.mEventQueue.get(i);
            if (source == ev.getSource() && target == ev.getTarget() && eventname.equals(ev.getEventName()) && (tag == 0 || tag == ev.getTag())) {
                this.mEventQueue.remove(i);
                ++delCount;
            }
            --i;
        }
        return delCount;
    }

    public int cancelEvents(Dispatch2 source, Dispatch2 target, String eventname) {
        return this.cancelEvents(source, target, eventname, 0);
    }

    public boolean areEventsInQueue(Dispatch2 source, Dispatch2 target, String eventname, int tag) {
        int count = this.mEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            Event ev = this.mEventQueue.get(i);
            if (source == ev.getSource() && target == ev.getTarget() && eventname.equals(ev.getEventName()) && (tag == 0 || tag == ev.getTag())) {
                return true;
            }
            --i;
        }
        return false;
    }

    public int countEventsInQueue(Dispatch2 source, Dispatch2 target, String eventname, int tag) {
        int evCount = 0;
        int count = this.mEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            Event ev = this.mEventQueue.get(i);
            if (source == ev.getSource() && target == ev.getTarget() && eventname.equals(ev.getEventName()) && (tag == 0 || tag == ev.getTag())) {
                ++evCount;
            }
            --i;
        }
        return evCount;
    }

    public void cancelEventsByTag(Dispatch2 source, Dispatch2 target, int tag) {
        int count = this.mEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            Event ev = this.mEventQueue.get(i);
            if (source == ev.getSource() && target == ev.getTarget() && (tag == 0 || tag == ev.getTag())) {
                this.mEventQueue.remove(i);
            }
            --i;
        }
    }

    public void cancelEventsByTag(Dispatch2 source, Dispatch2 target) {
        this.cancelEventsByTag(source, target, 0);
    }

    public void cancelSourceEvents(Dispatch2 source) {
        int count = this.mEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            Event ev = this.mEventQueue.get(i);
            if (source == ev.getSource()) {
                this.mEventQueue.remove(i);
            }
            --i;
        }
    }

    public void discardAllDiscardableEvents() {
        int count = this.mEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            Event ev = this.mEventQueue.get(i);
            if ((ev.getFlags() & 0x10) != 0) {
                this.mEventQueue.remove(i);
            }
            --i;
        }
    }

    private void deliverEventByPrio(int prio) throws VariantException, TJSException {
        while (true) {
            Event ev = null;
            int count = this.mEventQueue.size();
            if (count == 0) break;
            int i = 0;
            while (i < count) {
                ev = this.mEventQueue.get(i);
                if (ev.getSequence() <= this.mEventSequenceNumberToProcess && (ev.getFlags() & 0xE0) == prio) break;
                ++i;
            }
            if (i == count) break;
            this.mEventQueue.remove(i);
            if (ev == null) continue;
            ev.deliver();
            Object var2_2 = null;
        }
    }

    private boolean deliverAllEvents2() throws VariantException, TJSException {
        int count;
        this.mExclusiveEventPosted = false;
        this.deliverEventByPrio(32);
        if (this.mExclusiveEventPosted) {
            return true;
        }
        while ((count = this.mInputEventQueue.size()) != 0) {
            BaseInputEvent ev = this.mInputEventQueue.get(0);
            this.mInputEventQueue.remove(0);
            ev.deliver();
            ev = null;
            if (!this.mExclusiveEventPosted) continue;
            return true;
        }
        this.deliverEventByPrio(0);
        if (this.mExclusiveEventPosted) {
            return true;
        }
        return true;
    }

    private boolean deliverAllEventsInternal() throws VariantException, TJSException {
        if (this.mEventDisabled) {
            return true;
        }
        this.eventReceived();
        boolean ret_value = this.deliverAllEvents2();
        return ret_value;
    }

    public void deliverAllEvents() {
        block13: {
            boolean r;
            block11: {
                r = true;
                if (!this.mEventInterrupting) {
                    this.mEventSequenceNumberToProcess = this.mEventSequenceNumber++;
                }
                this.mEventInterrupting = false;
                try {
                    r = this.deliverAllEventsInternal();
                }
                catch (TJSException e) {
                    if (ScriptsClass.processUnhandledException(e)) break block11;
                    ScriptsClass.showScriptException(e);
                }
            }
            if (!r) {
                this.mEventInterrupting = true;
                this.callDeliverAllEventsOnIdle();
            }
            if (!this.mExclusiveEventPosted && !this.mEventInterrupting) {
                block12: {
                    try {
                        this.deliverEventByPrio(64);
                    }
                    catch (TJSException e) {
                        if (ScriptsClass.processUnhandledException(e)) break block12;
                        ScriptsClass.showScriptException(e);
                    }
                }
                if (this.mProcessContinuousHandlerEventFlag) {
                    this.mProcessContinuousHandlerEventFlag = false;
                    this.deliverContinuousEvent();
                }
                try {
                    this.deliverWindowUpdateEvents();
                }
                catch (TJSException e) {
                    if (ScriptsClass.processUnhandledException(e)) break block13;
                    ScriptsClass.showScriptException(e);
                }
            }
        }
        if (this.mEventQueue.size() == 0) {
            this.mEventSequenceNumber = 0L;
        }
    }

    public void postWindowUpdate(WindowNI window) {
        if (!this.mWindowUpdateEventsDelivering) {
            if (this.mWinUpdateEventQueue.size() > 0) {
                int count = this.mWinUpdateEventQueue.size();
                int i = 0;
                while (i < count) {
                    WinUpdateEvent ev = this.mWinUpdateEventQueue.get(i);
                    if (!ev.isEmpty() && window == ev.getWindow()) {
                        return;
                    }
                    ++i;
                }
            }
        } else if (this.mWinUpdateEventQueue.size() > 0) {
            int hitCount = 0;
            int count = this.mWinUpdateEventQueue.size();
            int i = 0;
            while (i < count) {
                WinUpdateEvent ev = this.mWinUpdateEventQueue.get(i);
                if (!ev.isEmpty() && window == ev.getWindow() && ++hitCount == 2) {
                    return;
                }
                ++i;
            }
        }
        this.mWinUpdateEventQueue.add(new WinUpdateEvent(window));
        this.invokeEvents();
    }

    public void removeWindowUpdate(WindowNI window) {
        if (this.mWinUpdateEventQueue.size() > 0) {
            int count = this.mWinUpdateEventQueue.size();
            int i = 0;
            while (i < count) {
                WinUpdateEvent ev = this.mWinUpdateEventQueue.get(i);
                if (!ev.isEmpty() && window == ev.getWindow()) {
                    ev.markEmpty();
                }
                ++i;
            }
        }
    }

    public void deliverWindowUpdateEvents() throws VariantException, TJSException {
        if (this.mWindowUpdateEventsDelivering) {
            return;
        }
        this.mWindowUpdateEventsDelivering = true;
        try {
            int count = this.mWinUpdateEventQueue.size();
            int i = 0;
            while (i < count) {
                WinUpdateEvent ev = this.mWinUpdateEventQueue.get(i);
                if (!ev.isEmpty()) {
                    ev.deliver();
                }
                ++i;
            }
        }
        finally {
            this.mWinUpdateEventQueue.clear();
            this.mWindowUpdateEventsDelivering = false;
        }
    }

    public void postInputEvent(BaseInputEvent ev, int flags) {
        if ((flags & 0x10) != 0 && (this.mEventDisabled || TVP.getSystemEventDisabledState())) {
            ev = null;
            return;
        }
        if ((flags & 1) != 0) {
            this.cancelInputEvents(ev.getSource(), ev.getTag());
        }
        this.mInputEventQueue.add(ev);
        this.invokeEvents();
    }

    public void cancelInputEvents(Object source) {
        int count = this.mInputEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            BaseInputEvent ev = this.mInputEventQueue.get(i);
            if (source == ev.getSource()) {
                this.mInputEventQueue.remove(i);
            }
            --i;
        }
    }

    void cancelInputEvents(Object source, int tag) {
        int count = this.mInputEventQueue.size();
        int i = count - 1;
        while (i >= 0) {
            BaseInputEvent ev = this.mInputEventQueue.get(i);
            if (source == ev.getSource() && tag == ev.getTag()) {
                this.mInputEventQueue.remove(i);
            }
            --i;
        }
    }

    public int getInputEventCount() {
        return this.mInputEventQueue.size();
    }

    public static Dispatch2 createEventObject(String type, Dispatch2 targthis, Dispatch2 targ) throws VariantException, TJSException {
        Variant val;
        Dispatch2 object = TJS.createDictionaryObject();
        int hr = object.propSet(2560, type_name, val = new Variant(type), object);
        if (hr < 0) {
            Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
        }
        val.set(targthis, targ);
        hr = object.propSet(2560, target_name, val, object);
        if (hr < 0) {
            Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
        }
        return object;
    }

    public void destroyContinuousHandlerVector() {
        int count = this.mContinuousHandlerVector.size();
        int i = 0;
        while (i < count) {
            VariantClosure clo = this.mContinuousHandlerVector.get(i);
            clo.set(null, null);
            ++i;
        }
        this.mContinuousHandlerVector.clear();
    }

    public void addContinuousEventHook(ContinuousEventCallbackInterface cb) {
        this.beginContinuousEvent();
        this.mContinuousEventVector.add(cb);
    }

    public void removeContinuousEventHook(ContinuousEventCallbackInterface cb) {
        int count = this.mContinuousEventVector.size();
        int i = 0;
        while (i < count) {
            ContinuousEventCallbackInterface c = this.mContinuousEventVector.get(i);
            if (c == cb) {
                this.mContinuousEventVector.set(i, null);
            }
            ++i;
        }
    }

    private void deliverContinuousEventInternal() throws TJSException {
        boolean emptyflag;
        long tick = TVP.getTickCount();
        int count = this.mContinuousEventVector.size();
        if (count > 0) {
            emptyflag = false;
            int i = 0;
            while (i < count) {
                if (this.mContinuousEventVector.get(i) != null) {
                    this.mContinuousEventVector.get(i).onContinuousCallback(tick);
                } else {
                    emptyflag = true;
                }
                if (this.mExclusiveEventPosted) {
                    return;
                }
                ++i;
            }
            if (emptyflag) {
                count = this.mContinuousEventVector.size();
                i = count - 1;
                while (i >= 0) {
                    if (this.mContinuousEventVector.get(i) == null) {
                        this.mContinuousEventVector.remove(i);
                    }
                    --i;
                }
            }
        }
        if (!this.mEventDisabled && this.mContinuousHandlerVector.size() > 0) {
            VariantClosure clo;
            emptyflag = false;
            Variant vtick = new Variant(tick);
            Variant[] pvtick = new Variant[]{vtick};
            count = this.mContinuousHandlerVector.size();
            int i = 0;
            while (i < count) {
                clo = this.mContinuousHandlerVector.get(i);
                if (clo != null && clo.mObject != null) {
                    int er;
                    try {
                        er = clo.funcCall(0, null, null, pvtick, null);
                    }
                    catch (VariantException e) {
                        clo.mObject = null;
                        clo.mObjThis = null;
                        throw e;
                    }
                    catch (TJSException e) {
                        clo.mObject = null;
                        clo.mObjThis = null;
                        throw e;
                    }
                    if (er < 0) {
                        clo.mObject = null;
                        clo.mObjThis = null;
                        emptyflag = true;
                    }
                    if (this.mExclusiveEventPosted) {
                        return;
                    }
                } else {
                    emptyflag = true;
                }
                ++i;
            }
            if (emptyflag) {
                count = this.mContinuousHandlerVector.size();
                i = count - 1;
                while (i >= 0) {
                    clo = this.mContinuousHandlerVector.get(i);
                    if (clo == null || clo.mObject == null) {
                        this.mContinuousHandlerVector.remove(i);
                    }
                    --i;
                }
            }
        }
        if (this.mContinuousEventVector.size() == 0 && this.mContinuousHandlerVector.size() == 0) {
            this.endContinuousEvent();
        }
    }

    public void deliverContinuousEvent() {
        block6: {
            if (this.mContinuousEventProcessing) {
                return;
            }
            this.mContinuousEventProcessing = true;
            try {
                try {
                    this.deliverContinuousEventInternal();
                }
                finally {
                    this.mContinuousEventProcessing = false;
                }
            }
            catch (TJSException e) {
                if (ScriptsClass.processUnhandledException(e)) break block6;
                ScriptsClass.showScriptException(e);
            }
        }
        this.mContinuousEventProcessing = false;
    }

    public void addContinuousHandler(VariantClosure clo) {
        boolean found = false;
        int count = this.mContinuousHandlerVector.size();
        int i = 0;
        while (i < count) {
            VariantClosure c = this.mContinuousHandlerVector.get(i);
            if (c != null && c.mObject == clo.mObject && c.mObjThis == clo.mObjThis) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.beginContinuousEvent();
            this.mContinuousHandlerVector.add(clo);
        }
    }

    public void removeContinuousHandler(VariantClosure clo) {
        int count = this.mContinuousHandlerVector.size();
        int i = 0;
        while (i < count) {
            VariantClosure c = this.mContinuousHandlerVector.get(i);
            if (c != null && c.mObject == clo.mObject && c.mObjThis == clo.mObjThis) {
                c.set(null, null);
                this.mContinuousHandlerVector.set(i, null);
                break;
            }
            ++i;
        }
    }

    public void addCompactEventHook(CompactEventCallbackInterface cb) {
        this.mCompactEventVector.add(cb);
    }

    public void removeCompactEventHook(CompactEventCallbackInterface cb) {
        int count = this.mCompactEventVector.size();
        int i = 0;
        while (i < count) {
            CompactEventCallbackInterface c = this.mCompactEventVector.get(i);
            if (c == cb) {
                this.mCompactEventVector.set(i, null);
            }
            ++i;
        }
    }

    public void deliverCompactEvent(int level) {
        int count = this.mCompactEventVector.size();
        if (count > 0) {
            boolean emptyflag = false;
            int i = 0;
            while (i < count) {
                block18: {
                    try {
                        try {
                            if (this.mCompactEventVector.get(i) != null) {
                                this.mCompactEventVector.get(i).onCompact(level);
                            } else {
                                emptyflag = true;
                            }
                        }
                        catch (TJSScriptException e) {
                            throw e;
                        }
                        catch (TJSScriptError e) {
                            throw e;
                        }
                        catch (TJSException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new TJSException(e.getMessage());
                        }
                    }
                    catch (TJSScriptException e) {
                        e.addTrace("Compact Event");
                        if (!ScriptsClass.processUnhandledException(e)) {
                            ScriptsClass.showScriptException(e);
                        }
                    }
                    catch (TJSScriptError e) {
                        e.addTrace("Compact Event");
                        if (!ScriptsClass.processUnhandledException(e)) {
                            ScriptsClass.showScriptException(e);
                        }
                    }
                    catch (TJSException e) {
                        if (ScriptsClass.processUnhandledException(e)) break block18;
                        ScriptsClass.showScriptException(e);
                    }
                }
                ++i;
            }
            if (emptyflag) {
                i = count - 1;
                while (i >= 0) {
                    if (this.mCompactEventVector.get(i) == null) {
                        this.mCompactEventVector.remove(i);
                    }
                    --i;
                }
            }
        }
    }

    private void invokeEvents() {
        if (this.mEventInvoked) {
            return;
        }
        this.mEventInvoked = true;
        if (TVP.MainForm != null) {
            TVP.MainForm.invokeEvents();
        }
    }

    public void eventReceived() {
        this.mEventInvoked = false;
        TVP.MainForm.notifyEventDelivered();
    }

    public void callDeliverAllEventsOnIdle() {
        if (TVP.MainForm != null) {
            TVP.MainForm.callDeliverAllEventsOnIdle();
        }
    }

    public void breathe() {
        this.mEventDisabled = true;
        this.mBreathing = true;
        this.mBreathing = false;
        this.mEventDisabled = false;
    }

    public boolean getBreathing() {
        return this.mBreathing;
    }

    void beginContinuousEvent() {
        if (this.mContinousHandlerLimitFrequency == 0 && TVP.MainForm != null) {
            TVP.MainForm.beginContinuousEvent();
        }
    }

    void endContinuousEvent() {
        if (TVP.MainForm != null) {
            TVP.MainForm.endContinuousEvent();
        }
    }

    public boolean isEventDisabled() {
        return this.mEventDisabled;
    }

    public void setProcessContinuousHandlerEventFlag(boolean b) {
        this.mProcessContinuousHandlerEventFlag = b;
    }
}

