/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.File;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.LocalFileStream;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.base.StorageLister;
import jp.kirikiri.tvp2.base.StorageMedia;
import jp.kirikiri.tvp2.msg.Message;

public class FileMedia
implements StorageMedia {
    private static final String SCHEME = "file";

    @Override
    public String getName() {
        return SCHEME;
    }

    @Override
    public String normalizeDomainName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    @Override
    public String normalizePathName(String name) {
        return name.toLowerCase();
    }

    @Override
    public boolean checkExistentStorage(String name) throws TJSException {
        if (name.length() == 0) {
            return false;
        }
        String _name = this.getLocalName(name);
        return Storage.checkExistentLocalFile(_name);
    }

    @Override
    public BinaryStream open(String name, int flags) throws TJSException {
        if (name == null | name.length() == 0) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", "\"\"");
        }
        String origname = name;
        String _name = this.getLocalName(name);
        return new LocalFileStream(origname, _name, flags);
    }

    @Override
    public void getListAt(String name, StorageLister lister) throws TJSException {
        String localName = this.getLocalName(name);
        File file = new File(localName);
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    lister.add(f.getName().toLowerCase());
                }
                ++n2;
            }
        }
    }

    @Override
    public String getLocallyAccessibleName(String name) {
        char ch3;
        char ch;
        StringBuilder newname = new StringBuilder(256);
        if (!name.startsWith("./")) {
            newname.append(File.separatorChar);
            if (File.separatorChar == '\\') {
                newname.append(File.separatorChar);
            }
            newname.append(name);
        } else if (name.length() != 2 && (ch = name.charAt(2)) >= 'a' && ch <= 'z' && (ch3 = name.charAt(3)) == '/') {
            newname.append(ch);
            newname.append(':');
            newname.append(name.substring(3));
        }
        if (newname.length() == 0) {
            if (File.separatorChar == '/') {
                newname.append(name);
            } else {
                return null;
            }
        }
        char replaceCh = '\\';
        if (File.separatorChar == '\\') {
            replaceCh = '/';
        }
        String pp = newname.toString();
        return pp.replace(replaceCh, File.separatorChar);
    }

    public String getLocalName(String name) throws TJSException {
        String tmp = this.getLocallyAccessibleName(name);
        if (tmp == null | tmp.length() == 0) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8\u540d %1 \u3092\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u3084\u3001\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u3067\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u306f\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002", name);
        }
        return tmp;
    }

    @Override
    public String getDefaultDomain() {
        if (File.separatorChar == '\\') {
            return ".";
        }
        return null;
    }
}

