/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.BinaryInputStream;
import jp.kirikiri.tvp2.base.BinaryOutputStream;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.Random;

public class LocalFileStream
extends BinaryStream {
    private RandomAccessFile mRandomAccessFile;
    private FileChannel mFilcChannel;
    private String mFilePath;

    public LocalFileStream(String origname, String localname, int flag) throws TJSException {
        this.mFilePath = origname;
        try {
            File file = Storage.getCaseInsensitiveFile(localname);
            int access = flag & 0xF;
            switch (access) {
                case 0: {
                    this.mRandomAccessFile = new RandomAccessFile(file, "r");
                    this.mFilcChannel = this.mRandomAccessFile.getChannel();
                    break;
                }
                case 1: {
                    File parent = file.getParentFile();
                    if (file.exists() && file.isFile()) {
                        file.delete();
                    }
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.mRandomAccessFile = new RandomAccessFile(file, "rws");
                    this.mFilcChannel = this.mRandomAccessFile.getChannel();
                    break;
                }
                case 2: {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.mRandomAccessFile = new RandomAccessFile(file, "rws");
                    this.mFilcChannel = this.mRandomAccessFile.getChannel();
                    break;
                }
                case 3: {
                    if (!file.exists()) {
                        Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", origname);
                    }
                    this.mRandomAccessFile = new RandomAccessFile(file, "rws");
                    this.mFilcChannel = this.mRandomAccessFile.getChannel();
                }
            }
            if (access == 2) {
                this.mFilcChannel.position(this.mFilcChannel.size());
            }
        }
        catch (FileNotFoundException e) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", origname);
        }
        catch (IOException e) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", origname);
        }
        Random.updateEnvironNoiseForTick();
    }

    protected void finalize() {
        if (this.mRandomAccessFile != null) {
            this.close();
        }
    }

    @Override
    public long seek(long offset, int whence) throws TJSException {
        try {
            if (offset == 0L) {
                return this.mFilcChannel.position();
            }
            switch (whence) {
                case 0: {
                    this.mFilcChannel.position(offset);
                    break;
                }
                case 1: {
                    this.mFilcChannel.position(this.mFilcChannel.position() + offset);
                    break;
                }
                case 2: {
                    this.mFilcChannel.position(this.mFilcChannel.size() + offset);
                }
            }
            return this.mFilcChannel.position();
        }
        catch (IOException e) {
            throw new TJSException("\u30b7\u30fc\u30af\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
    }

    @Override
    public int read(ByteBuffer buffer) {
        try {
            return this.mFilcChannel.read(buffer);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public int write(ByteBuffer buffer) {
        try {
            return this.mFilcChannel.write(buffer);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public long getPosition() {
        try {
            return this.mFilcChannel.position();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public void setPosition(long pos) throws TJSException {
        try {
            this.mFilcChannel.position(pos);
        }
        catch (IOException e) {
            throw new TJSException("\u30b7\u30fc\u30af\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
    }

    @Override
    public void close() {
        if (this.mRandomAccessFile == null) {
            return;
        }
        try {
            this.mRandomAccessFile.close();
            this.mRandomAccessFile = null;
            this.mFilcChannel = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setEndOfStorage() throws TJSException {
        Message.throwExceptionMessage("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059");
    }

    @Override
    public long getSize() {
        try {
            return this.mFilcChannel.size();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    FileChannel getHandle() {
        return this.mFilcChannel;
    }

    @Override
    public int read(byte[] buffer) {
        try {
            return this.mRandomAccessFile.read(buffer);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            return this.mRandomAccessFile.read(b, off, len);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public int write(byte[] buffer) {
        try {
            long pos = this.mRandomAccessFile.getFilePointer();
            this.mRandomAccessFile.write(buffer);
            return (int)(this.mRandomAccessFile.getFilePointer() - pos);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            this.mRandomAccessFile.write(b, off, len);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) {
        try {
            this.mRandomAccessFile.writeByte(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InputStream getInputStream() {
        return new BinaryInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() {
        return new BinaryOutputStream(this);
    }

    @Override
    public String getFilePath() {
        return this.mFilePath;
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        try {
            return this.mRandomAccessFile.getFD();
        }
        catch (IOException e) {
            return null;
        }
    }
}

