/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.LexBase;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Archive;
import jp.kirikiri.tvp2.msg.Message;

public class Storage {
    public static final char ArchiveDelimiter = '>';
    private static Inflater Decompresser;

    public static final void initialize() {
        Decompresser = null;
    }

    public static void finalizeApplication() {
        Decompresser = null;
    }

    public static boolean checkExistentLocalFile(String name) {
        File file = Storage.getCaseInsensitiveFile(name);
        if (file.exists() && file.isFile()) {
            return true;
        }
        file = null;
        return false;
    }

    public static File getCaseInsensitiveFile(String name) {
        if (File.separatorChar == '/') {
            File fistcheck = new File(name);
            if (fistcheck.exists()) {
                return fistcheck;
            }
            String[] path = name.split("/");
            int preLength = 0;
            int count = path.length;
            StringBuilder fullPath = new StringBuilder(name.length());
            int i = 0;
            while (i < count) {
                if (path[i] != null && path[i].length() > 0) {
                    boolean isFile = i == count - 1;
                    fullPath.append('/');
                    fullPath.append(path[i]);
                    File tmp = new File(fullPath.toString());
                    if (!tmp.exists()) {
                        String filename;
                        int j;
                        boolean isfound = false;
                        fullPath.delete(preLength, fullPath.length());
                        if (fullPath.length() == 0) {
                            fullPath.append('/');
                        }
                        String fullpathstr = fullPath.toString();
                        tmp = new File(fullpathstr);
                        File[] files = tmp.listFiles();
                        int filecount = files.length;
                        if (!isFile) {
                            j = 0;
                            while (j < filecount) {
                                if (files[j].isDirectory() && (filename = files[j].getName()).equalsIgnoreCase(path[i])) {
                                    if (fullPath.length() != 1) {
                                        fullPath.append('/');
                                        fullPath.append(filename);
                                    } else {
                                        fullPath.append(filename);
                                    }
                                    isfound = true;
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < filecount) {
                                if (files[j].isFile() && (filename = files[j].getName()).equalsIgnoreCase(path[i])) {
                                    if (fullPath.length() != 1) {
                                        fullPath.append('/');
                                        fullPath.append(filename);
                                    } else {
                                        fullPath.append(filename);
                                    }
                                    isfound = true;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (!isfound) {
                            while (i < count) {
                                fullPath.append('/');
                                fullPath.append(path[i]);
                                ++i;
                            }
                            return new File(fullPath.toString());
                        }
                    }
                }
                preLength = fullPath.length();
                ++i;
            }
            return new File(fullPath.toString());
        }
        return new File(name);
    }

    public static String extractStorageExt(String name) {
        int slen = name.length();
        int p = slen - 1;
        while (p >= 0) {
            char c = name.charAt(p);
            if (c == '\\' || c == '/' || c == '>') break;
            if (c == '.') {
                return name.substring(p);
            }
            --p;
        }
        return new String();
    }

    public static String extractStorageName(String name) {
        int slen = name.length();
        int p = slen - 1;
        while (p >= 0) {
            char c = name.charAt(p);
            if (c == '\\' || c == '/' || c == '>') break;
            --p;
        }
        if (++p <= 0) {
            return name;
        }
        return name.substring(p);
    }

    public static String extractStoragePath(String name) {
        int slen;
        int p = slen = name.length();
        --p;
        while (p >= 0) {
            char c = name.charAt(p);
            if (c == '\\' || c == '/' || c == '>') break;
            --p;
        }
        return name.substring(0, ++p);
    }

    public static String chopStorageExt(String name) {
        int slen;
        int p = slen = name.length();
        --p;
        while (p >= 0) {
            char c = name.charAt(p);
            if (c == '\\' || c == '/' || c == '>') break;
            if (c == '.') {
                return name.substring(0, p);
            }
            --p;
        }
        return name;
    }

    public static String searchPlacedPath(String name) throws TJSException {
        String place = Storage.getPlacedPath(name);
        if (place == null || place.length() == 0) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", name);
        }
        return place;
    }

    public static String getPlacedPath(String name) throws TJSException {
        return TVP.AutoPath.getPlacedPath(name);
    }

    public static boolean isExistentStorage(String name) throws TJSException {
        String path = TVP.AutoPath.getPlacedPath(name);
        return path != null && path.length() > 0;
    }

    public static boolean isExistentStorageNoSearch(String name) throws TJSException {
        return Storage.isExistentStorageNoSearchNoNormalize(TVP.StorageMediaManager.normalizeStorageName(name, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistentStorageNoSearchNoNormalize(String name) throws TJSException {
        Object object = TVP.CreateStreamCS;
        synchronized (object) {
            int sharp_pos = name.indexOf(62);
            if (sharp_pos != -1) {
                boolean ret;
                String arcname = name.substring(0, sharp_pos);
                Archive arc = TVP.ArchiveCache.get(arcname);
                try {
                    String in_arc_name = name.substring(sharp_pos + 1);
                    in_arc_name = Archive.normalizeInArchiveStorageName(in_arc_name);
                    ret = arc.isExistent(in_arc_name);
                }
                finally {
                    arc = null;
                }
                return ret;
            }
            return TVP.StorageMediaManager.checkExistentStorage(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryStream createStream(String _name, int flags) throws TJSException {
        try {
            Object object = TVP.CreateStreamCS;
            synchronized (object) {
                BinaryStream stream;
                int sharp_pos;
                int access = flags & 0xF;
                String name = access == 1 ? TVP.StorageMediaManager.normalizeStorageName(_name, null) : TVP.AutoPath.getPlacedPath(_name);
                if (name == null || name.length() == 0) {
                    Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", _name);
                }
                if ((sharp_pos = name.indexOf(62)) != -1) {
                    BinaryStream stream2;
                    if (access != 0) {
                        Message.throwExceptionMessage("\u30a2\u30fc\u30ab\u30a4\u30d6\u306b\u30c7\u30fc\u30bf\u3092\u66f8\u304d\u8fbc\u3080\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
                    }
                    String arcname = name.substring(0, sharp_pos);
                    Archive arc = TVP.ArchiveCache.get(arcname);
                    try {
                        String in_arc_name = name.substring(sharp_pos + 1);
                        in_arc_name = Archive.normalizeInArchiveStorageName(in_arc_name);
                        stream2 = arc.createStream(in_arc_name);
                    }
                    finally {
                        arc = null;
                        if (access >= 1) {
                            Storage.clearStorageCaches();
                        }
                    }
                    return stream2;
                }
                try {
                    stream = TVP.StorageMediaManager.open(name, flags);
                }
                finally {
                    if (access >= 1) {
                        Storage.clearStorageCaches();
                    }
                }
                return stream;
            }
        }
        catch (TJSException e) {
            if (_name.indexOf(35) != -1) {
                String tmp = "(\u6ce8\u610f) '#' \u304c\u30d5\u30a1\u30a4\u30eb\u540d \"%1\" \u306b\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u533a\u5207\u308a\u6587\u5b57\u306f\u5409\u91cc\u5409\u91cc\uff12 2.19 beta 14 \u3088\u308a'#' \u304b\u3089 '>' \u306b\u5909\u308f\u308a\u307e\u3057\u305f\u3002\u3082\u3057\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u533a\u5207\u308a\u6587\u5b57\u306e\u3064\u3082\u308a\u3067 '#' \u3092\u4f7f\u7528\u3057\u305f\u5834\u5408\u306f\u3001\u304a\u624b\u6570\u3067\u3059\u304c '>' \u306b\u5909\u3048\u3066\u304f\u3060\u3055\u3044".replace("%1", _name);
                StringBuilder builder = new StringBuilder(128);
                builder.append(e.getMessage());
                builder.append('[');
                builder.append(tmp);
                builder.append(']');
                throw new TJSException(builder.toString());
            }
            throw e;
        }
    }

    public static void clearStorageCaches() {
        TVP.AutoPath.clearAutoPathCache();
    }

    public static void setCurrentDirectory(String _name) throws TJSException {
        TVP.StorageMediaManager.setCurrentDirectory(_name);
        Storage.clearStorageCaches();
    }

    public static String readText(String name, String modestr) throws TJSException {
        BinaryStream stream = null;
        stream = Storage.createStream(name, 0);
        return Storage.readText(stream, name, modestr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readText(BinaryStream stream, String name, String modestr) throws TJSException {
        long size;
        try {
            block32: {
                String encodeType;
                block29: {
                    int ofs;
                    block30: {
                        int CryptMode;
                        block31: {
                            byte[] mark;
                            block28: {
                                encodeType = null;
                                CryptMode = -1;
                                int o_ofs = -1;
                                if (modestr != null) {
                                    o_ofs = modestr.indexOf(111);
                                }
                                ofs = 0;
                                if (o_ofs != -1) {
                                    char ch;
                                    StringBuilder builder = new StringBuilder(256);
                                    int i = o_ofs + 1;
                                    int count = modestr.length();
                                    while (i < count && (ch = modestr.charAt(i)) >= '0' && ch <= '9') {
                                        builder.append(ch);
                                        ++i;
                                    }
                                    LexBase lex = new LexBase(builder.toString());
                                    Number num = lex.parseNumber();
                                    if (num != null) {
                                        ofs = num.intValue();
                                        stream.setPosition(ofs);
                                    }
                                }
                                mark = new byte[2];
                                stream.read(mark);
                                if (mark[0] != -1 || mark[1] != -2) break block28;
                                encodeType = "UTF-16LE";
                                break block29;
                            }
                            if (mark[0] != -2 || mark[1] != -2) break block30;
                            byte[] mode = new byte[1];
                            stream.read(mode);
                            int m0 = mode[0];
                            if (m0 != 0 && m0 != 1 && m0 != 2) {
                                Message.throwExceptionMessage("%1 \u306f\u672a\u5bfe\u5fdc\u306e\u6697\u53f7\u5316\u5f62\u5f0f\u304b\u3001\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059", name);
                            }
                            CryptMode = m0;
                            stream.read(mark);
                            if (mark[0] != -1 || mark[1] != -2) {
                                Message.throwExceptionMessage("%1 \u306f\u672a\u5bfe\u5fdc\u306e\u6697\u53f7\u5316\u5f62\u5f0f\u304b\u3001\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059", name);
                            }
                            if (CryptMode != 2) break block31;
                            byte[] compress = new byte[16];
                            stream.read(compress);
                            ByteBuffer bytebuf = ByteBuffer.wrap(compress);
                            bytebuf.order(ByteOrder.LITTLE_ENDIAN);
                            long compressed = bytebuf.getLong();
                            long uncopressed = bytebuf.getLong();
                            if (compressed > Integer.MAX_VALUE || uncopressed > Integer.MAX_VALUE) {
                                Message.throwExceptionMessage("%1 \u306f\u672a\u5bfe\u5fdc\u306e\u6697\u53f7\u5316\u5f62\u5f0f\u304b\u3001\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059", name);
                            }
                            byte[] nbuf = new byte[(int)compressed];
                            stream.read(nbuf);
                            byte[] output = new byte[(int)uncopressed];
                            if (Decompresser == null) {
                                Decompresser = new Inflater();
                            }
                            try {
                                String result;
                                Decompresser.setInput(nbuf);
                                int destlen = Decompresser.inflate(output);
                                Decompresser.reset();
                                if ((long)destlen != uncopressed) {
                                    Message.throwExceptionMessage("%1 \u306f\u672a\u5bfe\u5fdc\u306e\u6697\u53f7\u5316\u5f62\u5f0f\u304b\u3001\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059");
                                }
                                ByteBuffer strbuf = ByteBuffer.wrap(output);
                                strbuf.order(ByteOrder.LITTLE_ENDIAN);
                                CharBuffer cbuff = strbuf.asCharBuffer();
                                String string = result = cbuff.subSequence(0, (int)(uncopressed / 2L)).toString();
                                return string;
                            }
                            catch (DataFormatException e) {
                                Decompresser.reset();
                                Message.throwExceptionMessage("%1 \u306f\u672a\u5bfe\u5fdc\u306e\u6697\u53f7\u5316\u5f62\u5f0f\u304b\u3001\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059");
                            }
                            break block29;
                        }
                        if (CryptMode != 1) {
                            long size2 = stream.getSize() - stream.getPosition();
                            byte[] output = new byte[(int)size2];
                            stream.read(output);
                            ByteBuffer strbuf = ByteBuffer.wrap(output);
                            strbuf.order(ByteOrder.LITTLE_ENDIAN);
                            CharBuffer cbuff = strbuf.asCharBuffer();
                            int len = (int)(size2 / 2L);
                            int i = 0;
                            while (true) {
                                if (i >= len) {
                                    String result;
                                    String string = result = cbuff.subSequence(0, len).toString();
                                    return string;
                                }
                                char ch = cbuff.get(i);
                                if (ch >= ' ') {
                                    ch = (char)((ch ^ ((ch & 0xFE) << 8 ^ 1)) & 0xFFFF);
                                    cbuff.put(i, ch);
                                }
                                ++i;
                            }
                        }
                        break block32;
                    }
                    stream.setPosition(ofs);
                    encodeType = "MS932";
                }
                if (encodeType == null) return null;
                long size3 = stream.getSize();
                byte[] buf = new byte[(int)size3];
                int readSize = stream.read(buf);
                if (readSize <= 0) return null;
                if ("UTF-16LE".equals(encodeType)) {
                    String result;
                    ByteBuffer strbuf = ByteBuffer.wrap(buf);
                    strbuf.order(ByteOrder.LITTLE_ENDIAN);
                    CharBuffer cbuff = strbuf.asCharBuffer();
                    int len = readSize / 2;
                    String string = result = cbuff.subSequence(0, len).toString();
                    return string;
                }
                String result = new String(buf, 0, readSize, encodeType);
                buf = null;
                String string = result;
                return string;
            }
            size = stream.getSize() - stream.getPosition();
        }
        catch (IOException e) {
            throw new TJSException("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059" + e.toString());
        }
        byte[] output = new byte[(int)size];
        stream.read(output);
        ByteBuffer strbuf = ByteBuffer.wrap(output);
        strbuf.order(ByteOrder.LITTLE_ENDIAN);
        CharBuffer cbuff = strbuf.asCharBuffer();
        int len = (int)(size / 2L);
        int i = 0;
        while (true) {
            if (i >= len) {
                String result = cbuff.subSequence(0, len).toString();
                return result;
            }
            char ch = cbuff.get(i);
            ch = (char)((ch & 0xAAAAAAAA) >>> 1 | (ch & 0x55555555) << 1);
            cbuff.put(i, ch);
            ++i;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static boolean checkExistentLocalFolder(String name) {
        File file = new File(name);
        return file.exists() && file.isDirectory();
    }

    public static boolean createFolders(String name) {
        File newdir = new File(name);
        return newdir.mkdir();
    }
}

