/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2env.FileSelector;

public class StorageClass
extends NativeClass {
    static int mClassID = -1;
    private static final String CLASS_NAME = "Storage";

    public StorageClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        mClassID = NCM_CLASSID;
        this.registerNCM("finalize", TVP.ReturnOKMethod, CLASS_NAME, 1, 0);
        this.registerNCM("addAutoPath", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                TVP.AutoPath.addAutoPath(path);
                if (result != null) {
                    result.clear();
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("removeAutoPath", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                TVP.AutoPath.removeAutoPath(path);
                if (result != null) {
                    result.clear();
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("getFullPath", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(TVP.StorageMediaManager.normalizeStorageName(path, null));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("getPlacedPath", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(Storage.getPlacedPath(path));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("isExistentStorage", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(Storage.isExistentStorage(path) ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("extractStorageExt", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(Storage.extractStorageExt(path));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("extractStorageName", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(Storage.extractStorageName(path));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("extractStoragePath", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(Storage.extractStoragePath(path));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("chopStorageExt", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    result.set(Storage.chopStorageExt(path));
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("clearArchiveCache", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                TVP.ArchiveCache.clear();
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("searchCD", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    result.set(0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("getLocalName", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                String path = param[0].asString();
                if (result != null) {
                    String str = TVP.StorageMediaManager.normalizeStorageName(path, null);
                    str = TVP.StorageMediaManager.getLocalName(str);
                    result.set(str);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("selectFile", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
                if (param.length < 1) {
                    return -1004;
                }
                Dispatch2 dsp = param[0].asObject();
                boolean res = FileSelector.selectFile(dsp);
                if (result != null) {
                    result.set(res ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
    }
}

