/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.HashMap;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Archive;
import jp.kirikiri.tvp2.base.StorageLister;
import jp.kirikiri.tvp2.base.StorageMedia;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2env.ApplicationSystem;

public class StorageMediaManager {
    private static String CurrentMedia;
    private static StringBuilder mBuilder;
    private HashMap<String, MediaRecord> mHashTable = new HashMap();

    public static void initialize() {
        CurrentMedia = null;
        mBuilder = new StringBuilder(256);
    }

    public static void finalizeApplication() {
        CurrentMedia = null;
        mBuilder = null;
    }

    public StorageMediaManager() throws TJSException {
        ((ApplicationSystem)TVP.Application.get()).registerFileMedia(this);
    }

    private static void throwUnsupportedMediaType(String name) throws TJSException {
        Message.throwExceptionMessage("\"%1\" \u306f\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u30e1\u30c7\u30a3\u30a2\u30bf\u30a4\u30d7\u3067\u3059", StorageMediaManager.extractMediaName(name));
    }

    private MediaRecord getMediaRecord(String name) throws TJSException {
        String media = StorageMediaManager.extractMediaName(name);
        MediaRecord rec = this.mHashTable.get(media);
        if (rec == null) {
            StorageMediaManager.throwUnsupportedMediaType(name);
        }
        return rec;
    }

    public void register(StorageMedia media) throws TJSException {
        String medianame = media.getName();
        MediaRecord rec = this.mHashTable.get(medianame);
        if (rec != null) {
            Message.throwExceptionMessage("Media name \"" + medianame + "\" had already been registered");
        }
        MediaRecord new_rec = new MediaRecord(media);
        this.mHashTable.put(medianame, new_rec);
    }

    public void Unregister(StorageMedia media) throws TJSException {
        String medianame = media.getName();
        MediaRecord rec = this.mHashTable.get(medianame);
        if (rec == null) {
            Message.throwExceptionMessage("Media name \"" + medianame + "\" is not registered");
        }
        this.mHashTable.remove(medianame);
    }

    public static String preNormalizeStorageName(String name) {
        char c0;
        int namelen = name.length();
        if (namelen == 0) {
            return name;
        }
        if (namelen >= 2 && ((c0 = name.charAt(0)) >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z') && name.charAt(1) == ':') {
            mBuilder.delete(0, mBuilder.length());
            StringBuilder builder = mBuilder;
            builder.append("file://./");
            builder.append(c0);
            builder.append(name.substring(2));
            return builder.toString();
        }
        if (namelen >= 3) {
            c0 = name.charAt(0);
            char c1 = name.charAt(1);
            if (c0 == '\\' && c1 == '\\' || c0 == '/' && c1 == '/') {
                mBuilder.delete(0, mBuilder.length());
                StringBuilder builder = mBuilder;
                builder.append("file:");
                builder.append(name);
                return builder.toString();
            }
        }
        return name;
    }

    public String normalizeStorageName(String name, MediaData ret_media) throws TJSException {
        if (name == null || name.length() == 0) {
            return name;
        }
        String tmp = StorageMediaManager.preNormalizeStorageName(name);
        tmp = tmp.replace('\\', '/');
        mBuilder.delete(0, mBuilder.length());
        StringBuilder builder = mBuilder;
        String inarchive_name = null;
        boolean inarc_name_found = false;
        int pa = tmp.indexOf(62);
        if (pa != -1) {
            inarchive_name = tmp.substring(pa + 1);
            inarchive_name = Archive.normalizeInArchiveStorageName(inarchive_name);
            inarc_name_found = true;
            tmp = tmp.substring(0, pa);
        }
        if (tmp.length() == 0) {
            Message.throwExceptionMessage("\u30d1\u30b9\u540d %1 \u306f\u7121\u52b9\u306a\u5f62\u5f0f\u3067\u3059\u3002\u5f62\u5f0f\u304c\u6b63\u3057\u3044\u304b\u3069\u3046\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", name);
        }
        String media = null;
        String domain = null;
        String path = null;
        int length = tmp.length();
        int i = 0;
        while (i < length) {
            char c = tmp.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) break;
            ++i;
        }
        if (i < length && tmp.charAt(i) == ':') {
            media = tmp.substring(0, i);
            ++i;
        } else {
            i = 0;
        }
        if (tmp.charAt(i) == '/' && tmp.charAt(i + 1) == '/') {
            if (tmp.charAt(i + 2) == '/') {
                i += 2;
            } else {
                int pc = tmp.indexOf(47, i += 2);
                if (pc == -1) {
                    Message.throwExceptionMessage("\u30d1\u30b9\u540d %1 \u306f\u7121\u52b9\u306a\u5f62\u5f0f\u3067\u3059\u3002\u5f62\u5f0f\u304c\u6b63\u3057\u3044\u304b\u3069\u3046\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", name);
                }
                domain = tmp.substring(i, pc);
                i = pc;
            }
        }
        path = tmp.substring(i);
        media = media == null || media.length() == 0 ? CurrentMedia : media.toLowerCase();
        MediaRecord mediarec = this.getMediaRecord(media);
        if (domain == null || domain.length() == 0) {
            domain = mediarec.CurrentDomain != null ? new String(mediarec.CurrentDomain) : "";
        }
        domain = mediarec.MediaIntf.normalizeDomainName(domain);
        if (path == null || path.length() == 0) {
            path = "/";
        } else if (path.charAt(0) != '/') {
            builder.append(mediarec.CurrentPath);
            builder.append(path);
            path = builder.toString();
            builder.delete(0, builder.length());
        }
        path = mediarec.MediaIntf.normalizePathName(path);
        if (inarc_name_found) {
            builder.append(path);
            builder.append('>');
            if (inarchive_name != null) {
                builder.append(inarchive_name);
            }
            path = builder.toString();
            builder.delete(0, builder.length());
        }
        pa = 0;
        int pb = 0;
        int pc = 0;
        int dot_count = -1;
        char[] pathArray = path.toCharArray();
        int pathLen = pathArray.length;
        while (pa < pathLen) {
            char ca = pathArray[pa];
            if (ca == '>' || ca == '/' || ca == '\u0000') {
                char delim = '\u0000';
                if (ca != '\u0000' && dot_count == 0) {
                    --pb;
                } else if (dot_count > 0) {
                    --pb;
                    while (pb >= pc) {
                        char cb = pathArray[pb];
                        if (cb == '/' || cb == '>') {
                            if (--dot_count == 0) {
                                delim = cb;
                                break;
                            }
                            if (cb == '>') {
                                Message.throwExceptionMessage("\u30d1\u30b9\u540d %1 \u306f\u7121\u52b9\u306a\u5f62\u5f0f\u3067\u3059\u3002\u5f62\u5f0f\u304c\u6b63\u3057\u3044\u304b\u3069\u3046\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", name);
                            }
                        }
                        --pb;
                    }
                    if (pb < pc) {
                        Message.throwExceptionMessage("\u30d1\u30b9\u540d %1 \u306f\u7121\u52b9\u306a\u5f62\u5f0f\u3067\u3059\u3002\u5f62\u5f0f\u304c\u6b63\u3057\u3044\u304b\u3069\u3046\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", name);
                    }
                }
                pathArray[pb] = delim == '\u0000' ? ca : delim;
                if (ca == '\u0000') break;
                ++pb;
                ++pa;
                dot_count = 0;
                continue;
            }
            if (ca == '.') {
                pathArray[pb] = ca;
                ++pb;
                ++pa;
                if (dot_count == -1) continue;
                ++dot_count;
                continue;
            }
            pathArray[pb] = ca;
            ++pb;
            ++pa;
            dot_count = -1;
        }
        int l = 0;
        while (l < pathLen) {
            if (pathArray[l] == '\u0000') break;
            ++l;
        }
        path = new String(pathArray, 0, l);
        if (ret_media != null) {
            ret_media.media = media;
            ret_media.domain = domain;
            ret_media.path = path;
        }
        builder.append(media);
        builder.append("://");
        builder.append(domain);
        builder.append(path);
        return builder.toString();
    }

    public void setCurrentDirectory(String name) throws TJSException {
        char ch = name.charAt(name.length() - 1);
        if (ch != '/' && ch != '\\' && ch != '>') {
            Message.throwExceptionMessage("\u30d1\u30b9\u540d\u306e\u6700\u5f8c\u306b\u306f '>' \u307e\u305f\u306f '/' \u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044 (\u5409\u91cc\u5409\u91cc\uff12 2.19 beta 14 \u3088\u308a\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u533a\u5207\u308a\u8a18\u53f7\u304c '#' \u304b\u3089 '>' \u306b\u5909\u308f\u308a\u307e\u3057\u305f)");
        }
        MediaData data = new MediaData();
        this.normalizeStorageName(name, data);
        MediaRecord rec = this.getMediaRecord(data.media);
        rec.CurrentDomain = data.domain;
        rec.CurrentPath = data.path;
        CurrentMedia = data.media;
    }

    public void setCurrentMediaName(String name) {
        CurrentMedia = name;
    }

    public static String extractMediaName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf(58);
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return new String(name);
    }

    public boolean checkExistentStorage(String name) throws TJSException {
        MediaRecord rec = this.getMediaRecord(name);
        return rec.MediaIntf.checkExistentStorage(rec.getDomainAndPath(name));
    }

    public BinaryStream open(String name, int flags) throws TJSException {
        MediaRecord rec = this.getMediaRecord(name);
        return rec.MediaIntf.open(rec.getDomainAndPath(name), flags);
    }

    public void getListAt(String name, StorageLister lister) throws TJSException {
        MediaRecord rec = this.getMediaRecord(name);
        rec.MediaIntf.getListAt(rec.getDomainAndPath(name), lister);
    }

    public String getLocallyAccessibleName(String name) throws TJSException {
        MediaRecord rec = this.getMediaRecord(name);
        String dname = rec.getDomainAndPath(name);
        return rec.MediaIntf.getLocallyAccessibleName(dname);
    }

    public String getLocalName(String name) throws TJSException {
        String tmp = this.getLocallyAccessibleName(name);
        if (tmp == null || tmp.length() == 0) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8\u540d %1 \u3092\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u3084\u3001\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u3067\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u306f\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002", name);
        }
        return tmp;
    }

    static class MediaData {
        public String media;
        public String domain;
        public String path;

        MediaData() {
        }
    }

    static class MediaRecord {
        public String CurrentDomain;
        public String CurrentPath;
        public StorageMedia MediaIntf;
        public int MediaNameLen;

        public MediaRecord(StorageMedia media) {
            this.MediaIntf = media;
            this.CurrentDomain = media.getDefaultDomain();
            this.CurrentPath = "/";
            String name = media.getName();
            this.MediaNameLen = name.length();
        }

        String getDomainAndPath(String name) {
            return name.substring(this.MediaNameLen + 3);
        }
    }
}

