/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.TVPSystem;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.Random;
import jp.kirikiri.tvp2.visual.GraphicsLoader;
import jp.kirikiri.tvp2.visual.LayerNI;
import jp.kirikiri.tvp2env.ApplicationSystem;

public class SystemClass
extends NativeClass {
    public static int mClassID = -1;
    private static final String CLASS_NAME = "System";

    @Override
    protected NativeInstance createNativeInstance() throws TJSException {
        Message.throwExceptionMessage("\u3053\u306e\u30af\u30e9\u30b9\u306f\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093");
        return null;
    }

    public SystemClass() throws VariantException, TJSException {
        super(CLASS_NAME);
        int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
        this.setClassID(NCM_CLASSID);
        mClassID = NCM_CLASSID;
        this.registerNCM(CLASS_NAME, TVP.ReturnOKConstructor, CLASS_NAME, 1, 0);
        this.registerNCM("finalize", TVP.ReturnOKMethod, CLASS_NAME, 1, 0);
        this.registerNCM("terminate", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                int code = param.length > 0 ? param[0].asInteger() : 0;
                ((ApplicationSystem)TVP.Application.get()).terminateAsync(code);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("exit", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                int code = param.length > 0 ? param[0].asInteger() : 0;
                ((ApplicationSystem)TVP.Application.get()).terminateSync(code);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("inputString", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 3) {
                    return -1004;
                }
                String value = param[2].asString();
                String b = ((ApplicationSystem)TVP.Application.get()).InputQuery(param[0].asString(), param[1].asString(), value);
                if (result != null) {
                    if (b != null) {
                        result.set(b);
                    } else {
                        result.clear();
                    }
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("addContinuousHandler", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                VariantClosure clo = param[0].asObjectClosure();
                TVP.EventManager.addContinuousHandler(clo);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("removeContinuousHandler", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                VariantClosure clo = param[0].asObjectClosure();
                TVP.EventManager.removeContinuousHandler(clo);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("toActualColor", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result != null) {
                    int color = param[0].asInteger();
                    color = LayerNI.toActualColor(color);
                    result.set(color);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("clearGraphicCache", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                GraphicsLoader.clearGraphicCache();
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("touchImages", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
                int hr;
                if (param.length < 1) {
                    return -1004;
                }
                ArrayList<String> storages = new ArrayList<String>();
                VariantClosure array = param[0].asObjectClosure();
                int count = 0;
                Variant val = new Variant();
                while ((hr = array.mObject.propGetByNum(0, count, val, array.mObjThis)) >= 0 && !val.isVoid()) {
                    storages.add(val.asString());
                    ++count;
                }
                int limit = 0;
                long timeout = 0L;
                if (param.length >= 2 && !param[1].isVoid()) {
                    limit = param[1].asInteger();
                }
                if (param.length >= 3 && !param[2].isVoid()) {
                    timeout = param[1].asInteger();
                }
                GraphicsLoader.touchImages(storages, limit, timeout);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("createUUID", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                byte[] uuid = new byte[16];
                Random.getRandomBits128(uuid);
                uuid[8] = (byte)(uuid[8] & 0x3F);
                uuid[8] = (byte)(uuid[8] | 0x80);
                uuid[6] = (byte)(uuid[6] & 0xF);
                uuid[6] = (byte)(uuid[6] | 0x40);
                String buf = String.format("%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x", uuid[0], uuid[1], uuid[2], uuid[3], uuid[4], uuid[5], uuid[6], uuid[7], uuid[8], uuid[9], uuid[10], uuid[11], uuid[12], uuid[13], uuid[14], uuid[15]);
                if (result != null) {
                    result.set(buf);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("assignMessage", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 2) {
                    return -1004;
                }
                String id = param[0].asString();
                String msg = param[1].asString();
                boolean res = TJS.assignMessage(id, msg);
                if (result != null) {
                    result.set(res ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("doCompact", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                int level = 100;
                if (param.length >= 1 && !param[0].isVoid()) {
                    level = param[0].asInteger();
                }
                TVP.EventManager.deliverCompactEvent(level);
                System.gc();
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("inform", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String text = param[0].asString();
                String caption = param.length >= 2 && !param[1].isVoid() ? param[1].asString() : "Information";
                ((ApplicationSystem)TVP.Application.get()).showSimpleMessageBox(text, caption);
                if (result != null) {
                    result.clear();
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("getTickCount", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                if (result != null) {
                    result.set(TVP.getTickCount());
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("getKeyState", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                int code = param[0].asInteger();
                boolean res = TVP.isKeyPressing(code);
                if (result != null) {
                    result.set(res ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("shellExecute", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String target = param[0].asString();
                String execparam = null;
                if (param.length >= 2) {
                    execparam = param[1].asString();
                }
                boolean res = ApplicationSystem.shellExecute(target, execparam);
                if (result != null) {
                    result.set(res ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("system", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String target = param[0].asString();
                boolean res = ApplicationSystem.shellExecute(target, null);
                TVP.EventManager.deliverCompactEvent(100);
                if (result != null) {
                    result.set(res ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("readRegValue", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result == null) {
                    return 0;
                }
                String key = param[0].asString();
                result.set(ApplicationSystem.readRegValue(key));
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("getArgument", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result == null) {
                    return 0;
                }
                String name = param[0].asString();
                String res = ApplicationSystem.getProperty(name);
                result.set(res);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("setArgument", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 2) {
                    return -1004;
                }
                String name = param[0].asString();
                String value = param[1].asString();
                ApplicationSystem.setProperty(name, value);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("createAppLock", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                if (result == null) {
                    return 0;
                }
                String lockname = param[0].asString();
                boolean res = ApplicationSystem.createAppLock(lockname);
                result.set(res ? 1 : 0);
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("nullpo", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
                throw new NullPointerException();
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("confirmYesNo", new NativeClassMethod(){

            @Override
            protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
                if (param.length < 1) {
                    return -1004;
                }
                String text = param[0].asString();
                String caption = param.length >= 2 && !param[1].isVoid() ? param[1].asString() : "Confirm";
                boolean ret = ((ApplicationSystem)TVP.Application.get()).showYesNoDialog(caption, text);
                if (result != null) {
                    result.set(ret ? 1 : 0);
                }
                return 0;
            }
        }, CLASS_NAME, 1, 65536);
        this.registerNCM("versionString", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(((ApplicationSystem)TVP.Application.get()).getVersionString());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("versionInformation", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(((ApplicationSystem)TVP.Application.get()).getVersionInformation());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("eventDisabled", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.getSystemEventDisabledState() ? 1 : 0);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                TVP.setSystemEventDisabledState(param.asBoolean());
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("graphicCacheLimit", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.getGraphicCacheLimit());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) throws VariantException {
                TVP.setGraphicCacheLimit(param.asInteger());
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("platformName", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVPSystem.getPlatformName());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("osName", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVPSystem.getOSName());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("exitOnWindowClose", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.TerminateOnWindowClose ? 1 : 0);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                TVP.TerminateOnWindowClose = param.asBoolean();
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("drawThreadNum", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(0);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("processorNum", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVPSystem.getProcessorNum());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("exitOnNoWindowStartup", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.TerminateOnNoWindowStartup ? 1 : 0);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                TVP.TerminateOnNoWindowStartup = param.asBoolean();
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("exePath", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) throws TJSException {
                result.set(ApplicationSystem.getAppPath());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("personalPath", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) throws TJSException {
                result.set(ApplicationSystem.getPersonalPath());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("appDataPath", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) throws TJSException {
                result.set(ApplicationSystem.getPersonalPath());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("dataPath", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.DataPath);
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("exeName", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getExeName());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("title", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.getAppTitle());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) throws VariantException {
                TVP.setAppTitle(param.asString());
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("screenWidth", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getScreenWidth());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("screenHeight", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getScreenHeight());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("desktopLeft", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getDesktopLeft());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("desktopTop", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getDesktopTop());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("desktopWidth", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getDesktopWidth());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("desktopHeight", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                result.set(TVP.MainForm.getDesktopHeight());
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                return -1007;
            }
        }, CLASS_NAME, 2, 65536);
        this.registerNCM("stayOnTop", new NativeClassProperty(){

            @Override
            public int get(Variant result, Dispatch2 objthis) {
                if (TVP.MainWindow != null) {
                    result.set(TVP.MainWindow.getStayOnTop() ? 1 : 0);
                }
                return 0;
            }

            @Override
            public int set(Variant param, Dispatch2 objthis) {
                if (TVP.MainWindow != null) {
                    TVP.MainWindow.setStayOnTop(param.asBoolean());
                }
                return 0;
            }
        }, CLASS_NAME, 2, 65536);
        Variant val = new Variant(null, null);
        this.propSet(512, "exceptionHandler", val, this);
        this.propSet(512, "onActivate", val, this);
        this.propSet(512, "onDeactivate", val, this);
    }
}

