/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.util.Enumeration;
import java.util.UUID;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.ScriptsClass;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.Random;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2env.ApplicationSystem;

public class SystemInitializer {
    private static boolean SystemUninitCalled;
    private static boolean ProgramArgumentsInit;
    private static boolean DataPathDirectoryEnsured;
    private static final int gsotNone = 0;
    private static final int gsotSimple = 1;
    private static final int gsotInterlace = 2;
    private static final int gsotBiDirection = 3;

    public static void initialize() {
        SystemUninitCalled = false;
        ProgramArgumentsInit = false;
        DataPathDirectoryEnsured = false;
    }

    public static void systemInitialize() throws TJSException {
        SystemInitializer.beforeSystemInitialize();
        SystemInitializer.afterSystemInit();
    }

    private static void initializeRandomGenerator() {
        Random.updateEnvironNoiseForTick();
        UUID uuid = UUID.randomUUID();
        long l = uuid.getLeastSignificantBits();
        Random.pushEnvironNoise(l);
        long m = uuid.getMostSignificantBits();
        Random.pushEnvironNoise(m);
        long id = Thread.currentThread().getId();
        Random.pushEnvironNoise(id);
        Random.updateEnvironNoiseForTick();
    }

    private static void beforeSystemInitialize() throws TJSException {
        SystemInitializer.initProgramArgumentsAndDataPath(false);
        SystemInitializer.initializeRandomGenerator();
        Runtime runtime = Runtime.getRuntime();
        long totalMem = runtime.totalMemory();
        long maxMem = runtime.maxMemory();
        long freeMem = runtime.freeMemory();
        Random.pushEnvironNoise(totalMem);
        Random.pushEnvironNoise(maxMem);
        Random.pushEnvironNoise(freeMem);
        TVP.MaxMemory = maxMem;
        DebugClass.addImportantLog("(info) Max memory : " + maxMem);
        if (TVP.MaxMemory <= 0x2400000L) {
            TVP.MaxMemory = 0L;
        }
        ((ApplicationSystem)TVP.Application.get()).initializeDataPath();
        if (TVP.ProjectDirSelected) {
            DebugClass.addImportantLog("(info) Selected project directory : " + TVP.ProjectDir);
        }
    }

    private static void dumpOptions() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("(info) Specified option(s) (earlier item has more priority) :");
        boolean appending = false;
        Enumeration<?> en = TVP.Properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = TVP.Properties.getProperty(key);
            builder.append(" -");
            builder.append(key);
            builder.append('=');
            builder.append(value);
            appending = true;
        }
        if (!appending) {
            builder.append(" (none)");
        }
        DebugClass.addImportantLog(builder.toString());
        builder = null;
    }

    private static void afterSystemInit() {
        int limitmb = -1;
        String prop = TVP.Properties.getProperty("gclim", "auto");
        if (!"auto".equals(prop)) {
            limitmb = Integer.valueOf(prop);
        }
        if (limitmb == -1) {
            TVP.GraphicCacheSystemLimit = TVP.MaxMemory <= 0x2000000L ? 0L : (TVP.MaxMemory <= 0x3000000L ? 0L : (TVP.MaxMemory <= 0x4000000L ? 0L : (TVP.MaxMemory <= 0x6000000L ? 4L : (TVP.MaxMemory <= 0x8000000L ? 8L : (TVP.MaxMemory <= 0xC000000L ? 12L : (TVP.MaxMemory <= 0x10000000L ? 20L : (TVP.MaxMemory <= 0x20000000L ? 40L : TVP.MaxMemory / 0xA00000L)))))));
            TVP.GraphicCacheSystemLimit *= 0x100000L;
        } else {
            TVP.GraphicCacheSystemLimit = limitmb * 1024 * 1024;
        }
        if (TVP.MaxMemory <= 0x4000000L) {
            TVP.IsLowMemory = true;
        }
        if ("no".equals(prop = TVP.Properties.getProperty("gsplit", "yes"))) {
            TVP.GraphicSplitOperationType = 0;
        } else if ("int".equals(prop)) {
            TVP.GraphicSplitOperationType = 2;
        } else if ("yes".equals(prop) || "simple".equals(prop)) {
            TVP.GraphicSplitOperationType = 1;
        } else if ("bidi".equals(prop)) {
            TVP.GraphicSplitOperationType = 3;
        }
        prop = TVP.Properties.getProperty("holdalpha", "false");
        TVP.DefaultHoldAlpha = "yes".equals(prop) || "true".equals(prop);
        SystemInitializer.dumpOptions();
    }

    static void initProgramArgumentsAndDataPath(boolean stop_after_datapath_got) throws TJSException {
        if (!ProgramArgumentsInit) {
            ProgramArgumentsInit = true;
            ((ApplicationSystem)TVP.Application.get()).initializeSaveDataPath(stop_after_datapath_got);
        }
    }

    public static void systemUninitialize() {
        if (SystemUninitCalled) {
            return;
        }
        SystemUninitCalled = true;
        try {
            ScriptsClass.uninitScriptEngine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseBitmap.unmapPrerenderedAllFont();
        TVP.finalizeApplication();
        TJS.finalizeApplication();
        System.gc();
    }

    public static void ensureDataPathDirectory() {
        if (!DataPathDirectoryEnsured) {
            DataPathDirectoryEnsured = true;
            if (!Storage.checkExistentLocalFolder(TVP.NativeDataPath)) {
                if (Storage.createFolders(TVP.NativeDataPath)) {
                    DebugClass.addImportantLog("(info) Data path does not exist, trying to make it ... ok.");
                } else {
                    DebugClass.addImportantLog("(info) Data path does not exist, trying to make it ... failed.");
                }
            }
        }
    }
}

