/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;

public class TextWriteStream
implements TextWriteStreamInterface {
    private static final int COMPRESSION_BUFFER_SIZE = 32768;
    private static final int BUILDER_BUFFER_SIZE = 4096;
    private static final byte[] BOM_MARK = new byte[]{-1, -2};
    private static final byte[] DUMMY_POS = new byte[16];
    private BinaryStream mStream;
    private StringBuilder mBuilder = new StringBuilder(4096);
    private int mCryptMode = -1;
    private int mCompressionLevel = -1;
    private int mCompressionSizePosition;
    private boolean mCompressionFailed;
    private byte[] mCompressionBuffer;
    private Deflater mCompresser;
    private boolean mIsUTF8;

    public TextWriteStream(String name, String mode) throws TJSException {
        int o_ofs;
        char c;
        int p;
        if (mode == null) {
            mode = "";
        }
        if ("utf-8".equalsIgnoreCase(mode)) {
            this.mIsUTF8 = true;
        }
        if ((p = mode.indexOf(99)) != -1) {
            this.mCryptMode = 1;
            if (p + 1 < mode.length() && (c = mode.charAt(p + 1)) >= '0' && c <= '9') {
                this.mCryptMode = c - 48;
            }
        }
        if ((p = mode.indexOf(122)) != -1) {
            this.mCryptMode = 2;
            if (p + 1 < mode.length() && (c = mode.charAt(p + 1)) >= '0' && c <= '9') {
                this.mCompressionLevel = c - 48;
            }
        }
        if (this.mCryptMode != -1 && this.mCryptMode != 1 && this.mCryptMode != 2) {
            Message.throwExceptionMessage("\u8a8d\u8b58\u3067\u304d\u306a\u3044\u30e2\u30fc\u30c9\u6587\u5b57\u5217\u306e\u6307\u5b9a\u3067\u3059(%1)", "unsupported cipher mode");
        }
        if ((o_ofs = mode.indexOf(111)) != -1) {
            StringBuilder buf = new StringBuilder(256);
            int modelen = mode.length() - ++o_ofs;
            int i = 0;
            while (i < modelen) {
                char c2 = mode.charAt(o_ofs + i);
                if (c2 < '0' || c2 > '9') break;
                buf.append(c2);
                ++i;
            }
            long ofs = Integer.valueOf(buf.toString()).intValue();
            this.mStream = Storage.createStream(name, 3);
            this.mStream.setPosition(ofs);
        } else {
            this.mStream = Storage.createStream(name, 1);
        }
        if (this.mCryptMode == 1 || this.mCryptMode == 2) {
            byte[] crypt_mode_sig = new byte[3];
            crypt_mode_sig[1] = -2;
            crypt_mode_sig[0] = -2;
            crypt_mode_sig[2] = (byte)this.mCryptMode;
            this.mStream.write(crypt_mode_sig);
        }
        if (!this.mIsUTF8) {
            this.mStream.write(BOM_MARK);
        }
        if (this.mCryptMode == 2) {
            this.mCompresser = new Deflater();
            this.mCompresser.setLevel(this.mCompressionLevel);
            try {
                this.mCompressionBuffer = new byte[32768];
            }
            catch (OutOfMemoryError e) {
                DebugClass.addLog("Faild to allocate memory in Text write buffer. Force GC and try agian.");
                TVP.EventManager.deliverCompactEvent(100);
                System.gc();
                this.mCompressionBuffer = new byte[8192];
            }
            this.mCompressionSizePosition = (int)this.mStream.getPosition();
            this.mStream.write(DUMMY_POS);
        }
    }

    @Override
    public void write(String val) throws TJSException {
        if (this.mStream != null) {
            int vallen = val.length();
            int length = this.mBuilder.length();
            if (vallen > 4096) {
                if (length > 0) {
                    this.writeInternal();
                    this.mBuilder.delete(0, length);
                }
                this.writeInternal(val);
            } else if (length + vallen > 4096) {
                this.writeInternal();
                this.mBuilder.delete(0, length);
                this.mBuilder.append(val);
            } else {
                this.mBuilder.append(val);
            }
        }
    }

    private void writeInternal() throws TJSException {
        if (!this.mIsUTF8) {
            StringBuilder val = this.mBuilder;
            int len = val.length();
            byte[] buf = new byte[len * 2];
            try {
                if (this.mCryptMode == 1) {
                    int i = 0;
                    while (i < len) {
                        char ch = val.charAt(i);
                        ch = (char)(((ch & 0xAAAAAAAA) >>> 1 | (ch & 0x55555555) << 1) & 0xFFFF);
                        buf[i << 1] = (byte)(ch & 0xFF);
                        buf[(i << 1) + 1] = (byte)(ch >>> 8);
                        ++i;
                    }
                    this.writeRawData(buf);
                }
                int i = 0;
                while (i < len) {
                    char ch = val.charAt(i);
                    buf[i << 1] = (byte)(ch & 0xFF);
                    buf[(i << 1) + 1] = (byte)(ch >>> 8);
                    ++i;
                }
                this.writeRawData(buf);
            }
            finally {
                buf = null;
            }
        } else {
            try {
                String val = this.mBuilder.toString();
                byte[] buf = val.getBytes("UTF-8");
                this.writeRawData(buf);
            }
            catch (UnsupportedEncodingException e) {
                Message.throwExceptionMessage("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059");
            }
        }
    }

    private void writeInternal(String val) throws TJSException {
        if (!this.mIsUTF8) {
            int len = val.length();
            byte[] buf = new byte[len * 2];
            try {
                if (this.mCryptMode == 1) {
                    int i = 0;
                    while (i < len) {
                        char ch = val.charAt(i);
                        ch = (char)(((ch & 0xAAAAAAAA) >>> 1 | (ch & 0x55555555) << 1) & 0xFFFF);
                        buf[i << 1] = (byte)(ch & 0xFF);
                        buf[(i << 1) + 1] = (byte)(ch >>> 8);
                        ++i;
                    }
                    this.writeRawData(buf);
                }
                int i = 0;
                while (i < len) {
                    char ch = val.charAt(i);
                    buf[i << 1] = (byte)(ch & 0xFF);
                    buf[(i << 1) + 1] = (byte)(ch >>> 8);
                    ++i;
                }
                this.writeRawData(buf);
            }
            finally {
                buf = null;
            }
        } else {
            try {
                byte[] buf = val.getBytes("UTF-8");
                this.writeRawData(buf);
            }
            catch (UnsupportedEncodingException e) {
                Message.throwExceptionMessage("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059");
            }
        }
    }

    private void writeRawData(byte[] buf) {
        if (this.mCryptMode == 2) {
            this.mCompresser.setInput(buf);
            while (!this.mCompresser.needsInput()) {
                int count = this.mCompresser.deflate(this.mCompressionBuffer);
                if (count <= 0) continue;
                this.mStream.write(this.mCompressionBuffer, 0, count);
            }
        } else {
            this.mStream.write(buf);
        }
    }

    @Override
    public void destruct() throws TJSException {
        this.writetail();
        if (this.mStream != null) {
            this.mStream.close();
            this.mStream = null;
        }
    }

    private void writetail() throws TJSException {
        if (this.mStream != null) {
            int length = this.mBuilder.length();
            if (length > 0) {
                this.writeInternal();
                this.mBuilder.delete(0, length);
            }
            if (this.mCryptMode == 2 && !this.mCompressionFailed) {
                try {
                    this.mCompresser.finish();
                    while (!this.mCompresser.finished()) {
                        int count = this.mCompresser.deflate(this.mCompressionBuffer);
                        this.mStream.write(this.mCompressionBuffer, 0, count);
                    }
                    long totalin = this.mCompresser.getTotalIn();
                    long totalout = this.mCompresser.getTotalOut();
                    this.mCompresser.reset();
                    byte[] size = new byte[16];
                    ByteBuffer buf = ByteBuffer.wrap(size);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    buf.putLong(totalout);
                    buf.putLong(totalin);
                    this.mStream.setPosition(this.mCompressionSizePosition);
                    this.mStream.write(size);
                }
                finally {
                    this.mCompressionBuffer = null;
                    this.mCompresser = null;
                    this.mStream.close();
                    this.mStream = null;
                }
            }
        }
    }

    protected void finalize() {
        if (this.mStream != null) {
            try {
                this.writetail();
                this.mStream.close();
                this.mStream = null;
            }
            catch (TJSException tJSException) {
                // empty catch block
            }
        }
    }
}

