/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tvp2.base.BaseInputEvent;
import jp.kirikiri.tvp2.visual.MenuItemNI;
import jp.kirikiri.tvp2.visual.WindowNI;

public class WindowEvents {

    public static class OnClickInputEvent
    extends BaseInputEvent {
        private int X;
        private int Y;

        public OnClickInputEvent(WindowNI win, int x, int y) {
            super(win, ++InputEventTagMax);
            this.X = x;
            this.Y = y;
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onClick(this.X, this.Y);
        }
    }

    public static class OnCloseInputEvent
    extends BaseInputEvent {
        public OnCloseInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onClose();
        }
    }

    public static class OnDoubleClickInputEvent
    extends BaseInputEvent {
        private int X;
        private int Y;

        public OnDoubleClickInputEvent(WindowNI win, int x, int y) {
            super(win, ++InputEventTagMax);
            this.X = x;
            this.Y = y;
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onDoubleClick(this.X, this.Y);
        }
    }

    public static class OnFileDropInputEvent
    extends BaseInputEvent {
        Variant Array;

        public OnFileDropInputEvent(WindowNI win, Variant val) {
            super(win, ++InputEventTagMax);
            this.Array = new Variant(val);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onFileDrop(this.Array);
        }
    }

    public static class OnKeyDownInputEvent
    extends BaseInputEvent {
        int Key;
        int Shift;

        public OnKeyDownInputEvent(WindowNI win, int key, int shift) {
            super(win, ++InputEventTagMax);
            this.Key = key;
            this.Shift = shift;
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onKeyDown(this.Key, this.Shift);
        }
    }

    public static class OnKeyPressInputEvent
    extends BaseInputEvent {
        char Key;

        public OnKeyPressInputEvent(WindowNI win, char key) {
            super(win, ++InputEventTagMax);
            this.Key = key;
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onKeyPress(this.Key);
        }
    }

    public static class OnKeyUpInputEvent
    extends BaseInputEvent {
        int Key;
        int Shift;

        public OnKeyUpInputEvent(WindowNI win, int key, int shift) {
            super(win, ++InputEventTagMax);
            this.Key = key;
            this.Shift = shift;
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onKeyUp(this.Key, this.Shift);
        }
    }

    public static class OnMenuItemClickInputEvent
    extends BaseInputEvent {
        public OnMenuItemClickInputEvent(MenuItemNI menu) {
            super(menu, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((MenuItemNI)this.getSource()).onClick();
        }
    }

    public static class OnMouseDownInputEvent
    extends BaseInputEvent {
        private int X;
        private int Y;
        private int Buttons;
        private int Flags;

        public OnMouseDownInputEvent(WindowNI win, int x, int y, int buttons, int flags) {
            super(win, ++InputEventTagMax);
            this.X = x;
            this.Y = y;
            this.Buttons = buttons;
            this.Flags = flags;
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onMouseDown(this.X, this.Y, this.Buttons, this.Flags);
        }
    }

    public static class OnMouseEnterInputEvent
    extends BaseInputEvent {
        public OnMouseEnterInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onMouseEnter();
        }
    }

    public static class OnMouseLeaveInputEvent
    extends BaseInputEvent {
        public OnMouseLeaveInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onMouseLeave();
        }
    }

    public static class OnMouseMoveInputEvent
    extends BaseInputEvent {
        int X;
        int Y;
        int Flags;

        public OnMouseMoveInputEvent(WindowNI win, int x, int y, int flags) {
            super(win, ++InputEventTagMax);
            this.X = x;
            this.Y = y;
            this.Flags = flags;
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onMouseMove(this.X, this.Y, this.Flags);
        }
    }

    public static class OnMouseOutOfWindowInputEvent
    extends BaseInputEvent {
        public OnMouseOutOfWindowInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onMouseOutOfWindow();
        }
    }

    public static class OnMouseUpInputEvent
    extends BaseInputEvent {
        private int X;
        private int Y;
        private int Buttons;
        private int Flags;

        public OnMouseUpInputEvent(WindowNI win, int x, int y, int buttons, int flags) {
            super(win, ++InputEventTagMax);
            this.X = x;
            this.Y = y;
            this.Buttons = buttons;
            this.Flags = flags;
        }

        @Override
        public void deliver() throws TJSException {
            ((WindowNI)this.getSource()).onMouseUp(this.X, this.Y, this.Buttons, this.Flags);
        }
    }

    public static class OnMouseWheelInputEvent
    extends BaseInputEvent {
        int Shift;
        int WheelDelta;
        int X;
        int Y;

        public OnMouseWheelInputEvent(WindowNI win, int shift, int wheeldelta, int x, int y) {
            super(win, ++InputEventTagMax);
            this.Shift = shift;
            this.WheelDelta = wheeldelta;
            this.X = x;
            this.Y = y;
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onMouseWheel(this.Shift, this.WheelDelta, this.X, this.Y);
        }
    }

    public static class OnOrientationChangedEvent
    extends BaseInputEvent {
        public OnOrientationChangedEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onOrientationChanged();
        }
    }

    public static class OnPopupHideInputEvent
    extends BaseInputEvent {
        public OnPopupHideInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onPopupHide();
        }
    }

    public static class OnReleaseCaptureInputEvent
    extends BaseInputEvent {
        public OnReleaseCaptureInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onReleaseCapture();
        }
    }

    public static class OnResizeInputEvent
    extends BaseInputEvent {
        public OnResizeInputEvent(WindowNI win) {
            super(win, ++InputEventTagMax);
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onResize();
        }
    }

    public static class OnWindowActivateEvent
    extends BaseInputEvent {
        boolean ActivateOrDeactivate;

        public OnWindowActivateEvent(WindowNI win, boolean activate_or_deactivate) {
            super(win, ++InputEventTagMax);
            this.ActivateOrDeactivate = activate_or_deactivate;
        }

        @Override
        public void deliver() {
            ((WindowNI)this.getSource()).onActivate(this.ActivateOrDeactivate);
        }
    }
}

