/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.Archive;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.base.XP3ArchiveExtractionFilter;
import jp.kirikiri.tvp2.base.XP3ArchiveStream;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;

public class XP3Archive
extends Archive {
    public static boolean AllowExtractProtectedStorage;
    public static XP3ArchiveExtractionFilter ArchiveExtractionFilter;
    private String mName;
    private int mCount;
    private ArrayList<ArchiveItem> mItems;
    private static final byte XP3_INDEX_ENCODE_METHOD_MASK = 7;
    private static final byte XP3_INDEX_ENCODE_ZLIB = 1;
    private static final byte XP3_INDEX_ENCODE_RAW = 0;
    private static final int XP3_INDEX_CONTINUE = 128;
    private static final int XP3_FILE_PROTECTED = Integer.MIN_VALUE;
    private static final int XP3_SEGM_ENCODE_METHOD_MASK = 7;
    private static final int XP3_SEGM_ENCODE_RAW = 0;
    private static final int XP3_SEGM_ENCODE_ZLIB = 1;
    private static final int FILE_TAG = 1701603654;
    private static final int INFO_TAG = 1868983913;
    private static final int SEGM_TAG = 1835492723;
    private static final int ADLR_TAG = 1919706209;
    private static final byte[] XP3Mark;

    static {
        XP3Mark = new byte[]{88, 80, 51, 13, 10, 32, 10, 26, -117, 103, 1};
    }

    public static void initialize() {
        ArchiveExtractionFilter = null;
        AllowExtractProtectedStorage = true;
    }

    public static void finalizeApplication() {
        ArchiveExtractionFilter = null;
    }

    public XP3Archive(String name) throws TJSException {
        super(name);
        this.mName = name;
        this.mItems = new ArrayList();
        BinaryStream st = Storage.createStream(name, 0);
        byte[] indexdata = null;
        DebugClass.addLog("(info) Trying to read XP3 virtual file system information from : " + name);
        int segmentcount = 0;
        try {
            try {
                long offset = XP3Archive.getXP3ArchiveOffset(st, name, true);
                st.setPosition(11L + offset);
                Inflater decompresser = new Inflater();
                byte[] longRead = new byte[8];
                byte[] byteRead = new byte[1];
                int[] start = new int[1];
                int[] size = new int[1];
                ByteBuffer longBuff = ByteBuffer.wrap(longRead);
                longBuff.order(ByteOrder.LITTLE_ENDIAN);
                while (true) {
                    int index_size;
                    byte index_flag;
                    block32: {
                        st.read(longRead);
                        longBuff.position(0);
                        long index_ofs = longBuff.getLong();
                        st.setPosition(index_ofs + offset);
                        st.read(byteRead);
                        index_flag = byteRead[0];
                        index_size = 0;
                        if ((index_flag & 7) == 1) {
                            st.read(longRead);
                            longBuff.position(0);
                            long compressed_size = longBuff.getLong();
                            st.read(longRead);
                            longBuff.position(0);
                            long r_index_size = longBuff.getLong();
                            if (compressed_size > Integer.MAX_VALUE || r_index_size > Integer.MAX_VALUE) {
                                Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                            }
                            index_size = (int)r_index_size;
                            indexdata = new byte[index_size];
                            byte[] compressed = new byte[(int)compressed_size];
                            try {
                                try {
                                    st.read(compressed);
                                    decompresser.setInput(compressed);
                                    int destlen = decompresser.inflate(indexdata);
                                    decompresser.reset();
                                    if (destlen != index_size) {
                                        Message.throwExceptionMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u672a\u5bfe\u5fdc\u306e\u5727\u7e2e\u5f62\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u305f\u304b\u3001\u3042\u308b\u3044\u306f\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                                    }
                                }
                                catch (DataFormatException e) {
                                    Message.throwExceptionMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u672a\u5bfe\u5fdc\u306e\u5727\u7e2e\u5f62\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u305f\u304b\u3001\u3042\u308b\u3044\u306f\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                                    compressed = null;
                                    break block32;
                                }
                            }
                            catch (Throwable throwable) {
                                compressed = null;
                                throw throwable;
                            }
                            compressed = null;
                        } else if ((index_flag & 7) == 0) {
                            st.read(longRead);
                            longBuff.position(0);
                            long r_index_size = longBuff.getLong();
                            if (r_index_size > Integer.MAX_VALUE) {
                                Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                            }
                            index_size = (int)r_index_size;
                            indexdata = new byte[index_size];
                            st.read(indexdata);
                        } else {
                            Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                        }
                    }
                    ByteBuffer indexdatabuf = ByteBuffer.wrap(indexdata);
                    indexdatabuf.order(ByteOrder.LITTLE_ENDIAN);
                    int ch_file_start = 0;
                    int ch_file_size = index_size;
                    while (true) {
                        start[0] = ch_file_start;
                        size[0] = ch_file_size;
                        if (!XP3Archive.findChunk(indexdatabuf, 1701603654, start, size)) break;
                        ch_file_start = start[0];
                        ch_file_size = size[0];
                        if (!XP3Archive.findChunk(indexdatabuf, 1868983913, start, size)) {
                            Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                        }
                        int ch_info_start = start[0];
                        indexdatabuf.position(ch_info_start);
                        ArchiveItem item = new ArchiveItem();
                        int flags = indexdatabuf.getInt();
                        if (!AllowExtractProtectedStorage && (flags & Integer.MIN_VALUE) != 0) {
                            Message.throwExceptionMessage("\u30d7\u30ed\u30c6\u30af\u30c8\u3055\u308c\u305f\u30a2\u30fc\u30ab\u30a4\u30d6\u3067\u3059");
                        }
                        item.OrgSize = indexdatabuf.getLong();
                        item.ArcSize = indexdatabuf.getLong();
                        int len = indexdatabuf.getShort();
                        CharBuffer cbuff = indexdatabuf.asCharBuffer();
                        if (len == -1) {
                            len = cbuff.capacity();
                        }
                        int i = 0;
                        while (i < len) {
                            if (cbuff.get(i) == '\u0000') {
                                len = i;
                                break;
                            }
                            ++i;
                        }
                        item.Name = cbuff.subSequence(0, len).toString();
                        item.Name = XP3Archive.normalizeInArchiveStorageName(item.Name);
                        start[0] = ch_file_start;
                        size[0] = ch_file_size;
                        if (!XP3Archive.findChunk(indexdatabuf, 1835492723, start, size)) {
                            Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                        }
                        int ch_segm_start = start[0];
                        int ch_segm_size = size[0];
                        int segment_count = ch_segm_size / 28;
                        long offset_in_archive = 0L;
                        indexdatabuf.order(ByteOrder.LITTLE_ENDIAN);
                        int i2 = 0;
                        while (i2 < segment_count) {
                            int pos_base = i2 * 28 + ch_segm_start;
                            indexdatabuf.position(pos_base);
                            XP3ArchiveSegment seg = new XP3ArchiveSegment();
                            int segflags = indexdatabuf.getInt();
                            if ((segflags & 7) == 0) {
                                seg.IsCompressed = false;
                            } else if ((segflags & 7) == 1) {
                                seg.IsCompressed = true;
                            } else {
                                Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                            }
                            seg.Start = indexdatabuf.getLong() + offset;
                            seg.Offset = offset_in_archive;
                            seg.OrgSize = indexdatabuf.getLong();
                            seg.ArcSize = indexdatabuf.getLong();
                            item.Segments.add(seg);
                            offset_in_archive += seg.OrgSize;
                            ++segmentcount;
                            ++i2;
                        }
                        start[0] = ch_file_start;
                        size[0] = ch_file_size;
                        if (!XP3Archive.findChunk(indexdatabuf, 1919706209, start, size)) {
                            Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                        }
                        int ch_adlr_start = start[0];
                        indexdatabuf.position(ch_adlr_start);
                        item.FileHash = indexdatabuf.getInt();
                        this.mItems.add(item);
                        ch_file_start += ch_file_size;
                        ch_file_size = index_size - ch_file_start;
                        ++this.mCount;
                    }
                    if ((index_flag & 0x80) == 0) {
                        break;
                    }
                    Collections.sort(this.mItems, new Comparator<ArchiveItem>(){

                        @Override
                        public int compare(ArchiveItem o1, ArchiveItem o2) {
                            return o1.Name.compareTo(o2.Name);
                        }
                    });
                }
            }
            catch (TJSException e) {
                DebugClass.addLog("(info) Faild.");
                throw e;
            }
        }
        finally {
            indexdata = null;
            st.close();
            st = null;
        }
        DebugClass.addLog("(info) Done. (contains " + this.mCount + " file(s), " + segmentcount + " segment(s))");
    }

    @Override
    public int getCount() {
        return this.mCount;
    }

    @Override
    public String getName(int idx) {
        return this.mItems.get((int)idx).Name;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public BinaryStream createStreamByIndex(int idx) throws TJSException {
        if (idx < 0 || idx >= this.mItems.size()) {
            Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
        ArchiveItem item = this.mItems.get(idx);
        BinaryStream stream = Storage.createStream(this.mName, 0);
        XP3ArchiveStream out = null;
        out = new XP3ArchiveStream(this, idx, item.Segments, stream, item.OrgSize, item.Name);
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getXP3ArchiveOffset(BinaryStream st, String name, boolean raise) throws TJSException {
        long offset;
        boolean found;
        st.setPosition(0L);
        byte[] mark = new byte[12];
        mark[0] = 0;
        st.read(mark, 0, 11);
        if (mark[0] == 77 && mark[1] == 90) {
            int read;
            found = false;
            offset = 16L;
            st.setPosition(16L);
            int one_read_size = 262144;
            byte[] buffer = new byte[262144];
            while ((read = st.read(buffer, 0, 262144)) != 0) {
                int p = 0;
                while (p < read) {
                    if (XP3Mark[0] == buffer[p + 0] && XP3Mark[1] == buffer[p + 1] && XP3Mark[2] == buffer[p + 2] && XP3Mark[3] == buffer[p + 3] && XP3Mark[4] == buffer[p + 4] && XP3Mark[5] == buffer[p + 5] && XP3Mark[6] == buffer[p + 6] && XP3Mark[7] == buffer[p + 7] && XP3Mark[8] == buffer[p + 8] && XP3Mark[9] == buffer[p + 9] && XP3Mark[10] == buffer[p + 10]) {
                        offset += (long)p;
                        found = true;
                        break;
                    }
                    p += 16;
                }
                if (found) break;
                offset += 262144L;
            }
        } else {
            if (XP3Mark[0] == mark[0] && XP3Mark[1] == mark[1] && XP3Mark[2] == mark[2] && XP3Mark[3] == mark[3] && XP3Mark[4] == mark[4] && XP3Mark[5] == mark[5] && XP3Mark[6] == mark[6] && XP3Mark[7] == mark[7] && XP3Mark[8] == mark[8] && XP3Mark[9] == mark[9] && XP3Mark[10] == mark[10]) {
                return 0L;
            }
            if (!raise) return -1L;
            Message.throwExceptionMessage("%1 \u306f XP3 \u30a2\u30fc\u30ab\u30a4\u30d6\u3067\u306f\u306a\u3044\u304b\u3001\u5bfe\u5fdc\u3067\u304d\u306a\u3044\u5f62\u5f0f\u3067\u3059\u3002\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3059\u3079\u304d\u5834\u9762\u3067\u901a\u5e38\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u3001\u3042\u308b\u3044\u306f\u5bfe\u5fdc\u3067\u304d\u306a\u3044\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u306a\u3069\u306b\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\u306e\u3067\u3001\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", name);
            return -1L;
        }
        if (found) return offset;
        if (!raise) return -1L;
        Message.throwExceptionMessage("%1 \u306f\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u306b\u898b\u3048\u307e\u3059\u304c\u3001\u3053\u308c\u306b\u7d50\u5408\u3055\u308c\u305f\u30a2\u30fc\u30ab\u30a4\u30d6\u3092\u767a\u898b\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f", name);
        return offset;
    }

    private static boolean findChunk(ByteBuffer data, int name, int[] start, int[] size) throws TJSException {
        int start_save = start[0];
        int size_save = size[0];
        int pos = 0;
        int tmp_start = start[0];
        int tmp_size = size[0];
        while (pos < tmp_size) {
            data.position(tmp_start);
            int fourcc = data.getInt();
            boolean found = fourcc == name;
            data.position(tmp_start += 4);
            long r_size = data.getLong();
            tmp_start += 8;
            if (r_size > Integer.MAX_VALUE) {
                Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u3084\u3001\u30c7\u30d0\u30a4\u30b9\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
            }
            int size_chunk = (int)r_size;
            if (found) {
                start[0] = tmp_start;
                size[0] = size_chunk;
                return true;
            }
            tmp_start += size_chunk;
            pos += size_chunk + 4 + 8;
        }
        start[0] = start_save;
        size[0] = size_save;
        return false;
    }

    public int getFileHash(int idx) {
        return this.mItems.get((int)idx).FileHash;
    }

    static class ArchiveItem {
        public String Name;
        public int FileHash;
        public long OrgSize;
        public long ArcSize;
        public ArrayList<XP3ArchiveSegment> Segments = new ArrayList();
    }

    public static class XP3ArchiveSegment {
        public long Start;
        public long Offset;
        public long OrgSize;
        public long ArcSize;
        public boolean IsCompressed;
    }
}

