/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.base;

import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.BinaryInputStream;
import jp.kirikiri.tvp2.base.XP3Archive;
import jp.kirikiri.tvp2.msg.Message;

public class XP3ArchiveStream
extends BinaryStream {
    private XP3Archive mOwner;
    private int mStorageIndex;
    private ArrayList<XP3Archive.XP3ArchiveSegment> mSegments;
    private BinaryStream mStream;
    private long mOrgSize;
    private String mOrgName;
    private int mCurSegmentNum;
    private XP3Archive.XP3ArchiveSegment mCurSegment;
    private int mLastOpenedSegmentNum;
    private long mCurPos;
    private long mSegmentRemain;
    private long mSegmentPos;
    private SegmentData mSegmentData;
    private boolean mSegmentOpened;

    public static void initialize() {
        SegmentData.initialize();
    }

    public static void finalizeApplication() {
        SegmentData.finalizeApplication();
    }

    public XP3ArchiveStream(XP3Archive owener, int storageindex, ArrayList<XP3Archive.XP3ArchiveSegment> segments, BinaryStream stream, long orgsize, String orgname) {
        this.mStorageIndex = storageindex;
        this.mSegments = segments;
        this.mCurSegment = segments.get(0);
        this.mSegmentRemain = this.mCurSegment.OrgSize;
        this.mLastOpenedSegmentNum = -1;
        this.mOwner = owener;
        this.mStream = stream;
        this.mOrgSize = orgsize;
        this.mOrgName = orgname;
    }

    private void ensureSegment() throws TJSException {
        if (this.mSegmentOpened) {
            return;
        }
        if (this.mLastOpenedSegmentNum == this.mCurSegmentNum) {
            if (!this.mCurSegment.IsCompressed) {
                this.mStream.setPosition(this.mCurSegment.Start + this.mSegmentPos);
            }
            return;
        }
        if (this.mSegmentData != null) {
            this.mSegmentData = null;
        }
        if (this.mCurSegment.IsCompressed) {
            this.mStream.setPosition(this.mCurSegment.Start);
            this.mSegmentData = new SegmentData();
            this.mSegmentData.setData((int)this.mCurSegment.OrgSize, this.mStream, (int)this.mCurSegment.ArcSize);
        } else {
            this.mStream.setPosition(this.mCurSegment.Start + this.mSegmentPos);
        }
        this.mSegmentOpened = true;
        this.mLastOpenedSegmentNum = this.mCurSegmentNum;
    }

    private void seekToPosition(long pos) {
        if (this.mCurPos == pos) {
            return;
        }
        int st = 0;
        int et = this.mSegments.size();
        while (true) {
            if (et - st <= 1) break;
            int m = st + (et - st) / 2;
            if (this.mSegments.get((int)m).Offset > pos) {
                et = m;
                continue;
            }
            st = m;
        }
        int seg_num = st;
        this.mCurSegmentNum = seg_num;
        this.mCurSegment = this.mSegments.get(this.mCurSegmentNum);
        this.mSegmentOpened = false;
        this.mSegmentPos = pos - this.mCurSegment.Offset;
        this.mSegmentRemain = this.mCurSegment.OrgSize - this.mSegmentPos;
        this.mCurPos = pos;
    }

    private boolean openNextSegment() throws TJSException {
        if (this.mCurSegmentNum == this.mSegments.size() - 1) {
            return false;
        }
        ++this.mCurSegmentNum;
        this.mCurSegment = this.mSegments.get(this.mCurSegmentNum);
        this.mSegmentOpened = false;
        this.mSegmentPos = 0L;
        this.mSegmentRemain = this.mCurSegment.OrgSize;
        this.mCurPos = this.mCurSegment.Offset;
        this.ensureSegment();
        return true;
    }

    @Override
    public long seek(long offset, int whence) throws TJSException {
        switch (whence) {
            case 0: {
                long newpos = offset;
                if (offset >= 0L && offset <= this.mOrgSize) {
                    this.seekToPosition(newpos);
                }
                return this.mCurPos;
            }
            case 1: {
                long newpos = offset + this.mCurPos;
                if (offset >= 0L && offset <= this.mOrgSize) {
                    this.seekToPosition(newpos);
                }
                return this.mCurPos;
            }
            case 2: {
                long newpos = offset + this.mOrgSize;
                if (offset >= 0L && offset <= this.mOrgSize) {
                    this.seekToPosition(newpos);
                }
                return this.mCurPos;
            }
        }
        return this.mCurPos;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(ByteBuffer buffer) throws TJSException {
        this.ensureSegment();
        read_size = buffer.limit() - buffer.position();
        write_size = 0;
        buf = new byte[read_size];
        ** GOTO lbl23
        {
            if (!this.openNextSegment()) {
                return write_size;
            }
            do {
                if (this.mSegmentRemain == 0L) continue block0;
                one_size = (int)((long)read_size > this.mSegmentRemain ? this.mSegmentRemain : (long)read_size);
                if (this.mCurSegment.IsCompressed) {
                    System.arraycopy(this.mSegmentData.getData(), (int)this.mSegmentPos, buf, write_size, one_size);
                } else {
                    this.mStream.read(buf, write_size, one_size);
                }
                if (XP3Archive.ArchiveExtractionFilter != null) {
                    XP3Archive.ArchiveExtractionFilter.encrypt(this.mCurPos, buf, write_size, one_size, this.mOwner.getFileHash(this.mStorageIndex));
                }
                this.mSegmentPos += (long)one_size;
                this.mCurPos += (long)one_size;
                this.mSegmentRemain -= (long)one_size;
                read_size -= one_size;
                write_size += one_size;
lbl23:
                // 2 sources

            } while (read_size > 0);
        }
        buffer.put(buf);
        return write_size;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] buffer) throws TJSException {
        this.ensureSegment();
        read_size = buffer.length;
        write_size = 0;
        ** GOTO lbl22
        {
            if (!this.openNextSegment()) {
                return write_size;
            }
            do {
                if (this.mSegmentRemain == 0L) continue block0;
                one_size = (int)((long)read_size > this.mSegmentRemain ? this.mSegmentRemain : (long)read_size);
                if (this.mCurSegment.IsCompressed) {
                    System.arraycopy(this.mSegmentData.getData(), (int)this.mSegmentPos, buffer, write_size, one_size);
                } else {
                    this.mStream.read(buffer, write_size, one_size);
                }
                if (XP3Archive.ArchiveExtractionFilter != null) {
                    XP3Archive.ArchiveExtractionFilter.encrypt(this.mCurPos, buffer, write_size, one_size, this.mOwner.getFileHash(this.mStorageIndex));
                }
                this.mSegmentPos += (long)one_size;
                this.mCurPos += (long)one_size;
                this.mSegmentRemain -= (long)one_size;
                read_size -= one_size;
                write_size += one_size;
lbl22:
                // 2 sources

            } while (read_size > 0);
        }
        return write_size;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws TJSException {
        this.ensureSegment();
        read_size = len;
        write_size = 0;
        ** GOTO lbl22
        {
            if (!this.openNextSegment()) {
                return write_size;
            }
            do {
                if (this.mSegmentRemain == 0L) continue block0;
                one_size = (int)((long)read_size > this.mSegmentRemain ? this.mSegmentRemain : (long)read_size);
                if (this.mCurSegment.IsCompressed) {
                    System.arraycopy(this.mSegmentData.getData(), (int)this.mSegmentPos, b, off + write_size, one_size);
                } else {
                    this.mStream.read(b, off + write_size, one_size);
                }
                if (XP3Archive.ArchiveExtractionFilter != null) {
                    XP3Archive.ArchiveExtractionFilter.encrypt(this.mCurPos, b, write_size, one_size, this.mOwner.getFileHash(this.mStorageIndex));
                }
                this.mSegmentPos += (long)one_size;
                this.mCurPos += (long)one_size;
                this.mSegmentRemain -= (long)one_size;
                read_size -= one_size;
                write_size += one_size;
lbl22:
                // 2 sources

            } while (read_size > 0);
        }
        return write_size;
    }

    @Override
    public int write(ByteBuffer buffer) {
        return 0;
    }

    @Override
    public int write(byte[] buffer) {
        return 0;
    }

    @Override
    public void write(byte[] b, int off, int len) {
    }

    @Override
    public void write(int b) {
    }

    @Override
    public void close() {
        this.mStream.close();
    }

    @Override
    public InputStream getInputStream() {
        return new BinaryInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public long getSize() throws TJSException {
        return this.mOrgSize;
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public String getFilePath() {
        StringBuilder builder = new StringBuilder(256);
        builder.append(this.mStream.getFilePath());
        builder.append('>');
        builder.append(this.mOrgName);
        return builder.toString();
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.mStream.getFileDescriptor();
    }

    @Override
    public long getFileOffset() {
        return this.mStream.getFileOffset() + this.mSegments.get((int)0).Start;
    }

    static class SegmentData {
        private static Inflater Decompresser;
        private int Size;
        private byte[] Data;

        public static void initialize() {
            Decompresser = null;
        }

        public static void finalizeApplication() {
            Decompresser = null;
        }

        public SegmentData() {
            if (Decompresser == null) {
                Decompresser = new Inflater();
            }
        }

        public void setData(int outsize, BinaryStream instream, int insize) throws TJSException {
            byte[] indata = new byte[insize];
            try {
                try {
                    instream.read(indata);
                    this.Data = new byte[outsize];
                    Decompresser.setInput(indata);
                    int destlen = Decompresser.inflate(this.Data);
                    Decompresser.reset();
                    if (destlen != outsize) {
                        Message.throwExceptionMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u672a\u5bfe\u5fdc\u306e\u5727\u7e2e\u5f62\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u305f\u304b\u3001\u3042\u308b\u3044\u306f\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                    }
                    this.Size = outsize;
                }
                catch (DataFormatException e) {
                    Message.throwExceptionMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u672a\u5bfe\u5fdc\u306e\u5727\u7e2e\u5f62\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u305f\u304b\u3001\u3042\u308b\u3044\u306f\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                    indata = null;
                }
            }
            finally {
                indata = null;
            }
        }

        public byte[] getData() {
            return this.Data;
        }

        public int getSize() {
            return this.Size;
        }
    }
}

