/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.sound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.kirikiri.tvp2.sound.WaveLabel;
import jp.kirikiri.tvp2.sound.WaveLoopLink;

public class WaveLoopManager {
    private static final int WL_MAX_FLAGS = 16;
    private static final int WL_MAX_FLAG_VALUE = 9999;
    private int[] mFlags = new int[16];
    private boolean mFlagsModifiedByLabelExpression;
    private ArrayList<WaveLoopLink> mLinks = new ArrayList();
    private ArrayList<WaveLabel> mLabels = new ArrayList();
    private Object DataCS = new Object();
    private long mPosition;
    private byte[] mCrossFadeSamples;
    private boolean mIsLinksSorted;
    private boolean mIsLabelsSorted;
    private boolean mIgnoreLinks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlag(int index) {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            return this.mFlags[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFlags(int[] dest) {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            if (dest.length >= this.mFlags.length) {
                System.arraycopy(this.mFlags, 0, dest, 0, this.mFlags.length);
            }
            this.mFlagsModifiedByLabelExpression = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFlagsModifiedByLabelExpression() {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            return this.mFlagsModifiedByLabelExpression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlag(int index, int f) {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            if (f < 0) {
                f = 0;
            }
            if (f > 9999) {
                f = 9999;
            }
            this.mFlags[index] = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFlags() {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            int i = 0;
            while (i < 16) {
                this.mFlags[i] = 0;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLinksAndLabels() {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            this.mLabels.clear();
            this.mLinks.clear();
            this.mIsLinksSorted = false;
            this.mIsLabelsSorted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<WaveLoopLink> getLinks() {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            return this.mLinks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<WaveLabel> getLabels() {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            if (!this.mIsLabelsSorted) {
                Collections.sort(this.mLabels, new Comparator<WaveLabel>(){

                    @Override
                    public int compare(WaveLabel o1, WaveLabel o2) {
                        return (int)(o1.Position - o2.Position);
                    }
                });
                this.mIsLabelsSorted = true;
            }
            return this.mLabels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinks(ArrayList<WaveLoopLink> links) {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            this.mLinks = links;
            this.mIsLinksSorted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabels(ArrayList<WaveLabel> labels) {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            this.mLabels = labels;
            this.mIsLabelsSorted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIgnoreLinks() {
        Object object = this.DataCS;
        synchronized (object) {
            return this.mIgnoreLinks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreLinks(boolean b) {
        Object object = this.DataCS;
        synchronized (object) {
            this.mIgnoreLinks = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPosition() {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            return this.mPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(long pos) {
        Object object = this.DataCS;
        synchronized (object) {
            this.mPosition = pos;
            this.clearCrossFadeInformation();
        }
    }

    public void decode(long position, int samples, ArrayList<WaveLabel> labels) {
        this.getLabelAt(position, position + (long)samples, labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getLabelAt(long from, long to, ArrayList<WaveLabel> labels) {
        WaveLoopManager waveLoopManager = this;
        synchronized (waveLoopManager) {
            if (this.mLabels.size() == 0) {
                return;
            }
            if (!this.mIsLabelsSorted) {
                Collections.sort(this.mLabels, new Comparator<WaveLabel>(){

                    @Override
                    public int compare(WaveLabel o1, WaveLabel o2) {
                        return (int)(o1.Position - o2.Position);
                    }
                });
                this.mIsLabelsSorted = true;
            }
            int s = 0;
            int e = this.mLabels.size();
            while (true) {
                if (e - s <= 1) {
                    if (s < this.mLabels.size() - 1 && this.mLabels.get((int)s).Position < from) {
                        ++s;
                    }
                    if (s >= this.mLabels.size()) return;
                    if (this.mLabels.get((int)s).Position >= from) break;
                    return;
                }
                int m = (s + e) / 2;
                if (this.mLabels.get((int)m).Position <= from) {
                    s = m;
                    continue;
                }
                e = m;
            }
            long pos = this.mLabels.get((int)s).Position;
            while (s >= 1 && this.mLabels.get((int)(s - 1)).Position == pos) {
                --s;
            }
            while (true) {
                if (s >= this.mLabels.size()) {
                    return;
                }
                pos = this.mLabels.get((int)s).Position;
                if (pos < from) return;
                if (pos >= to) return;
                labels.add(this.mLabels.get(s));
                ++s;
            }
        }
    }

    private void clearCrossFadeInformation() {
        if (this.mCrossFadeSamples != null) {
            this.mCrossFadeSamples = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readInformation(String p) {
        var2_2 = this;
        synchronized (var2_2) {
            block25: {
                block27: {
                    block26: {
                        if (p == null) {
                            return false;
                        }
                        count = p.length();
                        this.mLinks.clear();
                        this.mLabels.clear();
                        this.mIsLinksSorted = false;
                        this.mIsLabelsSorted = false;
                        ret = new long[1];
                        if (p.charAt(0) != '#') {
                            p_length = p.indexOf("LoopLength=");
                            p_start = p.indexOf("LoopStart=");
                            if (p_length == -1 || p_start == -1) {
                                return false;
                            }
                            link = new WaveLoopLink();
                            link.Smooth = false;
                            link.Condition = WaveLoopLink.llcNone;
                            link.RefValue = 0;
                            link.CondVar = 0;
                            if (!WaveLoopManager.getInt64(p, p_length + 11, ret)) {
                                return false;
                            }
                            length = ret[0];
                            if (!WaveLoopManager.getInt64(p, p_start + 10, ret)) {
                                return false;
                            }
                            start = ret[0];
                            link.From = start + length;
                            link.To = start;
                            this.mLinks.add(link);
                            break block25;
                        }
                        if (!p.startsWith("#2.00")) {
                            return false;
                        }
                        i = 0;
lbl36:
                        // 2 sources

                        while (true) {
                            if ((i == 0 || p.charAt(i - 1) == '\n') && p.charAt(i) == '#') {
                                while (true) {
                                    if (i >= count || p.charAt(i) == '\n') {
                                        if (i < count) break;
                                        break block25;
                                    }
                                    ++i;
                                }
                                ++i;
                                continue;
                            }
                            ** GOTO lbl51
                            break;
                        }
                        while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                            ++i;
lbl51:
                            // 2 sources

                            if (i < count) continue;
                        }
                        if (i >= count) break block25;
                        if (i + 5 >= count) {
                            return false;
                        }
                        link = p.substring(i, i + 4);
                        if (!"Link".equalsIgnoreCase(link) || Character.isLetter(p.charAt(i + 4))) break block26;
                        i += 4;
                        ** GOTO lbl69
                    }
                    if (i + 6 >= count) {
                        return false;
                    }
                    label = p.substring(i, i + 5);
                    if ("Label".equalsIgnoreCase(label) && !Character.isLetter(p.charAt(i + 5))) {
                        i += 5;
                    } else {
                        return false;
                    }
                    while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                        ++i;
lbl69:
                        // 2 sources

                        if (i < count) continue;
                    }
                    if (i >= count) {
                        return false;
                    }
                    linkData = new WaveLoopLink();
                    if ((i = WaveLoopManager.readLinkInformation(p, i, linkData)) < 0) {
                        return false;
                    }
                    this.mLinks.add(linkData);
                    break block27;
                    while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                        ++i;
                        if (i < count) continue;
                    }
                    if (i >= count) {
                        return false;
                    }
                    labelData = new WaveLabel();
                    if ((i = WaveLoopManager.readLabelInformation(p, i, labelData)) < 0) {
                        return false;
                    }
                    this.mLabels.add(labelData);
                }
                while (i < count) {
                    c = p.charAt(i);
                    if (c != ' ' && c != '\f' && c != '\n' && c != '\r' && c != '\t' && c != '\u000b') break;
                    ++i;
                }
                if (i >= count) ** break;
                ** continue;
            }
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int readLabelInformation(String p, int i, WaveLabel label) {
        count = p.length();
        if (i >= count) {
            return -1;
        }
        if (p.charAt(i) != '{') {
            return -1;
        }
        if (++i >= count) {
            return -1;
        }
        name = new String[1];
        value = new String[1];
        lv = new long[1];
        do {
            block11: {
                block10: {
                    if ((i = WaveLoopManager.getEntityToken(p, i, name, value)) < 0) {
                        return -1;
                    }
                    n = name[0];
                    if (!"Position".equalsIgnoreCase(n)) break block10;
                    if (!WaveLoopManager.getInt64(value[0], 0, lv)) {
                        return -1;
                    }
                    label.Position = lv[0];
                    ** GOTO lbl28
                }
                if (!"Name".equalsIgnoreCase(n)) break block11;
                label.Name = value[0];
                ** GOTO lbl28
            }
            return -1;
            while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                ++i;
lbl28:
                // 3 sources

                if (i < count) continue;
            }
            if (i >= count) {
                return -1;
            }
            if (p.charAt(i) != ';') {
                return -1;
            }
            if (++i < count) ** GOTO lbl37
            return -1;
            while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                ++i;
lbl37:
                // 2 sources

                if (i < count) continue;
            }
            if (i < count) continue;
            return -1;
        } while (p.charAt(i) != '}');
        return ++i;
    }

    /*
     * Unable to fully structure code
     */
    private static int readLinkInformation(String p, int i, WaveLoopLink link) {
        count = p.length();
        if (i >= count) {
            return -1;
        }
        if (p.charAt(i) != '{') {
            return -1;
        }
        if (++i >= count) {
            return -1;
        }
        name = new String[1];
        value = new String[1];
        lv = new long[1];
        bv = new boolean[1];
        iv = new int[1];
        do {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    if ((i = WaveLoopManager.getEntityToken(p, i, name, value)) < 0) {
                                        return -1;
                                    }
                                    n = name[0];
                                    if (!"From".equalsIgnoreCase(n)) break block15;
                                    if (!WaveLoopManager.getInt64(value[0], 0, lv)) {
                                        return -1;
                                    }
                                    link.From = lv[0];
                                    ** GOTO lbl56
                                }
                                if (!"To".equalsIgnoreCase(n)) break block16;
                                if (!WaveLoopManager.getInt64(value[0], 0, lv)) {
                                    return -1;
                                }
                                link.To = lv[0];
                                ** GOTO lbl56
                            }
                            if (!"Smooth".equalsIgnoreCase(n)) break block17;
                            if (!WaveLoopManager.getBool(value[0], 0, bv)) {
                                return -1;
                            }
                            link.Smooth = bv[0];
                            ** GOTO lbl56
                        }
                        if (!"Condition".equalsIgnoreCase(n)) break block18;
                        if (!WaveLoopManager.getCondition(value[0], 0, iv)) {
                            return -1;
                        }
                        link.Condition = iv[0];
                        ** GOTO lbl56
                    }
                    if (!"RefValue".equalsIgnoreCase(n)) break block19;
                    if (!WaveLoopManager.getInt(value[0], 0, iv)) {
                        return -1;
                    }
                    link.RefValue = iv[0];
                    ** GOTO lbl56
                }
                if (!"CondVar".equalsIgnoreCase(n)) break block20;
                if (!WaveLoopManager.getInt(value[0], 0, iv)) {
                    return -1;
                }
                link.CondVar = iv[0];
                ** GOTO lbl56
            }
            return -1;
            while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                ++i;
lbl56:
                // 7 sources

                if (i < count) continue;
            }
            if (i >= count) {
                return -1;
            }
            if (p.charAt(i) != ';') {
                return -1;
            }
            if (++i < count) ** GOTO lbl65
            return -1;
            while ((c = p.charAt(i)) == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                ++i;
lbl65:
                // 2 sources

                if (i < count) continue;
            }
            if (i < count) continue;
            return -1;
        } while (p.charAt(i) == '}');
        return ++i;
    }

    /*
     * Unable to fully structure code
     */
    private static int getEntityToken(String p, int i, String[] name, String[] value) {
        block15: {
            count = p.length();
            delimiter = '\u0000';
            while (i < count) {
                c = p.charAt(i);
                if (c != ' ' && c != '\t' && c != '\f' && c != '\n' && c != '\r' && c != '\u000b') break;
                ++i;
            }
            if (i >= count) {
                return -1;
            }
            namestart = i;
            while (i < count) {
                c = p.charAt(i);
                if (c == ' ' || c == '=' || c == '\t' || c == '\f' || c == '\n' || c == '\r' || c == '\u000b') break;
                ++i;
            }
            if (i >= count) {
                return -1;
            }
            namelast = i;
            while (i < count) {
                c = p.charAt(i);
                if (c != ' ' && c != '\t' && c != '\f' && c != '\n' && c != '\r' && c != '\u000b') break;
                ++i;
            }
            if (i >= count) {
                return -1;
            }
            if (p.charAt(i) != '=') {
                return -1;
            }
            if (++i < count) ** GOTO lbl32
            return -1;
            while ((c = p.charAt(i)) == ' ' || c == '\t' || c == '\f' || c == '\n' || c == '\r' || c == '\u000b') {
                ++i;
lbl32:
                // 2 sources

                if (i < count) continue;
            }
            if (i >= count) {
                return -1;
            }
            if (p.charAt(i) == '\'') {
                delimiter = p.charAt(i);
                ++i;
            }
            if (i >= count) {
                return -1;
            }
            valuestart = i;
            if (delimiter != '\u0000') ** GOTO lbl51
            while (i < count) {
                c = p.charAt(i);
                if (c != ' ' && c != ';' && c != '\t' && c != '\f' && c != '\n' && c != '\r' && c != '\u000b') {
                    ++i;
                    continue;
                }
                break block15;
            }
            break block15;
            while ((c = p.charAt(i)) != delimiter) {
                ++i;
lbl51:
                // 2 sources

                if (i < count) continue;
            }
        }
        valuelast = i;
        if (i < count && p.charAt(i) == delimiter) {
            ++i;
        }
        name[0] = p.substring(namestart, namelast);
        value[0] = p.substring(valuestart, valuelast);
        return i;
    }

    private static boolean getBool(String s, int idx, boolean[] ret) {
        int count = s.length();
        if (idx < count) {
            char c = s.charAt(idx);
            if (c == 'T' || c == 't') {
                if (idx + 4 > count) {
                    return false;
                }
                String v = s.substring(idx + 1, idx + 4);
                if ("rue".equalsIgnoreCase(v)) {
                    ret[0] = true;
                    return true;
                }
            } else if (c == 'F' || c == 'f') {
                if (idx + 5 > count) {
                    return false;
                }
                String v = s.substring(idx + 1, idx + 5);
                if ("alse".equalsIgnoreCase(v)) {
                    ret[0] = false;
                    return true;
                }
            } else if (c == 'Y' || c == 'y') {
                if (idx + 3 > count) {
                    return false;
                }
                String v = s.substring(idx + 1, idx + 3);
                if ("es".equalsIgnoreCase(v)) {
                    ret[0] = true;
                    return true;
                }
            } else if (c == 'N' || c == 'n') {
                if (idx + 2 > count) {
                    return false;
                }
                c = s.charAt(idx + 1);
                if (c == 'o' || c == 'O') {
                    ret[0] = false;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean getCondition(String s, int idx, int[] ret) {
        int count = s.length();
        if (idx + 2 > count) {
            return false;
        }
        String v = s.substring(idx, idx + 2);
        if ("no".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcNone;
            return true;
        }
        if ("eq".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcEqual;
            return true;
        }
        if ("ne".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcNotEqual;
            return true;
        }
        if ("gt".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcGreater;
            return true;
        }
        if ("ge".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcGreaterOrEqual;
            return true;
        }
        if ("lt".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcLesser;
            return true;
        }
        if ("le".equalsIgnoreCase(v)) {
            ret[0] = WaveLoopLink.llcLesserOrEqual;
            return true;
        }
        return false;
    }

    private static boolean getInt(String s, int idx, int[] ret) {
        int count = s.length();
        int r = 0;
        boolean sign = false;
        while (idx < count && s.charAt(idx) <= ' ') {
            ++idx;
        }
        if (idx >= count) {
            return false;
        }
        if (s.charAt(idx) == '-') {
            sign = true;
            ++idx;
            while (idx < count && s.charAt(idx) <= ' ') {
                ++idx;
            }
            if (idx >= count) {
                return false;
            }
        }
        char c = s.charAt(idx);
        while (idx < count && c >= '0' && c <= '9') {
            r *= 10;
            r += c - 48;
            if (++idx >= count) continue;
            c = s.charAt(idx);
        }
        if (sign) {
            r = -r;
        }
        ret[0] = r;
        return true;
    }

    private static boolean getInt64(String s, int idx, long[] ret) {
        int count = s.length();
        long r = 0L;
        boolean sign = false;
        while (idx < count && s.charAt(idx) <= ' ') {
            ++idx;
        }
        if (idx >= count) {
            return false;
        }
        if (s.charAt(idx) == '-') {
            sign = true;
            ++idx;
            while (idx < count && s.charAt(idx) <= ' ') {
                ++idx;
            }
            if (idx >= count) {
                return false;
            }
        }
        char c = s.charAt(idx);
        while (idx < count && c >= '0' && c <= '9') {
            r *= 10L;
            r += (long)(c - 48);
            if (++idx >= count) continue;
            c = s.charAt(idx);
        }
        if (sign) {
            r = -r;
        }
        ret[0] = r;
        return true;
    }
}

