/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.sound;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2env.SoundEventTimer;
import jp.kirikiri.tvp2env.SoundStream;

public class WaveSoundBufferNI
extends NativeInstanceObject {
    public static final int SB_BEAT_INTERVAL = 60;
    public static final int ssUnload = 0;
    public static final int ssStop = 1;
    public static final int ssPlay = 2;
    public static final int ssPause = 3;
    private static final String UNLOAD = "unload";
    private static final String PLAY = "play";
    private static final String STOP = "stop";
    private static final String UNKNOWN = "unknown";
    private static final String ON_STATUS_CHANGED = "onStatusChanged";
    private WeakReference<Dispatch2> mOwner;
    private VariantClosure mActionOwner = new VariantClosure(null);
    private int mStatus;
    private boolean mCanDeliverEvents = true;
    private boolean mInFading;
    private int mTargetVolume;
    private int mDeltaVolume;
    private int mFadeCount;
    private int mBlankLeft;
    private int mVolume = 100000;
    private int mVolume2 = 100000;
    private SoundStream mSoundStream;
    private static SoundEventTimer mSoundBufferTimer;
    private static ArrayList<WaveSoundBufferNI> mSoundBufferVector;
    private static final String ON_LABEL = "onLabel";
    private static final String onFadeCompleted = "onFadeCompleted";

    public static void initialize() {
        mSoundBufferVector = new ArrayList();
        mSoundBufferTimer = new SoundEventTimer();
    }

    public static void finalizeApplication() {
        mSoundBufferVector = null;
        mSoundBufferTimer = null;
    }

    public static void doSoundEvents() {
        int count = mSoundBufferVector.size();
        int i = 0;
        while (i < count) {
            WaveSoundBufferNI w = mSoundBufferVector.get(i);
            if (w != null) {
                w.timerBeatHandler();
            }
            ++i;
        }
    }

    public static void addSoundBuffer(WaveSoundBufferNI buf) {
        if (mSoundBufferVector.size() == 0) {
            mSoundBufferTimer.startIfStop();
        }
        mSoundBufferVector.add(buf);
    }

    public static void removeSoundBuffer(WaveSoundBufferNI buf) {
        if (mSoundBufferVector.size() != 0) {
            mSoundBufferVector.remove(buf);
        }
        if (mSoundBufferVector.size() == 0) {
            mSoundBufferTimer.stop();
        }
    }

    @Override
    public final int construct(Variant[] param, Dispatch2 tjs_obj) throws VariantException, TJSException {
        if (param.length < 1) {
            return -1004;
        }
        int hr = super.construct(param, tjs_obj);
        if (hr < 0) {
            return hr;
        }
        this.mActionOwner.set(param[0].asObjectClosure());
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        this.mSoundStream = new SoundStream(this);
        WaveSoundBufferNI.addSoundBuffer(this);
        return 0;
    }

    @Override
    public final void invalidate() throws VariantException, TJSException {
        WaveSoundBufferNI.removeSoundBuffer(this);
        this.mCanDeliverEvents = false;
        TVP.EventManager.cancelSourceEvents((Dispatch2)this.mOwner.get());
        this.mOwner.clear();
        this.mActionOwner.mObject = null;
        this.mActionOwner.mObjThis = null;
        this.mSoundStream = null;
        super.invalidate();
    }

    public void invokeLabelEvent(String name) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && this.mCanDeliverEvents) {
            Variant[] param = new Variant[]{new Variant(name)};
            TVP.EventManager.postEvent(owner, owner, ON_LABEL, 0, 0, param);
        }
    }

    public void open(String storagename) throws TJSException {
        this.mSoundStream.stop();
        BinaryStream stream = Storage.createStream(storagename, 0);
        try {
            this.mSoundStream.openFromStream(stream, storagename);
        }
        catch (IOException e) {
            Message.throwExceptionMessage("\u30b5\u30a6\u30f3\u30c9\u30d5\u30a1\u30a4\u30eb %1 \u3092\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", storagename);
        }
    }

    public void play() {
        this.setVolumeToSoundBuffer();
        this.mSoundStream.play();
        this.setStatus(2);
    }

    public void stop() {
        this.mSoundStream.stop();
        if (this.mStatus != 0) {
            this.setStatus(1);
        }
    }

    public void timerBeatHandler() {
        if (this.mOwner.get() == null) {
            return;
        }
        if (!this.mInFading) {
            return;
        }
        if (this.mBlankLeft != 0) {
            this.mBlankLeft -= 60;
            if (this.mBlankLeft < 0) {
                this.mBlankLeft = 0;
            }
        } else if (this.mFadeCount != 0) {
            if (this.mFadeCount == 1) {
                this.stopFade(true, true);
            } else {
                --this.mFadeCount;
                int v = this.getVolume();
                if ((v += this.mDeltaVolume) < 0) {
                    v = 0;
                }
                if (v > 100000) {
                    v = 100000;
                }
                this.setVolume(v);
            }
        }
    }

    public void fade(int to, int time, int blanktime) throws TJSException {
        if (this.mOwner.get() == null) {
            return;
        }
        if (time <= 0 || blanktime < 0) {
            Message.throwExceptionMessage("\u4e0d\u6b63\u306a\u30d1\u30e9\u30e1\u30fc\u30bf\u3067\u3059");
        }
        if (this.mInFading) {
            this.stopFade(false, false);
        }
        this.mDeltaVolume = (to - this.getVolume()) * 60 / time;
        if (this.mDeltaVolume == 0) {
            this.mDeltaVolume = 1;
        }
        this.mTargetVolume = to;
        this.mFadeCount = time / 60;
        this.mBlankLeft = blanktime;
        this.mInFading = true;
        if (this.mFadeCount == 0 && this.mBlankLeft == 0) {
            this.stopFade(false, true);
        }
    }

    public void stopFade(boolean async, boolean settargetvol) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner == null) {
            return;
        }
        if (this.mInFading) {
            this.mInFading = false;
            if (settargetvol) {
                this.setVolume(this.mTargetVolume);
            }
            if (this.mCanDeliverEvents) {
                TVP.EventManager.postEvent(owner, owner, onFadeCompleted, 0, async ? 0 : 2, TJS.NULL_ARG);
            }
        }
    }

    public VariantClosure getActionOwner() {
        return this.mActionOwner;
    }

    public boolean getLooping() {
        return this.mSoundStream.getLooping();
    }

    public void setLooping(boolean b) {
        this.mSoundStream.setLooping(b);
    }

    public boolean getPaused() {
        return this.mSoundStream.getPaused();
    }

    public void setPaused(boolean b) {
        this.mSoundStream.setPaused(b);
    }

    public int getPan() {
        return this.mSoundStream.getPan();
    }

    public void setPan(int v) {
        this.mSoundStream.setPan(v);
    }

    public int getPosition() {
        return this.mSoundStream.getPosition();
    }

    public void setPosition(int pos) {
        this.mSoundStream.setPosition(pos);
    }

    public int getSamplePosition() {
        return this.mSoundStream.getSamplePosition();
    }

    public void setSamplePosition(int sample) {
        this.mSoundStream.setSamplePosition(sample);
    }

    public int getTotalTime() {
        return this.mSoundStream.getTotalTime();
    }

    public int getVolume() {
        return this.mVolume;
    }

    public void setVolume(int v) {
        if (v < 0) {
            v = 0;
        }
        if (v > 100000) {
            v = 100000;
        }
        if (this.mVolume != v) {
            this.mVolume = v;
            this.setVolumeToSoundBuffer();
        }
    }

    public int getVolume2() {
        return this.mVolume2;
    }

    public void setVolume2(int v) {
        if (v < 0) {
            v = 0;
        }
        if (v > 100000) {
            v = 100000;
        }
        if (this.mVolume2 != v) {
            this.mVolume2 = v;
            this.setVolumeToSoundBuffer();
        }
    }

    private void setVolumeToSoundBuffer() {
        int v = this.mVolume / 10 * (this.mVolume2 / 10) / 1000;
        this.mSoundStream.setVolume(v);
    }

    public void setPos(double x, double y, double z) {
    }

    public int getPosX() {
        return 0;
    }

    public void setPosX(double x) {
    }

    public double getPosY() {
        return 0.0;
    }

    public void setPosY(double y) {
    }

    public double getPosZ() {
        return 0.0;
    }

    public void setPosZ(double z) {
    }

    public String getStatusString() {
        switch (this.mStatus) {
            case 0: {
                return UNLOAD;
            }
            case 2: {
                return PLAY;
            }
            case 1: {
                return STOP;
            }
        }
        return UNKNOWN;
    }

    public void setStatus(int s) {
        if (this.mStatus != s) {
            this.mStatus = s;
            Dispatch2 owner = (Dispatch2)this.mOwner.get();
            if (owner != null) {
                TVP.EventManager.cancelSourceEvents(owner);
                if (this.mCanDeliverEvents) {
                    Variant param = new Variant(this.getStatusString());
                    Variant[] params = new Variant[]{param};
                    TVP.EventManager.postEvent(owner, owner, ON_STATUS_CHANGED, 0, 2, params);
                }
            }
        }
    }

    public void setStatusAsync(int s) {
        if (this.mStatus != s) {
            Dispatch2 owner;
            this.mStatus = s;
            if (this.mCanDeliverEvents && (owner = (Dispatch2)this.mOwner.get()) != null) {
                Variant param = new Variant(this.getStatusString());
                Variant[] params = new Variant[]{param};
                TVP.EventManager.postEvent(owner, owner, ON_STATUS_CHANGED, 0, 0, params);
            }
        }
    }

    public int getFrequency() {
        return this.mSoundStream.getFrequency();
    }

    public void setFrequency(int freq) {
        this.mSoundStream.setFrequency(freq);
    }

    public int getBitsPerSample() {
        return this.mSoundStream.getBitsPerSample();
    }

    public int getChannels() {
        return this.mSoundStream.getChannels();
    }

    public Dispatch2 getWaveFlagsObject() {
        return null;
    }

    public Dispatch2 getWaveLabelsObject() {
        return null;
    }

    public Dispatch2 getWaveFiltersObject() {
        return null;
    }
}

