/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.ListIterator;
import jp.kirikiri.tjs2.ConsoleOutput;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.LogStreamHolder;
import jp.kirikiri.tvp2env.ApplicationSystem;
import jp.kirikiri.tvp2env.DefaultLogger;

public class DebugLog {
    private static boolean QUEUEING_LOG = true;
    private static boolean LOG_TIMESTAMP = true;
    private LinkedList<LogItem> mLogDeque;
    private int mLogMaxLines;
    private boolean mAutoLogToFileOnError;
    private boolean mAutoClearLogOnError;
    private boolean mLoggingToFile;
    private String mLogLocation;
    private String mNativeLogLocation;
    private String mDumpOutFileName;
    private LogStreamHolder mLogStreamHolder;
    private int mLogToFileRollBack;
    private StringBuilder mImportantLogs;
    private StringBuilder mWorkBuilder;
    private StringBuilder mLastLogWorkBuilder;
    private ConsoleOutput mOnLog;
    private Calendar mCalendar;
    private int mPrevHour;
    private int mPrevMinute;
    private int mPrevSecond;
    private String mTimeBuf;
    private static final String SEPARATOR = "\n------------------------------------------------------------------------------\n";

    public DebugLog() {
        String tmp = TVP.Properties.getProperty("log_queueing", "true");
        QUEUEING_LOG = "true".equalsIgnoreCase(tmp) || "yes".equalsIgnoreCase(tmp);
        tmp = TVP.Properties.getProperty("log_timestamp", "true");
        LOG_TIMESTAMP = "true".equalsIgnoreCase(tmp) || "yes".equalsIgnoreCase(tmp);
        this.mLogDeque = new LinkedList();
        this.mAutoLogToFileOnError = true;
        tmp = TVP.Properties.getProperty("log_to_file_roll_back", "100");
        this.mLogToFileRollBack = Integer.valueOf(tmp);
        tmp = TVP.Properties.getProperty("log_max_lines", "2048");
        this.mLogMaxLines = Integer.valueOf(tmp);
        this.mImportantLogs = new StringBuilder(128);
        this.mWorkBuilder = new StringBuilder(128);
        this.mLastLogWorkBuilder = new StringBuilder(128);
        this.mLogStreamHolder = new LogStreamHolder();
        this.mCalendar = Calendar.getInstance();
        this.mPrevHour = -1;
        this.mPrevMinute = -1;
        this.mPrevSecond = -1;
        this.mOnLog = new DefaultLogger();
    }

    public boolean enableLogLoacation() {
        return this.mLogLocation != null && this.mLogLocation.length() != 0;
    }

    public String getNativeLogLocation() {
        return this.mNativeLogLocation;
    }

    public void addLog(String line) {
        this.addLog(line, false);
    }

    public void addImportantLog(String line) {
        this.addLog(line, true);
    }

    public String getImportantLog() {
        if (this.mImportantLogs == null) {
            return "";
        }
        return this.mImportantLogs.toString();
    }

    public void addLog(String line, boolean appendtoimportant) {
        if (this.mLogDeque == null) {
            return;
        }
        if (this.mImportantLogs == null) {
            return;
        }
        if (LOG_TIMESTAMP) {
            this.mCalendar.setTimeInMillis(System.currentTimeMillis());
            int h = this.mCalendar.get(11);
            int m = this.mCalendar.get(12);
            int s = this.mCalendar.get(13);
            if (this.mPrevSecond != s || this.mPrevMinute != m || this.mPrevHour != h) {
                this.mTimeBuf = String.format("%02d:%02d:%02d", h, m, s);
                this.mPrevHour = h;
                this.mPrevMinute = m;
                this.mPrevSecond = s;
            }
        }
        if (QUEUEING_LOG) {
            this.mLogDeque.addLast(new LogItem(line, this.mTimeBuf));
        }
        if (appendtoimportant) {
            if (LOG_TIMESTAMP) {
                this.mImportantLogs.append(this.mTimeBuf);
            }
            this.mImportantLogs.append(" ! ");
            this.mImportantLogs.append(line);
            this.mImportantLogs.append("\n");
        }
        if (QUEUEING_LOG) {
            while (this.mLogDeque.size() >= this.mLogMaxLines + 100) {
                int i = 0;
                while (i < 100) {
                    this.mLogDeque.removeFirst();
                    ++i;
                }
            }
        }
        if (LOG_TIMESTAMP) {
            this.mWorkBuilder.append(this.mTimeBuf);
            this.mWorkBuilder.append(' ');
        }
        this.mWorkBuilder.append(line);
        String buf = this.mWorkBuilder.toString();
        this.mWorkBuilder.delete(0, this.mWorkBuilder.length());
        if (this.mOnLog != null) {
            this.mOnLog.print(buf);
        }
        if (this.mLoggingToFile) {
            TVP.LogStreamHolder.log(buf);
        }
    }

    public void setLogLocation(String loc) throws TJSException {
        String logerror;
        this.mLogLocation = TVP.StorageMediaManager.normalizeStorageName(loc, null);
        String nativepath = TVP.StorageMediaManager.getLocallyAccessibleName(this.mLogLocation);
        if (nativepath.length() == 0) {
            this.mNativeLogLocation = null;
            this.mLogLocation = null;
        } else {
            char last = nativepath.charAt(nativepath.length() - 1);
            this.mNativeLogLocation = last != File.separatorChar ? String.valueOf(nativepath) + File.separatorChar : nativepath;
        }
        this.mLogStreamHolder.reopen();
        String forcelog = TVP.Properties.getProperty("forcelog", "no");
        if (!"no".equals(forcelog)) {
            if ("yes".equals(forcelog)) {
                this.mLoggingToFile = false;
                this.startLogToFile(false);
            } else if ("clear".equals(forcelog)) {
                this.mLoggingToFile = false;
                this.startLogToFile(true);
            }
        }
        if (!"yes".equals(logerror = TVP.Properties.getProperty("logerror", "yes"))) {
            if ("no".equals(logerror)) {
                this.mAutoClearLogOnError = false;
                this.mAutoLogToFileOnError = false;
            } else if ("clear".equals(logerror)) {
                this.mAutoClearLogOnError = true;
                this.mAutoLogToFileOnError = true;
            }
        }
    }

    void startLogToFile(boolean clear) {
        if (this.mImportantLogs == null) {
            return;
        }
        if (this.mLoggingToFile) {
            return;
        }
        if (clear) {
            this.mLogStreamHolder.clear();
        }
        this.mLogStreamHolder.log(this.mImportantLogs.toString());
        this.mLogStreamHolder.log(SEPARATOR);
        String content = this.getLastLog(this.mLogToFileRollBack);
        this.mLogStreamHolder.log(content);
        this.mLoggingToFile = true;
    }

    private String getLastLog(int n) {
        if (this.mLogDeque == null) {
            return "";
        }
        int size = this.mLogDeque.size();
        if (n > size) {
            n = size;
        }
        if (n == 0) {
            return "";
        }
        ListIterator<LogItem> iter = this.mLogDeque.listIterator(size - n);
        while (iter.hasNext()) {
            LogItem item = iter.next();
            this.mLastLogWorkBuilder.append(item.Time);
            this.mLastLogWorkBuilder.append(' ');
            this.mLastLogWorkBuilder.append(item.Log);
            this.mLastLogWorkBuilder.append('\n');
        }
        String buf = this.mLastLogWorkBuilder.toString();
        this.mLastLogWorkBuilder.delete(0, this.mLastLogWorkBuilder.length());
        return buf;
    }

    public void startDump() throws TJSException {
        String path = ApplicationSystem.getNativeAppPath();
        char last = path.charAt(path.length() - 1);
        if (last != '/' && last != '\\') {
            path = String.valueOf(path) + File.separatorChar;
        }
        this.mDumpOutFileName = path = String.valueOf(path) + "dump.txt";
        try {
            TVP.DumpOutputStream = new FileOutputStream(path, true);
            byte[] buf = new byte[]{-1, -2};
            TVP.DumpOutputStream.write(buf);
        }
        catch (FileNotFoundException e) {
            Message.throwExceptionMessage("\u30b9\u30c8\u30ec\u30fc\u30b8 %1 \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", e.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void endDump() {
        if (TVP.DumpOutputStream != null) {
            try {
                TVP.DumpOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TVP.DumpOutputStream = null;
            this.addLog("Dumped to " + this.mDumpOutFileName);
        }
    }

    public void onError() {
        if (this.mAutoLogToFileOnError) {
            this.startLogToFile(this.mAutoClearLogOnError);
        }
    }

    public String getLogLocation() {
        return this.mLogLocation;
    }

    public boolean getAutoLogToFileOnError() {
        return this.mAutoLogToFileOnError;
    }

    public void setAutoLogToFileOnError(boolean b) {
        this.mAutoLogToFileOnError = b;
    }

    public boolean getAutoClearLogOnError() {
        return this.mAutoClearLogOnError;
    }

    public void setAutoClearLogOnError(boolean b) {
        this.mAutoClearLogOnError = b;
    }

    static class LogItem {
        public String Log;
        public String Time;

        public LogItem(String log, String time) {
            this.Log = log;
            this.Time = time;
        }
    }
}

