/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.CompileException;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.IntVector;
import jp.kirikiri.tjs2.IntWrapper;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.ScriptsClass;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.ScenarioCacheItem;

public class KAGParserNI
extends NativeInstanceObject {
    private static final int tkdlSimple = 1;
    private static final int tkdlVerbose = 2;
    private WeakReference<Dispatch2> mOwner;
    private Dispatch2 mDicClear;
    private Dispatch2 mDicAssign;
    private Dispatch2 mDicObj;
    private Dispatch2 mMacros;
    private ArrayList<Dispatch2> mMacroArgs;
    private int mMacroArgStackDepth;
    private int mMacroArgStackBase;
    private ArrayList<CallStackData> mCallStack;
    private ScenarioCacheItem mScenario;
    private String[] mLines;
    private int mLineCount;
    private String mStorageName;
    private String mStorageShortName;
    private int mCurLine;
    private int mCurPos;
    private String mCurLineStr;
    private String mLineBuffer;
    private boolean mLineBufferUsing;
    private String mCurLabel;
    private String mCurPage;
    private int mTagLine;
    private int mDebugLevel = 1;
    private boolean mProcessSpecialTags = true;
    private boolean mIgnoreCR;
    private boolean mRecordingMacro;
    private StringBuilder mRecordingMacroStr = new StringBuilder();
    private String mRecordingMacroName;
    private StringBuilder mWorkBuilder = new StringBuilder();
    private Variant mValueVariant;
    private int mExcludeLevel;
    private int mIfLevel;
    private IntVector mExcludeLevelStack;
    private ArrayList<Boolean> mIfLevelExecutedStack = new ArrayList();
    private boolean mInterrupted;
    private static final String HEX = "0123456789abcdef";
    private static final String BIT = "01";
    private static String __tag_name;
    private static String __eol_name;
    private static String __storage_name;
    private static String __target_name;
    private static String __exp_name;
    private static String STR_TEXT;
    private static String EV_ON_JUMP;
    private static String EV_ON_CALL;
    private static String EV_ON_RETURN;
    private static String EV_ON_AFTERETURN;
    private static String EV_ON_LABEL;
    private static String EV_ON_SCENARIO_LOAD;
    private static String EV_ON_SCENARIO_LOADED;
    private static String EV_ON_SCRIPT;
    private static Variant TAG_INTERRUPT;
    private static Variant TAG_R;
    private static Variant TAG_CH;
    private static Variant VAL_TRUE;
    private static HashMap<String, SpecialTags> special_tags_hash;

    public KAGParserNI() throws VariantException, TJSException {
        this.mExcludeLevelStack = new IntVector();
        this.mCallStack = new ArrayList();
        this.mMacroArgs = new ArrayList();
        this.mValueVariant = new Variant();
        Holder<Object> holder = new Holder<Object>(null);
        this.mDicObj = TJS.createDictionaryObject(holder);
        this.mMacros = TJS.createDictionaryObject();
        Dispatch2 dictclass = (Dispatch2)holder.mValue;
        holder.mValue = null;
        try {
            Variant val = new Variant();
            int er = dictclass.propGet(0, "clear", val, dictclass);
            if (er < 0) {
                Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            }
            this.mDicClear = val.asObject();
            er = dictclass.propGet(0, "assign", val, dictclass);
            if (er < 0) {
                Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            }
            this.mDicAssign = val.asObject();
        }
        catch (TJSException e) {
            dictclass = null;
            this.mDicObj = null;
            this.mMacros = null;
            this.mDicClear = null;
            this.mDicAssign = null;
            throw e;
        }
        dictclass = null;
    }

    @Override
    public int construct(Variant[] param, Dispatch2 tjsObj) throws VariantException, TJSException {
        int hr = super.construct(param, tjsObj);
        if (hr < 0) {
            return hr;
        }
        this.mOwner = new WeakReference<Dispatch2>(tjsObj);
        return 0;
    }

    @Override
    public void invalidate() throws VariantException, TJSException {
        this.mDicAssign = null;
        this.mDicClear = null;
        this.mDicObj = null;
        this.mMacros = null;
        this.clearMacroArgs();
        this.clearBuffer();
        this.mOwner.clear();
        super.invalidate();
    }

    public void copy(KAGParserNI ref) throws VariantException, TJSException {
        Variant src = new Variant(ref.mMacros, ref.mMacros);
        Variant[] psrc = new Variant[]{src};
        this.mDicAssign.funcCall(0, null, null, psrc, this.mMacros);
        this.clearMacroArgs();
        int i = 0;
        while (i < ref.mMacroArgStackDepth) {
            Variant src2;
            Dispatch2 dic = TJS.createDictionaryObject();
            Dispatch2 isrc = ref.mMacroArgs.get(i);
            psrc[0] = src2 = new Variant(isrc, isrc);
            this.mDicAssign.funcCall(0, null, null, psrc, dic);
            this.mMacroArgs.add(dic);
            ++i;
        }
        this.mMacroArgStackDepth = ref.mMacroArgStackDepth;
        this.mMacroArgStackBase = ref.mMacroArgStackBase;
        int count = ref.mCallStack.size();
        this.mCallStack = new ArrayList(count);
        int i2 = 0;
        while (i2 < count) {
            this.mCallStack.add(new CallStackData(ref.mCallStack.get(i2)));
            ++i2;
        }
        this.mStorageName = ref.mStorageName;
        this.mStorageShortName = ref.mStorageShortName;
        if (this.mScenario != ref.mScenario) {
            if (this.mScenario != null) {
                this.mScenario = null;
                this.mLines = null;
                this.mCurLineStr = null;
            }
            this.mScenario = ref.mScenario;
            this.mLines = ref.mLines;
            this.mLineCount = ref.mLineCount;
        }
        this.mCurLine = ref.mCurLine;
        this.mCurPos = ref.mCurPos;
        this.mCurLineStr = ref.mCurLineStr;
        this.mLineBuffer = ref.mLineBuffer;
        this.mLineBufferUsing = ref.mLineBufferUsing;
        this.mCurLabel = ref.mCurLabel;
        this.mCurPage = ref.mCurPage;
        this.mTagLine = ref.mTagLine;
        this.mDebugLevel = ref.mDebugLevel;
        this.mIgnoreCR = ref.mIgnoreCR;
        this.mRecordingMacro = ref.mRecordingMacro;
        this.mRecordingMacroStr.delete(0, this.mRecordingMacroStr.length());
        this.mRecordingMacroStr.append(ref.mRecordingMacroStr.toString());
        this.mRecordingMacroName = ref.mRecordingMacroName;
        this.mExcludeLevel = ref.mExcludeLevel;
        this.mIfLevel = ref.mIfLevel;
        this.mExcludeLevelStack = ref.mExcludeLevelStack.clone();
        this.mIfLevelExecutedStack = (ArrayList)ref.mIfLevelExecutedStack.clone();
    }

    public Dispatch2 store() throws TJSException {
        Dispatch2 dic = TJS.createDictionaryObject();
        try {
            Variant src;
            Variant val = new Variant();
            Variant[] psrc = new Variant[1];
            Dispatch2 dsp = TJS.createDictionaryObject();
            Variant tmp = new Variant(dsp, dsp);
            dic.propSet(512, "macros", tmp, dic);
            psrc[0] = src = new Variant(this.mMacros, this.mMacros);
            this.mDicAssign.funcCall(0, null, null, psrc, dsp);
            dsp = TJS.createArrayObject();
            tmp = new Variant(dsp, dsp);
            dic.propSet(512, "macroArgs", tmp, dic);
            int i = 0;
            while (i < this.mMacroArgStackDepth) {
                Variant src2;
                Dispatch2 dic1 = TJS.createDictionaryObject();
                tmp.set(dic1, dic1);
                dsp.propSetByNum(512, i, tmp, dsp);
                Dispatch2 isrc = this.mMacroArgs.get(i);
                psrc[0] = src2 = new Variant(isrc, isrc);
                this.mDicAssign.funcCall(0, null, null, psrc, dic1);
                ++i;
            }
            dsp = TJS.createArrayObject();
            tmp = new Variant(dsp, dsp);
            dic.propSet(512, "callStack", tmp, dic);
            int size = this.mCallStack.size();
            int i2 = 0;
            while (i2 < size) {
                CallStackData d = this.mCallStack.get(i2);
                Dispatch2 dic1 = TJS.createDictionaryObject();
                tmp.set(dic1, dic1);
                dsp.propSetByNum(512, i2, tmp, dsp);
                val.set(d.Storage);
                dic1.propSet(512, "storage", val, dic1);
                val.set(d.Label);
                dic1.propSet(512, "label", val, dic1);
                val.set(d.Offset);
                dic1.propSet(512, "offset", val, dic1);
                val.set(d.OrgLineStr);
                dic1.propSet(512, "orgLineStr", val, dic1);
                val.set(d.LineBuffer);
                dic1.propSet(512, "lineBuffer", val, dic1);
                val.set(d.Pos);
                dic1.propSet(512, "pos", val, dic1);
                val.set(d.LineBufferUsing ? 1 : 0);
                dic1.propSet(512, "lineBufferUsing", val, dic1);
                val.set(d.MacroArgStackBase);
                dic1.propSet(512, "macroArgStackBase", val, dic1);
                val.set(d.MacroArgStackDepth);
                dic1.propSet(512, "macroArgStackDepth", val, dic1);
                val.set(d.ExcludeLevel);
                dic1.propSet(512, "ExcludeLevel", val, dic1);
                val.set(d.IfLevel);
                dic1.propSet(512, "IfLevel", val, dic1);
                this.storeIntStackToDic(dic1, d.ExcludeLevelStack, "ExcludeLevelStack");
                this.storeBoolStackToDic(dic1, d.IfLevelExecutedStack, "IfLevelExecutedStack");
                ++i2;
            }
            val.set(this.mStorageName);
            dic.propSet(512, "storageName", val, dic);
            val.set(this.mStorageShortName);
            dic.propSet(512, "storageShortName", val, dic);
            val.set(this.mCurLine);
            dic.propSet(512, "curLine", val, dic);
            val.set(this.mCurPos);
            dic.propSet(512, "curPos", val, dic);
            val.set(this.mLineBuffer);
            dic.propSet(512, "lineBuffer", val, dic);
            val.set(this.mLineBufferUsing ? 1 : 0);
            dic.propSet(512, "lineBufferUsing", val, dic);
            val.set(this.mCurLabel);
            dic.propSet(512, "curLabel", val, dic);
            val.set(this.mExcludeLevel);
            dic.propSet(512, "ExcludeLevel", val, dic);
            val.set(this.mIfLevel);
            dic.propSet(512, "IfLevel", val, dic);
            this.storeIntStackToDic(dic, this.mExcludeLevelStack, "ExcludeLevelStack");
            this.storeBoolStackToDic(dic, this.mIfLevelExecutedStack, "IfLevelExecutedStack");
            val.set(this.mMacroArgStackBase);
            dic.propSet(512, "macroArgStackBase", val, dic);
            val.set(this.mMacroArgStackDepth);
            dic.propSet(512, "macroArgStackDepth", val, dic);
        }
        catch (TJSException e) {
            dic = null;
            throw e;
        }
        return dic;
    }

    private void storeIntStackToDic(Dispatch2 dic, IntVector stack, String membername) throws VariantException, TJSException {
        StringBuilder p = this.mWorkBuilder;
        p.delete(0, p.length());
        int count = stack.size();
        int i = 0;
        while (i < count) {
            int v = stack.get(i);
            p.append(HEX.charAt(v >> 28 & 0xF));
            p.append(HEX.charAt(v >> 24 & 0xF));
            p.append(HEX.charAt(v >> 20 & 0xF));
            p.append(HEX.charAt(v >> 16 & 0xF));
            p.append(HEX.charAt(v >> 12 & 0xF));
            p.append(HEX.charAt(v >> 8 & 0xF));
            p.append(HEX.charAt(v >> 4 & 0xF));
            p.append(HEX.charAt(v >> 0 & 0xF));
            ++i;
        }
        Variant val = new Variant(p.toString());
        p = null;
        dic.propSet(512, membername, val, dic);
    }

    private void restoreIntStackFromStr(IntVector stack, String str) {
        stack.clear();
        int len = str.length() / 8;
        int i = 0;
        while (i < len) {
            stack.add((str.charAt(0) <= '9' ? str.charAt(0) - 48 : str.charAt(0) - 97 + 10) << 28 | (str.charAt(1) <= '9' ? str.charAt(1) - 48 : str.charAt(1) - 97 + 10) << 24 | (str.charAt(2) <= '9' ? str.charAt(2) - 48 : str.charAt(2) - 97 + 10) << 20 | (str.charAt(3) <= '9' ? str.charAt(3) - 48 : str.charAt(3) - 97 + 10) << 16 | (str.charAt(4) <= '9' ? str.charAt(4) - 48 : str.charAt(4) - 97 + 10) << 12 | (str.charAt(5) <= '9' ? str.charAt(5) - 48 : str.charAt(5) - 97 + 10) << 8 | (str.charAt(6) <= '9' ? str.charAt(6) - 48 : str.charAt(6) - 97 + 10) << 4 | (str.charAt(7) <= '9' ? str.charAt(7) - 48 : str.charAt(7) - 97 + 10) << 0);
            ++i;
        }
    }

    private void restoreBoolStackFromStr(ArrayList<Boolean> stack, String str) {
        stack.clear();
        int len = str.length();
        int i = 0;
        while (i < len) {
            stack.add(str.charAt(i) == '1');
            ++i;
        }
    }

    private void storeBoolStackToDic(Dispatch2 dic, ArrayList<Boolean> stack, String membername) throws VariantException, TJSException {
        int count = stack.size();
        StringBuilder builder = this.mWorkBuilder;
        builder.delete(0, builder.length());
        int i = 0;
        while (i < count) {
            builder.append(BIT.charAt(stack.get(i) != false ? 1 : 0));
            ++i;
        }
        Variant val = new Variant(builder.toString());
        builder = null;
        dic.propSet(512, membername, val, dic);
    }

    public void restore(Dispatch2 dic) throws VariantException, TJSException {
        int i;
        int count;
        VariantClosure clo;
        Variant val = new Variant();
        Variant v = new Variant();
        Variant[] psrc = new Variant[1];
        dic.propGet(0, "macros", val, dic);
        if (!val.isVoid()) {
            psrc[0] = val;
            this.mDicAssign.funcCall(0, null, null, psrc, this.mMacros);
        }
        this.mMacroArgStackDepth = 0;
        val.clear();
        dic.propGet(0, "macroArgs", val, dic);
        if (!val.isVoid()) {
            clo = val.asObjectClosure();
            count = 0;
            clo.propGet(0, "count", v, null);
            count = v.asInteger();
            this.clearMacroArgs();
            val.clear();
            dic.propGet(0, "macroArgStackDepth", val, dic);
            if (!val.isVoid()) {
                this.mMacroArgStackDepth = val.asInteger();
            }
            i = 0;
            while (i < count) {
                Dispatch2 dsp = TJS.createDictionaryObject();
                clo.propGetByNum(0, i, v, null);
                psrc[0] = v;
                this.mDicAssign.funcCall(0, null, null, psrc, dsp);
                this.mMacroArgs.add(dsp);
                ++i;
            }
        }
        if (this.mMacroArgStackDepth != this.mMacroArgs.size()) {
            Message.throwExceptionMessage("\u681e\u30c7\u30fc\u30bf\u304c\u7570\u5e38\u3067\u3059\u3002\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
        this.mMacroArgStackBase = this.mMacroArgs.size();
        val.clear();
        dic.propGet(0, "callStack", val, dic);
        if (!val.isVoid()) {
            clo = val.asObjectClosure();
            count = 0;
            v.clear();
            clo.propGet(0, "count", v, null);
            count = v.asInteger();
            this.mCallStack.clear();
            i = 0;
            while (i < count) {
                IntVector ExcludeLevelStack = new IntVector();
                ArrayList<Boolean> IfLevelExecutedStack = new ArrayList<Boolean>();
                clo.propGetByNum(0, i, v, null);
                VariantClosure dic1 = v.asObjectClosure();
                dic1.propGet(0, "storage", val, null);
                String Storage2 = val.asString();
                dic1.propGet(0, "label", val, null);
                String Label = val.asString();
                dic1.propGet(0, "offset", val, null);
                int Offset = val.asInteger();
                dic1.propGet(0, "orgLineStr", val, null);
                String OrgLineStr = val.asString();
                dic1.propGet(0, "lineBuffer", val, null);
                String LineBuffer = val.asString();
                dic1.propGet(0, "pos", val, null);
                int Pos2 = val.asInteger();
                dic1.propGet(0, "lineBufferUsing", val, null);
                boolean LineBufferUsing = val.asBoolean();
                dic1.propGet(0, "macroArgStackBase", val, null);
                int MacroArgStackBase = val.asInteger();
                dic1.propGet(0, "macroArgStackDepth", val, null);
                int MacroArgStackDepth = val.asInteger();
                dic1.propGet(0, "ExcludeLevel", val, null);
                int ExcludeLevel = val.asInteger();
                dic1.propGet(0, "IfLevel", val, null);
                int IfLevel = val.asInteger();
                dic1.propGet(0, "ExcludeLevelStack", val, null);
                String stack_str = val.asString();
                this.restoreIntStackFromStr(ExcludeLevelStack, stack_str);
                dic1.propGet(0, "IfLevelExecutedStack", val, null);
                stack_str = val.asString();
                this.restoreBoolStackFromStr(IfLevelExecutedStack, stack_str);
                this.mCallStack.add(new CallStackData(Storage2, Label, Offset, OrgLineStr, LineBuffer, Pos2, LineBufferUsing, MacroArgStackBase, MacroArgStackDepth, ExcludeLevelStack, ExcludeLevel, IfLevelExecutedStack, IfLevel));
                ++i;
            }
        }
        val.clear();
        dic.propGet(0, "storageName", val, dic);
        if (!val.isVoid()) {
            this.mStorageName = val.asString();
        }
        val.clear();
        dic.propGet(0, "storageShortName", val, dic);
        if (!val.isVoid()) {
            this.mStorageShortName = val.asString();
        }
        val.clear();
        dic.propGet(0, "curLabel", val, dic);
        if (!val.isVoid()) {
            this.mCurLabel = val.asString();
        }
        String storage = this.mStorageName;
        String label = this.mCurLabel;
        this.clearBuffer();
        this.loadScenario(storage);
        this.goToLabel(label);
        val.clear();
        dic.propGet(0, "ExcludeLevel", val, dic);
        if (!val.isVoid()) {
            this.mExcludeLevel = val.asInteger();
        }
        val.clear();
        dic.propGet(0, "IfLevel", val, dic);
        if (!val.isVoid()) {
            this.mIfLevel = val.asInteger();
        }
        val.clear();
        dic.propGet(0, "ExcludeLevelStack", val, dic);
        if (!val.isVoid()) {
            String stack_str = val.asString();
            this.restoreIntStackFromStr(this.mExcludeLevelStack, stack_str);
        }
        val.clear();
        dic.propGet(0, "IfLevelExecutedStack", val, dic);
        if (!val.isVoid()) {
            String stack_str = val.asString();
            this.restoreBoolStackFromStr(this.mIfLevelExecutedStack, stack_str);
        }
        val.clear();
        dic.propGet(0, "macroArgStackBase", val, dic);
        if (!val.isVoid()) {
            this.mMacroArgStackBase = val.asInteger();
        }
    }

    public void loadScenario(String name) throws VariantException, TJSException {
        this.breakConditionAndMacro();
        if (this.mStorageName != null && this.mStorageName.equals(name)) {
            this.rewind();
        } else {
            this.clearBuffer();
            Variant param = new Variant(name);
            Variant[] pparam = new Variant[]{param};
            Variant result = new Variant();
            Dispatch2 owner = (Dispatch2)this.mOwner.get();
            int status = owner.funcCall(0, EV_ON_SCENARIO_LOAD, result, pparam, owner);
            this.mScenario = status == 0 && result.isString() ? TVP.ScnearioCache.getScenario(result.getString(), true) : TVP.ScnearioCache.getScenario(name, false);
            this.mLines = this.mScenario.getLines();
            this.mLineCount = this.mScenario.getLineCount();
            this.rewind();
            this.mStorageName = name;
            this.mStorageShortName = Storage.extractStorageName(name);
            if (this.mDebugLevel >= 1) {
                DebugClass.addLog("================================================================================");
                DebugClass.addLog("Scenario loaded : " + name);
            }
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant param = new Variant(this.mStorageName);
            Variant[] pparam = new Variant[]{param};
            owner.funcCall(0, EV_ON_SCENARIO_LOADED, null, pparam, owner);
        }
    }

    public void clear() {
        TVP.ScnearioCache.clearScnearioCache();
        this.clearBuffer();
        this.clearMacroArgs();
        this.clearCallStack();
    }

    private void clearBuffer() {
        if (this.mScenario != null) {
            this.mScenario = null;
            this.mLines = null;
            this.mCurLineStr = null;
        }
        this.mStorageName = null;
        this.mStorageShortName = null;
        this.breakConditionAndMacro();
    }

    private void rewind() {
        this.mCurLine = 0;
        this.mCurPos = 0;
        this.mCurLineStr = this.mLines[0];
        this.mLineBufferUsing = false;
        this.breakConditionAndMacro();
    }

    private void breakConditionAndMacro() {
        this.mRecordingMacro = false;
        this.mExcludeLevel = -1;
        this.mExcludeLevelStack.clear();
        this.mIfLevelExecutedStack.clear();
        this.mIfLevel = 0;
        this.popMacroArgsTo(this.mMacroArgStackBase);
    }

    public void goToLabel(String name) throws TJSException {
        if (name == null || name.length() == 0) {
            return;
        }
        this.mScenario.ensureLabelCache();
        ScenarioCacheItem.LabelCacheData newline = this.mScenario.getLabelCache().get(name);
        if (newline != null) {
            int vl = this.mLines[newline.Line].indexOf(124);
            this.mCurLabel = this.mScenario.getLabelAliasFromLine(newline.Line);
            this.mCurPage = vl != -1 ? this.mLines[newline.Line].substring(vl + 1) : null;
            this.mCurLine = newline.Line;
            this.mCurPos = 0;
            this.mLineBufferUsing = false;
        } else {
            Message.throwExceptionMessage("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb %1 \u5185\u306b\u30e9\u30d9\u30eb %2 \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", this.mStorageName, name);
        }
        if (this.mDebugLevel >= 1) {
            DebugClass.addLog("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
            DebugClass.addLog(String.valueOf(this.mStorageShortName) + " : jumped to : " + name);
        }
        this.breakConditionAndMacro();
    }

    public void goToStorageAndLabel(String storage, String label) throws TJSException {
        if (storage != null && storage.length() != 0) {
            this.loadScenario(storage);
        }
        if (label != null && label.length() != 0) {
            this.goToLabel(label);
        }
    }

    public void callLabel(String name) throws TJSException {
        this.pushCallStack();
        this.goToLabel(name);
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipCommentOrLabel() throws TJSException {
        this.mScenario.ensureLabelCache();
        this.mCurPos = 0;
        if (this.mCurLine < this.mLineCount) ** GOTO lbl59
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.mLines == null) {
                return false;
            }
            p = this.mLines[this.mCurLine];
            c0 = 0;
            if (p != null && p.length() > 0) {
                c0 = p.charAt(0);
            }
            if (c0 != 59) {
                if (c0 == 42) {
                    if (this.mRecordingMacro) {
                        Message.throwExceptionMessage("\u30e9\u30d9\u30eb\u3084 iscript \u306f\u30de\u30af\u30ed\u4e2d\u306b\u8a18\u8ff0\u3067\u304d\u307e\u305b\u3093");
                    }
                    if ((vl = p.indexOf(124)) != -1) {
                        this.mCurLabel = this.mScenario.getLabelAliasFromLine(this.mCurLine);
                        this.mCurPage = p.substring(vl + 1);
                        pagename = true;
                    } else {
                        this.mCurLabel = this.mScenario.getLabelAliasFromLine(this.mCurLine);
                        this.mCurPage = null;
                        pagename = false;
                    }
                    owner = (Dispatch2)this.mOwner.get();
                    if (owner != null) {
                        pparam = new Variant[]{new Variant(this.mCurLabel), pagename != false ? new Variant(this.mCurPage) : new Variant()};
                        owner.funcCall(0, KAGParserNI.EV_ON_LABEL, null, pparam, owner);
                    }
                } else {
                    if ((c0 != 91 || !"[iscript]".equals(p) && !"[iscript]\\".equals(p)) && (c0 != 64 || !"@iscript".equals(p))) break;
                    if (this.mRecordingMacro) {
                        Message.throwExceptionMessage("\u30e9\u30d9\u30eb\u3084 iscript \u306f\u30de\u30af\u30ed\u4e2d\u306b\u8a18\u8ff0\u3067\u304d\u307e\u305b\u3093");
                    }
                    script = this.mWorkBuilder;
                    script.delete(0, script.length());
                    script_start = ++this.mCurLine;
                    while (this.mCurLine < this.mLineCount) {
                        p = this.mLines[this.mCurLine];
                        if (p != null && p.length() > 0) {
                            c0 = p.charAt(0);
                            if (c0 == 91 && ("[endscript]".equals(p) || "[endscript]\\".equals(p)) || c0 == 64 && "@endscript".equals(p)) break;
                            if (this.mExcludeLevel == -1) {
                                script.append(p);
                                script.append("\r\n");
                            }
                        } else {
                            script.append("\r\n");
                        }
                        ++this.mCurLine;
                    }
                    if (this.mCurLine == this.mLineCount) {
                        Message.throwExceptionMessage("[endscript] \u307e\u305f\u306f @endscript \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                    }
                    if (this.mExcludeLevel == -1 && (owner = (Dispatch2)this.mOwner.get()) != null) {
                        pparam = new Variant[]{new Variant(script.toString()), new Variant(this.mStorageShortName), new Variant(script_start)};
                        script = null;
                        owner.funcCall(0, KAGParserNI.EV_ON_SCRIPT, null, pparam, owner);
                    }
                }
            }
            ++this.mCurLine;
lbl59:
            // 2 sources

            ** while (this.mCurLine < this.mLineCount)
        }
lbl60:
        // 2 sources

        if (this.mCurLine >= this.mLineCount) {
            return false;
        }
        this.mCurLineStr = this.mLines[this.mCurLine];
        this.mLineBufferUsing = false;
        if (this.mDebugLevel >= 2) {
            DebugClass.addLog(String.valueOf(this.mStorageShortName) + " : " + this.mCurLineStr);
        }
        return true;
    }

    private void pushMacroArgs(Dispatch2 args) throws VariantException, TJSException {
        Dispatch2 dsp;
        if (this.mMacroArgs.size() > this.mMacroArgStackDepth) {
            dsp = this.mMacroArgs.get(this.mMacroArgStackDepth);
        } else {
            if (this.mMacroArgStackDepth > this.mMacroArgs.size()) {
                Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            }
            dsp = TJS.createDictionaryObject();
            this.mMacroArgs.add(dsp);
        }
        ++this.mMacroArgStackDepth;
        Variant src = new Variant(args, args);
        Variant[] psrc = new Variant[]{src};
        this.mDicAssign.funcCall(0, null, null, psrc, dsp);
    }

    public void popMacroArgs() throws TJSException {
        if (this.mMacroArgStackDepth == 0) {
            Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        --this.mMacroArgStackDepth;
    }

    private void clearMacroArgs() {
        this.mMacroArgs.clear();
        this.mMacroArgStackDepth = 0;
    }

    private void popMacroArgsTo(int base) {
        this.mMacroArgStackDepth = base;
    }

    private String findNearestLabel(int start, IntWrapper labelline) throws TJSException {
        this.mScenario.ensureLabelCache();
        String labelname = null;
        --start;
        while (start >= 0) {
            String line = this.mLines[start];
            if (line.length() > 0 && line.charAt(0) == '*') {
                labelname = this.mScenario.getLabelAliasFromLine(start);
                break;
            }
            --start;
        }
        labelline.value = start;
        if (labelline.value == -1) {
            labelname = null;
        }
        return labelname;
    }

    private void pushCallStack() throws TJSException {
        if (this.mDebugLevel >= 2) {
            DebugClass.addLog(String.valueOf(this.mStorageShortName) + " : call stack depth before calling : " + String.valueOf(this.mCallStack.size()));
        }
        IntWrapper labelline = new IntWrapper(0);
        String labelname = this.findNearestLabel(this.mCurLine, labelline);
        if (labelline.value < 0) {
            labelline.value = 0;
        }
        String curline_content = this.mLines != null && this.mCurLine < this.mLineCount ? this.mLines[this.mCurLine] : "";
        this.mCallStack.add(new CallStackData(this.mStorageName, labelname, this.mCurLine - labelline.value, curline_content, this.mLineBuffer, this.mCurPos, this.mLineBufferUsing, this.mMacroArgStackBase, this.mMacroArgStackDepth, this.mExcludeLevelStack, this.mExcludeLevel, this.mIfLevelExecutedStack, this.mIfLevel));
        this.mMacroArgStackBase = this.mMacroArgStackDepth;
    }

    private void popCallStack(String storage, String label) throws VariantException, TJSException {
        StringBuilder builder;
        if (this.mCallStack.size() == 0) {
            Message.throwExceptionMessage("return \u30bf\u30b0\u304c call \u30bf\u30b0\u3068\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093 ( return \u30bf\u30b0\u304c\u591a\u3044 )");
        }
        CallStackData data = this.mCallStack.get(this.mCallStack.size() - 1);
        this.mMacroArgStackBase = data.MacroArgStackDepth;
        this.popMacroArgsTo(data.MacroArgStackDepth);
        if (storage != null && storage.length() != 0 || label != null && label.length() != 0) {
            this.goToStorageAndLabel(storage, label);
        } else {
            this.loadScenario(data.Storage);
            if (data.Label != null && data.Label.length() != 0) {
                this.goToLabel(data.Label);
            }
            this.mCurLine += data.Offset;
            if (this.mCurLine > this.mLineCount) {
                Message.throwExceptionMessage("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u306b\u5909\u66f4\u304c\u3042\u3063\u305f\u305f\u3081 return \u306e\u623b\u308a\u5148\u4f4d\u7f6e\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093");
            }
            if (this.mCurLine < this.mLineCount && data.OrgLineStr != this.mLines[this.mCurLine]) {
                if (data.OrgLineStr == null || this.mLines[this.mCurLine] == null) {
                    Message.throwExceptionMessage("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u306b\u5909\u66f4\u304c\u3042\u3063\u305f\u305f\u3081 return \u306e\u623b\u308a\u5148\u4f4d\u7f6e\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093");
                } else if (!data.OrgLineStr.equals(this.mLines[this.mCurLine])) {
                    Message.throwExceptionMessage("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u306b\u5909\u66f4\u304c\u3042\u3063\u305f\u305f\u3081 return \u306e\u623b\u308a\u5148\u4f4d\u7f6e\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093");
                }
            }
            if (data.LineBufferUsing) {
                this.mCurLineStr = this.mLineBuffer = data.LineBuffer;
                this.mLineBufferUsing = true;
            } else if (this.mCurLine < this.mLineCount) {
                this.mCurLineStr = this.mLines[this.mCurLine];
                this.mLineBufferUsing = false;
            }
            this.mCurPos = data.Pos;
            this.mExcludeLevelStack = data.ExcludeLevelStack;
            this.mExcludeLevel = data.ExcludeLevel;
            this.mIfLevelExecutedStack = data.IfLevelExecutedStack;
            this.mIfLevel = data.IfLevel;
            if (this.mDebugLevel >= 1) {
                String label1 = data.Label == null || data.Label.length() == 0 ? "(start)" : data.Label;
                builder = this.mWorkBuilder;
                builder.delete(0, builder.length());
                builder.append(this.mStorageShortName);
                builder.append(" : returned to : ");
                builder.append(label1);
                builder.append(" line offset ");
                builder.append(data.Offset);
                DebugClass.addLog(builder.toString());
                builder = null;
            }
        }
        this.mMacroArgStackBase = data.MacroArgStackBase;
        this.mCallStack.remove(this.mCallStack.size() - 1);
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{};
            owner.funcCall(0, EV_ON_AFTERETURN, null, arg, owner);
        }
        if (this.mDebugLevel >= 2) {
            builder = this.mWorkBuilder;
            builder.delete(0, builder.length());
            builder.append(this.mStorageShortName);
            builder.append(" : call stack depth after returning : ");
            builder.append(this.mCallStack.size());
            DebugClass.addLog(builder.toString());
            builder = null;
        }
    }

    public void clearCallStack() {
        this.mCallStack.clear();
        this.mMacroArgStackBase = 0;
        this.popMacroArgsTo(0);
    }

    private static final boolean isWS(char ch) {
        return ch == ' ' || ch == '\t';
    }

    public static void initialize() {
        __tag_name = TJS.mapGlobalStringMap("tagname");
        __eol_name = TJS.mapGlobalStringMap("eol");
        __storage_name = TJS.mapGlobalStringMap("storage");
        __target_name = TJS.mapGlobalStringMap("target");
        __exp_name = TJS.mapGlobalStringMap("exp");
        STR_TEXT = TJS.mapGlobalStringMap("text");
        EV_ON_JUMP = TJS.mapGlobalStringMap("onJump");
        EV_ON_CALL = TJS.mapGlobalStringMap("onCall");
        EV_ON_RETURN = TJS.mapGlobalStringMap("onReturn");
        EV_ON_AFTERETURN = TJS.mapGlobalStringMap("onAfterReturn");
        EV_ON_LABEL = TJS.mapGlobalStringMap("onLabel");
        EV_ON_SCENARIO_LOAD = TJS.mapGlobalStringMap("onScenarioLoad");
        EV_ON_SCENARIO_LOADED = TJS.mapGlobalStringMap("onScenarioLoaded");
        EV_ON_SCRIPT = TJS.mapGlobalStringMap("onScript");
        TAG_INTERRUPT = new Variant("interrupt");
        TAG_R = new Variant("r");
        TAG_CH = new Variant("ch");
        VAL_TRUE = new Variant("true");
        special_tags_hash = new HashMap();
        special_tags_hash.put("if", SpecialTags.tag_if);
        special_tags_hash.put("ignore", SpecialTags.tag_ignore);
        special_tags_hash.put("endif", SpecialTags.tag_endif);
        special_tags_hash.put("endignore", SpecialTags.tag_endignore);
        special_tags_hash.put("else", SpecialTags.tag_else);
        special_tags_hash.put("elsif", SpecialTags.tag_elsif);
        special_tags_hash.put("emb", SpecialTags.tag_emb);
        special_tags_hash.put("macro", SpecialTags.tag_macro);
        special_tags_hash.put("endmacro", SpecialTags.tag_endmacro);
        special_tags_hash.put("macropop", SpecialTags.tag_macropop);
        special_tags_hash.put("erasemacro", SpecialTags.tag_erasemacro);
        special_tags_hash.put("jump", SpecialTags.tag_jump);
        special_tags_hash.put("call", SpecialTags.tag_call);
        special_tags_hash.put("return", SpecialTags.tag_return);
    }

    private final char getC() {
        if (this.mCurPos >= this.mCurLineStr.length()) {
            return '\u0000';
        }
        return this.mCurLineStr.charAt(this.mCurPos);
    }

    public Dispatch2 getNextTag() throws VariantException, TJSException, CompileException {
        block0: while (true) {
            if (this.mCurLine >= this.mLineCount) {
                return null;
            }
            if (this.mLines == null) {
                return null;
            }
            char c = '\u0000';
            block1: while (true) {
                char ldelim;
                this.mDicClear.funcCall(0, null, null, TJS.NULL_ARG, this.mDicObj);
                if (this.mInterrupted) {
                    this.mDicObj.propSet(512, __tag_name, TAG_INTERRUPT, this.mDicObj);
                    this.mInterrupted = false;
                    return this.mDicObj;
                }
                if (this.mCurLine >= this.mLineCount) break block0;
                int tagstartpos = this.mCurPos;
                if (!this.mLineBufferUsing && this.mCurPos == 0 && !this.skipCommentOrLabel()) {
                    return null;
                }
                c = this.getC();
                if (!this.mIgnoreCR) {
                    if (c == '\\' && this.mCurLineStr.length() == this.mCurPos + 1 || this.mCurLineStr.length() == this.mCurPos && this.mCurPos >= 3 && this.mCurLineStr.startsWith("[p]", this.mCurPos - 3)) {
                        ++this.mCurLine;
                        this.mCurPos = 0;
                        this.mLineBufferUsing = false;
                        continue;
                    }
                    if (this.mCurLineStr.length() == this.mCurPos) {
                        this.mTagLine = this.mCurLine;
                        this.mDicObj.propSet(512, __tag_name, TAG_R, this.mDicObj);
                        this.mDicObj.propSet(512, __eol_name, VAL_TRUE, this.mDicObj);
                        if (this.mRecordingMacro) {
                            this.mRecordingMacroStr.append("[r eol=true]");
                        }
                        ++this.mCurLine;
                        this.mCurPos = 0;
                        this.mLineBufferUsing = false;
                        if (this.mRecordingMacro || this.mExcludeLevel != -1) continue;
                        return this.mDicObj;
                    }
                }
                if (!this.mLineBufferUsing && this.mCurPos == 0 && c == '@') {
                    ldelim = '\u0000';
                } else {
                    if (c != '[' || this.mCurLineStr.startsWith("[[", this.mCurPos)) {
                        char ch = c;
                        this.mTagLine = this.mCurLine++;
                        if (ch == '\u0000') {
                            this.mCurPos = 0;
                            this.mLineBufferUsing = false;
                            continue;
                        }
                        if (ch == '\t') {
                            ++this.mCurPos;
                            continue;
                        }
                        if (ch != '\n') {
                            this.mDicObj.propSet(512, __tag_name, TAG_CH, this.mDicObj);
                            Variant ch_val = new Variant(this.mCurLineStr.substring(this.mCurPos, this.mCurPos + 1));
                            this.mDicObj.propSet(512, STR_TEXT, ch_val, this.mDicObj);
                            if (this.mRecordingMacro) {
                                if (ch == '[') {
                                    this.mRecordingMacroStr.append("[[");
                                } else {
                                    this.mRecordingMacroStr.append(ch);
                                }
                            }
                        } else {
                            this.mDicObj.propSet(512, __tag_name, TAG_R, this.mDicObj);
                            if (this.mRecordingMacro) {
                                this.mRecordingMacroStr.append("[r]");
                            }
                        }
                        if ((c = this.getC()) == '[') {
                            ++this.mCurPos;
                        }
                        ++this.mCurPos;
                        if (this.mRecordingMacro || this.mExcludeLevel != -1) continue;
                        return this.mDicObj;
                    }
                    ldelim = ']';
                }
                boolean condition = true;
                this.mTagLine = this.mCurLine;
                int tagstart = this.mCurPos++;
                if (this.mCurLineStr.length() <= this.mCurPos) {
                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                while (this.mCurPos < this.mCurLineStr.length() && KAGParserNI.isWS(this.getC())) {
                    ++this.mCurPos;
                }
                if (this.mCurLineStr.length() <= this.mCurPos) {
                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                int tagnamestart = this.mCurPos;
                while (this.mCurPos < this.mCurLineStr.length() && !KAGParserNI.isWS(this.getC()) && this.getC() != ldelim) {
                    ++this.mCurPos;
                }
                if (tagnamestart == this.mCurPos) {
                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                String tagname = this.mCurLineStr.substring(tagnamestart, this.mCurPos);
                tagname = tagname.toLowerCase();
                Variant tag_val = new Variant(tagname);
                this.mDicObj.propSet(512, __tag_name, tag_val, this.mDicObj);
                SpecialTags tag = special_tags_hash.get(tagname);
                SpecialTags tagkind = this.mProcessSpecialTags ? (tag != null ? tag : SpecialTags.tag_other) : SpecialTags.tag_other;
                if (tagkind == SpecialTags.tag_macro) {
                    this.mRecordingMacroName = null;
                }
                block4: while (true) {
                    String value;
                    if (KAGParserNI.isWS(this.getC())) {
                        ++this.mCurPos;
                        continue;
                    }
                    if (this.getC() == ldelim) {
                        boolean cond;
                        Dispatch2 owner;
                        Variant val;
                        boolean ismacro = false;
                        String macrocontent = "";
                        if (condition && this.mExcludeLevel == -1) {
                            if (tagkind == SpecialTags.tag_endmacro) {
                                if (!this.mRecordingMacro) {
                                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                                }
                                this.mRecordingMacro = false;
                                if (this.mDebugLevel >= 2) {
                                    DebugClass.addLog("macro : " + this.mRecordingMacroName + " : " + this.mRecordingMacroStr.toString());
                                }
                                this.mRecordingMacroStr.append("[macropop]");
                                Variant macrocontent1 = new Variant(this.mRecordingMacroStr.toString());
                                this.mMacros.propSet(512, this.mRecordingMacroName, macrocontent1, this.mMacros);
                            }
                            if (this.mRecordingMacro) {
                                if (ldelim != '\u0000') {
                                    this.mRecordingMacroStr.append(this.mCurLineStr.substring(tagstart, this.mCurPos + 1));
                                } else if (this.mCurPos - tagstart >= 1) {
                                    this.mRecordingMacroStr.append('[');
                                    this.mRecordingMacroStr.append(this.mCurLineStr.substring(tagstart + 1, this.mCurPos));
                                    this.mRecordingMacroStr.append(']');
                                }
                                if (ldelim == '\u0000') {
                                    ++this.mCurLine;
                                    this.mCurPos = 0;
                                    this.mLineBufferUsing = false;
                                    continue block1;
                                }
                                ++this.mCurPos;
                                continue block1;
                            }
                            Variant macroval = new Variant();
                            int hr = this.mMacros.propGet(0, tagname, macroval, this.mMacros);
                            boolean bl = ismacro = hr >= 0;
                            if (ismacro) {
                                boolean bl2 = ismacro = !macroval.isVoid();
                            }
                            if (ismacro) {
                                macrocontent = macroval.asString();
                            }
                        }
                        if (tagkind == SpecialTags.tag_other && !ismacro) {
                            if (ldelim == '\u0000') {
                                ++this.mCurLine;
                                this.mCurPos = 0;
                                this.mLineBufferUsing = false;
                            } else {
                                ++this.mCurPos;
                            }
                            if (!condition || this.mExcludeLevel != -1) continue block1;
                            return this.mDicObj;
                        }
                        if (tagkind == SpecialTags.tag_if || tagkind == SpecialTags.tag_ignore) {
                            ++this.mIfLevel;
                            this.mIfLevelExecutedStack.add(false);
                            this.mExcludeLevelStack.add(this.mExcludeLevel);
                            if (this.mExcludeLevel == -1) {
                                val = new Variant();
                                this.mDicObj.propGet(0, __exp_name, val, this.mDicObj);
                                String exp = val.asString();
                                if (exp.length() == 0) {
                                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                                }
                                owner = (Dispatch2)this.mOwner.get();
                                ScriptsClass.executeExpression(exp, owner, val);
                                cond = val.asBoolean();
                                if (tagkind == SpecialTags.tag_ignore) {
                                    cond = !cond;
                                }
                                this.mIfLevelExecutedStack.set(this.mIfLevelExecutedStack.size() - 1, cond);
                                if (!cond) {
                                    this.mExcludeLevel = this.mIfLevel;
                                }
                            }
                        }
                        if (tagkind == SpecialTags.tag_elsif && !this.mIfLevelExecutedStack.isEmpty()) {
                            if (this.mIfLevelExecutedStack.get(this.mIfLevelExecutedStack.size() - 1).booleanValue()) {
                                this.mExcludeLevel = this.mIfLevel;
                            } else if (this.mIfLevel == this.mExcludeLevel) {
                                val = new Variant();
                                this.mDicObj.propGet(0, __exp_name, val, this.mDicObj);
                                String exp = val.asString();
                                if (exp.length() == 0) {
                                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                                }
                                owner = (Dispatch2)this.mOwner.get();
                                ScriptsClass.executeExpression(exp, owner, val);
                                cond = val.asBoolean();
                                if (cond) {
                                    this.mIfLevelExecutedStack.set(this.mIfLevelExecutedStack.size() - 1, true);
                                    this.mExcludeLevel = -1;
                                }
                            }
                        }
                        if (tagkind == SpecialTags.tag_else && !this.mIfLevelExecutedStack.isEmpty()) {
                            if (this.mIfLevelExecutedStack.get(this.mIfLevelExecutedStack.size() - 1).booleanValue()) {
                                this.mExcludeLevel = this.mIfLevel;
                            } else if (this.mIfLevel == this.mExcludeLevel) {
                                this.mIfLevelExecutedStack.set(this.mIfLevelExecutedStack.size() - 1, true);
                                this.mExcludeLevel = -1;
                            }
                        }
                        if (tagkind == SpecialTags.tag_endif || tagkind == SpecialTags.tag_endignore) {
                            if (!this.mExcludeLevelStack.isEmpty()) {
                                this.mExcludeLevel = this.mExcludeLevelStack.get(this.mExcludeLevelStack.size() - 1);
                                this.mExcludeLevelStack.remove(this.mExcludeLevelStack.size() - 1);
                            }
                            if (!this.mIfLevelExecutedStack.isEmpty()) {
                                this.mIfLevelExecutedStack.remove(this.mIfLevelExecutedStack.size() - 1);
                            }
                            --this.mIfLevel;
                            if (this.mIfLevel < 0) {
                                this.mIfLevel = 0;
                            }
                            if (ldelim == '\u0000') {
                                ++this.mCurLine;
                                this.mCurPos = 0;
                                this.mLineBufferUsing = false;
                                continue block1;
                            }
                            ++this.mCurPos;
                            continue block1;
                        }
                        if (condition && this.mExcludeLevel == -1) {
                            Dispatch2 owner2;
                            boolean process;
                            String attrib_target;
                            String attrib_storage;
                            if (tagkind == SpecialTags.tag_emb || ismacro && tagkind == SpecialTags.tag_other) {
                                if (ldelim != '\u0000') {
                                    ++this.mCurPos;
                                }
                                if (!ismacro) {
                                    val = new Variant();
                                    this.mDicObj.propGet(0, __exp_name, val, this.mDicObj);
                                    String exp = val.asString();
                                    if (exp.length() == 0) {
                                        Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                                    }
                                    owner = (Dispatch2)this.mOwner.get();
                                    ScriptsClass.executeExpression(exp, owner, val);
                                    exp = val.asString();
                                    char[] p = exp.toCharArray();
                                    int r_count = 0;
                                    int i = 0;
                                    while (i < p.length) {
                                        if (p[i] == '[') {
                                            ++r_count;
                                        }
                                        ++r_count;
                                        ++i;
                                    }
                                    int curposlen = this.mCurLineStr.length() - this.mCurPos;
                                    int finallen = r_count + tagstartpos + curposlen;
                                    if (ldelim == '\u0000' && !this.mIgnoreCR) {
                                        ++finallen;
                                    }
                                    StringBuilder d = this.mWorkBuilder;
                                    d.delete(0, d.length());
                                    if (tagstartpos > 0) {
                                        d.append(this.mCurLineStr.substring(0, tagstartpos));
                                    }
                                    int i2 = 0;
                                    while (i2 < p.length) {
                                        if (p[i2] == '[') {
                                            d.append('[');
                                            d.append('[');
                                        } else {
                                            d.append(p[i2]);
                                        }
                                        ++i2;
                                    }
                                    if (this.mCurPos < this.mCurLineStr.length()) {
                                        d.append(this.mCurLineStr.substring(this.mCurPos));
                                    }
                                    if (ldelim == '\u0000' && !this.mIgnoreCR) {
                                        d.append('\\');
                                    }
                                    this.mLineBuffer = d.toString();
                                    d = null;
                                } else {
                                    int maclen = macrocontent.length();
                                    int curposlen = this.mCurLineStr.length() - this.mCurPos;
                                    int finallen = tagstartpos + maclen + curposlen;
                                    if (ldelim == '\u0000' && !this.mIgnoreCR) {
                                        ++finallen;
                                    }
                                    StringBuilder d = this.mWorkBuilder;
                                    d.delete(0, d.length());
                                    if (tagstartpos > 0) {
                                        d.append(this.mCurLineStr.substring(0, tagstartpos));
                                    }
                                    d.append(macrocontent);
                                    if (this.mCurPos < this.mCurLineStr.length()) {
                                        d.append(this.mCurLineStr.substring(this.mCurPos));
                                    }
                                    if (ldelim == '\u0000' && !this.mIgnoreCR) {
                                        d.append('\\');
                                    }
                                    this.mLineBuffer = d.toString();
                                    d = null;
                                }
                                this.mCurLineStr = this.mLineBuffer;
                                this.mCurPos = tagstartpos;
                                this.mLineBufferUsing = true;
                                if (!ismacro) continue block1;
                                this.pushMacroArgs(this.mDicObj);
                                continue block1;
                            }
                            if (tagkind == SpecialTags.tag_jump) {
                                Variant param;
                                Variant[] pparam;
                                Variant res;
                                int er;
                                val = new Variant();
                                this.mDicObj.propGet(0, __storage_name, val, this.mDicObj);
                                attrib_storage = val.asString();
                                this.mDicObj.propGet(0, __target_name, val, this.mDicObj);
                                attrib_target = val.asString();
                                process = true;
                                owner2 = (Dispatch2)this.mOwner.get();
                                if (owner2 != null && (er = owner2.funcCall(0, EV_ON_JUMP, res = new Variant(), pparam = new Variant[]{param = new Variant(this.mDicObj, this.mDicObj)}, owner2)) == 0) {
                                    process = res.asBoolean();
                                }
                                if (process) {
                                    this.goToStorageAndLabel(attrib_storage, attrib_target);
                                    continue block0;
                                }
                            } else if (tagkind == SpecialTags.tag_call) {
                                Variant param;
                                Variant[] pparam;
                                Variant res;
                                int er;
                                val = new Variant();
                                this.mDicObj.propGet(0, __storage_name, val, this.mDicObj);
                                attrib_storage = val.asString();
                                this.mDicObj.propGet(0, __target_name, val, this.mDicObj);
                                attrib_target = val.asString();
                                process = true;
                                owner2 = (Dispatch2)this.mOwner.get();
                                if (owner2 != null && (er = owner2.funcCall(0, EV_ON_CALL, res = new Variant(), pparam = new Variant[]{param = new Variant(this.mDicObj, this.mDicObj)}, owner2)) == 0) {
                                    process = res.asBoolean();
                                }
                                if (process) {
                                    if (ldelim == '\u0000') {
                                        ++this.mCurLine;
                                        this.mCurPos = 0;
                                        this.mLineBufferUsing = false;
                                    } else {
                                        ++this.mCurPos;
                                    }
                                    this.pushCallStack();
                                    this.goToStorageAndLabel(attrib_storage, attrib_target);
                                    continue block0;
                                }
                            } else if (tagkind == SpecialTags.tag_return) {
                                Variant param;
                                Variant[] pparam;
                                Variant res;
                                int er;
                                val = new Variant();
                                this.mDicObj.propGet(0, __storage_name, val, this.mDicObj);
                                attrib_storage = val.asString();
                                this.mDicObj.propGet(0, __target_name, val, this.mDicObj);
                                attrib_target = val.asString();
                                process = true;
                                owner2 = (Dispatch2)this.mOwner.get();
                                if (owner2 != null && (er = owner2.funcCall(0, EV_ON_RETURN, res = new Variant(), pparam = new Variant[]{param = new Variant(this.mDicObj, this.mDicObj)}, owner2)) == 0) {
                                    process = res.asBoolean();
                                }
                                if (process) {
                                    this.popCallStack(attrib_storage, attrib_target);
                                    continue block0;
                                }
                            } else if (tagkind == SpecialTags.tag_macro) {
                                val = new Variant();
                                this.mDicObj.propGet(0, "name", val, this.mDicObj);
                                this.mRecordingMacroName = val.asString();
                                this.mRecordingMacroName = this.mRecordingMacroName.toLowerCase();
                                if (this.mRecordingMacroName.length() == 0) {
                                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                                }
                                this.mRecordingMacro = true;
                                this.mRecordingMacroStr.delete(0, this.mRecordingMacroStr.length());
                            } else if (tagkind == SpecialTags.tag_macropop) {
                                this.popMacroArgs();
                            } else if (tagkind == SpecialTags.tag_erasemacro) {
                                val = new Variant();
                                this.mDicObj.propGet(0, "name", val, this.mDicObj);
                                String macroname = val.asString();
                                int hr = this.mMacros.deleteMember(0, macroname, this.mMacros);
                                if (hr < 0) {
                                    Message.throwExceptionMessage("\u30de\u30af\u30ed \"%1\" \u306f\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093", macroname);
                                }
                            }
                        }
                        if (ldelim == '\u0000') {
                            ++this.mCurLine;
                            this.mCurPos = 0;
                            this.mLineBufferUsing = false;
                            continue block1;
                        }
                        ++this.mCurPos;
                        continue block1;
                    }
                    if (this.getC() == '\u0000') {
                        Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                    }
                    if (this.getC() == '*') {
                        if (!this.mRecordingMacro) {
                            Dispatch2 dsp = this.getMacroTop();
                            if (dsp != null) {
                                Variant src = new Variant(dsp, dsp);
                                Variant[] psrc = new Variant[]{src};
                                this.mDicAssign.funcCall(0, null, null, psrc, this.mDicObj);
                            }
                            Variant tag_val2 = new Variant(tagname);
                            this.mDicObj.propSet(512, __tag_name, tag_val2, this.mDicObj);
                        }
                        ++this.mCurPos;
                        while (true) {
                            if (this.mCurPos >= this.mCurLineStr.length() || !KAGParserNI.isWS(this.getC())) continue block4;
                            ++this.mCurPos;
                        }
                    }
                    int attribnamestart = this.mCurPos;
                    while (this.mCurPos < this.mCurLineStr.length() && !KAGParserNI.isWS(this.getC()) && this.getC() != '=' && this.getC() != ldelim) {
                        ++this.mCurPos;
                    }
                    int attribnameend = this.mCurPos;
                    String attribname = this.mCurLineStr.substring(attribnamestart, attribnameend);
                    attribname = attribname.toLowerCase();
                    while (this.mCurPos < this.mCurLineStr.length() && KAGParserNI.isWS(this.getC())) {
                        ++this.mCurPos;
                    }
                    boolean entity = false;
                    boolean macroarg = false;
                    if (this.getC() != '=') {
                        value = "true";
                    } else {
                        if (this.mCurLineStr.length() <= this.mCurPos) {
                            Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                        }
                        ++this.mCurPos;
                        if (this.mCurLineStr.length() <= this.mCurPos) {
                            Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                        }
                        while (this.mCurLineStr.length() > this.mCurPos && KAGParserNI.isWS(this.getC())) {
                            ++this.mCurPos;
                        }
                        if (this.mCurLineStr.length() <= this.mCurPos) {
                            Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                        }
                        char vdelim = '\u0000';
                        if (this.getC() == '&') {
                            entity = true;
                            ++this.mCurPos;
                        } else if (this.getC() == '%') {
                            macroarg = true;
                            ++this.mCurPos;
                        }
                        if (this.getC() == '\"' || this.getC() == '\'') {
                            vdelim = this.getC();
                        }
                        int valuestart = ++this.mCurPos;
                        while (this.mCurLineStr.length() > this.mCurPos && !(vdelim != '\u0000' ? this.getC() == vdelim : this.getC() == ldelim || KAGParserNI.isWS(this.getC()))) {
                            if (this.getC() == '`') {
                                ++this.mCurPos;
                                if (this.mCurLineStr.length() <= this.mCurPos) {
                                    Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                                }
                            }
                            ++this.mCurPos;
                        }
                        if (ldelim != '\u0000' && this.mCurLineStr.length() <= this.mCurPos) {
                            Message.throwExceptionMessage("\u30bf\u30b0\u306e\u6587\u6cd5\u30a8\u30e9\u30fc\u3067\u3059\u3002'[' \u3084 ']' \u306e\u5bfe\u5fdc\u3001\" \u3068 \" \u306e\u5bfe\u5fdc\u3001\u30b9\u30da\u30fc\u30b9\u306e\u5165\u308c\u5fd8\u308c\u3001\u4f59\u5206\u306a\u6539\u884c\u3001macro \uff5e endmacro \u306e\u5bfe\u5fdc\u3001\u5fc5\u8981\u306a\u5c5e\u6027\u306e\u4e0d\u8db3\u306a\u3069\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
                        }
                        int valueend = this.mCurPos++;
                        if (vdelim != '\u0000') {
                            // empty if block
                        }
                        value = this.mCurLineStr.substring(valuestart, valueend);
                        if (valueend != valuestart) {
                            int count = value.length();
                            StringBuilder v = this.mWorkBuilder;
                            v.delete(0, v.length());
                            int vp = 0;
                            if (!entity && vp < count && value.charAt(vp) == '&') {
                                entity = true;
                                ++vp;
                            }
                            if (!macroarg && vp < count && value.charAt(vp) == '%') {
                                macroarg = true;
                                ++vp;
                            }
                            while (vp < count) {
                                if (value.charAt(vp) == '`' && ++vp >= count) break;
                                v.append(value.charAt(vp));
                                ++vp;
                            }
                            value = v.toString();
                            v = null;
                        }
                    }
                    boolean store = true;
                    if (!this.mRecordingMacro && this.mExcludeLevel == -1 || tagkind == SpecialTags.tag_elsif) {
                        if (entity) {
                            Dispatch2 owner = (Dispatch2)this.mOwner.get();
                            ScriptsClass.executeExpression(value, owner, this.mValueVariant);
                            if (!this.mValueVariant.isVoid()) {
                                this.mValueVariant.toString();
                            }
                        } else if (macroarg) {
                            Dispatch2 args = this.getMacroTop();
                            if (args != null) {
                                int vp = value.indexOf(124);
                                if (vp != -1) {
                                    String name = value.substring(0, vp);
                                    args.propGet(0, name, this.mValueVariant, args);
                                    if (this.mValueVariant.isVoid()) {
                                        this.mValueVariant.set(value.substring(vp + 1));
                                    }
                                } else {
                                    args.propGet(0, value, this.mValueVariant, args);
                                }
                            } else {
                                this.mValueVariant.set(value);
                            }
                        } else {
                            this.mValueVariant.set(value);
                        }
                        if ("cond".equals(attribname)) {
                            Variant val = new Variant();
                            Dispatch2 owner = (Dispatch2)this.mOwner.get();
                            ScriptsClass.executeExpression(this.mValueVariant.asString(), owner, val);
                            condition = val.asBoolean();
                            store = false;
                        }
                    }
                    if (!store) continue;
                    this.mDicObj.propSet(512, attribname, this.mValueVariant, this.mDicObj);
                }
                break;
            }
            break;
        }
        return null;
    }

    public Dispatch2 getMacroTop() {
        if (this.mMacroArgStackDepth == 0) {
            return null;
        }
        return this.mMacroArgs.get(this.mMacroArgStackDepth - 1);
    }

    public final String getStorageName() {
        return this.mStorageName;
    }

    public final void interrupt() {
        this.mInterrupted = true;
    }

    public final void resetInterrupt() {
        this.mInterrupted = false;
    }

    public final String getCurLabel() {
        return this.mCurLabel;
    }

    public final int getCurLine() {
        return this.mCurLine;
    }

    public final int getCurPos() {
        return this.mCurPos;
    }

    public final String getCurLineStr() {
        return this.mCurLineStr;
    }

    public final void setProcessSpecialTags(boolean b) {
        this.mProcessSpecialTags = b;
    }

    public final boolean getProcessSpecialTags() {
        return this.mProcessSpecialTags;
    }

    public final void setIgnoreCR(boolean b) {
        this.mIgnoreCR = b;
    }

    public final boolean getIgnoreCR() {
        return this.mIgnoreCR;
    }

    public final void setDebugLevel(int level) {
        this.mDebugLevel = level;
    }

    public final int getDebugLevel() {
        return this.mDebugLevel;
    }

    public final Dispatch2 getMacros() {
        return this.mMacros;
    }

    public int getCallStackDepth() {
        return this.mCallStack.size();
    }

    public void assign(KAGParserNI src) throws VariantException, TJSException {
        this.copy(src);
    }

    static class CallStackData {
        public String Storage;
        public String Label;
        public int Offset;
        public String OrgLineStr;
        public String LineBuffer;
        public int Pos;
        public boolean LineBufferUsing;
        public int MacroArgStackBase;
        public int MacroArgStackDepth;
        public IntVector ExcludeLevelStack;
        public ArrayList<Boolean> IfLevelExecutedStack;
        public int ExcludeLevel;
        public int IfLevel;

        public CallStackData(String storage, String label, int offset, String orglinestr, String linebuffer, int pos, boolean linebufferusing, int macroargstackbase, int macroargstackdepth, IntVector excludelevelstack, int excludelevel, ArrayList<Boolean> iflevelexecutedstack, int iflevel) {
            this.Storage = storage;
            this.Label = label;
            this.Offset = offset;
            this.OrgLineStr = orglinestr;
            this.LineBuffer = linebuffer;
            this.Pos = pos;
            this.LineBufferUsing = linebufferusing;
            this.MacroArgStackBase = macroargstackbase;
            this.MacroArgStackDepth = macroargstackdepth;
            this.ExcludeLevelStack = excludelevelstack;
            this.ExcludeLevel = excludelevel;
            this.IfLevelExecutedStack = iflevelexecutedstack;
            this.IfLevel = iflevel;
        }

        public CallStackData(CallStackData ref) {
            this.Storage = ref.Storage;
            this.Label = ref.Label;
            this.Offset = ref.Offset;
            this.OrgLineStr = ref.OrgLineStr;
            this.LineBuffer = ref.LineBuffer;
            this.Pos = ref.Pos;
            this.LineBufferUsing = ref.LineBufferUsing;
            this.MacroArgStackBase = ref.MacroArgStackBase;
            this.MacroArgStackDepth = ref.MacroArgStackDepth;
            this.ExcludeLevelStack = ref.ExcludeLevelStack.clone();
            this.IfLevelExecutedStack = (ArrayList)ref.IfLevelExecutedStack.clone();
            this.ExcludeLevel = ref.ExcludeLevel;
            this.IfLevel = ref.IfLevel;
        }

        public void copy(CallStackData ref) {
            this.Storage = ref.Storage;
            this.Label = ref.Label;
            this.Offset = ref.Offset;
            this.OrgLineStr = ref.OrgLineStr;
            this.LineBuffer = ref.LineBuffer;
            this.Pos = ref.Pos;
            this.LineBufferUsing = ref.LineBufferUsing;
            this.MacroArgStackBase = ref.MacroArgStackBase;
            this.MacroArgStackDepth = ref.MacroArgStackDepth;
            this.ExcludeLevelStack = ref.ExcludeLevelStack.clone();
            this.IfLevelExecutedStack = (ArrayList)ref.IfLevelExecutedStack.clone();
            this.ExcludeLevel = ref.ExcludeLevel;
            this.IfLevel = ref.IfLevel;
        }
    }

    static enum SpecialTags {
        tag_other,
        tag_if,
        tag_else,
        tag_elsif,
        tag_ignore,
        tag_endif,
        tag_endignore,
        tag_emb,
        tag_macro,
        tag_endmacro,
        tag_macropop,
        tag_erasemacro,
        tag_jump,
        tag_call,
        tag_return;

    }
}

