/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.util.ArrayList;

public class KAGTokenizer {
    private ArrayList<Token> mTokenList;
    private char[] mText;

    public void tokenize() {
        StringBuilder builder = new StringBuilder(1024);
        int pos = 0;
        int lineno = 0;
        boolean islinehead = true;
        KAGTokenType currentToken = null;
        while (true) {
            char c1;
            char c = this.mText[pos];
            if (islinehead) {
                if (c == ';') {
                    currentToken = KAGTokenType.COMMENT;
                    c = this.mText[++pos];
                    while (c != '\r' && c != '\n') {
                        builder.append(c);
                    }
                    this.mTokenList.add(new CommentToken(lineno, builder.toString()));
                    builder.delete(0, builder.length());
                    this.mTokenList.add(new Token(KAGTokenType.RETURN, lineno, null));
                    ++lineno;
                    islinehead = true;
                    c1 = this.mText[pos + 1];
                    if (c != '\r' || c1 != '\n') continue;
                    ++pos;
                    continue;
                }
                if (c == '*') {
                    currentToken = KAGTokenType.LABEL;
                    c = this.mText[++pos];
                    while (c != '\r' && c != '\n') {
                        builder.append(c);
                    }
                    this.mTokenList.add(new LabelToken(lineno, builder.toString()));
                    builder.delete(0, builder.length());
                    this.mTokenList.add(new Token(KAGTokenType.RETURN, lineno, null));
                    ++lineno;
                    islinehead = true;
                    c1 = this.mText[pos + 1];
                    if (c != '\r' || c1 != '\n') continue;
                    ++pos;
                    continue;
                }
                if (c == '@') {
                    currentToken = KAGTokenType.TAG;
                    c = this.mText[++pos];
                    while (c != '\r' && c != '\n') {
                        builder.append(c);
                    }
                    this.mTokenList.add(new TagToken(lineno, builder.toString()));
                    builder.delete(0, builder.length());
                    this.mTokenList.add(new Token(KAGTokenType.RETURN, lineno, null));
                    ++lineno;
                    islinehead = true;
                    c1 = this.mText[pos + 1];
                    if (c != '\r' || c1 != '\n') continue;
                    ++pos;
                    continue;
                }
                if (c == '\t') {
                    while ((c = this.mText[++pos]) == '\t') {
                    }
                }
            }
            if (c == '[') {
                c = this.mText[++pos];
            }
            if (c != '\r' && c != '\n') continue;
            this.mTokenList.add(new Token(KAGTokenType.RETURN, lineno, null));
            ++lineno;
            islinehead = true;
            c1 = this.mText[++pos];
            if (c != '\r' || c1 != '\n') continue;
            ++pos;
        }
    }

    static class CommentToken
    extends Token {
        public CommentToken(int lineno, String contents) {
            super(KAGTokenType.COMMENT, lineno, contents);
        }
    }

    public static enum KAGTokenType {
        TAG,
        LABEL,
        SCRIPT,
        TEXT,
        COMMENT,
        RETURN;

    }

    static class LabelToken
    extends Token {
        public LabelToken(int lineno, String contents) {
            super(KAGTokenType.LABEL, lineno, contents);
        }
    }

    static class ScriptToken
    extends Token {
        public ScriptToken(int lineno, String contents) {
            super(KAGTokenType.SCRIPT, lineno, contents);
        }
    }

    static class TagToken
    extends Token {
        public TagToken(int lineno, String contents) {
            super(KAGTokenType.TAG, lineno, contents);
        }

        public String getTagName() {
            int index = this.mContents.indexOf(32);
            return this.mContents.substring(0, index);
        }
    }

    static class Token {
        public KAGTokenType mType;
        public int mLineNo;
        public String mContents;

        public Token(KAGTokenType type, int lineno, String contents) {
            this.mType = type;
            this.mLineNo = lineno;
            this.mContents = contents;
        }
    }
}

