/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.SystemInitializer;

public class LogStreamHolder {
    PrintWriter mStream;
    boolean mAlive = true;
    boolean mOpenFailed;
    private static final String SEPARATOR = "\n\n\n==============================================================================\n==============================================================================\n";

    protected void finalize() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        this.mAlive = false;
    }

    private static boolean checkBeforeWritefile(File file) {
        if (file.exists()) {
            return file.isFile() && file.canWrite();
        }
        return true;
    }

    private void open(boolean append) {
        if (this.mOpenFailed) {
            return;
        }
        try {
            String filename = null;
            if (!TVP.DebugLog.enableLogLoacation()) {
                this.mStream = null;
                this.mOpenFailed = true;
            } else {
                filename = String.valueOf(TVP.DebugLog.getNativeLogLocation()) + "\\krkr.console.log";
                SystemInitializer.ensureDataPathDirectory();
                File file = new File(filename);
                if (LogStreamHolder.checkBeforeWritefile(file)) {
                    boolean appendbom = !file.exists();
                    this.mStream = new PrintWriter(new BufferedWriter(new FileWriter(file, append)));
                    if (this.mStream != null && appendbom) {
                        this.mStream.write(255);
                        this.mStream.write(254);
                    }
                }
                if (this.mStream == null) {
                    this.mOpenFailed = true;
                }
            }
            if (this.mStream != null) {
                this.log(SEPARATOR);
                Calendar cal = Calendar.getInstance();
                Date date = cal.getTime();
                DateFormat formatter = DateFormat.getDateInstance();
                String timebuf = formatter.format(date);
                formatter = null;
                date = null;
                cal = null;
                StringBuffer buffer = new StringBuffer(32);
                buffer.append("Logging to ");
                buffer.append(filename);
                buffer.append(" started on ");
                buffer.append(timebuf);
                this.log(buffer.toString());
                buffer = null;
            }
        }
        catch (IOException e) {
            this.mOpenFailed = true;
        }
    }

    public void clear() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        this.open(false);
    }

    public void log(String text) {
        if (this.mStream == null) {
            this.open(true);
        }
        if (this.mStream != null) {
            this.mStream.print(text);
            this.mStream.print('\n');
            this.mStream.flush();
        }
    }

    public void reopen() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        this.mStream = null;
        this.mAlive = false;
        this.mOpenFailed = false;
    }
}

