/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.util.ArrayList;

public class ObjectList<E> {
    private ArrayList<E> mObjects;
    private ArrayList<E> mBackupedObjects;
    private int mSafeLockCount;
    private boolean mBackuped;

    private final void internalAssign(ObjectList<E> ref) {
        this.mObjects = ref.mObjects != null && ref.mObjects.size() > 0 ? (ArrayList)ref.mObjects.clone() : null;
    }

    private final void backup() {
        this.mBackupedObjects = this.mObjects != null && this.mObjects.size() > 0 ? (ArrayList)this.mObjects.clone() : null;
        this.mBackuped = true;
    }

    private final void commit() {
        this.mBackupedObjects = null;
        this.mBackuped = false;
    }

    public ObjectList() {
    }

    public ObjectList(ObjectList<E> ref) {
        this.internalAssign(ref);
    }

    public final void assign(ObjectList<E> ref) {
        this.mObjects = null;
        this.internalAssign(ref);
    }

    public final void safeLock() {
        if (this.mSafeLockCount == 0) {
            this.compact();
        }
        ++this.mSafeLockCount;
    }

    public final void safeUnlock() {
        --this.mSafeLockCount;
        if (this.mSafeLockCount == 0) {
            this.commit();
        }
    }

    public final int getSafeLockedObjectCount() {
        if (this.mBackuped) {
            if (this.mBackupedObjects == null) {
                return 0;
            }
            return this.mBackupedObjects.size();
        }
        if (this.mObjects == null) {
            return 0;
        }
        return this.mObjects.size();
    }

    public final E getSafeLockedObjectAt(int index) {
        if (this.mBackuped) {
            if (this.mBackupedObjects == null) {
                return null;
            }
            return this.mBackupedObjects.get(index);
        }
        if (this.mObjects == null) {
            return null;
        }
        return this.mObjects.get(index);
    }

    public final int getCount() {
        if (this.mObjects == null) {
            return 0;
        }
        return this.mObjects.size();
    }

    public final int getActualCount() {
        this.compact();
        if (this.mObjects == null) {
            return 0;
        }
        return this.mObjects.size();
    }

    public final void setCount(int count) {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        this.reserve(count);
    }

    public final void reserve(int count) {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        this.mObjects.ensureCapacity(count);
        int i = this.mObjects.size();
        while (i < count) {
            this.mObjects.add(null);
            ++i;
        }
    }

    public final void compact() {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        if (this.mObjects == null) {
            return;
        }
        int count = this.mObjects.size();
        int i = count - 1;
        while (i >= 0) {
            E o = this.mObjects.get(i);
            if (o == null) {
                this.mObjects.remove(i);
            }
            --i;
        }
        if (this.mObjects.size() == 0) {
            this.mObjects = null;
        }
    }

    public final E get(int index) {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        if (this.mObjects == null) {
            return null;
        }
        return this.mObjects.get(index);
    }

    public final E getConst(int index) {
        if (this.mObjects == null) {
            return null;
        }
        return this.mObjects.get(index);
    }

    public final E set(int index, E obj) {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        if (this.mObjects == null) {
            return null;
        }
        return this.mObjects.set(index, obj);
    }

    public final int find(E object) {
        if (object == null) {
            return -1;
        }
        if (this.mObjects == null) {
            return -1;
        }
        int count = this.mObjects.size();
        int i = 0;
        while (i < count) {
            E o = this.mObjects.get(i);
            if (o == object) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final boolean add(E object) {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        if (object == null) {
            return false;
        }
        if (this.find(object) == -1) {
            if (this.mObjects == null) {
                this.mObjects = new ArrayList();
            }
            this.mObjects.add(object);
            return true;
        }
        return false;
    }

    public final boolean remove(E object) {
        boolean ret;
        int index;
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        if ((index = this.find(object)) != -1) {
            this.mObjects.set(index, null);
            ret = true;
        } else {
            ret = false;
        }
        if (this.mBackuped && object != null && this.mBackupedObjects != null) {
            int count = this.mBackupedObjects.size();
            int i = 0;
            while (i < count) {
                E o = this.mBackupedObjects.get(i);
                if (o == object) {
                    this.mBackupedObjects.set(i, null);
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public final void remove(int index) {
        if (this.mSafeLockCount != 0 && !this.mBackuped) {
            this.backup();
        }
        Object object = null;
        if (this.mObjects != null) {
            object = this.mObjects.get(index);
            this.mObjects.set(index, null);
        }
        if (this.mBackuped && object != null && this.mBackupedObjects != null) {
            int count = this.mBackupedObjects.size();
            int i = 0;
            while (i < count) {
                E o = this.mBackupedObjects.get(i);
                if (o == object) {
                    this.mBackupedObjects.set(i, null);
                    break;
                }
                ++i;
            }
        }
    }
}

