/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class Random {
    private static byte[] RandomSeedPool;
    private static int RandomSeedPoolPos;
    private static byte RandomSeedAtom;

    public static void initialize() {
        RandomSeedPool = new byte[4608];
        RandomSeedPoolPos = 0;
        UUID uuid = UUID.randomUUID();
        long m = uuid.getMostSignificantBits();
        long l = uuid.getLeastSignificantBits();
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 56 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 48 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 40 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 32 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 24 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 16 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m >> 8 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(m & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 56 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 48 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 40 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 32 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 24 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 16 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l >> 8 & 0xFFL));
        RandomSeedAtom = (byte)(RandomSeedAtom ^ (byte)(l & 0xFFL));
    }

    public static void finalizeApplication() {
        RandomSeedPool = null;
        RandomSeedPoolPos = 0;
    }

    public static void pushEnvironNoise(byte[] buf) {
        int bufsize = buf.length;
        int i = 0;
        while (i < bufsize) {
            int n = RandomSeedPoolPos++;
            RandomSeedAtom = (byte)(RandomSeedAtom ^ buf[i]);
            RandomSeedPool[n] = (byte)(RandomSeedPool[n] ^ RandomSeedAtom);
            RandomSeedPoolPos &= 0xFFF;
            ++i;
        }
        RandomSeedPoolPos += buf[0] & 1;
        RandomSeedPoolPos &= 0xFFF;
    }

    public static void updateEnvironNoiseForTick() {
        long tick = System.currentTimeMillis();
        Random.pushEnvironNoise(tick);
    }

    public static void pushEnvironNoise(long val) {
        byte[] buf = new byte[]{(byte)(val >> 56 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val & 0xFFL)};
        Random.pushEnvironNoise(buf);
        buf = null;
    }

    public static void pushEnvironNoise(int val) {
        byte[] buf = new byte[]{(byte)(val >> 24 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        Random.pushEnvironNoise(buf);
        buf = null;
    }

    public static void getRandomBits128(byte[] dest) {
        Random.pushEnvironNoise(RandomSeedPoolPos);
        UUID uuid = UUID.randomUUID();
        long m = uuid.getMostSignificantBits();
        long l = uuid.getLeastSignificantBits();
        if (dest.length >= 16) {
            dest[0] = (byte)(m >> 56 & 0xFFL);
            dest[1] = (byte)(m >> 48 & 0xFFL);
            dest[2] = (byte)(m >> 40 & 0xFFL);
            dest[3] = (byte)(m >> 32 & 0xFFL);
            dest[4] = (byte)(m >> 24 & 0xFFL);
            dest[5] = (byte)(m >> 16 & 0xFFL);
            dest[6] = (byte)(m >> 8 & 0xFFL);
            dest[7] = (byte)(m & 0xFFL);
            dest[8] = (byte)(l >> 56 & 0xFFL);
            dest[9] = (byte)(l >> 48 & 0xFFL);
            dest[10] = (byte)(l >> 40 & 0xFFL);
            dest[11] = (byte)(l >> 32 & 0xFFL);
            dest[12] = (byte)(l >> 24 & 0xFFL);
            dest[13] = (byte)(l >> 16 & 0xFFL);
            dest[14] = (byte)(l >> 8 & 0xFFL);
            dest[15] = (byte)(l & 0xFFL);
            Random.pushEnvironNoise(dest);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(RandomSeedPool, 0, 4096);
            byte[] digest = md.digest();
            int i = 0;
            while (i < digest.length && i < dest.length) {
                int n = i;
                dest[n] = (byte)(dest[n] ^ digest[i]);
                ++i;
            }
            Random.pushEnvironNoise(digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

