/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.StringStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;

public class ScenarioCacheItem {
    private String[] mLines;
    private HashMap<String, LabelCacheData> mLabelCache;
    private ArrayList<String> mLabelAliases = new ArrayList();
    private boolean mLabelCached;

    public ScenarioCacheItem(String name, boolean isstring) {
        this.mLabelCache = new HashMap();
        try {
            this.loadScenario(name, isstring);
        }
        catch (Exception e) {
            this.mLines = null;
        }
    }

    private final void loadScenario(String name, boolean isstring) throws TJSException {
        String buffer = isstring ? name : Storage.readText(name, "");
        StringStream stream = new StringStream(buffer);
        int count = stream.getMaxLine();
        if (count == 0) {
            Message.throwExceptionMessage("\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u305f\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb %1 \u306f\u7a7a\u3067\u3059", name);
        }
        this.mLines = new String[count];
        int i = 0;
        while (i < count) {
            String line = stream.getLine(i);
            if (line.length() != 0 && line.charAt(0) == '\t') {
                int tab = 1;
                int length = line.length();
                while (tab < length) {
                    if (line.charAt(tab) != '\t') break;
                    ++tab;
                }
                this.mLines[i] = line.substring(tab);
            } else {
                this.mLines[i] = line;
            }
            ++i;
        }
        stream = null;
    }

    public final String getLabelAliasFromLine(int line) {
        return this.mLabelAliases.get(line);
    }

    public final void ensureLabelCache() throws TJSException {
        if (!this.mLabelCached) {
            String prevlabel = null;
            int count = this.mLines.length;
            this.mLabelAliases.ensureCapacity(count);
            int i = 0;
            while (i < count) {
                this.mLabelAliases.add(null);
                ++i;
            }
            StringBuilder builder = new StringBuilder(256);
            int i2 = 0;
            while (i2 < count) {
                if (this.mLines[i2].length() >= 2 && this.mLines[i2].charAt(0) == '*') {
                    String p = this.mLines[i2];
                    int vl = p.indexOf(124);
                    String label = vl != -1 ? p.substring(0, vl) : p;
                    if (label.length() == 1) {
                        if (prevlabel == null || prevlabel.length() == 0) {
                            Message.throwExceptionMessage("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u306e\u6700\u521d\u306e\u30e9\u30d9\u30eb\u540d\u306f\u7701\u7565\u3067\u304d\u307e\u305b\u3093");
                        }
                        label = prevlabel;
                    }
                    prevlabel = label;
                    LabelCacheData data = this.mLabelCache.get(label);
                    if (data != null) {
                        ++data.Count;
                        builder.append(label);
                        builder.append(':');
                        builder.append(data.Count);
                        label = builder.toString();
                        builder.delete(0, builder.length());
                    }
                    this.mLabelCache.put(label, new LabelCacheData(i2, 1));
                    this.mLabelAliases.add(i2, label);
                }
                ++i2;
            }
            this.mLabelCached = true;
        }
    }

    public final String[] getLines() {
        return this.mLines;
    }

    public final int getLineCount() {
        return this.mLines.length;
    }

    public final HashMap<String, LabelCacheData> getLabelCache() {
        return this.mLabelCache;
    }

    public static class LabelCacheData {
        public int Line;
        public int Count;

        public LabelCacheData(int line, int count) {
            this.Line = line;
            this.Count = count;
        }
    }
}

