/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.utils;

import java.lang.ref.WeakReference;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2env.TimerThread;

public class TimerNI
extends NativeInstanceObject {
    private static final int DEFAULT_TIMER_CAPACITY = 6;
    private static final int atmNormal = 0;
    private static final int atmExclusive = 1;
    private static final int atmAtIdle = 2;
    public static boolean LimitTimerCapacity;
    private static final String ON_TIMER = "onTimer";
    private WeakReference<Dispatch2> mOwner;
    private VariantClosure mActionOwner = new VariantClosure(null);
    private int mCounter;
    private int mCapacity = 6;
    private String mActionName = "action";
    private int mMode = 0;
    private long mInterval = 1000L;
    private long mNextTick;
    private int mPendingCount;
    private boolean mEnabled;

    public static void initialize() {
        LimitTimerCapacity = false;
    }

    @Override
    public int construct(Variant[] param, Dispatch2 tjs_obj) throws VariantException, TJSException {
        if (param.length < 1) {
            return -1004;
        }
        int hr = super.construct(param, tjs_obj);
        if (hr < 0) {
            return hr;
        }
        if (param.length >= 2 && !param[1].isVoid()) {
            this.mActionName = param[1].asString();
        }
        this.mActionOwner.set(param[0].asObjectClosure());
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        TimerThread.add(this);
        return 0;
    }

    @Override
    public void invalidate() throws VariantException, TJSException {
        TimerThread.remove(this);
        this.zeroPendingCount();
        this.cancelEvents();
        TVP.EventManager.cancelSourceEvents((Dispatch2)this.mOwner.get());
        this.mOwner.clear();
        this.mActionOwner.mObject = null;
        this.mActionOwner.mObjThis = null;
        super.invalidate();
    }

    private void fire(int n) {
        int count;
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner == null) {
            return;
        }
        if (TVP.EventManager == null) {
            return;
        }
        int cap = LimitTimerCapacity ? 1 : (this.mCapacity == 0 ? 65535 : this.mCapacity);
        int more = cap - (count = TVP.EventManager.countEventsInQueue(owner, owner, ON_TIMER, 0));
        if (more > 0) {
            if (n > more) {
                n = more;
            }
            if ((owner = (Dispatch2)this.mOwner.get()) != null) {
                int tag = 1 + (this.mCounter << 1);
                int flags = 16;
                switch (this.mMode) {
                    case 0: {
                        flags |= 0;
                        break;
                    }
                    case 1: {
                        flags |= 0x20;
                        break;
                    }
                    case 2: {
                        flags |= 0x40;
                    }
                }
                while (n-- > 0) {
                    TVP.EventManager.postEvent(owner, owner, ON_TIMER, tag, flags, TJS.NULL_ARG);
                }
            }
            ++this.mCounter;
        }
    }

    public void cancelEvents() {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.cancelEvents(owner, owner, ON_TIMER, 0);
        }
    }

    private boolean areEventsInQueue() {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            return TVP.EventManager.areEventsInQueue(owner, owner, ON_TIMER, 0);
        }
        return false;
    }

    public VariantClosure getActionOwner() {
        return this.mActionOwner;
    }

    public final String getActionName() {
        return this.mActionName;
    }

    public int getCapacity() {
        return this.mCapacity;
    }

    public void setCapacity(int c) {
        this.mCapacity = c;
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void internalSetInterval(long n) {
        this.mInterval = n;
    }

    public void setInterval(long n) {
        if (TVP.TimerThread != null) {
            TVP.TimerThread.setInterval(this, n);
        }
    }

    public long getInterval() {
        return this.mInterval;
    }

    public void zeroPendingCount() {
        this.mPendingCount = 0;
    }

    public void setNextTick(long n) {
        this.mNextTick = n;
    }

    public long getNextTick() {
        return this.mNextTick;
    }

    public void internalSetEnabled(boolean b) {
        this.mEnabled = b;
    }

    public void setEnabled(boolean b) {
        if (TVP.TimerThread != null) {
            TVP.TimerThread.setEnabled(this, b);
        }
    }

    public boolean getEnabled() {
        return this.mEnabled;
    }

    public void trigger(int n) {
        if (this.mPendingCount == 0) {
            TimerThread.registerToPending(this);
        }
        this.mPendingCount += n;
    }

    public void firePendingEventsAndClear() {
        if (this.mPendingCount != 0) {
            this.fire(this.mPendingCount);
            this.zeroPendingCount();
        }
    }
}

