/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.HashCache;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.BinaryOutputStream;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.AffineMatrix2D;
import jp.kirikiri.tvp2.visual.CharacterData;
import jp.kirikiri.tvp2.visual.ComplexRect;
import jp.kirikiri.tvp2.visual.FontAndCharacterData;
import jp.kirikiri.tvp2.visual.GammaAdjustData;
import jp.kirikiri.tvp2.visual.GammaAdjustTempData;
import jp.kirikiri.tvp2.visual.PointD;
import jp.kirikiri.tvp2.visual.PrerenderedFont;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.Size;
import jp.kirikiri.tvp2env.Font;
import jp.kirikiri.tvp2env.NativeImageBuffer;

public class BaseBitmap {
    public static final int BB_COPY_MAIN = 1;
    public static final int BB_COPY_MASK = 2;
    public static final int stNearest = 0;
    public static final int stFastLinear = 1;
    public static final int stLinear = 2;
    public static final int stCubic = 3;
    public static final int stTypeMask = 15;
    public static final int stFlagMask = 240;
    public static final int stRefNoClip = 16;
    public static boolean USE_NATIVE_TEXT_DRAW = false;
    private static HashMap<String, PrerenderedFont> PrerenderedFonts;
    private static ArrayList<PrerenderedFontMap> PrerenderedFontMapVector;
    private static int GlobalFontStateMagic;
    private static final int CH_MAX_CACHE_COUNT_LOW = 100;
    private static HashCache<FontAndCharacterData, CharacterData> FontCache;
    private static boolean ClearFontCacheCallbackInit;
    private NativeImageBuffer mBitmap;
    private boolean mFontChanged = true;
    private Font mFont = new Font(Font.getDefaultFont());
    private PrerenderedFont mPrerenderedFont;
    private int mGlobalFontState = -1;
    private int mAscentOfsX;
    private int mAscentOfsY;
    private double mRadianAngle;
    private int mTextWidth;
    private int mTextHeight;
    private String mCachedText;
    private DrawTextData mDrawTextData;
    private static final double EPS = 1.0E-12;
    private static final int MAX_COEFF = 3;

    static {
        ClearFontCacheCallbackInit = false;
    }

    public static void initialize() {
        PrerenderedFonts = new HashMap();
        PrerenderedFontMapVector = new ArrayList();
        FontCache = new HashCache(100);
        GlobalFontStateMagic = 0;
        ClearFontCacheCallbackInit = false;
        String type = TVP.Properties.getProperty("text_draw_method", "engine");
        USE_NATIVE_TEXT_DRAW = !"engine".equals(type);
    }

    public static void finalizeApplication() {
        FontCache = null;
        PrerenderedFonts = null;
        PrerenderedFontMapVector = null;
    }

    static void clearFontCache() {
        FontCache.clear();
    }

    public BaseBitmap(int w, int h, int bpp) {
        this.mBitmap = new NativeImageBuffer(w, h, bpp);
    }

    public BaseBitmap(BaseBitmap r) {
        this.mBitmap = r.mBitmap;
        this.mBitmap.addRef();
    }

    protected final void finalize() {
        if (this.mBitmap != null) {
            this.mBitmap.finalizeRelease();
            this.mBitmap = null;
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final int getWidth() {
        return this.mBitmap.getWidth();
    }

    private final void setWidth(int w) throws TJSException {
        this.setSize(w, this.getHeight());
    }

    public final int getHeight() {
        return this.mBitmap.getHeight();
    }

    private final void setHeight(int h) throws TJSException {
        this.setSize(this.getWidth(), h);
    }

    public final void setSize(int w, int h) throws TJSException {
        this.setSize(w, h, true);
    }

    public final void setSize(int w, int h, boolean keepimage) throws TJSException {
        if (this.mBitmap.getWidth() != w || this.mBitmap.getHeight() != h) {
            NativeImageBuffer newbitmap = keepimage ? new NativeImageBuffer(w, h, this.mBitmap) : new NativeImageBuffer(w, h, this.mBitmap.getBPP());
            this.mBitmap.release();
            this.mBitmap = null;
            this.mBitmap = newbitmap;
            this.mFontChanged = true;
        }
    }

    public final int getByteSize() {
        int w = this.mBitmap.getWidth();
        int h = this.mBitmap.getHeight();
        int bpp = this.mBitmap.getBPP() / 8;
        return w * h * bpp;
    }

    public final int getBPP() {
        return this.mBitmap.getBPP();
    }

    public final boolean is32BPP() {
        return this.getBPP() == 32;
    }

    public final boolean is8BPP() {
        return this.getBPP() == 8;
    }

    public boolean assign(BaseBitmap rhs) {
        if (this == rhs || this.mBitmap == rhs.mBitmap) {
            return false;
        }
        this.mBitmap.release();
        this.mBitmap = null;
        this.mBitmap = rhs.mBitmap;
        this.mBitmap.addRef();
        this.mFont = new Font(rhs.mFont);
        this.mFontChanged = true;
        return true;
    }

    public boolean assignBitmap(BaseBitmap rhs) {
        if (this == rhs || this.mBitmap == rhs.mBitmap) {
            return false;
        }
        this.mBitmap.release();
        this.mBitmap = null;
        this.mBitmap = rhs.mBitmap;
        this.mBitmap.addRef();
        this.mFontChanged = true;
        return true;
    }

    public boolean setNativeBitmap(NativeImageBuffer rhs) {
        if (this.mBitmap == rhs) {
            return false;
        }
        this.mBitmap.release();
        this.mBitmap = null;
        this.mBitmap = rhs;
        this.mFontChanged = true;
        return true;
    }

    public int getPitchBytes() {
        return this.getWidth();
    }

    public void independ() {
        if (this.mBitmap.isIndependent()) {
            return;
        }
        NativeImageBuffer newb = new NativeImageBuffer(this.mBitmap);
        this.mBitmap.release();
        this.mBitmap = null;
        this.mBitmap = newb;
        this.mFontChanged = true;
    }

    public void independNoCopy() {
        if (this.mBitmap.isIndependent()) {
            return;
        }
        this.recreate();
    }

    private void recreate() {
        this.recreate(this.mBitmap.getWidth(), this.mBitmap.getHeight(), this.mBitmap.getBPP());
    }

    private void recreate(int width, int height, int bpp) {
        this.mBitmap.release();
        this.mBitmap = null;
        this.mBitmap = new NativeImageBuffer(width, height, bpp);
        this.mFontChanged = true;
    }

    private void applyFont() {
        if (this.mFontChanged || this.mGlobalFontState != GlobalFontStateMagic) {
            this.independ();
            this.mFontChanged = false;
            this.mGlobalFontState = GlobalFontStateMagic;
            this.mCachedText = null;
            this.mTextHeight = 0;
            this.mTextWidth = 0;
            if (this.mPrerenderedFont != null) {
                this.mPrerenderedFont = null;
            }
            this.mPrerenderedFont = BaseBitmap.getPrerenderedMappedFont(this.mFont);
            float ascent = this.mFont.getAscent();
            this.mRadianAngle = (double)this.mFont.getAngle() * 0.0017453292519943296;
            double angle90 = this.mRadianAngle + 1.5707963267948966;
            this.mAscentOfsX = (int)(-Math.cos(angle90) * (double)ascent);
            this.mAscentOfsY = (int)(Math.sin(angle90) * (double)ascent);
        }
    }

    public boolean isIndependent() {
        return this.mBitmap.isIndependent();
    }

    public NativeImageBuffer getNativeImageBuffer() {
        return this.mBitmap;
    }

    public NativeImageBuffer getBitmap() {
        return this.mBitmap;
    }

    public void setFont(Font font) {
        if (this.mFont != font) {
            this.mFont.setFont(font);
        }
        this.mFontChanged = true;
    }

    public Font getFont() {
        this.applyFont();
        return this.mFont;
    }

    public boolean selectFont(int flags, String caption, String prompt, String samplestring, String faceName) {
        this.applyFont();
        return false;
    }

    public void getFontList(int flags, ArrayList<String> list) {
        Font.getFontList(flags, list);
    }

    public void loadFont(String storage, String facename) throws TJSException {
        this.applyFont();
        String name = TVP.StorageMediaManager.normalizeStorageName(storage, null);
        BinaryStream stream = Storage.createStream(name, 0);
        this.independ();
        this.mFont = new Font(stream, this.mFont, facename);
        this.mFontChanged = true;
    }

    public void mapPrerenderedFont(String storage) throws TJSException {
        this.applyFont();
        String fn = Storage.searchPlacedPath(storage);
        PrerenderedFont font = PrerenderedFonts.get(fn);
        if (font == null) {
            String name = TVP.StorageMediaManager.normalizeStorageName(storage, null);
            BinaryStream stream = Storage.createStream(name, 0);
            font = new PrerenderedFont(stream);
            PrerenderedFonts.put(fn, font);
        }
        int count = PrerenderedFontMapVector.size();
        int i = 0;
        while (i < count) {
            PrerenderedFontMap p = PrerenderedFontMapVector.get(i);
            if (p.equals(this.mFont)) {
                p.Object = null;
                p.Object = font;
                break;
            }
            ++i;
        }
        if (i == count) {
            PrerenderedFontMap map = new PrerenderedFontMap();
            map.setFont(this.mFont);
            map.Object = font;
            PrerenderedFontMapVector.add(map);
        }
        ++GlobalFontStateMagic;
        BaseBitmap.clearFontCache();
        this.mFontChanged = true;
    }

    public void unmapPrerenderedFont() {
        this.applyFont();
        int count = PrerenderedFontMapVector.size();
        int i = 0;
        while (i < count) {
            PrerenderedFontMap p = PrerenderedFontMapVector.get(i);
            if (p.equals(this.mFont)) {
                p.Object = null;
                PrerenderedFontMapVector.remove(i);
                ++GlobalFontStateMagic;
                BaseBitmap.clearFontCache();
                break;
            }
            ++i;
        }
        this.mFontChanged = true;
    }

    public static void unmapPrerenderedAllFont() {
        if (PrerenderedFontMapVector == null) {
            return;
        }
        int count = PrerenderedFontMapVector.size();
        int i = 0;
        while (i < count) {
            PrerenderedFontMap p = PrerenderedFontMapVector.get(i);
            p.clear();
            ++i;
        }
        PrerenderedFontMapVector.clear();
        ++GlobalFontStateMagic;
    }

    private static PrerenderedFont getPrerenderedMappedFont(Font font) {
        int count = PrerenderedFontMapVector.size();
        int i = 0;
        while (i < count) {
            PrerenderedFontMap p = PrerenderedFontMapVector.get(i);
            if (p.equals(font)) {
                return p.Object;
            }
            ++i;
        }
        return null;
    }

    public final void drawText(Rect destrect, int x, int y, String text, int color, int bltmode, int opa, boolean holdalpha, boolean aa, int shlevel, int shadowcolor, int shwidth, int shofsx, int shofsy, ComplexRect updaterects) throws TJSException {
        int len = text.length();
        if (len == 0) {
            return;
        }
        if (USE_NATIVE_TEXT_DRAW && this.mPrerenderedFont == null) {
            this.independ();
            this.applyFont();
            this.mBitmap.drawText(this.mFont, destrect, x, y, text, color, bltmode, opa, holdalpha, aa, shlevel, shadowcolor, shwidth, shofsx, shofsy, updaterects);
        } else if (len >= 2) {
            this.drawTextMultiple(destrect, x, y, text, color, bltmode, opa, holdalpha, aa, shlevel, shadowcolor, shwidth, shofsx, shofsy, updaterects);
        } else {
            this.drawTextSingle(destrect, x, y, text, color, bltmode, opa, holdalpha, aa, shlevel, shadowcolor, shwidth, shofsx, shofsy, updaterects);
        }
    }

    private void drawTextSingle(Rect destrect, int x, int y, String text, int color, int bltmode, int opa, boolean holdalpha, boolean aa, int shlevel, int shadowcolor, int shwidth, int shofsx, int shofsy, ComplexRect updaterects) throws TJSException {
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (bltmode == 3) {
            if (opa < -255) {
                opa = -255;
            }
            if (opa > 255) {
                opa = 255;
            }
        } else {
            if (opa < 0) {
                opa = 0;
            }
            if (opa > 255) {
                opa = 255;
            }
        }
        if (opa == 0) {
            return;
        }
        this.independ();
        this.applyFont();
        if (this.mDrawTextData == null) {
            this.mDrawTextData = new DrawTextData();
        }
        this.mDrawTextData.rect.set(destrect);
        this.mDrawTextData.bltmode = bltmode;
        this.mDrawTextData.opa = opa;
        this.mDrawTextData.holdalpha = holdalpha;
        FontAndCharacterData font = new FontAndCharacterData();
        font.Font.setFont(this.mFont);
        font.Antialiased = aa;
        font.BlurLevel = shlevel;
        font.BlurWidth = shwidth;
        font.Character = text.charAt(0);
        font.Blured = false;
        CharacterData shadow = null;
        CharacterData data = this.getCharacter(font, this.mPrerenderedFont, this.mAscentOfsX, this.mAscentOfsY);
        if (shlevel != 0) {
            if (shlevel == 255 && shwidth == 0) {
                shadow = data;
            } else {
                font = new FontAndCharacterData(font);
                font.Blured = true;
                shadow = this.getCharacter(font, this.mPrerenderedFont, this.mAscentOfsX, this.mAscentOfsY);
            }
        }
        if (data != null && data.mBlackBoxX != 0 && data.mBlackBoxY != 0) {
            Rect drect = new Rect();
            Rect shadowdrect = new Rect();
            boolean shadowdrawn = false;
            if (shadow != null) {
                shadowdrawn = this.internalDrawText(shadow, x + shofsx, y + shofsy, shadowcolor, this.mDrawTextData, shadowdrect);
            }
            boolean drawn = this.internalDrawText(data, x, y, color, this.mDrawTextData, drect);
            if (updaterects != null) {
                if (!shadowdrawn) {
                    if (drawn) {
                        updaterects.or(drect);
                    }
                } else if (drawn) {
                    Rect d = new Rect();
                    Rect.unionRect(d, drect, shadowdrect);
                    updaterects.or(d);
                } else {
                    updaterects.or(shadowdrect);
                }
            }
        }
    }

    private void drawTextMultiple(Rect destrect, int x, int y, String text, int color, int bltmode, int opa, boolean holdalpha, boolean aa, int shlevel, int shadowcolor, int shwidth, int shofsx, int shofsy, ComplexRect updaterects) throws TJSException {
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (bltmode == 3) {
            if (opa < -255) {
                opa = -255;
            }
            if (opa > 255) {
                opa = 255;
            }
        } else {
            if (opa < 0) {
                opa = 0;
            }
            if (opa > 255) {
                opa = 255;
            }
        }
        if (opa == 0) {
            return;
        }
        this.independ();
        this.applyFont();
        if (this.mDrawTextData == null) {
            this.mDrawTextData = new DrawTextData();
        }
        this.mDrawTextData.rect.set(destrect);
        this.mDrawTextData.bltmode = bltmode;
        this.mDrawTextData.opa = opa;
        this.mDrawTextData.holdalpha = holdalpha;
        FontAndCharacterData base = new FontAndCharacterData();
        base.Font.setFont(this.mFont);
        base.Antialiased = aa;
        base.BlurLevel = shlevel;
        base.BlurWidth = shwidth;
        base.Blured = false;
        int count = text.length();
        ArrayList<CharacterDrawData> drawdata = new ArrayList<CharacterDrawData>(count);
        CharacterData data = null;
        CharacterData shadow = null;
        int i = 0;
        while (i < count) {
            char c = text.charAt(i);
            FontAndCharacterData font = new FontAndCharacterData(base);
            font.Character = c;
            data = this.getCharacter(font, this.mPrerenderedFont, this.mAscentOfsX, this.mAscentOfsY);
            if (data != null) {
                if (shlevel != 0) {
                    if (shlevel == 255 && shwidth == 0) {
                        shadow = data;
                    } else {
                        font = new FontAndCharacterData(font);
                        font.Blured = true;
                        shadow = this.getCharacter(font, this.mPrerenderedFont, this.mAscentOfsX, this.mAscentOfsY);
                    }
                }
                if (data.mBlackBoxX != 0 && data.mBlackBoxY != 0) {
                    drawdata.add(new CharacterDrawData(data, shadow, x, y));
                }
                x += data.mCellIncX;
                if (data.mCellIncY != 0) {
                    if (this.mFont.getAngle() < 1800) {
                        if (data.mCellIncY > 0) {
                            data.mCellIncY = -data.mCellIncY;
                        }
                    } else if (data.mCellIncY < 0) {
                        data.mCellIncY = -data.mCellIncY;
                    }
                    y += data.mCellIncY;
                }
            }
            ++i;
        }
        int dcount = drawdata.size();
        if (shlevel != 0) {
            int i2 = 0;
            while (i2 < dcount) {
                CharacterDrawData d = (CharacterDrawData)drawdata.get(i2);
                shadow = d.mShadow;
                if (shadow != null) {
                    d.mShadowDrawn = this.internalDrawText(shadow, d.mX + shofsx, d.mY + shofsy, shadowcolor, this.mDrawTextData, d.mShadowRect);
                }
                ++i2;
            }
        }
        Rect drect = new Rect();
        int i3 = 0;
        while (i3 < dcount) {
            CharacterDrawData d = (CharacterDrawData)drawdata.get(i3);
            boolean drawn = this.internalDrawText(d.mData, d.mX, d.mY, color, this.mDrawTextData, drect);
            if (updaterects != null) {
                if (!d.mShadowDrawn) {
                    if (drawn) {
                        updaterects.or(drect);
                    }
                } else if (drawn) {
                    Rect ur = new Rect();
                    Rect.unionRect(ur, drect, d.mShadowRect);
                    updaterects.or(ur);
                } else {
                    updaterects.or(d.mShadowRect);
                }
            }
            ++i3;
        }
    }

    private boolean internalDrawText(CharacterData data, int x, int y, int color, DrawTextData dtdata, Rect drect) throws TJSException {
        drect.left = x + data.mOriginX;
        drect.top = y + data.mOriginY;
        drect.right = drect.left + data.mBlackBoxX;
        drect.bottom = drect.top + data.mBlackBoxY;
        Rect srect = new Rect();
        srect.top = 0;
        srect.left = 0;
        srect.right = data.mBlackBoxX;
        srect.bottom = data.mBlackBoxY;
        if (drect.left < dtdata.rect.left) {
            srect.left += dtdata.rect.left - drect.left;
            drect.left = dtdata.rect.left;
        }
        if (drect.right > dtdata.rect.right) {
            srect.right -= drect.right - dtdata.rect.right;
            drect.right = dtdata.rect.right;
        }
        if (srect.left >= srect.right) {
            return false;
        }
        if (drect.top < dtdata.rect.top) {
            srect.top += dtdata.rect.top - drect.top;
            drect.top = dtdata.rect.top;
        }
        if (drect.bottom > dtdata.rect.bottom) {
            srect.bottom -= drect.bottom - dtdata.rect.bottom;
            drect.bottom = dtdata.rect.bottom;
        }
        if (srect.top >= srect.bottom) {
            return false;
        }
        int pitch = data.mPitch;
        byte[] bp = data.getData();
        this.mBitmap.drawFontImage(bp, pitch, srect, drect, color, dtdata.bltmode, dtdata.opa, dtdata.holdalpha);
        return true;
    }

    private CharacterData getCharacter(FontAndCharacterData font, PrerenderedFont pfont, int aofsx, int aofsy) {
        CharacterData ptr;
        if (!ClearFontCacheCallbackInit) {
            TVP.EventManager.addCompactEventHook(new CompactEventCallbackInterface(){

                @Override
                public void onCompact(int level) {
                    if (level >= 15) {
                        BaseBitmap.clearFontCache();
                    }
                }
            });
            ClearFontCacheCallbackInit = true;
        }
        if ((ptr = (CharacterData)FontCache.getAndTouch(font)) != null) {
            return ptr;
        }
        PrerenderedFont.CharacterItem pitem = null;
        if (pfont != null) {
            pitem = pfont.getCharData(font.Character);
        }
        if (pitem != null) {
            CharacterData data = new CharacterData();
            data.mBlackBoxX = pitem.Width;
            data.mBlackBoxY = pitem.Height;
            data.mCellIncX = pitem.IncX;
            data.mCellIncY = pitem.IncY;
            data.mOriginX = pitem.OriginX + aofsx;
            data.mOriginY = -pitem.OriginY + aofsy;
            data.mAntialiased = font.Antialiased;
            data.mFullColored = false;
            data.mBlured = font.Blured;
            data.mBlurWidth = font.BlurWidth;
            data.mBlurLevel = font.BlurLevel;
            if (data.mBlackBoxX != 0 && data.mBlackBoxY != 0) {
                int newpitch;
                data.mPitch = newpitch = (pitem.Width - 1 >>> 2) + 1 << 2;
                data.alloc(newpitch * data.mBlackBoxY);
                pfont.retrieve(pitem, data.getData(), newpitch);
                if (font.Blured) {
                    data.blur();
                }
                FontCache.put(font, data);
            }
            return data;
        }
        CharacterData data = NativeImageBuffer.getCharacterData(this.mFont, font.Character, font.Antialiased);
        data.mOriginX += aofsx;
        data.mOriginY += aofsy;
        data.mBlured = font.Blured;
        data.mBlurWidth = font.BlurWidth;
        data.mBlurLevel = font.BlurLevel;
        if (font.Blured) {
            data.blur();
        }
        FontCache.put(font, data);
        return data;
    }

    private void getTextSize(String text) {
        this.applyFont();
        if (this.mCachedText == null || !this.mCachedText.equals(text)) {
            this.mCachedText = text;
            if (this.mPrerenderedFont == null) {
                Size size = this.mFont.getTextSize(text);
                this.mTextWidth = size.width;
                this.mTextHeight = size.height;
            } else {
                int width = 0;
                int len = text.length();
                int i = 0;
                while (i < len) {
                    char c = text.charAt(i);
                    PrerenderedFont.CharacterItem item = this.mPrerenderedFont.getCharData(c);
                    if (item != null) {
                        width += item.Inc;
                    } else {
                        int w = this.mFont.getTextWidth(String.valueOf(c));
                        width += w;
                    }
                    ++i;
                }
                this.mTextWidth = width;
                this.mTextHeight = Math.abs(this.mFont.getHeight());
            }
        }
    }

    public int getTextWidth(String text) {
        this.getTextSize(text);
        return this.mTextWidth;
    }

    public int getTextHeight(String text) {
        this.getTextSize(text);
        return this.mTextHeight;
    }

    public double getEscWidthX(String text) {
        this.getTextSize(text);
        return Math.cos(this.mFont.getAngle()) * (double)this.mTextWidth;
    }

    public double getEscWidthY(String text) {
        this.getTextSize(text);
        return Math.sin(this.mFont.getAngle()) * (double)(-this.mTextWidth);
    }

    public double getEscHeightX(String text) {
        this.getTextSize(text);
        return Math.sin(this.mFont.getAngle()) * (double)this.mTextHeight;
    }

    public double getEscHeightY(String text) {
        this.getTextSize(text);
        return Math.cos(this.mFont.getAngle()) * (double)this.mTextHeight;
    }

    public void setSizeWithFill(int w, int h, int fillvalue) throws TJSException {
        int orgw = this.getWidth();
        int orgh = this.getHeight();
        this.setSize(w, h);
        if (this.mBitmap.getBPP() == 32 && !this.mBitmap.isImageAllocated()) {
            Rect rect = new Rect(0, 0, w, h);
            this.fill(rect, fillvalue);
            return;
        }
        if (w > orgw && h > orgh) {
            Rect rect = new Rect();
            rect.left = orgw;
            rect.top = 0;
            rect.right = w;
            rect.bottom = h;
            this.fill(rect, fillvalue);
            rect.left = 0;
            rect.top = orgh;
            rect.right = orgw;
            rect.bottom = h;
            this.fill(rect, fillvalue);
        } else if (w > orgw) {
            Rect rect = new Rect();
            rect.left = orgw;
            rect.top = 0;
            rect.right = w;
            rect.bottom = h;
            this.fill(rect, fillvalue);
        } else if (h > orgh) {
            Rect rect = new Rect();
            rect.left = 0;
            rect.top = orgh;
            rect.right = w;
            rect.bottom = h;
            this.fill(rect, fillvalue);
        }
    }

    public final int getPoint(int x, int y) throws TJSException {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        return this.mBitmap.getPoint(x, y);
    }

    public final void setPoint(int x, int y, int n) throws TJSException {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        this.independ();
        this.mBitmap.setPoint(x, y, n);
    }

    public boolean fill(Rect rect, int value) throws TJSException {
        int i;
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        this.independ();
        this.mBitmap.fill(rect, value);
        return true;
    }

    public boolean fillColor(Rect rect, int color, int opa) throws TJSException {
        int i;
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (opa == 0) {
            return false;
        }
        if (opa < 0) {
            opa = 0;
        }
        if (opa > 255) {
            opa = 255;
        }
        this.independ();
        if (opa == 255) {
            this.mBitmap.fill(rect, color);
        } else {
            this.mBitmap.fillColor(rect, color, opa);
        }
        return true;
    }

    public boolean fillMask(Rect rect, int opa) throws TJSException {
        int i;
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        this.independ();
        this.mBitmap.fillMask(rect, opa);
        return true;
    }

    public boolean copyRect(int x, int y, BaseBitmap src, Rect refrect) throws TJSException {
        return this.copyRect(x, y, src, refrect, 3);
    }

    public boolean copyRect(int x, int y, BaseBitmap ref, Rect refrect, int plane) throws TJSException {
        if (!this.is32BPP()) {
            plane = 3;
        }
        if (x == 0 && y == 0 && refrect.left == 0 && refrect.top == 0 && refrect.right == ref.getWidth() && refrect.bottom == ref.getHeight() && this.getWidth() == refrect.right && this.getHeight() == refrect.bottom && plane == 3 && !this.is32BPP() == !ref.is32BPP()) {
            this.assignBitmap(ref);
            return true;
        }
        int bmpw = ref.getWidth();
        int bmph = ref.getHeight();
        if (refrect.left < 0) {
            x -= refrect.left;
            refrect.left = 0;
        }
        if (refrect.right > bmpw) {
            refrect.right = bmpw;
        }
        if (refrect.left >= refrect.right) {
            return false;
        }
        if (refrect.top < 0) {
            y -= refrect.top;
            refrect.top = 0;
        }
        if (refrect.bottom > bmph) {
            refrect.bottom = bmph;
        }
        if (refrect.top >= refrect.bottom) {
            return false;
        }
        bmpw = this.getWidth();
        bmph = this.getHeight();
        Rect rect = new Rect();
        rect.left = x;
        rect.top = y;
        rect.right = rect.left + refrect.width();
        rect.bottom = rect.top + refrect.height();
        if (rect.left < 0) {
            refrect.left += -rect.left;
            rect.left = 0;
        }
        if (rect.right > bmpw) {
            refrect.right -= rect.right - bmpw;
            rect.right = bmpw;
        }
        if (refrect.left >= refrect.right) {
            return false;
        }
        if (rect.top < 0) {
            refrect.top += -rect.top;
            rect.top = 0;
        }
        if (rect.bottom > bmph) {
            refrect.bottom -= rect.bottom - bmph;
            rect.bottom = bmph;
        }
        if (refrect.top >= refrect.bottom) {
            return false;
        }
        this.independ();
        return this.mBitmap.copyRect(rect.left, rect.top, ref.getBitmap(), refrect, plane);
    }

    public void blt(int x, int y, BaseBitmap ref, Rect refrect, int method, int opa) throws TJSException {
        this.blt(x, y, ref, refrect, method, opa, true);
    }

    public boolean blt(int x, int y, BaseBitmap ref, Rect refrect, int method, int opa, boolean hda) throws TJSException {
        if (opa == 255 && method == 0 && !hda) {
            this.independ();
            return this.copyRect(x, y, ref, refrect);
        }
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (opa == 0) {
            return false;
        }
        int bmpw = ref.getWidth();
        int bmph = ref.getHeight();
        if (refrect.left < 0) {
            x -= refrect.left;
            refrect.left = 0;
        }
        if (refrect.right > bmpw) {
            refrect.right = bmpw;
        }
        if (refrect.left >= refrect.right) {
            return false;
        }
        if (refrect.top < 0) {
            y -= refrect.top;
            refrect.top = 0;
        }
        if (refrect.bottom > bmph) {
            refrect.bottom = bmph;
        }
        if (refrect.top >= refrect.bottom) {
            return false;
        }
        bmpw = this.getWidth();
        bmph = this.getHeight();
        Rect rect = new Rect();
        rect.left = x;
        rect.top = y;
        rect.right = rect.left + refrect.width();
        rect.bottom = rect.top + refrect.height();
        if (rect.left < 0) {
            refrect.left += -rect.left;
            rect.left = 0;
        }
        if (rect.right > bmpw) {
            refrect.right -= rect.right - bmpw;
            rect.right = bmpw;
        }
        if (refrect.left >= refrect.right) {
            return false;
        }
        if (rect.top < 0) {
            refrect.top += -rect.top;
            rect.top = 0;
        }
        if (rect.bottom > bmph) {
            refrect.bottom -= rect.bottom - bmph;
            rect.bottom = bmph;
        }
        if (refrect.top >= refrect.bottom) {
            return false;
        }
        this.independ();
        return this.mBitmap.copyRect(rect, ref.getBitmap(), refrect, method, opa, hda);
    }

    public void saveAsBMP(String name, String type) throws TJSException {
        String nname = TVP.StorageMediaManager.normalizeStorageName(name, null);
        BinaryStream stream = Storage.createStream(nname, 1);
        if (stream != null) {
            BinaryOutputStream output = new BinaryOutputStream(stream);
            this.mBitmap.saveAs(output, name, type);
            output = null;
        }
        stream = null;
    }

    public void setPointMain(int x, int y, int color) throws TJSException {
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        this.independ();
        this.mBitmap.setPointMain(x, y, color);
    }

    public void setPointMask(int x, int y, int mask) throws TJSException {
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        this.independ();
        this.mBitmap.setPointMask(x, y, mask);
    }

    public boolean fillColorOnAlpha(Rect rect, int color, int opa) throws TJSException {
        return this.blendColor(rect, color, opa, false);
    }

    public boolean removeConstOpacity(Rect rect, int level) throws TJSException {
        int i;
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (level == 0) {
            return false;
        }
        if (level < 0) {
            level = 0;
        }
        if (level > 255) {
            level = 255;
        }
        this.independ();
        this.mBitmap.removeConstOpacity(rect, level);
        return true;
    }

    public boolean fillColorOnAddAlpha(Rect rect, int color, int opa) throws TJSException {
        return this.blendColor(rect, color, opa, true);
    }

    private boolean blendColor(Rect rect, int color, int opa, boolean additive) throws TJSException {
        int i;
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (opa == 0) {
            return false;
        }
        if (opa < 0) {
            opa = 0;
        }
        if (opa > 255) {
            opa = 255;
        }
        if (opa == 255 && !this.isIndependent() && rect.left == 0 && rect.top == 0 && rect.right == this.getWidth() && rect.bottom == this.getHeight()) {
            this.independNoCopy();
        }
        this.independ();
        this.mBitmap.blendColor(rect, color, opa, additive);
        return true;
    }

    public boolean stretchBlt(Rect cliprect, Rect destrect, BaseBitmap ref, Rect refrect, int method, int opa, boolean hda, int mode) throws TJSException {
        int dw = destrect.width();
        int dh = destrect.height();
        int rw = refrect.width();
        int rh = refrect.height();
        if (dw == 0 || rw == 0 || dh == 0 || rh == 0) {
            return false;
        }
        if (dw == rw && dh == rh && destrect.includedIn(cliprect)) {
            return this.blt(destrect.left, destrect.top, ref, refrect, method, opa, hda);
        }
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        int type = mode & 0xF;
        int w = this.getWidth();
        int h = this.getHeight();
        Rect cr = new Rect(cliprect);
        if (cr.left < 0) {
            cr.left = 0;
        }
        if (cr.top < 0) {
            cr.top = 0;
        }
        if (cr.right > w) {
            cr.right = w;
        }
        if (cr.bottom > h) {
            cr.bottom = h;
        }
        this.independ();
        this.mBitmap.stretchBlt(cr, destrect, ref.getBitmap(), refrect, type, hda, opa, method);
        return false;
    }

    public boolean affineBlt(Rect destrect, BaseBitmap ref, Rect refrect, AffineMatrix2D matrix, int method, int opa, Rect updaterect, boolean hda, int type, boolean clear, int clearcolor) throws TJSException {
        this.independ();
        return this.mBitmap.affineBlt(destrect, ref.getBitmap(), refrect, matrix, method, opa, updaterect, hda, type, clear, clearcolor);
    }

    private static boolean gaussianElimination(double[][] coeff, double[] tmp, double[] val) {
        int j;
        int i;
        int k = 0;
        while (k < 2) {
            int p = k;
            double pmax = Math.abs(coeff[k][k]);
            i = k + 1;
            while (i < 3) {
                if (Math.abs(coeff[i][k]) > pmax) {
                    p = i;
                    pmax = Math.abs(coeff[i][k]);
                }
                ++i;
            }
            if (Math.abs(pmax) < 1.0E-12) {
                return false;
            }
            if (p != k) {
                double s;
                i = k;
                while (i < 3) {
                    s = coeff[k][i];
                    coeff[k][i] = coeff[p][i];
                    coeff[p][i] = s;
                    ++i;
                }
                s = val[k];
                val[k] = val[p];
                val[p] = s;
            }
            i = k + 1;
            while (i < 3) {
                tmp[i] = coeff[i][k] / coeff[k][k];
                coeff[i][k] = 0.0;
                j = k + 1;
                while (j < 3) {
                    coeff[i][j] = coeff[i][j] - coeff[k][j] * tmp[i];
                    ++j;
                }
                val[i] = val[i] - val[k] * tmp[i];
                ++i;
            }
            ++k;
        }
        i = 2;
        while (i >= 0) {
            j = i + 1;
            while (j < 3) {
                val[i] = val[i] - coeff[i][j] * val[j];
                coeff[i][j] = 0.0;
                ++j;
            }
            val[i] = val[i] / coeff[i][i];
            coeff[i][i] = 1.0;
            --i;
        }
        return true;
    }

    public boolean affineBlt(Rect destrect, BaseBitmap ref, Rect refrect, PointD[] points_in, int method, int opa, Rect updaterect, boolean hda, int type, boolean clear, int clearcolor) throws TJSException {
        int rp = refrect.width();
        int bp = refrect.height();
        double[][] coeff = new double[3][];
        double[] val = new double[3];
        double[] tmp = new double[3];
        int i = 0;
        while (i < 3) {
            coeff[i] = new double[3];
            val[i] = points_in[i].x;
            coeff[i][0] = -0.5;
            coeff[i][1] = -0.5;
            coeff[i][2] = 1.0;
            ++i;
        }
        coeff[1][0] = (double)rp - 0.5;
        coeff[2][1] = (double)bp - 0.5;
        if (!BaseBitmap.gaussianElimination(coeff, tmp, val)) {
            return false;
        }
        double a = val[0];
        double c = val[1];
        double tx = val[2];
        int i2 = 0;
        while (i2 < 3) {
            val[i2] = points_in[i2].y;
            coeff[i2][0] = -0.5;
            coeff[i2][1] = -0.5;
            coeff[i2][2] = 1.0;
            ++i2;
        }
        coeff[1][0] = (double)rp - 0.5;
        coeff[2][1] = (double)bp - 0.5;
        if (!BaseBitmap.gaussianElimination(coeff, tmp, val)) {
            return false;
        }
        double b = val[0];
        double d = val[1];
        double ty = val[2];
        AffineMatrix2D matrix = new AffineMatrix2D(a, b, c, d, tx, ty);
        this.independ();
        return this.mBitmap.affineBlt(destrect, ref.getBitmap(), refrect, matrix, method, opa, updaterect, hda, type, clear, clearcolor);
    }

    public boolean affineBlt(Rect destrect, BaseBitmap ref, Rect refrect, AffineMatrix2D matrix, int method, int opa, Rect updaterect, boolean hda, int type) throws TJSException {
        return this.affineBlt(destrect, ref, refrect, matrix, method, opa, updaterect, hda, type, false, 0);
    }

    public boolean affineBlt(Rect destrect, BaseBitmap ref, Rect refrect, PointD[] points_in, int method, int opa, Rect updaterect, boolean hda, int type) throws TJSException {
        return this.affineBlt(destrect, ref, refrect, points_in, method, opa, updaterect, hda, type, false, 0);
    }

    public boolean doBoxBlur(Rect rect, Rect area) throws TJSException {
        long area_size;
        int t;
        int i;
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        if (area.right < area.left) {
            t = area.right;
            area.right = area.left;
            area.left = t;
        }
        if (area.bottom < area.top) {
            t = area.bottom;
            area.bottom = area.top;
            area.top = t;
        }
        if (area.left == 0 && area.right == 0 && area.top == 0 && area.bottom == 0) {
            return false;
        }
        if (area.left > 0 || area.right < 0 || area.top > 0 || area.bottom < 0) {
            Message.throwExceptionMessage("\u77e9\u5f62\u30d6\u30e9\u30fc\u306e\u7bc4\u56f2\u306f\u5fc5\u305a(0,0)\u3092\u305d\u306e\u4e2d\u306b\u542b\u3080\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002left\u3068right\u304c\u4e21\u65b9\u3068\u3082\u6b63\u306e\u6570\u5024\u3001\u3042\u308b\u3044\u306f\u4e21\u65b9\u3068\u3082\u8ca0\u306e\u6570\u5024\u3068\u3044\u3046\u6307\u5b9a\u306f\u3067\u304d\u307e\u305b\u3093(top\u3068bottom\u306b\u5bfe\u3057\u3066\u3082\u540c\u69d8)");
        }
        if ((area_size = (long)(area.right - area.left + 1) * (long)(area.bottom - area.top + 1)) < 0x800000L) {
            this.independ();
            this.mBitmap.doBoxBlurLoop(rect, area);
        } else {
            Message.throwExceptionMessage("\u77e9\u5f62\u30d6\u30e9\u30fc\u306e\u7bc4\u56f2\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002\u77e9\u5f62\u30d6\u30e9\u30fc\u306e\u7bc4\u56f2\u306f838\u4e07\u4ee5\u4e0b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
        }
        return true;
    }

    public boolean doBoxBlurForAlpha(Rect rect, Rect area) throws TJSException {
        long area_size;
        int t;
        int i;
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return false;
        }
        if (area.right < area.left) {
            t = area.right;
            area.right = area.left;
            area.left = t;
        }
        if (area.bottom < area.top) {
            t = area.bottom;
            area.bottom = area.top;
            area.top = t;
        }
        if (area.left == 0 && area.right == 0 && area.top == 0 && area.bottom == 0) {
            return false;
        }
        if (area.left > 0 || area.right < 0 || area.top > 0 || area.bottom < 0) {
            Message.throwExceptionMessage("\u77e9\u5f62\u30d6\u30e9\u30fc\u306e\u7bc4\u56f2\u306f\u5fc5\u305a(0,0)\u3092\u305d\u306e\u4e2d\u306b\u542b\u3080\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002left\u3068right\u304c\u4e21\u65b9\u3068\u3082\u6b63\u306e\u6570\u5024\u3001\u3042\u308b\u3044\u306f\u4e21\u65b9\u3068\u3082\u8ca0\u306e\u6570\u5024\u3068\u3044\u3046\u6307\u5b9a\u306f\u3067\u304d\u307e\u305b\u3093(top\u3068bottom\u306b\u5bfe\u3057\u3066\u3082\u540c\u69d8)");
        }
        if ((area_size = (long)(area.right - area.left + 1) * (long)(area.bottom - area.top + 1)) < 0x800000L) {
            this.independ();
            this.mBitmap.doBoxBlurLoopAlpha(rect, area);
        } else {
            Message.throwExceptionMessage("\u77e9\u5f62\u30d6\u30e9\u30fc\u306e\u7bc4\u56f2\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002\u77e9\u5f62\u30d6\u30e9\u30fc\u306e\u7bc4\u56f2\u306f838\u4e07\u4ee5\u4e0b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
        }
        return true;
    }

    public void adjustGamma(Rect rect, GammaAdjustData data) throws TJSException {
        int i;
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return;
        }
        GammaAdjustTempData tmp = new GammaAdjustTempData();
        tmp.Initialize(data);
        this.independ();
        this.mBitmap.adjustGamma(rect, tmp);
    }

    public void adjustGammaForAdditiveAlpha(Rect rect, GammaAdjustData data) throws TJSException {
        int i;
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return;
        }
        GammaAdjustTempData tmp = new GammaAdjustTempData();
        tmp.Initialize(data);
        this.independ();
        this.mBitmap.adjustGammaForAdditiveAlpha(rect, tmp);
    }

    public void doGrayScale(Rect rect) throws TJSException {
        int i;
        if (!this.is32BPP()) {
            Message.throwExceptionMessage("8bpp \u753b\u50cf\u306b\u5bfe\u3057\u3066\u306f\u884c\u3048\u306a\u3044\u64cd\u4f5c\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        if (rect.left < 0) {
            rect.left = 0;
        }
        if (rect.top < 0) {
            rect.top = 0;
        }
        if (rect.right > (i = this.getWidth())) {
            rect.right = i;
        }
        if (rect.bottom > (i = this.getHeight())) {
            rect.bottom = i;
        }
        if (rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0) {
            return;
        }
        this.independ();
        this.mBitmap.doGrayScale(rect);
    }

    public void flipLR(Rect rect) throws TJSException {
        if (rect.left < 0 || rect.top < 0 || rect.right > this.getWidth() || rect.bottom > this.getHeight()) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u304c\u30d3\u30c3\u30c8\u30de\u30c3\u30d7\u5916\u306e\u9818\u57df\u3092\u542b\u3093\u3067\u3044\u307e\u3059\u3002\u6b63\u3057\u3044\u7bc4\u56f2\u306b\u53ce\u307e\u308b\u3088\u3046\u306b\u8ee2\u9001\u5143\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        this.independ();
        this.mBitmap.flipLR(rect);
    }

    public void flipUD(Rect rect) throws TJSException {
        if (rect.left < 0 || rect.top < 0 || rect.right > this.getWidth() || rect.bottom > this.getHeight()) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u304c\u30d3\u30c3\u30c8\u30de\u30c3\u30d7\u5916\u306e\u9818\u57df\u3092\u542b\u3093\u3067\u3044\u307e\u3059\u3002\u6b63\u3057\u3044\u7bc4\u56f2\u306b\u53ce\u307e\u308b\u3088\u3046\u306b\u8ee2\u9001\u5143\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        this.independ();
        this.mBitmap.flipUD(rect);
    }

    public void convertAddAlphaToAlpha() {
        if (this.mBitmap.isAlphaPremultiplied()) {
            this.independ();
            this.mBitmap.coerceData(false);
        }
    }

    public void convertAlphaToAddAlpha() {
        if (!this.mBitmap.isAlphaPremultiplied()) {
            this.independ();
            this.mBitmap.coerceData(true);
        }
    }

    public boolean isAlphaPremultiplied() {
        return this.mBitmap.isAlphaPremultiplied();
    }

    public void makeAlphaFromAdaptiveColor() throws TJSException {
        if (!this.is32BPP()) {
            return;
        }
        this.mBitmap.makeAlphaFromAdaptiveColor();
    }

    public void purgeImage() {
        this.mBitmap.purgeImage();
    }

    static class CharacterDrawData {
        CharacterData mData;
        CharacterData mShadow;
        int mX;
        int mY;
        Rect mShadowRect;
        boolean mShadowDrawn;

        public CharacterDrawData(CharacterData data, CharacterData shadow, int x, int y) {
            this.mData = data;
            this.mShadow = shadow;
            this.mX = x;
            this.mY = y;
            this.mShadowRect = new Rect();
            this.mShadowDrawn = false;
        }

        public CharacterDrawData(CharacterDrawData rhs) {
            this.mData = rhs.mData;
            this.mShadow = rhs.mShadow;
            this.mX = rhs.mX;
            this.mY = rhs.mY;
            this.mShadowRect = new Rect(rhs.mShadowRect);
            this.mShadowDrawn = rhs.mShadowDrawn;
        }

        public void set(CharacterDrawData rhs) {
            this.mData = rhs.mData;
            this.mShadow = rhs.mShadow;
            this.mX = rhs.mX;
            this.mY = rhs.mY;
            this.mShadowRect.set(rhs.mShadowRect);
            this.mShadowDrawn = rhs.mShadowDrawn;
        }
    }

    static class DrawTextData {
        Rect rect = new Rect();
        int opa;
        boolean holdalpha;
        int bltmode;
    }

    static class PrerenderedFontMap {
        static final int TF_ITALIC = 1;
        static final int TF_BOLD = 2;
        static final int TF_UNDERLINE = 4;
        static final int TF_STRIKEOUT = 8;
        int Height;
        int Flags;
        int Angle;
        String Face;
        PrerenderedFont Object;

        PrerenderedFontMap() {
        }

        public boolean equals(Object o) {
            if (o instanceof Font) {
                Font f = (Font)o;
                if (this.Face.equals(f.getFaceName()) && this.Height == f.getHeight() && this.Angle == f.getAngle()) {
                    int flag = 0;
                    flag |= f.getBold() ? 2 : 0;
                    flag |= f.getItalic() ? 1 : 0;
                    flag |= f.getStrikeout() ? 8 : 0;
                    return (flag |= f.getUnderline() ? 4 : 0) == this.Flags;
                }
                return false;
            }
            if (o instanceof PrerenderedFontMap) {
                PrerenderedFontMap f = (PrerenderedFontMap)o;
                return this.Face.equals(f.Face) && this.Height == f.Height && this.Flags == f.Flags && this.Angle == f.Angle;
            }
            return false;
        }

        public void setFont(Font f) {
            this.Face = f.getFaceName();
            this.Height = f.getHeight();
            this.Angle = f.getAngle();
            this.Flags = 0;
            this.Flags |= f.getBold() ? 2 : 0;
            this.Flags |= f.getItalic() ? 1 : 0;
            this.Flags |= f.getStrikeout() ? 8 : 0;
            this.Flags |= f.getUnderline() ? 4 : 0;
        }

        public void clear() {
            this.Face = null;
            this.Height = 0;
            this.Angle = 0;
            this.Flags = 0;
            this.Object = null;
        }
    }
}

