/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

public class CharacterData {
    private byte[] mData;
    public int mOriginX;
    public int mOriginY;
    public int mCellIncX;
    public int mCellIncY;
    public int mPitch;
    public int mBlackBoxX;
    public int mBlackBoxY;
    public int mBlurLevel;
    public int mBlurWidth;
    public boolean mAntialiased;
    public boolean mBlured;
    public boolean mFullColored;

    public void alloc(int size) {
        this.mData = new byte[size];
    }

    public byte[] getData() {
        return this.mData;
    }

    public void blur() {
        this.blur(this.mBlurLevel, this.mBlurWidth);
    }

    private void blur(int blurlevel, int blurwidth) {
        if (this.mData == null) {
            return;
        }
        if (blurlevel == 255 && blurwidth == 0) {
            return;
        }
        if (blurwidth == 0) {
            CharacterData.chBlurMulCopy65(this.mData, this.mData, this.mPitch * this.mBlackBoxY, this.mBlurLevel << 10);
            return;
        }
        int bw = Math.abs(blurwidth);
        int newwidth = this.mBlackBoxX + bw * 2;
        int newheight = this.mBlackBoxY + bw * 2;
        int newpitch = (newwidth - 1 >> 2) + 1 << 2;
        byte[] newdata = new byte[newpitch * newheight];
        this.chBlurCopy65(newdata, newpitch, newwidth, newheight, this.mData, this.mPitch, this.mBlackBoxX, this.mBlackBoxY, bw, blurlevel);
        this.mData = null;
        this.mData = newdata;
        this.mBlackBoxX = newwidth;
        this.mBlackBoxY = newheight;
        this.mPitch = newpitch;
        this.mOriginX -= blurwidth;
        this.mOriginY -= blurwidth;
    }

    private void chBlurCopy65(byte[] dest, int destpitch, int destwidth, int destheight, byte[] src, int srcpitch, int srcwidth, int srcheight, int blurwidth, int blurlevel) {
        int len;
        int x;
        int lvsum = 0;
        int y = -blurwidth;
        while (y <= blurwidth) {
            x = -blurwidth;
            while (x <= blurwidth) {
                len = CharacterData.fastIntHypot(x, y);
                if (len <= blurwidth) {
                    lvsum += blurwidth - len + 1;
                }
                ++x;
            }
            ++y;
        }
        lvsum = lvsum != 0 ? 262144 / lvsum : 262144;
        y = -blurwidth;
        while (y <= blurwidth) {
            x = -blurwidth;
            while (x <= blurwidth) {
                len = CharacterData.fastIntHypot(x, y);
                if (len <= blurwidth) {
                    len = blurwidth - len + 1;
                    len *= lvsum;
                    len *= blurlevel;
                    len >>>= 8;
                    int sy = 0;
                    while (sy < srcheight) {
                        CharacterData.chBlurAddMulCopy65(dest, (y + sy + blurwidth) * destpitch + x + blurwidth, src, sy * srcpitch, srcwidth, len);
                        ++sy;
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private static final void chBlurMulCopy65(byte[] dest, byte[] src, int len, int level) {
        int i = 0;
        while (i < len) {
            int a = src[i] * level >>> 18;
            if (a >= 64) {
                a = 64;
            }
            dest[i] = (byte)a;
            ++i;
        }
    }

    private static final void chBlurAddMulCopy65(byte[] dest, int desti, byte[] src, int srci, int len, int level) {
        int limit = desti + len;
        while (desti < limit) {
            int a = dest[desti] + (src[srci] * level >>> 18);
            if (a >= 64) {
                a = 64;
            }
            dest[desti] = (byte)a;
            ++desti;
            ++srci;
        }
    }

    private static final int fastIntHypot(int lx, int ly) {
        int len2;
        int len1;
        if (lx < 0) {
            lx = -lx;
        }
        if (ly < 0) {
            ly = -ly;
        }
        if (lx >= ly) {
            len1 = lx;
            len2 = ly;
        } else {
            len1 = ly;
            len2 = lx;
        }
        int t = len2 + (len2 >>> 1);
        int length = len1 - (len1 >>> 5) - (len1 >>> 7) + (t >>> 2) + (t >>> 6);
        return length;
    }
}

