/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.RegionRect;

public class ComplexRect {
    private RegionRect Head;
    private RegionRect Current;
    private int Count;
    private Rect Bound;
    private boolean BoundValid;

    public ComplexRect() {
        this.Bound = new Rect();
        this.init();
    }

    public ComplexRect(ComplexRect ref) {
        this.Bound = new Rect(ref.Bound);
        this.init();
        this.setCount(ref.Count);
        if (this.Count != 0) {
            RegionRect this_cur = this.Head;
            RegionRect ref_cur = ref.Head;
            do {
                this_cur.set(ref_cur);
                this_cur = this_cur.Next;
            } while ((ref_cur = ref_cur.Next) != ref.Head);
        }
    }

    public void clear() {
        this.freeAllRectangles();
        this.init();
    }

    private void freeAllRectangles() {
        if (this.Count != 0) {
            RegionRect n;
            RegionRect cur = this.Head;
            do {
                n = cur.Next;
                RegionRect.release(cur);
            } while ((cur = n) != this.Head);
        }
    }

    private void init() {
        this.Head = null;
        this.Current = null;
        this.Count = 0;
        this.Bound.bottom = 0;
        this.Bound.right = 0;
        this.Bound.top = 0;
        this.Bound.left = 0;
        this.BoundValid = false;
    }

    private void setCount(int count) {
        if (count > this.Count) {
            RegionRect cur;
            int add_count = count - this.Count;
            if (this.Count == 0) {
                this.Head.Prev = this.Head = RegionRect.allocate();
                this.Head.Next = this.Head;
                --add_count;
            }
            this.Current = cur = this.Head.Prev;
            while (add_count > 0) {
                RegionRect newrect = RegionRect.allocate();
                newrect.linkBefore(this.Head);
                --add_count;
            }
            this.Count = count;
        } else if (count < this.Count && this.Count != 0) {
            int remove_count = this.Count - count;
            RegionRect cur = this.Head.Prev;
            while (remove_count > 0) {
                RegionRect prev = cur.Prev;
                RegionRect.release(cur);
                cur = prev;
                --remove_count;
            }
            this.Count = count;
            if (this.Count != 0) {
                cur.Next = this.Head;
                this.Current = this.Head;
                this.Head.Prev = cur;
            } else {
                this.Head = null;
                this.Current = null;
            }
        }
    }

    private boolean insert(Rect rect) {
        block15: {
            if (rect.isEmpty()) {
                return false;
            }
            if (this.Count == 0) {
                this.Head = RegionRect.allocate();
                this.Head.set(rect);
                this.Head.Prev = this.Head.Next = this.Head;
                this.Current = this.Head;
                this.Count = 1;
                return true;
            }
            if (this.Current.greaterThan(rect)) {
                while (true) {
                    if (this.Current == this.Head) {
                        if (this.Head.top == rect.top && this.Head.bottom == rect.bottom && this.Head.left == rect.right) {
                            this.Head.left = rect.left;
                        } else {
                            RegionRect new_rect = RegionRect.allocate();
                            new_rect.set(rect);
                            new_rect.linkBefore(this.Head);
                            ++this.Count;
                            this.Head = new_rect;
                        }
                        break block15;
                    }
                    RegionRect prev = this.Current.Prev;
                    if (prev.littlerThan(rect)) {
                        if (this.Current.top == rect.top && this.Current.bottom == rect.bottom && this.Current.left == rect.right) {
                            this.Current.left = rect.left;
                        } else {
                            RegionRect new_rect = RegionRect.allocate();
                            new_rect.set(rect);
                            new_rect.linkBefore(this.Current);
                            ++this.Count;
                        }
                        break block15;
                    }
                    this.Current = prev;
                }
            }
            while (true) {
                RegionRect next;
                if ((next = this.Current.Next) == this.Head) {
                    if (this.Current.top == rect.top && this.Current.bottom == rect.bottom && this.Current.right == rect.left) {
                        this.Current.right = rect.right;
                        break;
                    }
                    RegionRect new_rect = RegionRect.allocate();
                    new_rect.set(rect);
                    new_rect.linkBefore(this.Head);
                    ++this.Count;
                    break;
                }
                if (next.greaterThan(rect)) {
                    if (next.top == rect.top && next.bottom == rect.bottom && next.left == rect.right) {
                        next.left = rect.left;
                        if (this.Current.top != rect.top || this.Current.bottom != rect.bottom || this.Current.right != rect.left) break;
                        next.left = this.Current.left;
                        this.remove(this.Current);
                        break;
                    }
                    RegionRect new_rect = RegionRect.allocate();
                    new_rect.set(rect);
                    new_rect.linkBefore(next);
                    ++this.Count;
                    break;
                }
                this.Current = next;
            }
        }
        return true;
    }

    private void remove(RegionRect rect) {
        if (rect == this.Head) {
            this.Head = rect.Next;
        }
        --this.Count;
        if (this.Count == 0) {
            this.Head = null;
            this.Current = null;
        } else if (rect == this.Current) {
            this.Current = rect.Prev;
        }
        rect.unlink();
        RegionRect.release(rect);
    }

    private void merge(ComplexRect rects) {
        rects.ensureBound();
        this.ensureBound();
        if (this.Count != 0) {
            if (rects.Count != 0) {
                this.Bound.doUnion(rects.Bound);
            }
        } else if (rects.Count != 0) {
            this.Bound.set(rects.Bound);
        } else {
            return;
        }
        RegionRect ref_cur = rects.Head;
        do {
            this.insert(ref_cur);
        } while ((ref_cur = ref_cur.Next) != rects.Head);
    }

    public int getCount() {
        return this.Count;
    }

    public void or(Rect r) {
        if (r.isEmpty()) {
            return;
        }
        if (this.Count == 0) {
            if (this.insert(r)) {
                this.Bound.set(r);
                this.BoundValid = true;
            }
            return;
        }
        this.ensureBound();
        if (!this.Bound.intersectsWithNoEmptyCheck(r)) {
            if (this.insert(r)) {
                this.Bound.doUnion(r);
            }
            return;
        }
        if (r.left >= r.right || r.top >= r.bottom) {
            return;
        }
        this.Bound.doUnion(r);
        RegionRect c = this.Head;
        while (c.top < r.bottom) {
            boolean next_is_head;
            if (r.includedInNoEmptyCheck(c)) {
                return;
            }
            if (c.intersectsWithNoEmptyCheck(r)) {
                RegionRect next = c.Next;
                next_is_head = next == this.Head;
                this.Current = c;
                this.rectangleSub(c, r);
                c = next_is_head ? this.Head : next;
            } else {
                c = c.Next;
                boolean bl = next_is_head = c == this.Head;
            }
            if (this.Head == null || c == null || next_is_head) break;
        }
        this.insert(r);
    }

    public void or(ComplexRect ref) {
        if (ref.Count == 0) {
            return;
        }
        this.ensureBound();
        ref.ensureBound();
        if (!this.Bound.intersectsWithNoEmptyCheck(ref.Bound)) {
            this.merge(ref);
            return;
        }
        RegionRect c = ref.Head;
        do {
            this.or(c);
        } while ((c = c.Next) != ref.Head);
    }

    public void sub(Rect r) {
        if (r.left >= r.right || r.top >= r.bottom) {
            return;
        }
        this.ensureBound();
        if (!this.Bound.intersectsWithNoEmptyCheck(r)) {
            return;
        }
        switch (this.getRectangleIntersectionCode(this.Bound, r)) {
            case 15: {
                this.clear();
                return;
            }
            case 14: {
                this.Bound.top = r.bottom;
                break;
            }
            case 7: {
                this.Bound.right = r.left;
                break;
            }
            case 13: {
                this.Bound.bottom = r.top;
                break;
            }
            case 11: {
                this.Bound.left = r.right;
            }
        }
        RegionRect c = this.Head;
        while (c.top < r.bottom) {
            boolean next_is_head;
            if (c.intersectsWithNoEmptyCheck(r)) {
                RegionRect next;
                if (c.left == this.Bound.left || c.top == this.Bound.top || c.right == this.Bound.top || c.bottom == this.Bound.bottom) {
                    this.BoundValid = false;
                }
                next_is_head = (next = c.Next) == this.Head;
                this.Current = c;
                this.rectangleSub(c, r);
                c = next_is_head ? this.Head : next;
            } else {
                c = c.Next;
                boolean bl = next_is_head = c == this.Head;
            }
            if (this.Head == null || c == null || next_is_head) break;
        }
    }

    public void sub(ComplexRect ref) {
        if (ref.Count == 0) {
            return;
        }
        this.ensureBound();
        ref.ensureBound();
        if (!this.Bound.intersectsWithNoEmptyCheck(ref.Bound)) {
            return;
        }
        RegionRect c = ref.Head;
        boolean boundvalid = true;
        do {
            this.sub(c);
            boundvalid = this.BoundValid && boundvalid;
            this.BoundValid = true;
        } while ((c = c.Next) != ref.Head);
        this.BoundValid = boundvalid;
    }

    public void and(Rect r) {
        boolean next_is_head;
        if (this.Count == 0) {
            return;
        }
        if (r.left >= r.right || r.top >= r.bottom) {
            this.clear();
            return;
        }
        this.ensureBound();
        if (!this.Bound.intersectsWithNoEmptyCheck(r)) {
            this.clear();
            return;
        }
        switch (this.getRectangleIntersectionCode(this.Bound, r)) {
            case 15: {
                return;
            }
        }
        boolean is_first = true;
        RegionRect c = this.Head;
        do {
            RegionRect cc = c;
            c = cc.Next;
            boolean bl = next_is_head = c == this.Head;
            if (cc.clip(r)) {
                if (is_first) {
                    this.Bound = cc;
                    is_first = false;
                    continue;
                }
                this.Bound.doUnion(cc);
                continue;
            }
            this.remove(cc);
        } while (!next_is_head);
        this.BoundValid = !is_first;
    }

    public void copyWithOffsets(ComplexRect ref, Rect clip, int ofsx, int ofsy) {
        if (ref.Count != 0) {
            RegionRect ref_cur = ref.Head;
            boolean is_first = true;
            do {
                Rect rect = new Rect(ref_cur);
                rect.addOffsets(ofsx, ofsy);
                if (!Rect.intersectRect(rect, rect, clip)) continue;
                this.insert(rect);
                if (is_first) {
                    this.Bound.set(rect);
                    is_first = false;
                    continue;
                }
                this.Bound.doUnion(rect);
            } while ((ref_cur = ref_cur.Next) != ref.Head);
            this.BoundValid = !is_first;
        }
    }

    public final Rect getBound() {
        this.ensureBound();
        return this.Bound;
    }

    public void unite() {
        Rect r = new Rect(this.getBound());
        this.clear();
        this.or(r);
    }

    private void ensureBound() {
        if (!this.BoundValid) {
            this.calcBound();
        }
    }

    private void calcBound() {
        if (this.Count != 0) {
            RegionRect c = this.Head;
            this.Bound.set(this.Head);
            c = c.Next;
            while (c != this.Head) {
                this.Bound.doUnion(c);
                c = c.Next;
            }
        } else {
            this.Bound.bottom = 0;
            this.Bound.right = 0;
            this.Bound.top = 0;
            this.Bound.left = 0;
        }
    }

    private int getRectangleIntersectionCode(Rect r, Rect rr) {
        int cond = rr.left <= r.left && rr.right >= r.left ? 8 : 0;
        if (rr.left <= r.right && rr.right >= r.right) {
            cond |= 4;
        }
        if (rr.top <= r.top && rr.bottom >= r.top) {
            cond |= 2;
        }
        if (rr.top <= r.bottom && rr.bottom >= r.bottom) {
            cond |= 1;
        }
        return cond;
    }

    private void rectangleSub(RegionRect r, Rect rr) {
        int cond = this.getRectangleIntersectionCode(r, rr);
        Rect nr = new Rect();
        switch (cond) {
            case 0: {
                nr.left = r.left;
                nr.top = rr.top;
                nr.right = rr.left;
                nr.bottom = rr.bottom;
                this.insert(nr);
                nr.left = rr.right;
                nr.top = rr.top;
                nr.right = r.right;
                nr.bottom = rr.bottom;
                this.insert(nr);
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            case 15: {
                this.remove(r);
                break;
            }
            case 12: {
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            case 3: {
                nr.left = rr.right;
                nr.top = r.top;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.right = rr.left;
                break;
            }
            case 10: {
                nr.left = rr.right;
                nr.top = r.top;
                nr.right = r.right;
                nr.bottom = rr.bottom;
                this.insert(nr);
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                this.remove(r);
                break;
            }
            case 6: {
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.bottom;
                r.right = rr.left;
                break;
            }
            case 5: {
                nr.left = r.left;
                nr.top = rr.top;
                nr.right = rr.left;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            case 9: {
                nr.left = rr.right;
                nr.top = rr.top;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            case 14: {
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                this.remove(r);
                break;
            }
            case 7: {
                r.right = rr.left;
                break;
            }
            case 13: {
                r.bottom = rr.top;
                break;
            }
            case 11: {
                nr.left = rr.right;
                nr.top = r.top;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                this.remove(r);
                break;
            }
            case 8: {
                nr.left = rr.right;
                nr.top = rr.top;
                nr.right = r.right;
                nr.bottom = rr.bottom;
                this.insert(nr);
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            case 4: {
                nr.left = r.left;
                nr.top = rr.top;
                nr.right = rr.left;
                nr.bottom = rr.bottom;
                this.insert(nr);
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            case 2: {
                nr.left = rr.right;
                nr.top = r.top;
                nr.right = r.right;
                nr.bottom = rr.bottom;
                this.insert(nr);
                nr.left = r.left;
                nr.top = rr.bottom;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.right = rr.left;
                r.bottom = rr.bottom;
                break;
            }
            case 1: {
                nr.left = r.left;
                nr.top = rr.top;
                nr.right = rr.left;
                nr.bottom = r.bottom;
                this.insert(nr);
                nr.left = rr.right;
                nr.top = rr.top;
                nr.right = r.right;
                nr.bottom = r.bottom;
                this.insert(nr);
                r.bottom = rr.top;
                break;
            }
            default: {
                return;
            }
        }
    }

    public void addOffsets(int x, int y) {
        if (this.Count == 0) {
            return;
        }
        this.Bound.addOffsets(x, y);
        RegionRect cur = this.Head;
        do {
            cur.addOffsets(x, y);
        } while ((cur = cur.Next) != this.Head);
    }

    public Iterator getIterator() {
        if (this.Count != 0) {
            return new Iterator(this.Head);
        }
        return new Iterator(null);
    }

    public void dumpChain() {
        StringBuilder builder = new StringBuilder(256);
        Iterator it = this.getIterator();
        while (it.step()) {
            builder.append(String.format("%x (%x) %x : ", it.get().Prev.hashCode(), it.get().hashCode(), it.get().Next.hashCode()));
        }
        Logger.log(builder.toString());
    }

    static class Iterator {
        private RegionRect Head;
        private RegionRect Current;

        public Iterator() {
            this.Head = null;
            this.Current = null;
        }

        Iterator(RegionRect head) {
            this.Head = head;
        }

        public RegionRect get() {
            return this.Current;
        }

        public boolean step() {
            if (this.Head == null) {
                return false;
            }
            if (this.Current == null) {
                this.Current = this.Head;
                return true;
            }
            if (this.Current.Next == this.Head) {
                return false;
            }
            this.Current = this.Current.Next;
            return true;
        }
    }
}

